<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// ✅ Check if user is logged in as a parent
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'parent') {
    header('Location: login.php');
    exit();
}

$parent_id = $_SESSION['user_id'];
$success = '';
$error = '';

// ✅ Get children for this parent - FIXED QUERY
// Assuming the parent ID is stored in the students table as parent_id
$children_query = "SELECT s.id, s.full_name, s.student_id, c.class_name, sec.section_name
                   FROM students s
                   LEFT JOIN classes c ON s.class = c.id
                   LEFT JOIN sections sec ON s.section = sec.id
                   WHERE s.parent_id = $parent_id";
$children_result = mysqli_query($conn, $children_query);

// Check if query was successful
if (!$children_result) {
    $error = "Database error: " . mysqli_error($conn);
}

// ✅ Selected child
$student_id = isset($_GET['student_id']) ? intval($_GET['student_id']) : 0;

// If no child selected, show list
if ($student_id === 0) {
    ?>
    <div class="bg-white p-6  ">
        <h2 class="text-2xl font-bold mb-4">Select a Child</h2>
        
        <?php if (!empty($error)): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <?php echo $error; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($children_result && mysqli_num_rows($children_result) > 0): ?>
            <ul class="space-y-3">
                <?php while ($child = mysqli_fetch_assoc($children_result)): ?>
                    <li class="p-4 border  flex justify-between items-center hover:bg-gray-50">
                        <div>
                            <p class="font-semibold"><?php echo htmlspecialchars($child['full_name']); ?></p>
                            <p class="text-sm text-gray-600">
                                <?php echo htmlspecialchars($child['class_name'].' - '.$child['section_name']); ?>
                            </p>
                        </div>
                        <a href="?student_id=<?php echo $child['id']; ?>"
                           class="bg-blue-600 text-white px-4 py-2 rounded">
                           View Payments
                        </a>
                    </li>
                <?php endwhile; ?>
            </ul>
        <?php else: ?>
            <p class="text-gray-700">No children linked to this parent account.</p>
        <?php endif; ?>
    </div>
    <?php
    include 'include/footer.php';
    ob_end_flush();
    exit();
}

// Verify the selected student belongs to the parent
$valid_student = false;
if ($children_result) {
    mysqli_data_seek($children_result, 0); // Reset pointer
    while ($child = mysqli_fetch_assoc($children_result)) {
        if ($child['id'] == $student_id) {
            $valid_student = true;
            break;
        }
    }
}

if (!$valid_student) {
    header('Location: payments.php');
    exit();
}

// ✅ Fetch student details
$student_query = "SELECT s.*, c.class_name, sec.section_name 
                  FROM students s 
                  LEFT JOIN classes c ON s.class = c.id 
                  LEFT JOIN sections sec ON s.section = sec.id 
                  WHERE s.id = $student_id";
$student_result = mysqli_query($conn, $student_query);
$student = mysqli_fetch_assoc($student_result);

if (!$student) {
    $error = "Invalid student selected.";
}

// ✅ Fetch invoices for this student
$invoices_query = "SELECT i.*, 
                  (SELECT COALESCE(SUM(amount), 0) FROM payments p WHERE p.invoice_id = i.id) as paid_amount
                  FROM invoices i
                  WHERE i.student_id = $student_id
                  ORDER BY i.created_at DESC";
$invoices_result = mysqli_query($conn, $invoices_query);
$invoices = [];
if ($invoices_result) {
    while ($invoice = mysqli_fetch_assoc($invoices_result)) {
        $invoices[] = $invoice;
    }
}

// ✅ Fetch payment history with pagination
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$per_page = 10;
$offset = ($page - 1) * $per_page;

$total_payments_query = "SELECT COUNT(*) as total 
                         FROM payments p
                         JOIN invoices i ON p.invoice_id = i.id
                         WHERE i.student_id = $student_id";
$total_payments_result = mysqli_query($conn, $total_payments_query);
$total_payments_data = $total_payments_result ? mysqli_fetch_assoc($total_payments_result) : ['total' => 0];
$total_payments = $total_payments_data['total'];

$total_pages = ceil($total_payments / $per_page);

$payments_query = "SELECT p.*, i.description 
                   FROM payments p
                   JOIN invoices i ON p.invoice_id = i.id
                   WHERE i.student_id = $student_id
                   ORDER BY p.payment_date DESC
                   LIMIT $offset, $per_page";
$payments_result = mysqli_query($conn, $payments_query);
$payments = [];
if ($payments_result) {
    while ($payment = mysqli_fetch_assoc($payments_result)) {
        $payments[] = $payment;
    }
}

ob_end_flush();
?>

<div class="bg-white p-6  ">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Invoices & Payments</h2>
        <div class="bg-blue-100 text-blue-800 px-4 py-2 ">
            <span class="font-semibold"><?php echo htmlspecialchars($student['student_id']); ?></span> - 
            <?php echo htmlspecialchars($student['full_name']); ?>
            | <?php echo htmlspecialchars($student['class_name'].' '.$student['section_name']); ?>
        </div>
    </div>

    <!-- Invoices -->
    <?php if (!empty($invoices)): ?>
        <div class="overflow-x-auto mb-8">
            <table class="min-w-full bg-white">
                <thead class="bg-gray-200 text-gray-700">
                    <tr>
                        <th class="py-3 px-4 text-left">Description</th>
                        <th class="py-3 px-4 text-left">Amount</th>
                        <th class="py-3 px-4 text-left">Paid</th>
                        <th class="py-3 px-4 text-left">Balance</th>
                        <th class="py-3 px-4 text-left">Due Date</th>
                        <th class="py-3 px-4 text-left">Status</th>
                    </tr>
                </thead>
                <tbody class="text-gray-600">
                    <?php foreach ($invoices as $invoice): 
                        $balance = $invoice['amount'] - $invoice['paid_amount'];
                        $status = $balance <= 0 ? 'Paid' : ($invoice['paid_amount'] > 0 ? 'Partial' : 'Unpaid');
                        $status_class = $status == 'Paid' ? 'bg-green-100 text-green-800' : 
                                      ($status == 'Partial' ? 'bg-yellow-100 text-yellow-800' : 'bg-red-100 text-red-800');
                    ?>
                        <tr class="border-b border-gray-200 hover:bg-gray-50">
                            <td class="py-3 px-4"><?php echo htmlspecialchars($invoice['description']); ?></td>
                            <td class="py-3 px-4">₦<?php echo number_format($invoice['amount'], 2); ?></td>
                            <td class="py-3 px-4">₦<?php echo number_format($invoice['paid_amount'], 2); ?></td>
                            <td class="py-3 px-4">₦<?php echo number_format($balance, 2); ?></td>
                            <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($invoice['due_date'])); ?></td>
                            <td class="py-3 px-4">
                                <span class="px-2 py-1 rounded-full text-xs <?php echo $status_class; ?>">
                                    <?php echo $status; ?>
                                </span>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <p class="text-gray-500">No invoices found for this student.</p>
    <?php endif; ?>

    <!-- Payment History -->
    <h3 class="text-lg font-semibold text-gray-800 mb-4">Payment History</h3>
    <?php if (!empty($payments)): ?>
        <div class="overflow-x-auto">
            <table class="min-w-full bg-white">
                <thead class="bg-gray-200 text-gray-700">
                    <tr>
                        <th class="py-3 px-4 text-left">Date</th>
                        <th class="py-3 px-4 text-left">Description</th>
                        <th class="py-3 px-4 text-left">Amount</th>
                        <th class="py-3 px-4 text-left">Method</th>
                        <th class="py-3 px-4 text-left">Transaction ID</th>
                        <th class="py-3 px-4 text-left">Receipt</th>
                    </tr>
                </thead>
                <tbody class="text-gray-600">
                    <?php foreach ($payments as $payment): ?>
                        <tr class="border-b border-gray-200 hover:bg-gray-50">
                            <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($payment['payment_date'])); ?></td>
                            <td class="py-3 px-4"><?php echo htmlspecialchars($payment['description']); ?></td>
                            <td class="py-3 px-4">₦<?php echo number_format($payment['amount'], 2); ?></td>
                            <td class="py-3 px-4"><?php echo ucfirst($payment['payment_method']); ?></td>
                            <td class="py-3 px-4"><?php echo !empty($payment['transaction_id']) ? htmlspecialchars($payment['transaction_id']) : 'N/A'; ?></td>
                           <td class="py-3 px-4">
    <a href="download_receipt.php?payment_id=<?php echo $payment['id']; ?>" target="_blank"
       class="bg-blue-600 hover:bg-blue-700 text-white px-3 py-1 rounded text-sm flex items-center">
        <i class="fas fa-download mr-1"></i> Receipt
    </a>
</td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if ($total_pages > 1): ?>
            <div class="flex justify-center items-center mt-4">
                <nav class="inline-flex ">
                    <?php if ($page > 1): ?>
                        <a href="?student_id=<?php echo $student_id; ?>&page=<?php echo $page - 1; ?>" class="px-3 py-2 rounded-l-md border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                            <i class="fas fa-chevron-left mr-1"></i> Previous
                        </a>
                    <?php endif; ?>
                    <span class="px-3 py-2 border-t border-b border-gray-300 bg-white text-sm font-medium text-gray-700">
                        Page <?php echo $page; ?> of <?php echo $total_pages; ?>
                    </span>
                    <?php if ($page < $total_pages): ?>
                        <a href="?student_id=<?php echo $student_id; ?>&page=<?php echo $page + 1; ?>" class="px-3 py-2 rounded-r-md border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                            Next <i class="fas fa-chevron-right ml-1"></i>
                        </a>
                    <?php endif; ?>
                </nav>
            </div>
        <?php endif; ?>
    <?php else: ?>
        <p class="text-gray-500">No payment history found for this student.</p>
    <?php endif; ?>
</div>

<?php
include 'include/footer.php';
mysqli_close($conn);
?>