<?php
include 'include/header.php';
include '../config/conn.php';



// Logged in student
$student_id = $_SESSION['user_id'];

// Get student's class and section
$student_query = "SELECT class, section FROM students WHERE id = ? AND status = 'active'";
$student_stmt = $conn->prepare($student_query);
$student_stmt->bind_param("i", $student_id);
$student_stmt->execute();
$student_result = $student_stmt->get_result();
$student = $student_result->fetch_assoc();
$student_stmt->close();

if (!$student) {
    echo "<div class='bg-white p-6  '><p class='text-red-500'>Student record not found.</p></div>";
    include 'include/footer.php';
}

// Get teacher assigned to student's section
$teacher_query = "SELECT section_teacher_id 
                  FROM sections 
                  WHERE id = ? AND class_id = ? AND status = 'active'";
$teacher_stmt = $conn->prepare($teacher_query);
$teacher_stmt->bind_param("ii", $student['section'], $student['class']);
$teacher_stmt->execute();
$teacher_result = $teacher_stmt->get_result();
$teacher_row = $teacher_result->fetch_assoc();
$teacher_stmt->close();

if (!$teacher_row || empty($teacher_row['section_teacher_id'])) {
    echo "<div class='bg-white p-6  '><p class='text-red-500'>No teacher assigned for this class/section.</p></div>";
    include 'include/footer.php';
    exit();
}

$teacher_id = $teacher_row['section_teacher_id'];

// Fetch teacher details
$teacher_query = "SELECT * FROM users WHERE id = ? AND role = 'teacher' AND status = 'active'";
$teacher_stmt = $conn->prepare($teacher_query);
$teacher_stmt->bind_param("i", $teacher_id);
$teacher_stmt->execute();
$teacher_result = $teacher_stmt->get_result();

if ($teacher_result->num_rows === 0) {
    echo "<div class='bg-white p-6  '><p class='text-red-500'>Teacher not found.</p></div>";
    include 'include/footer.php';
    exit();
}

$teacher = $teacher_result->fetch_assoc();
$teacher_stmt->close();

// Fetch classes assigned to this teacher
$classes_query = "SELECT c.id, c.class_name 
                  FROM classes c 
                  WHERE c.class_teacher_id = ? 
                  ORDER BY c.class_name";
$classes_stmt = $conn->prepare($classes_query);
$classes_stmt->bind_param("i", $teacher_id);
$classes_stmt->execute();
$classes_result = $classes_stmt->get_result();
$teacher_classes = $classes_result->fetch_all(MYSQLI_ASSOC);
$classes_stmt->close();

// Get class IDs for student query
$class_ids = array_column($teacher_classes, 'id');
$placeholders = implode(',', array_fill(0, count($class_ids), '?'));

// Fetch students taught by this teacher
$students = [];
if (!empty($class_ids)) {
    $students_query = "SELECT s.id, s.full_name, s.student_id, s.roll_number, s.photo, 
                       c.class_name, sec.section_name
                       FROM students s
                       INNER JOIN classes c ON s.class = c.id
                       INNER JOIN sections sec ON s.section = sec.id
                       WHERE s.class IN ($placeholders) AND s.status = 'active'
                       ORDER BY c.class_name, sec.section_name, s.roll_number";
    
    $students_stmt = $conn->prepare($students_query);
    
    // Bind parameters dynamically
    $types = str_repeat('i', count($class_ids));
    $students_stmt->bind_param($types, ...$class_ids);
    
    $students_stmt->execute();
    $students_result = $students_stmt->get_result();
    $students = $students_result->fetch_all(MYSQLI_ASSOC);
    $students_stmt->close();
}

// Get sections for each class taught by this teacher
$class_sections = [];
if (!empty($class_ids)) {
    $sections_query = "SELECT DISTINCT c.class_name, sec.section_name
                       FROM students s
                       INNER JOIN classes c ON s.class = c.id
                       INNER JOIN sections sec ON s.section = sec.id
                       WHERE s.class IN ($placeholders) AND s.status = 'active'
                       ORDER BY c.class_name, sec.section_name";
    
    $sections_stmt = $conn->prepare($sections_query);
    
    // Bind parameters dynamically
    $types = str_repeat('i', count($class_ids));
    $sections_stmt->bind_param($types, ...$class_ids);
    
    $sections_stmt->execute();
    $sections_result = $sections_stmt->get_result();
    $class_sections = $sections_result->fetch_all(MYSQLI_ASSOC);
    $sections_stmt->close();
}
?>



<div class="container mx-auto px-4 py-8">
    <div class="bg-white p-6  ">

        <!-- Teacher Profile -->
        <div class="bg-blue-50 p-6  mb-6 flex flex-col md:flex-row items-center">
            <div class="mr-6 mb-4 md:mb-0">
                <?php if (!empty($teacher['photo'])): ?>
                    <img src="../uploads/<?php echo htmlspecialchars($teacher['photo']); ?>" 
                         alt="<?php echo htmlspecialchars($teacher['full_name']); ?>" 
                         class="w-32 h-32 rounded-full object-cover border-4 border-white shadow">
                <?php else: ?>
                    <div class="w-32 h-32 rounded-full bg-blue-100 flex items-center justify-center border-4 border-white shadow">
                        <i class="fas fa-user-tie text-blue-400 text-4xl"></i>
                    </div>
                <?php endif; ?>
            </div>
            <div class="flex-1 text-center md:text-left">
                <h1 class="text-3xl font-bold text-gray-800"><?php echo htmlspecialchars($teacher['full_name']); ?></h1>
                <p class="text-gray-600 mt-2"><i class="fas fa-id-card mr-2"></i> Teacher ID: <?php echo htmlspecialchars($teacher['teacher_id']); ?></p>
                <div class="flex flex-wrap justify-center md:justify-start mt-4 gap-4">
                    <?php if (!empty($teacher['email'])): ?>
                        <p class="text-gray-600"><i class="fas fa-envelope mr-2"></i> <?php echo htmlspecialchars($teacher['email']); ?></p>
                    <?php endif; ?>
                    <?php if (!empty($teacher['phone'])): ?>
                        <p class="text-gray-600"><i class="fas fa-phone mr-2"></i> <?php echo htmlspecialchars($teacher['phone']); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Students Taught by This Teacher -->
        
    </div>
</div>
</body>
</html>

<?php include 'include/footer.php'; ?>
