<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// Check login
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'parent') {
    header('Location: login.php');
    exit();
}

$parent_id = $_SESSION['user_id'];
$success = '';
$error = '';

// Get children for this parent - FIXED QUERY
// Assuming the parent ID is stored in the students table as parent_id
$children_query = "SELECT s.id, s.full_name, s.student_id, s.roll_number, 
                          c.class_name, sec.section_name
                   FROM students s
                   LEFT JOIN classes c ON s.class = c.id
                   LEFT JOIN sections sec ON s.section = sec.id
                   WHERE s.parent_id = $parent_id";
$children_result = mysqli_query($conn, $children_query);

// Check if query was successful
if (!$children_result) {
    $error = "Database error: " . mysqli_error($conn);
}

// Which child is selected?
$student_id = isset($_GET['student_id']) ? intval($_GET['student_id']) : 0;

// If no child selected, show list
if ($student_id === 0) {
    ?>
    <div class="bg-white p-6  ">
        <h2 class="text-2xl font-bold mb-4">Select a Child</h2>
        
        <?php if (!empty($error)): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <?php echo $error; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($children_result && mysqli_num_rows($children_result) > 0): ?>
            <ul class="space-y-3">
                <?php while ($child = mysqli_fetch_assoc($children_result)): ?>
                    <li class="p-4 border  flex justify-between items-center hover:bg-gray-50">
                        <div>
                            <p class="font-semibold"><?php echo htmlspecialchars($child['full_name']); ?></p>
                            <p class="text-sm text-gray-600">
                                <?php echo htmlspecialchars($child['class_name'].' - '.$child['section_name']); ?>
                            </p>
                        </div>
                        <a href="result.php?student_id=<?php echo $child['id']; ?>"
                           class="bg-blue-600 text-white px-4 py-2 rounded">
                           View Results
                        </a>
                    </li>
                <?php endwhile; ?>
            </ul>
        <?php else: ?>
            <p class="text-gray-700">No children linked to this parent account.</p>
        <?php endif; ?>
    </div>
    <?php
    include 'include/footer.php';
    ob_end_flush();
    exit();
}

// Verify the selected student belongs to the parent
$valid_student = false;
if ($children_result) {
    mysqli_data_seek($children_result, 0); // Reset pointer
    while ($child = mysqli_fetch_assoc($children_result)) {
        if ($child['id'] == $student_id) {
            $valid_student = true;
            break;
        }
    }
}

if (!$valid_student) {
    header('Location: result.php');
    exit();
}

// Fetch student details
$student_query = "SELECT s.*, c.class_name, sec.section_name 
                  FROM students s 
                  LEFT JOIN classes c ON s.class = c.id 
                  LEFT JOIN sections sec ON s.section = sec.id 
                  WHERE s.id = $student_id";
$student_result = mysqli_query($conn, $student_query);
$student = mysqli_fetch_assoc($student_result);

if (!$student) {
    $error = "Invalid student selected.";
}

// Fetch only released exams for this student
$exams_query = "SELECT DISTINCT e.id, e.exam_name, e.exam_date 
                FROM exams e 
                JOIN exam_results er ON e.id = er.exam_id 
                WHERE er.student_id = $student_id AND er.is_released = 1
                ORDER BY e.exam_date DESC";
$exams_result = mysqli_query($conn, $exams_query);

// Fetch school information
$school_query = "SELECT * FROM school_info LIMIT 1";
$school_result = mysqli_query($conn, $school_query);
$school_info = mysqli_fetch_assoc($school_result);

// If no school info exists, create default
if (!$school_info) {
    $school_info = [
        'school_name' => 'Adino Height School',
        'address' => '123 School Street, City, State',
        'phone' => '+1234567890',
        'email' => 'info@adinoheight.edu',
        'logo' => '',
        'motto' => 'Excellence in Education'
    ];
}

// Get current academic year and term
$current_year = date('Y');
$current_month = date('n');
$academic_year = ($current_month >= 8) ? $current_year . '/' . ($current_year + 1) : ($current_year - 1) . '/' . $current_year;
$term = '';
if ($current_month >= 1 && $current_month <= 4) {
    $term = 'Third Term';
} elseif ($current_month >= 5 && $current_month <= 8) {
    $term = 'Second Term';
} else {
    $term = 'First Term';
}

// Function to get student results data (only if released)
function getStudentResultsData($conn, $student_id, $exam_id) {
    // First check if result is released
    $release_check = "SELECT is_released FROM exam_results 
                     WHERE student_id = $student_id AND exam_id = $exam_id 
                     LIMIT 1";
    $release_result = mysqli_query($conn, $release_check);
    
    if (!$release_result) {
        return false;
    }
    
    $release_status = mysqli_fetch_assoc($release_result);
    
    if (!$release_status || !$release_status['is_released']) {
        return false; // Result not released
    }
    
    // Fetch student details
    $student_query = "SELECT s.*, c.class_name, sec.section_name 
                      FROM students s 
                      LEFT JOIN classes c ON s.class = c.id 
                      LEFT JOIN sections sec ON s.section = sec.id 
                      WHERE s.id = $student_id";
    $student_result = mysqli_query($conn, $student_query);
    $student = mysqli_fetch_assoc($student_result);
    
    // Fetch exam details
    $exam_query = "SELECT * FROM exams WHERE id = $exam_id";
    $exam_result = mysqli_query($conn, $exam_query);
    $exam = mysqli_fetch_assoc($exam_result);
    
    // Fetch all results for this student and exam (only if released)
    $results_query = "SELECT er.*, s.subject_name 
                      FROM exam_results er 
                      JOIN subjects s ON er.subject_id = s.id 
                      WHERE er.student_id = $student_id AND er.exam_id = $exam_id 
                      AND er.is_released = 1
                      ORDER BY s.subject_name";
    $results_result = mysqli_query($conn, $results_query);
    $results = [];
    $total_marks = 0;
    $obtained_marks = 0;
    
    if ($results_result) {
        while ($row = mysqli_fetch_assoc($results_result)) {
            $results[] = $row;
            $obtained_marks += $row['ca_score'] + $row['exam_score'];
            $total_marks += $exam['total_marks'];
        }
    }
    
    // Calculate overall percentage and grade
    $overall_percentage = $total_marks > 0 ? ($obtained_marks / $total_marks) * 100 : 0;
    
    // Determine overall grade
    $overall_grade = '';
    if ($overall_percentage >= 90) $overall_grade = 'A+';
    elseif ($overall_percentage >= 80) $overall_grade = 'A';
    elseif ($overall_percentage >= 70) $overall_grade = 'B+';
    elseif ($overall_percentage >= 60) $overall_grade = 'B';
    elseif ($overall_percentage >= 50) $overall_grade = 'C';
    elseif ($overall_percentage >= 40) $overall_grade = 'D';
    else $overall_grade = 'F';
    
    // Fetch attendance data for the term
    $attendance_query = "SELECT 
                         COUNT(*) as total_days,
                         SUM(CASE WHEN status = 'present' THEN 1 ELSE 0 END) as present_days,
                         SUM(CASE WHEN status = 'absent' THEN 1 ELSE 0 END) as absent_days,
                         SUM(CASE WHEN status = 'late' THEN 1 ELSE 0 END) as late_days,
                         SUM(CASE WHEN status = 'half_day' THEN 1 ELSE 0 END) as half_days
                         FROM attendance 
                         WHERE student_id = $student_id 
                         AND attendance_date BETWEEN DATE_SUB(NOW(), INTERVAL 3 MONTH) AND NOW()";
    $attendance_result = mysqli_query($conn, $attendance_query);
    $attendance = $attendance_result ? mysqli_fetch_assoc($attendance_result) : [
        'total_days' => 0,
        'present_days' => 0,
        'absent_days' => 0,
        'late_days' => 0,
        'half_days' => 0
    ];
    
    return [
        'student' => $student,
        'exam' => $exam,
        'results' => $results,
        'total_marks' => $total_marks,
        'obtained_marks' => $obtained_marks,
        'overall_percentage' => $overall_percentage,
        'overall_grade' => $overall_grade,
        'attendance' => $attendance
    ];
}

// Handle PDF generation (only if released)
if (isset($_GET['action']) && $_GET['action'] == 'download' && isset($_GET['exam_id'])) {
    $exam_id = intval($_GET['exam_id']);
    
    $data = getStudentResultsData($conn, $student_id, $exam_id);
    
    if (!$data) {
        // Result not released
        header("Location: result.php?student_id=$student_id&error=Result not available or not released yet");
        exit();
    }
    
    extract($data);
    
    // Clear any previous output
    ob_end_clean();
    
    // Check if TCPDF exists, otherwise provide a simple PDF download
    if (file_exists('../tcpdf/TCPDF-main/tcpdf.php')) {
        require_once('../tcpdf/TCPDF-main/tcpdf.php');
        
        // Create new PDF document
        $pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);
        
        // Set document information
        $pdf->SetCreator('Adino Height School');
        $pdf->SetAuthor('Adino Height School');
        $pdf->SetTitle('Report Card - ' . $student['full_name']);
        $pdf->SetSubject('Student Report Card');
        
        // Get logo path correctly
        $logo_path = '';
        if (!empty($school_info['logo'])) {
            // Check if file exists in both possible locations
            if (file_exists('../admin/uploads/' . $school_info['logo'])) {
                $logo_path = '../admin/uploads/' . $school_info['logo'];
            } elseif (file_exists('uploads/' . $school_info['logo'])) {
                $logo_path = 'uploads/' . $school_info['logo'];
            }
        }
        
        // Set default header data
        $pdf->SetHeaderData('', 0, $school_info['school_name'], 'Academic Report Card');
        
        // Set header and footer fonts
        $pdf->setHeaderFont(Array('helvetica', '', 10));
        $pdf->setFooterFont(Array('helvetica', '', 8));
        
        // Set margins
        $pdf->SetMargins(15, 25, 15);
        $pdf->SetHeaderMargin(10);
        $pdf->SetFooterMargin(10);
        
        // Set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 25);
        
        // Add a page
        $pdf->AddPage();
        
        // Set font
        $pdf->SetFont('helvetica', '', 10);
        
        // School header with logo
        $html = '
        <div style="text-align: center;">
            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                <tr>
                    <td width="20%" style="text-align: left; vertical-align: middle;">';
        
        if (!empty($logo_path) && file_exists($logo_path)) {
            $html .= '<img src="' . $logo_path . '" style="height: 60px;">';
        }
        
        $html .= '</td>
                    <td width="60%" style="text-align: center; vertical-align: middle;">
                        <h1 style="font-size: 18px; margin-bottom: 5px;">' . $school_info['school_name'] . '</h1>
                        <p style="font-size: 12px; margin: 0;">' . $school_info['address'] . '</p>
                        <p style="font-size: 12px; margin: 0;">Phone: ' . $school_info['phone'] . ' | Email: ' . $school_info['email'] . '</p>
                        <p style="font-size: 12px; margin: 0; font-style: italic;">' . $school_info['motto'] . '</p>
                    </td>
                    <td width="20%" style="text-align: right; vertical-align: middle;">
                        <!-- Empty space for alignment -->
                    </td>
                </tr>
            </table>
            <hr style="margin: 10px 0;">
        </div>
        
        <h2 style="text-align: center; font-size: 16px; margin: 10px 0;">STUDENT REPORT CARD</h2>
        
        <table border="0" cellpadding="5" width="100%">
            <tr>
                <td width="50%">
                    <strong>Student Name:</strong> ' . $student['full_name'] . '<br>
                    <strong>Student ID:</strong>' . $student['student_id'] . 'br
                    <strong>Roll Number:</strong> ' . $student['roll_number'] . '
                </td>
                <td width="50%">
                    <strong>Class:</strong> ' . $student['class_name'] . ' - ' . $student['section_name'] . '<br>
                    <strong>Academic Year:</strong> ' . $academic_year . '<br>
                    <strong>Term:</strong> ' . $term . '
                </td>
            </tr>
            <tr>
                <td>
                    <strong>Exam:</strong> ' . $exam['exam_name'] . '<br>
                    <strong>Exam Date:</strong> ' . date('F j, Y', strtotime($exam['exam_date'])) . '
                </td>
                <td>
                    <strong>Date Issued:</strong> ' . date('F j, Y') . '
                </td>
            </tr>
        </table>
        
        <br>
        
        <h3 style="font-size: 14px; margin: 10px 0;">ACADEMIC PERFORMANCE</h3>
        <table border="1" cellpadding="5" width="100%">
            <tr style="background-color: #f2f2f2;">
                <th width="40%"><strong>Subject</strong></th>
                <th width="15%"><strong>CA Score</strong></th>
                <th width="15%"><strong>Exam Score</strong></th>
                <th width="15%"><strong>Total</strong></th>
                <th width="15%"><strong>Grade</strong></th>
            </tr>';
        
        foreach ($results as $result) {
            $total_score = $result['ca_score'] + $result['exam_score'];
            $html .= '
            <tr>
                <td>' . $result['subject_name'] . '</td>
                <td>' . $result['ca_score'] . '</td>
                <td>' . $result['exam_score'] . '</td>
                <td>' . $total_score . '</td>
                <td>' . $result['grade'] . '</td>
            </tr>';
        }
        
        $html .= '
            <tr style="background-color: #f2f2f2;">
                <td colspan="3" align="right"><strong>Overall Total:</strong></td>
                <td><strong>' . $obtained_marks . '/' . $total_marks . '</strong></td>
                <td><strong>' . $overall_grade . '</strong></td>
            </tr>
            <tr style="background-color: #f2f2f2;">
                <td colspan="3" align="right"><strong>Overall Percentage:</strong></td>
                <td colspan="2"><strong>' . number_format($overall_percentage, 2) . '%</strong></td>
            </tr>
        </table>
        
        <br>
        
        <h3 style="font-size: 14px; margin: 10px 0;">ATTENDANCE RECORD</h3>
        <table border="1" cellpadding="5" width="100%">
            <tr style="background-color: #f2f2f2;">
                <th width="25%"><strong>Total Days</strong></th>
                <th width="25%"><strong>Present</strong></th>
                <th width="25%"><strong>Absent</strong></th>
                <th width="25%"><strong>Attendance %</strong></th>
            </tr>
            <tr>
                <td>' . $attendance['total_days'] . '</td>
                <td>' . $attendance['present_days'] . '</td>
                <td>' . $attendance['absent_days'] . '</td>
                <td>' . ($attendance['total_days'] > 0 ? number_format(($attendance['present_days'] / $attendance['total_days']) * 100, 2) . '%' : '0%') . '</td>
            </tr>
        </table>
        
        <br>
        
        <h3 style="font-size: 14px; margin: 10px 0;">GRADING SYSTEM</h3>
        <table border="1" cellpadding="5" width="100%">
            <tr style="background-color: #f2f2f2;">
                <th width="20%"><strong>Percentage</strong></th>
                <th width="20%"><strong>Grade</strong></th>
                <th width="60%"><strong>Remarks</strong></th>
            </tr>
            <tr>
                <td>90-100%</td>
                <td>A+</td>
                <td>Excellent</td>
            </tr>
            <tr>
                <td>80-89%</td>
                <td>A</td>
                <td>Very Good</td>
            </tr>
            <tr>
                <td>70-79%</td>
                <td>B+</td>
                <td>Good</td>
            </tr>
            <tr>
                <td>60-69%</td>
                <td>B</td>
                <td>Satisfactory</td>
            </tr>
            <tr>
                <td>50-59%</td>
                <td>C</td>
                <td>Average</td>
            </tr>
            <tr>
                <td>40-49%</td>
                <td>D</td>
                <td>Below Average</td>
            </tr>
            <tr>
                <td>Below 40%</td>
                <td>F</td>
                <td>Fail</td>
            </tr>
        </table>
        
        <br>
        
        <table border="0" cellpadding="5" width="100%">
            <tr>
                <td width="50%">
                    <strong>Class Teacher\'s Remarks:</strong><br>
                    <br><br><br>
                    _________________________<br>
                    Signature & Date
                </td>
                <td width="50%">
                    <strong>Principal\'s Remarks:</strong><br>
                    <br><br><br>
                    _________________________<br>
                    Signature & Date
                </td>
            </tr>
        </table>
        
        <div style="text-align: center; margin-top: 20px; font-size: 10px;">
            This is a computer generated report. No signature is required.
        </div>';
        
        // Output HTML content
        $pdf->writeHTML($html, true, false, true, false, '');
        
        // Close and output PDF document
        $pdf->Output('report_card_' . $student['student_id'] . '_' . $exam['exam_name'] . '.pdf', 'D');
    } else {
        // Simple text-based PDF alternative
        header('Content-Type: application/pdf');
        header('Content-Disposition: attachment; filename="report_card_' . $student['student_id'] . '_' . $exam['exam_name'] . '.pdf"');
        
        $pdf_content = "Report Card\n";
        $pdf_content .= "School: " . $school_info['school_name'] . "\n";
        $pdf_content .= "Student: " . $student['full_name'] . "\n";
        $pdf_content .= "Class: " . $student['class_name'] . ' - ' . $student['section_name'] . "\n";
        $pdf_content .= "Exam: " . $exam['exam_name'] . "\n\n";
        
        $pdf_content .= "SUBJECTS:\n";
        foreach ($results as $result) {
            $total_score = $result['ca_score'] + $result['exam_score'];
            $pdf_content .= $result['subject_name'] . ": " . $total_score . " (" . $result['grade'] . ")\n";
        }
        
        $pdf_content .= "\nOverall: " . $obtained_marks . "/" . $total_marks . " (" . number_format($overall_percentage, 2) . "%) " . $overall_grade . "\n";
        
        echo $pdf_content;
    }
    exit();
}

// Handle view action (only if released)
if (isset($_GET['action']) && $_GET['action'] == 'view' && isset($_GET['exam_id'])) {
    $exam_id = intval($_GET['exam_id']);
    
    $data = getStudentResultsData($conn, $student_id, $exam_id);
    
    if (!$data) {
        // Result not released
        header("Location: result.php?student_id=$student_id&error=Result not available or not released yet");
        exit();
    }
    
    extract($data);
    
    // Get logo path correctly
    $logo_path = '';
    if (!empty($school_info['logo'])) {
        // Check if file exists in both possible locations
        if (file_exists('../admin/uploads/' . $school_info['logo'])) {
            $logo_path = '../admin/uploads/' . $school_info['logo'];
        } elseif (file_exists('uploads/' . $school_info['logo'])) {
            $logo_path = 'uploads/' . $school_info['logo'];
        }
    }
    
    // Display the report in HTML format
    echo '<!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Student Report - ' . $student['full_name'] . '</title>
        <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
        <style>
            @media print {
                .no-print {
                    display: none !important;
                }
                body {
                    margin: 0;
                    padding: 15px;
                }
            }
        </style>
    </head>
    <body class="bg-gray-100">
        <div class="container mx-auto p-4 bg-white ">
            <div class="text-center mb-6 no-print">
                <button onclick="window.print()" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 ">
                    <i class="fas fa-print mr-2"></i> Print Report
                </button>
                <a href="result.php?student_id=' . $student_id . '&action=download&exam_id=' . $exam_id . '" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2  ml-2">
                    <i class="fas fa-download mr-2"></i> Download PDF
                </a>
                <a href="result.php?student_id=' . $student_id . '" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2  ml-2">
                    <i class="fas fa-arrow-left mr-2"></i> Back to Results
                </a>
            </div>
            
            <div style="text-align: center;">
                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                    <tr>
                        <td width="20%" style="text-align: left; vertical-align: middle;">';
    
    if (!empty($logo_path) && file_exists($logo_path)) {
        echo '<img src="' . $logo_path . '" style="height: 60px;">';
    }
    
    echo '</td>
                        <td width="60%" style="text-align: center; vertical-align: middle;">
                            <h1 style="font-size: 18px; margin-bottom: 5px;">' . $school_info['school_name'] . '</h1>
                            <p style="font-size: 12px; margin: 0;">' . $school_info['address'] . '</p>
                            <p style="font-size: 12px; margin: 0;">Phone: ' . $school_info['phone'] . ' | Email: ' . $school_info['email'] . '</p>
                            <p style="font-size: 12px; margin: 0; font-style: italic;">' . $school_info['motto'] . '</p>
                        </td>
                        <td width="20%" style="text-align: right; vertical-align: middle;">
                            <!-- Empty space for alignment -->
                        </td>
                    </tr>
                </table>
                <hr style="margin: 10px 0;">
            </div>
            
            <h2 style="text-align: center; font-size: 16px; margin: 10px 0;">STUDENT REPORT CARD</h2>
            
            <table border="0" cellpadding="5" width="100%">
                <tr>
                    <td width="50%">
                        <strong>Student Name:</strong> ' . $student['full_name'] . '<br>
                        <strong>Student ID:</strong> ' . $student['student_id'] . '<br>
                        <strong>Roll Number:</strong> ' . $student['roll_number'] . '
                    </td>
                    <td width="50%">
                        <strong>Class:</strong> ' . $student['class_name'] . ' - ' . $student['section_name'] . '<br>
                        <strong>Academic Year:</strong> ' . $academic_year . '<br>
                        <strong>Term:</strong> ' . $term . '
                    </td>
                </tr>
                <tr>
                    <td>
                        <strong>Exam:</strong> ' . $exam['exam_name'] . '<br>
                        <strong>Exam Date:</strong> ' . date('F j, Y', strtotime($exam['exam_date'])) . '
                    </td>
                    <td>
                        <strong>Date Issued:</strong> ' . date('F j, Y') . '
                    </td>
                </tr>
            </table>
            
            <br>
            
            <h3 style="font-size: 14px; margin: 10px 0;">ACADEMIC PERFORMANCE</h3>
            <table border="1" cellpadding="5" width="100%" style="border-collapse: collapse;">
                <tr style="background-color: #f2f2f2;">
                    <th width="40%"><strong>Subject</strong></th>
                    <th width="15%"><strong>CA Score</strong></th>
                    <th width="15%"><strong>Exam Score</strong></th>
                    <th width="15%"><strong>Total</strong></th>
                    <th width="15%"><strong>Grade</strong></th>
                </tr>';
    
    foreach ($results as $result) {
        $total_score = $result['ca_score'] + $result['exam_score'];
        echo '
                <tr>
                    <td>' . $result['subject_name'] . '</td>
                    <td>' . $result['ca_score'] . '</td>
                    <td>' . $result['exam_score'] . '</td>
                    <td>' . $total_score . '</td>
                    <td>' . $result['grade'] . '</td>
                </tr>';
    }
    
    echo '
                <tr style="background-color: #f2f2f2;">
                    <td colspan="3" align="right"><strong>Overall Total:</strong></td>
                    <td><strong>' . $obtained_marks . '/' . $total_marks . '</strong></td>
                    <td><strong>' . $overall_grade . '</strong></td>
                </tr>
                <tr style="background-color: #f2f2f2;">
                    <td colspan="3" align="right"><strong>Overall Percentage:</strong></td>
                    <td colspan="2"><strong>' . number_format($overall_percentage, 2) . '%</strong></td>
                </tr>
            </table>
            
            <br>
            
            <h3 style="font-size: 14px; margin: 10px 0;">ATTENDANCE RECORD</h3>
            <table border="1" cellpadding="5" width="100%" style="border-collapse: collapse;">
                <tr style="background-color: #f2f2f2;">
                    <th width="25%"><strong>Total Days</strong></th>
                    <th width="25%"><strong>Present</strong></th>
                    <th width="25%"><strong>Absent</strong></th>
                    <th width="25%"><strong>Attendance %</strong></th>
                </tr>
                <tr>
                    <td>' . $attendance['total_days'] . '</td>
                    <td>' . $attendance['present_days'] . '</td>
                    <td>' . $attendance['absent_days'] . '</td>
                    <td>' . ($attendance['total_days'] > 0 ? number_format(($attendance['present_days'] / $attendance['total_days']) * 100, 2) . '%' : '0%') . '</td>
                </tr>
            </table>
            
            <br>
            
            <h3 style="font-size: 14px; margin: 10px 0;">GRADING SYSTEM</h3>
            <table border="1" cellpadding="5" width="100%" style="border-collapse: collapse;">
                <tr style="background-color: #f2f2f2;">
                    <th width="20%"><strong>Percentage</strong></th>
                    <th width="20%"><strong>Grade</strong></th>
                    <th width="60%"><strong>Remarks</strong></th>
                </tr>
                <tr>
                    <td>90-100%</td>
                    <td>A+</td>
                    <td>Excellent</td>
                </tr>
                <tr>
                    <td>80-89%</td>
                    <td>A</td>
                    <td>Very Good</td>
                </tr>
                <tr>
                    <td>70-79%</td>
                    <td>B+</td>
                    <td>Good</td>
                </tr>
                <tr>
                    <td>60-69%</td>
                    <td>B</td>
                    <td>Satisfactory</td>
                </tr>
                <tr>
                    <td>50-59%</td>
                    <td>C</td>
                    <td>Average</td>
                </tr>
                <tr>
                    <td>40-49%</td>
                    <td>D</td>
                    <td>Below Average</td>
                </tr>
                <tr>
                    <td>Below 40%</td>
                    <td>F</td>
                    <td>Fail</td>
                </tr>
            </table>
            
            <br>
            
            <table border="0" cellpadding="5" width="100%">
                <tr>
                    <td width="50%">
                        <strong>Class Teacher\'s Remarks:</strong><br>
                        <br><br><br>
                        _________________________<br>
                        Signature & Date
                    </td>
                    <td width="50%">
                        <strong>Principal\'s Remarks:</strong><br>
                        <br><br><br>
                        _________________________<br>
                        Signature & Date
                    </td>
                </tr>
            </table>
            
            <div style="text-align: center; margin-top: 20px; font-size: 10px;">
                This is a computer generated report. No signature is required.
            </div>
        </div>
    </body>
    </html>';
    exit();
}

// Display error message if any
if (isset($_GET['error'])) {
    $error = $_GET['error'];
}
?>

<div class="bg-white p-0  ">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Academic Results for <?php echo htmlspecialchars($student['full_name']); ?></h2>
        <a href="result.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded">
            <i class="fas fa-arrow-left mr-2"></i> Back to Children List
        </a>
    </div>

    <?php if (!empty($success)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo $success; ?>
        </div>
    <?php endif; ?>
    
    <?php if (!empty($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <?php echo $error; ?>
        </div>
    <?php endif; ?>

    <!-- Student Information -->
    <div class="mb-6 bg-blue-50 p-4 ">
        <h3 class="text-lg font-semibold text-blue-800 mb-2">Student Information</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <p><strong>Name:</strong> <?php echo htmlspecialchars($student['full_name']); ?></p>
                <p><strong>Student ID:</strong> <?php echo htmlspecialchars($student['student_id']); ?></p>
                <p><strong>Roll Number:</strong> <?php echo htmlspecialchars($student['roll_number']); ?></p>
            </div>
            <div>
                <p><strong>Class:</strong> <?php echo htmlspecialchars($student['class_name'] . ' - ' . $student['section_name']); ?></p>
                <p><strong>Academic Year:</strong> <?php echo $academic_year; ?></p>
                <p><strong>Current Term:</strong> <?php echo $term; ?></p>
            </div>
        </div>
    </div>

    <!-- Available Exams -->
    <div class="mb-6">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">Available Exam Results</h3>
        
        <?php if ($exams_result && mysqli_num_rows($exams_result) > 0): ?>
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white border border-gray-200">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="py-3 px-4 text-left">Exam Name</th>
                            <th class="py-3 px-4 text-left">Exam Date</th>
                            <th class="py-3 px-4 text-left">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($exam = mysqli_fetch_assoc($exams_result)): ?>
                            <tr class="border-b border-gray-200 hover:bg-gray-50">
                                <td class="py-3 px-4"><?php echo htmlspecialchars($exam['exam_name']); ?></td>
                                <td class="py-3 px-4"><?php echo date('F j, Y', strtotime($exam['exam_date'])); ?></td>
                                <td class="py-3 px-4">
                                    <div class="flex space-x-2">
                                        <a href="result.php?student_id=<?php echo $student_id; ?>&action=view&exam_id=<?php echo $exam['id']; ?>" 
                                           class="bg-blue-600 hover:bg-blue-700 text-white px-3 py-1 rounded flex items-center">
                                            <i class="fas fa-eye mr-1"></i> View
                                        </a>
                                        <a href="result.php?student_id=<?php echo $student_id; ?>&action=download&exam_id=<?php echo $exam['id']; ?>" 
                                           class="bg-green-600 hover:bg-green-700 text-white px-3 py-1 rounded flex items-center">
                                            <i class="fas fa-download mr-1"></i> Download
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="bg-yellow-50 border border-yellow-200  p-4 text-center">
                <i class="fas fa-exclamation-circle text-yellow-500 text-3xl mb-2"></i>
                <p class="text-yellow-700">No exam results available at this time. Results will appear here once released by your administrator.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php
include 'include/footer.php';
ob_end_flush();
?>