<?php
session_start();
include '../config/conn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Validate payment ID
$payment_id = isset($_GET['payment_id']) ? intval($_GET['payment_id']) : 0;
if ($payment_id <= 0) {
    die("Invalid payment ID");
}

// Get payment details
$payment_query = "SELECT p.*, i.description, i.amount as invoice_amount, 
                 s.full_name, s.student_id, s.roll_number, 
                 c.class_name, sec.section_name
                 FROM payments p
                 JOIN invoices i ON p.invoice_id = i.id
                 JOIN students s ON i.student_id = s.id
                 LEFT JOIN classes c ON s.class = c.id
                 LEFT JOIN sections sec ON s.section = sec.id
                 WHERE p.id = $payment_id";

$payment_result = mysqli_query($conn, $payment_query);

if (!$payment_result || mysqli_num_rows($payment_result) == 0) {
    die("Payment not found for ID: $payment_id");
}

$payment = mysqli_fetch_assoc($payment_result);

// Check if user has permission to view this receipt

require_once(__DIR__ . '/../tcpdf/TCPDF-main/tcpdf.php');

// Create new PDF document
$pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);

// Set document info
$pdf->SetCreator('AdinoHeight College');
$pdf->SetAuthor('AdinoHeight College');
$pdf->SetTitle('Payment Receipt - ' . $payment['student_id']);
$pdf->SetSubject('Payment Receipt');

// Add a page
$pdf->AddPage();

// Build HTML content
$html = '
<style>
    .header { text-align: center; margin-bottom: 20px; }
    .school-name { font-size: 20px; font-weight: bold; color: #2c3e50; }
    .receipt-title { font-size: 18px; color: #3498db; margin-top: 5px; }
    .details { margin: 15px 0; }
    .detail-row { margin: 6px 0; }
    .label { font-weight: bold; display: inline-block; width: 120px; }
    .footer { margin-top: 30px; text-align: center; font-size: 12px; color: #7f8c8d; }
    .signature { margin-top: 40px; border-top: 1px solid #000; width: 200px; margin-left: auto; margin-right: auto; }
    table { width: 100%; border-collapse: collapse; margin: 15px 0; }
    th { background-color: #f2f2f2; text-align: left; padding: 8px; border: 1px solid #ddd; }
    td { padding: 8px; border: 1px solid #ddd; }
    .total-row { font-weight: bold; }
</style>

<div class="header">
    <div class="school-name">ADINOHEIGHT COLLEGE</div>
    <div class="receipt-title">PAYMENT RECEIPT</div>
</div>

<div class="details">
    <div class="detail-row"><span class="label">Receipt No:</span> REC' . str_pad($payment_id, 6, '0', STR_PAD_LEFT) . '</div>
    <div class="detail-row"><span class="label">Date:</span> ' . date('F j, Y', strtotime($payment['payment_date'])) . '</div>
    <div class="detail-row"><span class="label">Student Name:</span> ' . $payment['full_name'] . '</div>
    <div class="detail-row"><span class="label">Student ID:</span> ' . $payment['student_id'] . '</div>
    <div class="detail-row"><span class="label">Class:</span> ' . $payment['class_name'] . ' - ' . $payment['section_name'] . '</div>
    <div class="detail-row"><span class="label">Roll No:</span> ' . $payment['roll_number'] . '</div>
</div>

<table>
    <tr>
        <th width="70%">Description</th>
        <th width="30%">Amount (₦)</th>
    </tr>
    <tr>
        <td>' . $payment['description'] . '</td>
        <td>' . number_format($payment['invoice_amount'], 2) . '</td>
    </tr>
    <tr class="total-row">
        <td style="text-align:right;">Amount Paid:</td>
        <td>' . number_format($payment['amount'], 2) . '</td>
    </tr>
    <tr>
        <td style="text-align:right;">Payment Method:</td>
        <td>' . ucfirst($payment['payment_method']) . '</td>
    </tr>
    <tr>
        <td style="text-align:right;">Transaction ID:</td>
        <td>' . (!empty($payment['transaction_id']) ? $payment['transaction_id'] : 'N/A') . '</td>
    </tr>
    <tr>
        <td style="text-align:right;">Payment Date:</td>
        <td>' . date('M j, Y g:i A', strtotime($payment['payment_date'])) . '</td>
    </tr>
</table>

<div class="footer">
    <div>Thank you for your payment!</div>
    <div>AdinoHeight College<br>www.adinoheightcollege.edu.ng</div>
    <div class="signature"></div>
</div>
';

// Output HTML content
$pdf->writeHTML($html, true, false, true, false, '');

// Download as PDF
$pdf->Output('receipt_' . $payment['student_id'] . '_' . date('Ymd_His') . '.pdf', 'D');
?>