<?php
include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in and is a teacher
if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_type']) || $_SESSION['user_type'] !== 'teacher') {
    header('Location: ../portal_login.php');
    exit();
}

$teacher_id = $_SESSION['user_id'];

// --- Fetch teacher data with ALL required fields ---
$sql = "SELECT * FROM users WHERE id = ? AND role = 'teacher'";
$stmt1 = $conn->prepare($sql);
$stmt1->bind_param("i", $teacher_id);
$stmt1->execute();
$result1 = $stmt1->get_result();

if ($result1->num_rows == 0) {
    echo "<div class='bg-white p-6  '>
            <div class='bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4'>
                Teacher not found.
            </div>
          </div>";
    exit();
}

$teacher = $result1->fetch_assoc();
$stmt1->close();

// --- Fetch admin who created this teacher record ---
$admin_name = "Unknown";
if (!empty($teacher['created_by'])) {
    $admin_sql = "SELECT name FROM users WHERE id = ?";
    $stmt2 = $conn->prepare($admin_sql);
    $stmt2->bind_param("i", $teacher['created_by']);
    $stmt2->execute();
    $result2 = $stmt2->get_result();

    if ($result2->num_rows > 0) {
        $admin_data = $result2->fetch_assoc();
        $admin_name = $admin_data['name'];
    }
    $stmt2->close();
}

// --- Display teacher profile ---
?>
<div class="bg-white p-6  ">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Teacher Profile</h2>

    </div>

    <!-- Teacher Header -->
    <div class="bg-blue-50 p-6  mb-6 flex items-center">
        <div class="mr-4">
            <?php if (!empty($teacher['image'])): ?>
                <img src="<?php echo htmlspecialchars($teacher['image']); ?>" alt="<?php echo htmlspecialchars($teacher['full_name']); ?>" class="w-24 h-24 rounded-full object-cover border-4 border-white shadow">
            <?php else: ?>
                <div class="w-24 h-24 rounded-full bg-blue-100 flex items-center justify-center border-4 border-white shadow">
                    <i class="fas fa-user text-blue-400 text-3xl"></i>
                </div>
            <?php endif; ?>
        </div>
        <div>
            <h1 class="text-2xl font-bold text-gray-800"><?php echo !empty($teacher['full_name']) ? htmlspecialchars($teacher['full_name']) : htmlspecialchars($teacher['name']); ?></h1>
            <p class="text-gray-600">ID: <?php echo !empty($teacher['teacher_id']) ? htmlspecialchars($teacher['teacher_id']) : 'Not provided'; ?></p>
            <div class="flex items-center mt-2">
                <?php if (!empty($teacher['status']) && $teacher['status'] == 'active'): ?>
                    <span class="bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Active</span>
                <?php else: ?>
                    <span class="bg-red-100 text-red-800 text-xs font-medium px-2.5 py-0.5 rounded-full"><?php echo !empty($teacher['status']) ? ucfirst($teacher['status']) : 'Inactive'; ?></span>
                <?php endif; ?>
                <span class="mx-2 text-gray-400">•</span>
                <span class="text-gray-600"><i class="fas fa-book mr-1"></i> <?php echo !empty($teacher['subjects']) ? htmlspecialchars($teacher['subjects']) : 'Not specified'; ?></span>
            </div>
        </div>
    </div>

    <!-- Teacher Information in Table Format -->
    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">Personal Information</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Date of Birth</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['dob']) ? date('F j, Y', strtotime($teacher['dob'])) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Gender</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['gender']) ? ucfirst($teacher['gender']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Nationality</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['nationality']) ? htmlspecialchars($teacher['nationality']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">ID Number</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['id_number']) ? htmlspecialchars($teacher['id_number']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Blood Group</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['blood_group']) ? htmlspecialchars($teacher['blood_group']) : 'Not provided'; ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">Contact Information</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Address</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['address']) ? htmlspecialchars($teacher['address']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Phone</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['phone']) ? htmlspecialchars($teacher['phone']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Email</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['email']) ? htmlspecialchars($teacher['email']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Emergency Contact</td>
                    <td class="py-3 px-4">
                        <?php if (!empty($teacher['emergency_contact'])): ?>
                            <?php echo htmlspecialchars($teacher['emergency_contact']); ?>
                            <?php if (!empty($teacher['emergency_phone'])): ?>
                                (<?php echo htmlspecialchars($teacher['emergency_phone']); ?>)
                            <?php endif; ?>
                        <?php else: ?>
                            Not provided
                        <?php endif; ?>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">Educational Background</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Highest Degree</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['highest_degree']) ? htmlspecialchars($teacher['highest_degree']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">University</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['university']) ? htmlspecialchars($teacher['university']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Graduation Year</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['graduation_year']) ? htmlspecialchars($teacher['graduation_year']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Specialization</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['specialization']) ? htmlspecialchars($teacher['specialization']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Certifications</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['certifications']) ? htmlspecialchars($teacher['certifications']) : 'None provided'; ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">Professional Information</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Subjects</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['subjects']) ? htmlspecialchars($teacher['subjects']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Grades</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['grades']) ? htmlspecialchars($teacher['grades']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Experience</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['experience']) ? htmlspecialchars($teacher['experience']) . ' years' : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Previous School</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['previous_school']) ? htmlspecialchars($teacher['previous_school']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Salary</td>
                    <td class="py-3 px-4">
                        <?php 
                        if (!empty($teacher['salary'])) {
                            echo htmlspecialchars($teacher['salary']);
                        } elseif (!empty($teacher['salary_expectation'])) {
                            echo htmlspecialchars($teacher['salary_expectation']);
                        } else {
                            echo 'Not provided';
                        }
                        ?>
                    </td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Hire Date</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['hire_date']) ? date('F j, Y', strtotime($teacher['hire_date'])) : 'Not provided'; ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">Additional Information</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Skills</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['skills']) ? htmlspecialchars($teacher['skills']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Languages</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['languages']) ? htmlspecialchars($teacher['languages']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Medical Conditions</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['medical_conditions']) ? htmlspecialchars($teacher['medical_conditions']) : 'None'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Allergies</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['allergies']) ? htmlspecialchars($teacher['allergies']) : 'None'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Bank Details</td>
                    <td class="py-3 px-4">
                        <?php if (!empty($teacher['bank_account']) && !empty($teacher['bank_name'])): ?>
                            <?php echo htmlspecialchars($teacher['bank_name']); ?> - <?php echo htmlspecialchars($teacher['bank_account']); ?>
                        <?php else: ?>
                            Not provided
                        <?php endif; ?>
                    </td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">References</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['references_info']) ? nl2br(htmlspecialchars($teacher['references_info'])) : 'Not provided'; ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">System Information</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Registration Date</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['created_at']) ? date('F j, Y', strtotime($teacher['created_at'])) : 'Not provided'; ?></td>
                </tr>
                <?php if (isset($teacher['created_by'])): ?>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Registered By</td>
                    <td class="py-3 px-4"><?php echo htmlspecialchars($admin_name); ?></td>
                </tr>
                <?php endif; ?>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Status</td>
                    <td class="py-3 px-4">
                        <?php if (!empty($teacher['status']) && $teacher['status'] == 'active'): ?>
                            <span class="bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Active</span>
                        <?php else: ?>
                            <span class="bg-red-100 text-red-800 text-xs font-medium px-2.5 py-0.5 rounded-full"><?php echo !empty($teacher['status']) ? ucfirst($teacher['status']) : 'Inactive'; ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<?php include 'include/footer.php'; ?>