<?php
// DB connection
include '../config/conn.php';

// Get teacher info from session
$teacher_id = $_SESSION['user_id'];
$query = "SELECT * FROM users WHERE id = ? AND role = 'teacher'";
$stmt  = $conn->prepare($query);
$stmt->bind_param("i", $teacher_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    session_destroy();
    header('Location: ../portal_login.php');
    exit();
}

$teacher = $result->fetch_assoc();
$stmt->close();

// Profile picture
$user_image = !empty($teacher['image']) ? $teacher['image'] : 'default.png';
?>
<!-- Sidebar -->
<div class="sidebar bg-white w-64 md:w-72 py-6 px-4 flex flex-col justify-between shadow-sm overflow-y-auto">

    <!-- Logo -->
<div class="mb-10 px-2">

       <h1 class="heading text-xl font-semibold text-primary flex items-center">
            <img src="../img/logotwo.png" alt="Adinoheight Logo" 
                 class="h-20 w-20 object-contain"> 
            Adinoheight
        </h1>
        <p class="text-xs text-gray-500 mt-1">Teacher Portal</p>

    </div>

    <!-- Navigation -->
    <nav class="flex-1">
        <ul class="space-y-1">

            <li>
                <a href="index.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item hover:bg-gray-100">
                    <i class="fas fa-chart-line mr-3 w-5 text-center"></i>
                    <span>Dashboard</span>
                </a>
            </li>

            <li>
                <a href="student.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                    <i class="fas fa-user-graduate mr-3 w-5 text-center"></i>
                    <span>My Students</span>
                </a>
            </li>

            <li>
                <a href="attendance.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                    <i class="fas fa-check-circle mr-3 w-5 text-center"></i>
                    <span>Mark Attendance</span>
                </a>
            </li>

            <li>
                <a href="report.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                    <i class="fas fa-file-alt mr-3 w-5 text-center"></i>
                    <span>Report Card</span>
                </a>
            </li>

            <li>
                <a href="result.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                    <i class="fas fa-clipboard-list mr-3 w-5 text-center"></i>
                    <span>Exams & Scores</span>
                </a>
            </li>

            <li>
                <a href="teacher_quiz.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                    <i class="fas fa-question-circle mr-3 w-5 text-center"></i>
                    <span>Create Quiz</span>
                </a>
            </li>

            <li>
                <a href="teacher_lesson.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                    <i class="fas fa-book-open mr-3 w-5 text-center"></i>
                    <span>Lesson Note</span>
                </a>
            </li>
            
            <li>
                <a href="assigment.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                    <i class="fas fa-tasks mr-3 w-5 text-center"></i>
                    <span>Create Assignment</span>
                </a>
            </li>

            <li>
                <a href="view_attendance.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                    <i class="fas fa-calendar-check mr-3 w-5 text-center"></i>
                    <span>My Attendance</span>
                </a>
            </li>

            <li>
                <a href="leave.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                    <i class="fas fa-plane-departure mr-3 w-5 text-center"></i>
                    <span>Leave Management</span>
                </a>
            </li>

        </ul>
    </nav>

    <!-- User section -->
    <div class="pt-6 mt-6 border-t border-gray-100">
        <div class="relative">
            <button class="flex items-center w-full px-4 py-2 hover:bg-gray-100 rounded-lg focus:outline-none user-dropdown-btn">
                <div class="flex-shrink-0">
                    <img src="../uploads/<?php echo htmlspecialchars($user_image); ?>" 
                        alt="Profile" 
                        class="profile-img"
                        style="width:60px; height:60px; object-fit:cover; border-radius:50%; border:3px solid #4CAF50; box-shadow:0px 4px 10px rgba(0,0,0,0.2);">
                </div>
                <div class="ml-3 text-left">
                    <p class="text-sm font-medium text-gray-700"><?= htmlspecialchars($teacher['full_name']) ?></p>
                    <p class="text-xs text-gray-500">Teacher</p>
                </div>
                <i class="fas fa-chevron-down ml-auto text-xs text-gray-500"></i>
            </button>

            <!-- Dropdown -->
            <div class="hidden absolute bottom-12 left-4 w-48 bg-white border rounded-lg shadow-md user-dropdown">
                <a href="profile.php" class="block px-4 py-2 text-sm text-gray-600 hover:bg-gray-100">
                    <i class="fas fa-user mr-2"></i> My Profile
                </a>
          
                <a href="logout.php" class="block px-4 py-2 text-sm text-red-600 hover:bg-red-50">
                    <i class="fas fa-sign-out-alt mr-2"></i> Logout
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Overlay for mobile -->
<div class="overlay"></div>

<!-- JS for dropdown -->
<script>
document.addEventListener("DOMContentLoaded", function () {
    const userBtn = document.querySelector(".user-dropdown-btn");
    const dropdown = document.querySelector(".user-dropdown");

    if (userBtn && dropdown) {
        userBtn.addEventListener("click", (e) => {
            e.stopPropagation();
            dropdown.classList.toggle("hidden");
        });
        document.addEventListener("click", () => dropdown.classList.add("hidden"));
    }
});
</script>
