<?php
ob_start();
include '../config/conn.php';
session_start();

// Check if user is logged in and is a teacher
if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_type']) || $_SESSION['user_type'] !== 'teacher') {
    header('Location: login.php');
    exit();
}

$teacher_id = $_SESSION['user_id'];

// Get filter parameters
$status_filter = isset($_GET['status']) ? mysqli_real_escape_string($conn, $_GET['status']) : 'all';
$year_filter = isset($_GET['year']) ? intval($_GET['year']) : date('Y');
$month_filter = isset($_GET['month']) ? intval($_GET['month']) : 0;

// Build query
$where_conditions = ["la.teacher_id = $teacher_id"];
if ($status_filter !== 'all') {
    $where_conditions[] = "la.status = '$status_filter'";
}
if ($year_filter) {
    $where_conditions[] = "YEAR(la.start_date) = $year_filter";
}
if ($month_filter > 0) {
    $where_conditions[] = "MONTH(la.start_date) = $month_filter";
}
$where_clause = implode(' AND ', $where_conditions);

// Query leave history
$leave_query = "SELECT la.*, lt.type_name, lt.type_code,
                       COALESCE(rev.full_name, 'Not reviewed') as reviewed_by_name
                FROM leave_applications la
                JOIN leave_types lt ON la.leave_type_id = lt.id
                LEFT JOIN users rev ON la.reviewed_by = rev.id
                WHERE $where_clause
                ORDER BY la.applied_at DESC";
$leave_result = mysqli_query($conn, $leave_query);

// Send headers for Excel export
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=leave_history_" . date('Ymd_His') . ".xls");
header("Pragma: no-cache");
header("Expires: 0");

// Start table
echo "<table border='1'>";
echo "<tr>
        <th>Leave Type</th>
        <th>Start Date</th>
        <th>End Date</th>
        <th>Working Days</th>
        <th>Reason</th>
        <th>Status</th>
        <th>Applied On</th>
        <th>Reviewed By</th>
        <th>Admin Notes</th>
      </tr>";

// Fill data
while ($row = mysqli_fetch_assoc($leave_result)) {
    echo "<tr>";
    echo "<td>" . htmlspecialchars($row['type_name']) . "</td>";
    echo "<td>" . date('Y-m-d', strtotime($row['start_date'])) . "</td>";
    echo "<td>" . date('Y-m-d', strtotime($row['end_date'])) . "</td>";
    echo "<td>" . $row['working_days'] . "</td>";
    echo "<td>" . htmlspecialchars($row['reason']) . "</td>";
    echo "<td>" . ucfirst($row['status']) . "</td>";
    echo "<td>" . date('Y-m-d H:i', strtotime($row['applied_at'])) . "</td>";
    echo "<td>" . htmlspecialchars($row['reviewed_by_name']) . "</td>";
    echo "<td>" . htmlspecialchars($row['admin_notes']) . "</td>";
    echo "</tr>";
}

echo "</table>";
exit;
?>
