<?php
ob_start();
session_start();
include '../config/conn.php';

// Check login
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$is_teacher = ($_SESSION['user_type'] === 'teacher');
$user_id = $_SESSION['user_id'];

// Filters
$class_id = isset($_GET['class_id']) ? intval($_GET['class_id']) : 0;
$section_id = isset($_GET['section_id']) ? intval($_GET['section_id']) : 0;
$month = isset($_GET['month']) ? $_GET['month'] : date('Y-m'); // YYYY-MM format

// Authorization check (teachers can only access their assigned classes/sections)
if ($is_teacher) {
    $authorized = false;

    // Check class teacher
    $check_class = mysqli_query($conn, "SELECT id FROM classes WHERE id=$class_id AND class_teacher_id=$user_id");
    if ($check_class && mysqli_num_rows($check_class) > 0) {
        $authorized = true;
    }

    // Check section teacher
    if (!$authorized) {
        $check_section = mysqli_query($conn, "SELECT id FROM sections WHERE id=$section_id AND section_teacher_id=$user_id");
        if ($check_section && mysqli_num_rows($check_section) > 0) {
            $authorized = true;
        }
    }

    if (!$authorized) {
        die("❌ You are not authorized to export attendance for this class/section.");
    }
}

// Fetch class and section names
$class_name = '';
$section_name = '';
if ($class_id > 0) {
    $res = mysqli_query($conn, "SELECT class_name FROM classes WHERE id=$class_id");
    if ($res && mysqli_num_rows($res) > 0) {
        $class_name = mysqli_fetch_assoc($res)['class_name'];
    }
}
if ($section_id > 0) {
    $res = mysqli_query($conn, "SELECT section_name FROM sections WHERE id=$section_id");
    if ($res && mysqli_num_rows($res) > 0) {
        $section_name = mysqli_fetch_assoc($res)['section_name'];
    }
}

// Query monthly attendance records
$query = "SELECT 
            s.student_id, 
            s.full_name, 
            a.status, 
            a.attendance_date, 
            u.full_name as recorded_by
          FROM attendance a
          JOIN students s ON a.student_id = s.id   -- adjust if needed
          LEFT JOIN users u ON a.recorded_by = u.id
          WHERE a.class_id = $class_id 
          AND a.section_id = $section_id 
          AND DATE_FORMAT(a.attendance_date, '%Y-%m') = '$month'
          ORDER BY s.student_id ASC, a.attendance_date ASC";

$result = mysqli_query($conn, $query);

// Headers for Excel
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=attendance_{$class_name}_{$section_name}_{$month}.xls");
header("Pragma: no-cache");
header("Expires: 0");

// Build table
echo "<table border='1'>";
echo "<tr>
        <th>Student ID</th>
        <th>Student Name</th>
        <th>Status</th>
        <th>Date</th>
        <th>Recorded By</th>
      </tr>";

if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['student_id']) . "</td>";
        echo "<td>" . htmlspecialchars($row['full_name']) . "</td>";
        echo "<td>" . ucfirst($row['status']) . "</td>";
        echo "<td>" . $row['attendance_date'] . "</td>";
        echo "<td>" . htmlspecialchars($row['recorded_by']) . "</td>";
        echo "</tr>";
    }
} else {
    echo "<tr><td colspan='5' style='text-align:center;'>No records found for this month.</td></tr>";
}

echo "</table>";
exit;
?>
