<?php
// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Enhanced session handling
$sessionName = 'ADINOHEIGHT_SESSION';
session_name($sessionName);

// Start session with error handling
try {
    if (!session_start()) {
        throw new Exception('Failed to start session');
    }
} catch (Exception $e) {
    error_log("Session start failed: " . $e->getMessage());
    header('Location: ../portal_login.php?error=session');
    exit();
}

// Check if user is logged in and is a teacher
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true || $_SESSION['user_type'] !== 'teacher') {
    header('Location: ../portal_login.php');
    exit();
}

// Session timeout (30 minutes)
$inactive = 1800;
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $inactive)) {
    session_unset();
    session_destroy();
    header('Location: ../portal_login.php?error=timeout');
    exit();
}
$_SESSION['last_activity'] = time();

// Include database connection
include '../config/conn.php';

// Set teacher variables
$teacher_id = intval($_SESSION['user_id']);
$assignment_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($assignment_id > 0) {
    // Verify the assignment belongs to this teacher
    $verify_query = "SELECT id FROM assignments WHERE id = ? AND teacher_id = ?";
    $verify_stmt = $conn->prepare($verify_query);
    $verify_stmt->bind_param("ii", $assignment_id, $teacher_id);
    $verify_stmt->execute();
    $verify_result = $verify_stmt->get_result();
    
    if ($verify_result->num_rows > 0) {
        // Delete submissions first
        $delete_submissions_query = "DELETE FROM assignment_submissions WHERE assignment_id = ?";
        $stmt1 = $conn->prepare($delete_submissions_query);
        $stmt1->bind_param("i", $assignment_id);
        
        if ($stmt1->execute()) {
            // Delete assignment
            $delete_assignment_query = "DELETE FROM assignments WHERE id = ?";
            $stmt2 = $conn->prepare($delete_assignment_query);
            $stmt2->bind_param("i", $assignment_id);
            
            if ($stmt2->execute()) {
                $_SESSION['success'] = "Assignment deleted successfully.";
            } else {
                $_SESSION['error'] = "Error deleting assignment: " . $conn->error;
            }
            $stmt2->close();
        } else {
            $_SESSION['error'] = "Error deleting assignment submissions: " . $conn->error;
        }
        $stmt1->close();
    } else {
        $_SESSION['error'] = "Assignment not found or you don't have permission to delete it.";
    }
    $verify_stmt->close();
} else {
    $_SESSION['error'] = "Invalid assignment ID.";
}

$conn->close();
header("Location: assigment.php");
exit();
?>