<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';


$teacher_id = $_SESSION['user_id'];
$success = '';
$error = '';

// Verify the teacher exists
$teacher_check_query = "SELECT id, full_name 
                        FROM users 
                        WHERE id = $teacher_id 
                          AND role = 'teacher' 
                          AND status = 'active'";
$teacher_check_result = mysqli_query($conn, $teacher_check_query);

if (mysqli_num_rows($teacher_check_result) == 0) {
    $error = "System error: Your teacher account is not properly configured. Please contact administration.";
} else {
    $teacher_data = mysqli_fetch_assoc($teacher_check_result);
    $teacher_name = $teacher_data['full_name'];
}

// Fetch classes and sections that this teacher teaches
$teacher_classes_query = "SELECT DISTINCT c.id, c.class_name, s.id as section_id, s.section_name 
                         FROM classes c 
                         JOIN class_schedules cs ON c.id = cs.class_id 
                         JOIN sections s ON cs.section_id = s.id
                         WHERE cs.teacher_id = $teacher_id 
                         AND c.status = 'active' 
                         ORDER BY c.class_name, s.section_name";
$teacher_classes_result = mysqli_query($conn, $teacher_classes_query);

// Get filter parameters
$class_filter = isset($_GET['class_filter']) ? intval($_GET['class_filter']) : 0;
$section_filter = isset($_GET['section_filter']) ? intval($_GET['section_filter']) : 0;
$status_filter = isset($_GET['status_filter']) ? $_GET['status_filter'] : 'all';

// Build query to fetch assignments
$assignments_query = "SELECT a.*, c.class_name, s.section_name, sub.subject_name,
                     COUNT(asub.id) as submission_count,
                     CASE 
                         WHEN a.due_date < NOW() THEN 'past_due'
                         WHEN a.due_date >= NOW() THEN 'upcoming'
                         ELSE 'completed'
                     END as status
                     FROM assignments a
                     JOIN classes c ON a.class_id = c.id
                     JOIN sections s ON a.section_id = s.id
                     JOIN subjects sub ON a.subject_id = sub.id
                     LEFT JOIN assignment_submissions asub ON a.id = asub.assignment_id
                     WHERE a.teacher_id = $teacher_id";

// Apply filters
if ($class_filter > 0) {
    $assignments_query .= " AND a.class_id = $class_filter";
}

if ($section_filter > 0) {
    $assignments_query .= " AND a.section_id = $section_filter";
}

if ($status_filter !== 'all') {
    if ($status_filter === 'upcoming') {
        $assignments_query .= " AND a.due_date >= NOW()";
    } elseif ($status_filter === 'past_due') {
        $assignments_query .= " AND a.due_date < NOW()";
    }
}

$assignments_query .= " GROUP BY a.id ORDER BY a.created_at DESC";

$assignments_result = mysqli_query($conn, $assignments_query);

// Handle bulk actions
if (isset($_POST['bulk_action']) && isset($_POST['selected_assignments'])) {
    $selected_assignments = $_POST['selected_assignments'];
    $bulk_action = $_POST['bulk_action'];
    
    if (!empty($selected_assignments)) {
        $assignment_ids = implode(',', array_map('intval', $selected_assignments));
        
        if ($bulk_action == 'delete') {
            // First, delete related submissions
            $delete_submissions_query = "DELETE FROM assignment_submissions 
                                        WHERE assignment_id IN ($assignment_ids)";
            mysqli_query($conn, $delete_submissions_query);
            
            // Then delete assignments
            $delete_query = "DELETE FROM assignments 
                            WHERE id IN ($assignment_ids) AND teacher_id = $teacher_id";
            
            if (mysqli_query($conn, $delete_query)) {
                $success = "Successfully deleted " . count($selected_assignments) . " assignments.";
            } else {
                $error = "Error deleting assignments: " . mysqli_error($conn);
            }
        }
    } else {
        $error = "No assignments selected for bulk action.";
    }
    
    // Refresh the page to show updated list
    header("Location: all_assignments.php?class_filter=$class_filter&section_filter=$section_filter&status_filter=$status_filter");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>All Assignments - School Management System</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
<div class="container mx-auto px-2">
    <div class="bg-white p-6 r ">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-bold text-gray-800">All Assignments</h2>
            <div class="flex space-x-2">
                <a href="create_assignment.php" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 r flex items-center">
                    <i class="fas fa-plus-circle mr-2"></i> Create New
                </a>
               
            </div>
        </div>

        <?php if (!empty($success)): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                <?php echo $success; ?>
            </div>
        <?php endif; ?>
        
        <?php if (!empty($error)): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <?php echo $error; ?>
            </div>
        <?php endif; ?>

        <!-- Filter Section -->
        <div class="mb-6 bg-gray-50 p-4 r">
            <form method="GET" action="" class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <!-- Class Filter -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Filter by Class</label>
                    <select name="class_filter" class="w-full px-4 py-2 border r focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="0">All Classes</option>
                        <?php 
                        if (isset($teacher_classes_result) && mysqli_num_rows($teacher_classes_result) > 0) {
                            mysqli_data_seek($teacher_classes_result, 0);
                            while ($class = mysqli_fetch_assoc($teacher_classes_result)): 
                        ?>
                            <option value="<?php echo $class['id']; ?>" <?php echo ($class_filter == $class['id']) ? 'selected' : ''; ?>>
                                <?php echo $class['class_name']; ?>
                            </option>
                        <?php 
                            endwhile;
                        }
                        ?>
                    </select>
                </div>
                
                <!-- Section Filter -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Filter by Section</label>
                    <select name="section_filter" class="w-full px-4 py-2 border r focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="0">All Sections</option>
                        <?php 
                        if (isset($teacher_classes_result) && mysqli_num_rows($teacher_classes_result) > 0) {
                            mysqli_data_seek($teacher_classes_result, 0);
                            while ($class = mysqli_fetch_assoc($teacher_classes_result)): 
                        ?>
                            <option value="<?php echo $class['section_id']; ?>" <?php echo ($section_filter == $class['section_id']) ? 'selected' : ''; ?>>
                                <?php echo $class['section_name']; ?>
                            </option>
                        <?php 
                            endwhile;
                        }
                        ?>
                    </select>
                </div>
                
                <!-- Status Filter -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Filter by Status</label>
                    <select name="status_filter" class="w-full px-4 py-2 border r focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="all" <?php echo ($status_filter == 'all') ? 'selected' : ''; ?>>All Assignments</option>
                        <option value="upcoming" <?php echo ($status_filter == 'upcoming') ? 'selected' : ''; ?>>Upcoming</option>
                        <option value="past_due" <?php echo ($status_filter == 'past_due') ? 'selected' : ''; ?>>Past Due</option>
                    </select>
                </div>
                
                <!-- Buttons -->
                <div class="flex items-end space-x-2">
                    <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 r flex items-center h-10">
                        <i class="fas fa-filter mr-2"></i> Apply Filters
                    </button>
                    <a href="assigment.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 r flex items-center h-10">
                        <i class="fas fa-times mr-2"></i> Clear
                    </a>
                </div>
            </form>
        </div>

        <!-- Assignments List -->
        <div class="bg-white p-4 r             <?php if (mysqli_num_rows($assignments_result) > 0): ?>
                <form method="POST" action="">
                    <div class="flex items-center mb-4 space-x-2">
                        <select name="bulk_action" class="px-4 py-2 border r focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Bulk Actions</option>
                            <option value="delete">Delete Selected</option>
                        </select>
                        <button type="submit" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 r" onclick="return confirm('Are you sure you want to perform this action?')">
                            Apply
                        </button>
                    </div>
                    
                    <div class="overflow-x-auto">
                        <table class="min-w-full bg-white">
                            <thead class="bg-gray-200 text-gray-700">
                                <tr>
                                    <th class="py-3 px-4 text-left w-12">
                                        <input type="checkbox" id="select_all" class="rounded">
                                    </th>
                                    <th class="py-3 px-4 text-left">Title</th>
                                    <th class="py-3 px-4 text-left">Class & Section</th>
                                    <th class="py-3 px-4 text-left">Subject</th>
                                    <th class="py-3 px-4 text-left">Due Date</th>
                                    <th class="py-3 px-4 text-left">Submissions</th>
                                    <th class="py-3 px-4 text-left">Status</th>
                                    <th class="py-3 px-4 text-left">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-600">
                                <?php while ($assignment = mysqli_fetch_assoc($assignments_result)): 
                                    $status_class = '';
                                    $status_text = '';
                                    
                                    if ($assignment['due_date'] < date('Y-m-d H:i:s')) {
                                        $status_class = 'bg-red-100 text-red-800';
                                        $status_text = 'Past Due';
                                    } else {
                                        $status_class = 'bg-green-100 text-green-800';
                                        $status_text = 'Active';
                                    }
                                ?>
                                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                                        <td class="py-3 px-4">
                                            <input type="checkbox" name="selected_assignments[]" value="<?php echo $assignment['id']; ?>" class="assignment-checkbox rounded">
                                        </td>
                                        <td class="py-3 px-4 font-medium"><?php echo $assignment['title']; ?></td>
                                        <td class="py-3 px-4"><?php echo $assignment['class_name'] . ' - ' . $assignment['section_name']; ?></td>
                                        <td class="py-3 px-4"><?php echo $assignment['subject_name']; ?></td>
                                        <td class="py-3 px-4"><?php echo date('M j, Y g:i A', strtotime($assignment['due_date'])); ?></td>
                                        <td class="py-3 px-4">
                                            <span class="px-2 py-1  text-xs font-medium bg-blue-100 text-blue-800">
                                                <?php echo $assignment['submission_count']; ?> submissions
                                            </span>
                                        </td>
                                        <td class="py-3 px-4">
                                            <span class="px-2 py-1  text-xs font-medium <?php echo $status_class; ?>">
                                                <?php echo $status_text; ?>
                                            </span>
                                        </td>
                                        <td class="py-3 px-4">
                                            <div class="flex space-x-2">
                                                <?php if (!empty($assignment['file_path'])): ?>
                                                    <a href="../uploads/assignments/<?php echo $assignment['file_path']; ?>" 
                                                       class="text-blue-600 hover:text-blue-800" download title="Download File">
                                                        <i class="fas fa-download"></i>
                                                    </a>
                                                <?php endif; ?>
                                                <a href="view_assignment.php?id=<?php echo $assignment['id']; ?>" 
                                                   class="text-green-600 hover:text-green-800" title="View Details">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                             
                                                <a href="delete_assignment.php?id=<?php echo $assignment['id']; ?>" 
                                                   class="text-red-600 hover:text-red-800" 
                                                   onclick="return confirm('Are you sure you want to delete this assignment?')" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </a>
                                           
                                            </div>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </form>
            <?php else: ?>
                <div class="text-center py-8">
                    <i class="fas fa-tasks text-4xl text-gray-300 mb-4"></i>
                    <h3 class="text-lg font-medium text-gray-600">No assignments found</h3>
                    <p class="text-gray-500 mt-2">You haven't created any assignments yet or no assignments match your filters.</p>
                    <a href="create_assignment.php" class="inline-block mt-4 bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 r">
                        <i class="fas fa-plus-circle mr-2"></i> Create Your First Assignment
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
// JavaScript to handle select all functionality
document.getElementById('select_all').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.assignment-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
    });
});
</script>

</body>
</html>

<?php
include 'include/footer.php';
ob_end_flush();
?>