<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Check if notice ID is provided
if (!isset($_GET['id'])) {
    header('Location: view_student_notice.php');
    exit();
}

$notice_id = intval($_GET['id']);
$student_id = $_SESSION['user_id'];

// Fetch student details
$student_query = "SELECT s.*, c.class_name, sec.section_name 
                  FROM students s 
                  LEFT JOIN classes c ON s.class = c.id 
                  LEFT JOIN sections sec ON s.section = sec.id 
                  WHERE s.id = $student_id";
$student_result = mysqli_query($conn, $student_query);

if ($student_result && mysqli_num_rows($student_result) > 0) {
    $student_data = mysqli_fetch_assoc($student_result);
    $student_class = $student_data['class'];
    $student_section = $student_data['section'];
    $student_name = $student_data['full_name'];
} else {
    header('Location: ../portal_logins.php');
    exit();
}

// Fetch notice details
$notice_query = "SELECT n.*, u.full_name as author 
                 FROM notices n 
                 LEFT JOIN users u ON n.created_by = u.id 
                 WHERE n.id = $notice_id";
$notice_result = mysqli_query($conn, $notice_query);

if (!$notice_result || mysqli_num_rows($notice_result) == 0) {
    header('Location: view_student_notice.php');
    exit();
}

$notice = mysqli_fetch_assoc($notice_result);

// Check if user has access to this notice
$has_access = false;
if ($notice['audience_type'] === 'all') {
    $has_access = true;
} elseif ($notice['audience_type'] === 'class' && $notice['target_id'] == $student_class) {
    $has_access = true;
} elseif ($notice['audience_type'] === 'section' && $notice['target_id'] == $student_section) {
    $has_access = true;
} elseif ($notice['audience_type'] === 'student' && $notice['target_id'] == $student_id) {
    $has_access = true;
}

if (!$has_access) {
    header('Location: view_student_notice.php');
    exit();
}

// Determine audience text
$audience_text = '';
if ($notice['audience_type'] === 'all') {
    $audience_text = 'All Students';
} elseif ($notice['audience_type'] === 'class') {
    $class_query = "SELECT class_name FROM classes WHERE id = " . $notice['target_id'];
    $class_result = mysqli_query($conn, $class_query);
    if ($class_result && mysqli_num_rows($class_result) > 0) {
        $class_name = mysqli_fetch_assoc($class_result)['class_name'];
        $audience_text = 'Class: ' . $class_name;
    }
} elseif ($notice['audience_type'] === 'section') {
    $section_query = "SELECT s.section_name, c.class_name 
                      FROM sections s 
                      LEFT JOIN classes c ON s.class_id = c.id 
                      WHERE s.id = " . $notice['target_id'];
    $section_result = mysqli_query($conn, $section_query);
    if ($section_result && mysqli_num_rows($section_result) > 0) {
        $section = mysqli_fetch_assoc($section_result);
        $audience_text = 'Section: ' . $section['class_name'] . ' - ' . $section['section_name'];
    }
} elseif ($notice['audience_type'] === 'student') {
    $student_query = "SELECT full_name FROM students WHERE id = " . $notice['target_id'];
    $student_result = mysqli_query($conn, $student_query);
    if ($student_result && mysqli_num_rows($student_result) > 0) {
        $target_student = mysqli_fetch_assoc($student_result);
        $audience_text = 'Student: ' . $target_student['full_name'];
    }
}

// Priority badge color
$priority_class = '';
switch ($notice['priority']) {
    case 'high':
        $priority_class = 'bg-yellow-100 text-yellow-800';
        break;
    case 'urgent':
        $priority_class = 'bg-red-100 text-red-800';
        break;
    default:
        $priority_class = 'bg-blue-100 text-blue-800';
}

// Mark as viewed if view tracking is enabled
$table_check = mysqli_query($conn, "SHOW TABLES LIKE 'notice_views'");
if (mysqli_num_rows($table_check) > 0) {
    $view_check_query = "SELECT id FROM notice_views WHERE notice_id = $notice_id AND student_id = $student_id";
    $view_check_result = mysqli_query($conn, $view_check_query);
    
    if (mysqli_num_rows($view_check_result) === 0) {
        $view_query = "INSERT INTO notice_views (notice_id, student_id, viewed_at) 
                       VALUES ($notice_id, $student_id, NOW())";
        mysqli_query($conn, $view_query);
    }
}
?>

<div class="bg-white p-6 rounded-lg shadow-md">
    <div class="flex justify-between items-center mb-6">
        <div>
            <a href="view_student_notice.php" class="text-blue-600 hover:text-blue-800 flex items-center mb-2">
                <i class="fas fa-arrow-left mr-2"></i> Back to Notices
            </a>
            <h2 class="text-2xl font-bold text-gray-800">Notice Details</h2>
        </div>
        <div class="flex items-center space-x-2">
            <span class="bg-blue-100 text-blue-800 text-xs font-medium px-2.5 py-0.5 rounded-full">
                <?php echo $student_data['class_name'] . ' - ' . $student_data['section_name']; ?>
            </span>
        </div>
    </div>

    <div class="bg-white border border-gray-200 rounded-lg p-6">
        <div class="flex justify-between items-start mb-4">
            <div>
                <h3 class="text-2xl font-bold text-gray-800 mb-2"><?php echo $notice['title']; ?></h3>
                <p class="text-sm text-gray-600"><?php echo $audience_text; ?></p>
            </div>
            <div class="flex items-center space-x-2">
                <span class="text-xs font-medium px-2.5 py-0.5 rounded-full <?php echo $priority_class; ?>">
                    <?php echo ucfirst($notice['priority']); ?>
                </span>
            </div>
        </div>
        
        <div class="prose max-w-none mb-6 text-gray-700">
            <?php echo nl2br($notice['content']); ?>
        </div>
        
        <div class="border-t border-gray-200 pt-4 text-sm text-gray-500">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <p><span class="font-medium">Posted by:</span> <?php echo $notice['author']; ?></p>
                    <p><span class="font-medium">Posted on:</span> <?php echo date('M j, Y \a\t g:i A', strtotime($notice['created_at'])); ?></p>
                </div>
                <div>
                    <?php if ($notice['expiry_date']): ?>
                        <p><span class="font-medium">Expires on:</span> <?php echo date('M j, Y', strtotime($notice['expiry_date'])); ?></p>
                    <?php else: ?>
                        <p><span class="font-medium">Expires:</span> Never</p>
                    <?php endif; ?>
                    <p><span class="font-medium">Audience:</span> <?php echo ucfirst($notice['audience_type']); ?></p>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.prose {
    line-height: 1.6;
}
.prose p {
    margin-bottom: 1rem;
}
</style>

<?php
include 'include/footer.php';
?>