<?php
include 'include/header.php';
include '../config/conn.php';

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'student') {
    header('Location: login.php');
    exit();
}

$student_id = $_SESSION['user_id'];
$success = '';
$error = '';

// Validate event ID
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo "<p class='text-red-500 text-center mt-10'>Invalid event ID.</p>";
    exit();
}

$event_id = (int) $_GET['id'];

// Fetch event details
$sql = "SELECT * FROM events WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $event_id);
$stmt->execute();
$result = $stmt->get_result();
$event = $result->fetch_assoc();
$stmt->close();

if (!$event) {
    echo "<p class='text-gray-500 text-center mt-10'>Event not found.</p>";
    exit();
}
?>

<div class=" p-0 max-w-3xl mx-auto mt-6  ">
    <h2 class="text-2xl font-bold text-gray-800 mb-4">
        <?php echo htmlspecialchars($event['title']); ?>
    </h2>

    <!-- Event Date & Time -->
    <div class="flex items-center space-x-6 mb-4 text-sm text-gray-500">
        <p><i class="fas fa-calendar-alt mr-1"></i>
            <?php echo date('l, F d, Y', strtotime($event['event_date'])); ?>
        </p>
        <p><i class="fas fa-clock mr-1"></i>
            <?php echo date('g:i A', strtotime($event['start_time'])); ?> - 
            <?php echo date('g:i A', strtotime($event['end_time'])); ?>
        </p>
    </div>

    <!-- Location -->
    <p class="text-gray-600 mb-4">
        <i class="fas fa-map-marker-alt mr-1"></i>
        <?php echo htmlspecialchars($event['location']); ?>
    </p>

    <!-- Event Image -->
    <?php if (!empty($event['image_path'])): ?>
        <div class="mb-4">
            <img src="../uploads/events/<?php echo htmlspecialchars($event['image_path']); ?>" 
                 alt="Event Image" 
                 class="w-full h-64 object-cover  border">
        </div>
    <?php endif; ?>

    <!-- Description -->
    <div class="mb-6">
        <h3 class="text-lg font-semibold text-gray-800 mb-2">Description</h3>
        <p class="text-gray-700">
            <?php echo !empty($event['description']) ? nl2br(htmlspecialchars($event['description'])) : 'No description available.'; ?>
        </p>
    </div>

    <!-- Back Button -->
    <a href="events.php" class="inline-block px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">
        ← Back to Events
    </a>
</div>

<?php include 'include/footer.php'; ?>
