<?php
include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in, if not redirect to login page
if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_type'])) {
    header('Location: ../portal_login.php');
    exit();
}

// Check if user is a student, if not redirect to appropriate dashboard
if ($_SESSION['user_type'] !== 'student') {
    if ($_SESSION['user_type'] === 'teacher') {
        header('Location: teacher_dashboard.php');
    } else if ($_SESSION['user_type'] === 'parent') {
        header('Location: parent_dashboard.php');
    }
    exit();
}

// Get student data including class and section
$student_id = $_SESSION['user_id'];
$student_query = "SELECT s.*, c.class_name, sec.section_name 
                  FROM students s 
                  JOIN classes c ON s.class = c.id 
                  JOIN sections sec ON s.section = sec.id 
                  WHERE s.id = $student_id";
$student_result = mysqli_query($conn, $student_query);

if (mysqli_num_rows($student_result) === 0) {
    echo "<div class='bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4'>
            <i class='fas fa-exclamation-circle mr-2'></i> Student record not found.
          </div>";
    include 'include/footer.php';
    exit();
}

$student = mysqli_fetch_assoc($student_result);
$class_id = $student['class'];
$section_id = $student['section'];
$class_name = $student['class_name'];
$section_name = $student['section_name'];

// Fetch timetable for the student's class and section
$timetable_query = "SELECT cs.*, ts.period_name, ts.start_time, ts.end_time, 
                   sub.subject_name, u.full_name as teacher_name
                   FROM class_schedules cs
                   JOIN time_slots ts ON cs.time_slot_id = ts.id
                   JOIN subjects sub ON cs.subject_id = sub.id
                   JOIN users u ON cs.teacher_id = u.id
                   WHERE cs.class_id = $class_id AND cs.section_id = $section_id
                   ORDER BY cs.day_of_week, ts.start_time";
$timetable_result = mysqli_query($conn, $timetable_query);

// Days of week for timetable
$days_of_week = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];

// Fetch all time slots for the timetable structure
$time_slots_query = "SELECT * FROM time_slots ORDER BY start_time";
$time_slots_result = mysqli_query($conn, $time_slots_query);
$all_time_slots = [];
while($time_slot = mysqli_fetch_assoc($time_slots_result)) {
    $all_time_slots[] = $time_slot;
}

// Organize timetable data by day and time slot
$timetable_data = [];
while($schedule = mysqli_fetch_assoc($timetable_result)) {
    $day = $schedule['day_of_week'];
    $time_slot_id = $schedule['time_slot_id'];
    $timetable_data[$day][$time_slot_id] = $schedule;
}

// Get current day for highlighting
$current_day = date('l');
?>

<div class="p-0  ">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h2 class="text-2xl font-bold text-gray-800">My Timetable</h2>
            <p class="text-gray-600"><?php echo $class_name . ' - ' . $section_name; ?></p>
        </div>
        <div class="text-sm text-gray-600">
            <i class="fas fa-user-graduate mr-1"></i> <?php echo $student['full_name']; ?>
        </div>
    </div>

    <!-- Timetable Display -->
    <div class=" p-0  ">
        <?php if (mysqli_num_rows($timetable_result) > 0): ?>
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white border border-gray-200">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="py-3 px-4 border text-left">Time/Day</th>
                            <?php foreach($days_of_week as $day): 
                                $is_today = ($day === $current_day) ? 'bg-blue-50 text-blue-800 font-semibold' : '';
                            ?>
                                <th class="py-3 px-4 border text-left <?php echo $is_today; ?>">
                                    <?php echo $day; ?>
                                    <?php if ($day === $current_day): ?>
                                        <span class="text-xs text-blue-600">(Today)</span>
                                    <?php endif; ?>
                                </th>
                            <?php endforeach; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($all_time_slots as $time_slot): 
                            $start_time = date('h:i A', strtotime($time_slot['start_time']));
                            $end_time = date('h:i A', strtotime($time_slot['end_time']));
                            $time_slot_id = $time_slot['id'];
                        ?>
                            <tr>
                                <td class="py-3 px-4 border font-medium">
                                    <?php echo $start_time . ' - ' . $end_time; ?>
                                    <?php if (!empty($time_slot['period_name'])): ?>
                                        <br><span class="text-xs text-gray-500">(<?php echo $time_slot['period_name']; ?>)</span>
                                    <?php endif; ?>
                                </td>
                                <?php foreach($days_of_week as $day): 
                                    $is_today = ($day === $current_day) ? 'bg-blue-50' : '';
                                    $schedule = isset($timetable_data[$day][$time_slot_id]) ? $timetable_data[$day][$time_slot_id] : null;
                                ?>
                                    <td class="py-3 px-4 border <?php echo $is_today; ?>">
                                        <?php if ($schedule): ?>
                                            <div class="p-2 rounded border border-blue-100 bg-blue-50">
                                                <div class="font-medium text-blue-800"><?php echo $schedule['subject_name']; ?></div>
                                                <div class="text-sm text-blue-600"><?php echo $schedule['teacher_name']; ?></div>
                                                <div class="text-xs text-gray-500 mt-1">
                                                    <?php 
                                                    $start = new DateTime($time_slot['start_time']);
                                                    $end = new DateTime($time_slot['end_time']);
                                                    $duration = $start->diff($end);
                                                    echo $duration->h . 'h ' . $duration->i . 'm';
                                                    ?>
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-gray-400">-</span>
                                        <?php endif; ?>
                                    </td>
                                <?php endforeach; ?>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Timetable Summary -->
            <div class="mt-6 p-0 bg-gray-50 ">
                <h3 class="text-lg font-medium text-gray-800 mb-3">Timetable Summary</h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <?php
                    // Count subjects and periods
                    $subject_count = [];
                    $total_periods = 0;
                    
                    foreach($timetable_data as $day => $schedules) {
                        foreach($schedules as $schedule) {
                            $subject = $schedule['subject_name'];
                            if (!isset($subject_count[$subject])) {
                                $subject_count[$subject] = 0;
                            }
                            $subject_count[$subject]++;
                            $total_periods++;
                        }
                    }
                    
                    // Display subject distribution
                    arsort($subject_count);
                    $count = 0;
                    foreach($subject_count as $subject => $periods) {
                        if ($count < 3) {
                            echo "<div class='bg-white p-3 rounded -sm'>
                                    <div class='font-medium text-gray-800'>$subject</div>
                                    <div class='text-sm text-gray-600'>$periods periods per week</div>
                                  </div>";
                            $count++;
                        }
                    }
                    ?>
                </div>
                <div class="mt-4 text-sm text-gray-600">
                    Total periods per week: <span class="font-semibold"><?php echo $total_periods; ?></span>
                </div>
            </div>
        <?php else: ?>
            <div class="text-center py-8 text-gray-500">
                <i class="fas fa-calendar-times text-4xl mb-3"></i>
                <h3 class="text-lg font-medium mb-2">No Timetable Available</h3>
                <p>Your class timetable has not been set up yet. Please check back later or contact your administrator.</p>
            </div>
        <?php endif; ?>
    </div>
    
    <!-- Additional Information -->
    <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-6">
        <div class="bg-blue-50 p-4 ">
            <h3 class="text-lg font-medium text-blue-800 mb-2">
                <i class="fas fa-info-circle mr-2"></i> About Your Timetable
            </h3>
            <ul class="text-sm text-blue-700 space-y-1">
                <li>• Today's schedule is highlighted in blue</li>
                <li>• Hover over subjects to see teacher names</li>
                <li>• Timetable is updated automatically by your school</li>
                <li>• Contact your teacher for any timetable changes</li>
            </ul>
        </div>
        
        <div class="bg-green-50 p-0 ">
            <h3 class="text-lg font-medium text-green-800 mb-2">
                <i class="fas fa-clock mr-2"></i> Current School Period
            </h3>
            <div id="current-period" class="text-sm text-green-700">
                <?php
                $current_time = date('H:i:s');
                $current_period = null;
                
                foreach($all_time_slots as $time_slot) {
                    if ($current_time >= $time_slot['start_time'] && $current_time <= $time_slot['end_time']) {
                        $current_period = $time_slot;
                        break;
                    }
                }
                
                if ($current_period) {
                    $period_name = !empty($current_period['period_name']) ? $current_period['period_name'] : 'Period';
                    $end_time = date('h:i A', strtotime($current_period['end_time']));
                    echo "Currently: <span class='font-semibold'>$period_name</span> (until $end_time)";
                    
                    // Check if there's a class right now
                    if (isset($timetable_data[$current_day][$current_period['id']])) {
                        $current_class = $timetable_data[$current_day][$current_period['id']];
                        echo "<br>Class: <span class='font-semibold'>" . $current_class['subject_name'] . "</span>";
                        echo "<br>Teacher: <span class='font-semibold'>" . $current_class['teacher_name'] . "</span>";
                    } else {
                        echo "<br>No scheduled class at this time";
                    }
                } else {
                    echo "No ongoing period at this time";
                }
                ?>
            </div>
        </div>
    </div>
</div>

<script>
// Function to refresh current period information
function refreshCurrentPeriod() {
    fetch('get_current_period.php')
        .then(response => response.text())
        .then(data => {
            document.getElementById('current-period').innerHTML = data;
        })
        .catch(error => {
            console.error('Error refreshing current period:', error);
        });
}

// Refresh current period every minute
setInterval(refreshCurrentPeriod, 60000);

// Add hover effects to timetable cells
document.addEventListener('DOMContentLoaded', function() {
    const cells = document.querySelectorAll('td');
    cells.forEach(cell => {
        cell.addEventListener('mouseenter', function() {
            if (this.querySelector('.bg-blue-50')) {
                this.querySelector('.bg-blue-50').classList.add('shadow-md');
            }
        });
        
        cell.addEventListener('mouseleave', function() {
            if (this.querySelector('.bg-blue-50')) {
                this.querySelector('.bg-blue-50').classList.remove('shadow-md');
            }
        });
    });
});
</script>

<?php
include 'include/footer.php';
?>