<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in as a student (match header.php validation)
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true || $_SESSION['user_type'] !== 'student') {
    header('Location: portal_login.php');
    exit();
}

$student_id = $_SESSION['user_id'];
$success = '';
$error = '';


// Fetch student details
$student_query = "SELECT s.*, c.class_name, sec.section_name 
                  FROM students s 
                  LEFT JOIN classes c ON s.class = c.id 
                  LEFT JOIN sections sec ON s.section = sec.id 
                  WHERE s.id = $student_id";
$student_result = mysqli_query($conn, $student_query);
$student = mysqli_fetch_assoc($student_result);

// Fetch invoices for this student
$invoices_query = "SELECT i.*, 
                  (SELECT COALESCE(SUM(amount), 0) FROM payments p WHERE p.invoice_id = i.id) as paid_amount
                  FROM invoices i
                  WHERE i.student_id = $student_id
                  ORDER BY i.created_at DESC";
$invoices_result = mysqli_query($conn, $invoices_query);
$invoices = [];
while ($invoice = mysqli_fetch_assoc($invoices_result)) {
    $invoices[] = $invoice;
}

// Handle payment recording
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['record_payment'])) {
    $invoice_id = intval($_POST['invoice_id']);
    $amount = floatval($_POST['amount']);
    $payment_method = mysqli_real_escape_string($conn, $_POST['payment_method']);
    $transaction_id = mysqli_real_escape_string($conn, $_POST['transaction_id']);
    
    // Validate inputs
    if ($amount <= 0 || empty($payment_method)) {
        $error = "Please fill all required fields with valid values.";
    } else {
        // Check if payment amount doesn't exceed invoice balance
        $check_balance_query = "SELECT amount, 
                               (SELECT COALESCE(SUM(amount), 0) FROM payments WHERE invoice_id = $invoice_id) as total_paid
                               FROM invoices WHERE id = $invoice_id AND student_id = $student_id";
        $balance_result = mysqli_query($conn, $check_balance_query);
        $balance_data = mysqli_fetch_assoc($balance_result);
        
        $balance = $balance_data['amount'] - $balance_data['total_paid'];
        
        if ($amount > $balance) {
            $error = "Payment amount cannot exceed the outstanding balance of ₦" . number_format($balance, 2);
        } else {
            $insert_query = "INSERT INTO payments (invoice_id, amount, payment_method, transaction_id, recorded_by, payment_date) 
                             VALUES ($invoice_id, $amount, '$payment_method', '$transaction_id', $student_id, NOW())";
            
            if (mysqli_query($conn, $insert_query)) {
                // Update invoice status if fully paid
                $new_balance = $balance - $amount;
                if ($new_balance <= 0) {
                    $update_query = "UPDATE invoices SET status = 'paid' WHERE id = $invoice_id";
                    mysqli_query($conn, $update_query);
                }
                
                $success = "Payment recorded successfully!";
            } else {
                $error = "Error recording payment: " . mysqli_error($conn);
            }
        }
    }
}

// Handle Paystack payment initiation
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['pay_with_paystack'])) {
    $invoice_id = intval($_POST['invoice_id']);
    $amount = floatval($_POST['amount']);
    
    // Check if payment amount doesn't exceed invoice balance
    $check_balance_query = "SELECT amount, 
                           (SELECT COALESCE(SUM(amount), 0) FROM payments WHERE invoice_id = $invoice_id) as total_paid
                           FROM invoices WHERE id = $invoice_id AND student_id = $student_id";
    $balance_result = mysqli_query($conn, $check_balance_query);
    $balance_data = mysqli_fetch_assoc($balance_result);
    
    $balance = $balance_data['amount'] - $balance_data['total_paid'];
    
    if ($amount > $balance) {
        $error = "Payment amount cannot exceed the outstanding balance of ₦" . number_format($balance, 2);
    } else {
        // Redirect to Paystack payment page
        $amount_in_kobo = $amount * 100; // Paystack expects amount in kobo
        
        // Store payment details in session for verification after payment
        $_SESSION['pending_payment'] = [
            'invoice_id' => $invoice_id,
            'amount' => $amount,
            'payment_method' => 'paystack',
            'timestamp' => time()
        ];
        
        // Redirect to Paystack
        header("Location: paystack_redirect.php?invoice_id=$invoice_id&amount=$amount_in_kobo&email=" . urlencode($student['email']));
        exit();
    }
}

// Pagination for payment history
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$per_page = 10; // Number of records per page
$offset = ($page - 1) * $per_page;

// Get total number of payments
$total_payments_query = "SELECT COUNT(*) as total 
                         FROM payments p
                         JOIN invoices i ON p.invoice_id = i.id
                         WHERE i.student_id = $student_id";
$total_payments_result = mysqli_query($conn, $total_payments_query);
$total_payments_data = mysqli_fetch_assoc($total_payments_result);
$total_payments = $total_payments_data['total'];

// Calculate total pages
$total_pages = ceil($total_payments / $per_page);

// Fetch payment history for this student with pagination
$payments_query = "SELECT p.*, i.description 
                   FROM payments p
                   JOIN invoices i ON p.invoice_id = i.id
                   WHERE i.student_id = $student_id
                   ORDER BY p.payment_date DESC
                   LIMIT $offset, $per_page";
$payments_result = mysqli_query($conn, $payments_query);
$payments = [];
while ($payment = mysqli_fetch_assoc($payments_result)) {
    $payments[] = $payment;
}

ob_end_flush();
?>

<div class="p-0  ">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">My Invoices & Payments</h2>
        <div class="bg-blue-100 text-blue-800 px-4 py-2 ">
            <span class="font-semibold"><?php echo $student['student_id']; ?></span> - 
            <?php echo $student['full_name']; ?>
            <?php if (!empty($student['class_name'])): ?>
                | <?php echo $student['class_name']; ?>
                <?php if (!empty($student['section_name'])): ?>
                    - <?php echo $student['section_name']; ?>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>

    <?php if (!empty($success)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo $success; ?>
        </div>
    <?php endif; ?>
    
    <?php if (!empty($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <?php echo $error; ?>
        </div>
    <?php endif; ?>

    <?php if (!empty($invoices)): ?>
        <div class="overflow-x-auto mb-8">
            <table class="min-w-full bg-white">
                <thead class="bg-gray-200 text-gray-700">
                    <tr>
                        <th class="py-3 px-4 text-left">Description</th>
                        <th class="py-3 px-4 text-left">Amount</th>
                        <th class="py-3 px-4 text-left">Paid</th>
                        <th class="py-3 px-4 text-left">Balance</th>
                        <th class="py-3 px-4 text-left">Due Date</th>
                        <th class="py-3 px-4 text-left">Status</th>
                        <th class="py-3 px-4 text-left">Actions</th>
                    </tr>
                </thead>
                <tbody class="text-gray-600">
                    <?php foreach ($invoices as $invoice): 
                        $balance = $invoice['amount'] - $invoice['paid_amount'];
                        $status = $balance <= 0 ? 'Paid' : ($invoice['paid_amount'] > 0 ? 'Partial' : 'Unpaid');
                        $status_class = $status == 'Paid' ? 'bg-green-100 text-green-800' : 
                                      ($status == 'Partial' ? 'bg-yellow-100 text-yellow-800' : 'bg-red-100 text-red-800');
                    ?>
                        <tr class="border-b border-gray-200 hover:bg-gray-50">
                            <td class="py-3 px-4"><?php echo $invoice['description']; ?></td>
                            <td class="py-3 px-4">₦<?php echo number_format($invoice['amount'], 2); ?></td>
                            <td class="py-3 px-4">₦<?php echo number_format($invoice['paid_amount'], 2); ?></td>
                            <td class="py-3 px-4">₦<?php echo number_format($balance, 2); ?></td>
                            <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($invoice['due_date'])); ?></td>
                            <td class="py-3 px-4">
                                <span class="px-2 py-1 rounded-full text-xs <?php echo $status_class; ?>">
                                    <?php echo $status; ?>
                                </span>
                            </td>
                            <td class="py-3 px-4">
                                <?php if ($balance > 0): ?>
                                    <button onclick="openPaymentModal(<?php echo $invoice['id']; ?>, <?php echo $balance; ?>)" 
                                            class="bg-green-600 hover:bg-green-700 text-white px-3 py-1 rounded text-sm flex items-center mr-2">
                                        <i class="fas fa-money-bill-wave mr-1"></i> Pay Now
                                    </button>
                                <?php else: ?>
                                    <span class="text-green-600">Paid in Full</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="bg-white p-8   text-center mb-8">
            <i class="fas fa-file-invoice-dollar text-4xl text-gray-300 mb-4"></i>
            <h3 class="text-lg font-medium text-gray-600">No invoices found for your account.</h3>
            <p class="text-gray-500">Your invoices will appear here once they are created by the administrator.</p>
        </div>
    <?php endif; ?>

    <!-- Payment History Section -->
    <div class="bg-white p-4  ">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">Payment History</h3>
        
        <?php if (!empty($payments)): ?>
            <div class="overflow-x-auto mb-4">
                <table class="min-w-full bg-white">
                    <thead class="bg-gray-200 text-gray-700">
                        <tr>
                            <th class="py-3 px-4 text-left">Date</th>
                            <th class="py-3 px-4 text-left">Description</th>
                            <th class="py-3 px-4 text-left">Amount</th>
                            <th class="py-3 px-4 text-left">Method</th>
                            <th class="py-3 px-4 text-left">Transaction ID</th>
                            <th class="py-3 px-4 text-left">Receipt</th>
                        </tr>
                    </thead>
                    <tbody class="text-gray-600">
                        <?php foreach ($payments as $payment): ?>
                            <tr class="border-b border-gray-200 hover:bg-gray-50">
                                <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($payment['payment_date'])); ?></td>
                                <td class="py-3 px-4"><?php echo $payment['description']; ?></td>
                                <td class="py-3 px-4">₦<?php echo number_format($payment['amount'], 2); ?></td>
                                <td class="py-3 px-4"><?php echo ucfirst($payment['payment_method']); ?></td>
                                <td class="py-3 px-4"><?php echo !empty($payment['transaction_id']) ? $payment['transaction_id'] : 'N/A'; ?></td>
                                <td class="py-3 px-4">
                                    <a href="download_receipt.php?payment_id=<?php echo $payment['id']; ?>" target="_blank"
                                       class="bg-blue-600 hover:bg-blue-700 text-white px-3 py-1 rounded text-sm flex items-center">
                                        <i class="fas fa-download mr-1"></i> Receipt
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            <?php if ($total_pages > 1): ?>
                <div class="flex justify-center items-center mt-4">
                    <nav class="inline-flex  ">
                        <?php if ($page > 1): ?>
                            <a href="?page=<?php echo $page - 1; ?>" class="px-3 py-2 rounded-l-md border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                                <i class="fas fa-chevron-left mr-1"></i> Previous
                            </a>
                        <?php else: ?>
                            <span class="px-3 py-2 rounded-l-md border border-gray-300 bg-gray-100 text-sm font-medium text-gray-400">
                                <i class="fas fa-chevron-left mr-1"></i> Previous
                            </span>
                        <?php endif; ?>
                        
                        <span class="px-3 py-2 border-t border-b border-gray-300 bg-white text-sm font-medium text-gray-700">
                            Page <?php echo $page; ?> of <?php echo $total_pages; ?>
                        </span>
                        
                        <?php if ($page < $total_pages): ?>
                            <a href="?page=<?php echo $page + 1; ?>" class="px-3 py-2  border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                                Next <i class="fas fa-chevron-right ml-1"></i>
                            </a>
                        <?php else: ?>
                            <span class="px-3 py-2  border border-gray-300 bg-gray-100 text-sm font-medium text-gray-400">
                                Next <i class="fas fa-chevron-right ml-1"></i>
                            </span>
                        <?php endif; ?>
                    </nav>
                </div>
            <?php endif; ?>
        <?php else: ?>
            <p class="text-center py-4 text-gray-500">
                No payment history found.
            </p>
        <?php endif; ?>
    </div>
</div>

<!-- Payment Modal -->
<div id="paymentModal" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white p-6   w-full max-w-md">
        <h3 class="text-xl font-semibold text-gray-800 mb-4">Make Payment</h3>
        <form method="POST" action="">
            <input type="hidden" id="invoice_id" name="invoice_id" value="">
            
            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 mb-1">Amount to Pay (₦)</label>
                <input type="number" step="0.01" min="0" id="payment_amount" name="amount" 
                    class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 mb-1">Payment Method</label>
                <select name="payment_method" id="payment_method" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required onchange="toggleTransactionId()">
                    <option value="">Select Method</option>

                    <option value="paystack">Paystack (Online)</option>
                </select>
            </div>
            
            <div class="mb-4" id="transaction_id_field">
                <label class="block text-sm font-medium text-gray-700 mb-1">Transaction ID (Optional)</label>
                <input type="text" name="transaction_id" 
                    class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" hidden>
            </div>
            
            <div class="flex justify-end space-x-3">
                <button type="button" onclick="closePaymentModal()" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 ">
                    Cancel
                </button>
                <button type="submit" name="record_payment" id="record_payment_btn" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 ">
                    Record Payment
                </button>
                <button type="submit" name="pay_with_paystack" id="paystack_btn" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2  hidden">
                    Pay with Paystack
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// Payment modal functions
function openPaymentModal(invoiceId, maxAmount) {
    document.getElementById('invoice_id').value = invoiceId;
    document.getElementById('payment_amount').value = maxAmount;
    document.getElementById('payment_amount').max = maxAmount;
    document.getElementById('paymentModal').classList.remove('hidden');
    
    // Reset form state
    document.getElementById('payment_method').value = '';
    document.getElementById('record_payment_btn').classList.remove('hidden');
    document.getElementById('paystack_btn').classList.add('hidden');
    document.getElementById('transaction_id_field').classList.remove('hidden');
}

function closePaymentModal() {
    document.getElementById('paymentModal').classList.add('hidden');
}

function toggleTransactionId() {
    const paymentMethod = document.getElementById('payment_method').value;
    const transactionIdField = document.getElementById('transaction_id_field');
    const recordPaymentBtn = document.getElementById('record_payment_btn');
    const paystackBtn = document.getElementById('paystack_btn');
    
    if (paymentMethod === 'paystack') {
        transactionIdField.classList.add('hidden');
        recordPaymentBtn.classList.add('hidden');
        paystackBtn.classList.remove('hidden');
    } else {
        transactionIdField.classList.remove('hidden');
        recordPaymentBtn.classList.remove('hidden');
        paystackBtn.classList.add('hidden');
    }
}
</script>

<?php
include 'include/footer.php';
mysqli_close($conn);
?>