<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

$student_id = $_SESSION['user_id'];
$user_type = 'student';

// Mark notifications as read when viewed
if (isset($_GET['mark_read']) && $_GET['mark_read'] == 'all') {
    $mark_read_query = "UPDATE notifications SET is_read = 1 WHERE user_id = $student_id AND user_type = '$user_type'";
    mysqli_query($conn, $mark_read_query);
}

// ✅ Pagination setup
$limit = 10; // number of notifications per page
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? intval($_GET['page']) : 1;
$offset = ($page - 1) * $limit;

// Count total notifications
$total_query = "SELECT COUNT(*) as total FROM notifications WHERE user_id = $student_id AND user_type = '$user_type'";
$total_result = mysqli_query($conn, $total_query);
$total_notifications = mysqli_fetch_assoc($total_result)['total'];
$total_pages = ceil($total_notifications / $limit);

// Fetch paginated notifications
$notifications_query = "SELECT * FROM notifications 
                       WHERE user_id = $student_id AND user_type = '$user_type' 
                       ORDER BY created_at DESC 
                       LIMIT $limit OFFSET $offset";
$notifications_result = mysqli_query($conn, $notifications_query);

// Count unread notifications
$unread_query = "SELECT COUNT(*) as count FROM notifications 
                WHERE user_id = $student_id AND user_type = '$user_type' AND is_read = 0";
$unread_result = mysqli_query($conn, $unread_query);
$unread_count = mysqli_fetch_assoc($unread_result)['count'];
?>

<div class=" p-0">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Notifications</h2>
        <div class="flex items-center">
            <?php if ($unread_count > 0): ?>
                <span class="bg-red-500 text-white text-xs font-medium px-2.5 py-0.5 rounded-full mr-3">
                    <?php echo $unread_count; ?> unread
                </span>
            <?php endif; ?>
            <a href="?mark_read=all" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 text-sm">
                <i class="fas fa-check-double mr-1"></i> Mark all as read
            </a>
        </div>
    </div>

    <div class="space-y-4">
        <?php if (mysqli_num_rows($notifications_result) > 0): ?>
            <?php while ($notification = mysqli_fetch_assoc($notifications_result)): ?>
                <div class="border border-gray-200 p-4 <?php echo $notification['is_read'] ? 'bg-white' : 'bg-blue-50'; ?>">
                    <div class="flex justify-between items-start">
                        <div class="flex-1">
                            <h3 class="font-semibold text-gray-800"><?php echo $notification['title']; ?></h3>
                            <p class="text-gray-600 mt-1"><?php echo $notification['message']; ?></p>
                            <p class="text-sm text-gray-500 mt-2">
                                <i class="far fa-clock mr-1"></i> 
                                <?php echo date('M j, Y g:i A', strtotime($notification['created_at'])); ?>
                            </p>
                        </div>
                        <?php if (!$notification['is_read']): ?>
                            <span class="bg-blue-500 text-white text-xs font-medium px-2 py-1 rounded-full ml-3">
                                New
                            </span>
                        <?php endif; ?>
                    </div>
                    
                    <?php if ($notification['type'] == 'assignment' && !empty($notification['related_id'])): ?>
                        <div class="mt-3 pt-3 border-t border-gray-100">
                            <a href="answer_assignment.php?id=<?php echo $notification['related_id']; ?>" 
                               class="text-blue-600 hover:text-blue-800 text-sm">
                                <i class="fas fa-external-link-alt mr-1"></i> View Assignment
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endwhile; ?>
        <?php else: ?>
            <div class="text-center py-8">
                <i class="far fa-bell text-4xl text-gray-300 mb-3"></i>
                <p class="text-gray-500">No notifications yet.</p>
            </div>
        <?php endif; ?>
    </div>

    <!-- ✅ Pagination controls -->
    <?php if ($total_pages > 1): ?>
        <div class="mt-6 flex justify-center space-x-2">
            <?php if ($page > 1): ?>
                <a href="?page=<?php echo $page - 1; ?>" 
                   class="px-3 py-1 bg-gray-200 text-gray-700 hover:bg-gray-300 rounded">
                   « Prev
                </a>
            <?php endif; ?>

            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                <a href="?page=<?php echo $i; ?>" 
                   class="px-3 py-1 <?php echo $i == $page ? 'bg-blue-600 text-white' : 'bg-gray-200 text-gray-700 hover:bg-gray-300'; ?> rounded">
                   <?php echo $i; ?>
                </a>
            <?php endfor; ?>

            <?php if ($page < $total_pages): ?>
                <a href="?page=<?php echo $page + 1; ?>" 
                   class="px-3 py-1 bg-gray-200 text-gray-700 hover:bg-gray-300 rounded">
                   Next »
                </a>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>

<?php
include 'include/footer.php';
ob_end_flush();
?>
