<?php

// DB connection
include '../config/conn.php';

// Get student info
$student_id = $_SESSION['user_id'];
$query = "SELECT * FROM students WHERE id = ?";
$stmt  = $conn->prepare($query);
$stmt->bind_param("i", $student_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    session_destroy();
    header('Location: ../portal_login.php');
    exit();
}

$student = $result->fetch_assoc();
$stmt->close();

// Role variable (optional if stored in session)
$user_role = $_SESSION['user_type'];
$user_image = !empty($student['photo']) ? $student['photo'] : 'default.png';
?>

<!-- Sidebar -->
<div class="sidebar bg-white w-64 md:w-72 py-6 px-4 flex flex-col justify-between shadow-sm overflow-y-auto">

    <!-- Logo -->
<div class="mb-10 px-2">

       <h1 class="heading text-xl font-semibold text-primary flex items-center">
            <img src="../img/logotwo.png" alt="Adinoheight Logo" 
                 class="h-20 w-20 object-contain"> 
            Adinoheight
        </h1>
        <p class="text-xs text-gray-500 mt-1">Student Portal</p>

    </div>

    <!-- Navigation -->
    <nav class="flex-1">
        <ul class="space-y-1">
            <li>
                <a href="index.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item hover:bg-gray-100">
                    <i class="fas fa-tachometer-alt mr-3 w-5 text-center"></i>
                    <span>Dashboard</span>
                </a>
            </li>

            <li>
                <a href="timetable.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                    <i class="fas fa-calendar-alt mr-3 w-5 text-center"></i>
                    <span>Timetable</span>
                </a>
            </li>

            <li>
                <a href="attendance.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                    <i class="fas fa-user-check mr-3 w-5 text-center"></i>
                    <span>Attendance</span>
                </a>
            </li>

        

            <li>
                <a href="result.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                    <i class="fas fa-file-alt mr-3 w-5 text-center"></i>
                    <span>Report Card</span>
                </a>
            </li>

         
    <li>
                <a href="answer_assignment.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                    <i class="fas fa-desktop mr-3 w-5 text-center"></i>
                    <span>Assignment</span>
                </a>
            </li>
            <!-- CBT Submenu -->
            <li>
                <button class="flex items-center justify-between w-full px-4 py-3 text-gray-700 rounded-lg nav-item staff-btn">
                    <div class="flex items-center">
                        <i class="fas fa-chalkboard-teacher mr-3 w-5 text-center"></i>
                        <span>CBT Test</span>
                    </div>
                    <i class="fas fa-chevron-down text-xs transition-transform"></i>
                </button>
                <ul class="submenu pl-9 mt-1">
                    <li class="py-2"><a href="cbttest.php" class="text-gray-600 hover:text-primary">Test</a></li>
                    <li class="py-2"><a href="view_result.php" class="text-gray-600 hover:text-primary">Result</a></li>          
                </ul>
            </li>
            
             
            <!-- Fee Payment -->
            <li>
                <a href="student_payment.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                    <i class="fas fa-money-bill-wave mr-3 w-5 text-center"></i>
                    <span>Fee Payment</span>
                </a>
            </li>
              

           
        </ul>

    </nav>

    <!-- User section -->
    <div class="pt-6 mt-6 border-t border-gray-100">
        <div class="relative">
            <button class="flex items-center w-full px-4 py-2 hover:bg-gray-100 rounded-lg focus:outline-none user-dropdown-btn">
                <div class="flex-shrink-0">
                    <img src="../uploads/<?php echo htmlspecialchars($user_image); ?>" 
                        alt="Profile" 
                        class="profile-img"
                        style="width:60px; height:60px; object-fit:cover; border-radius:50%; border:3px solid #4CAF50; box-shadow:0px 4px 10px rgba(0,0,0,0.2);">
                </div>
                <div class="ml-3 text-left">
                    <p class="text-sm font-medium text-gray-700"><?= htmlspecialchars($student['full_name']) ?></p>
                  
                </div>
                <i class="fas fa-chevron-down ml-auto text-xs text-gray-500"></i>
            </button>

            <!-- Dropdown -->
            <div class="hidden absolute bottom-12 left-4 w-48 bg-white border rounded-lg shadow-md user-dropdown">
                <a href="profile.php" class="block px-4 py-2 text-sm text-gray-600 hover:bg-gray-100">My Profile</a>
                
                <a href="logout.php" class="block px-4 py-2 text-sm text-red-600 hover:bg-red-50">Logout</a>
            </div>
        </div>
    </div>
</div>

<!-- Overlay for mobile -->
<div class="overlay"></div>

<!-- JS for dropdown & submenu -->
<script>
document.addEventListener("DOMContentLoaded", function () {
    const userBtn = document.querySelector(".user-dropdown-btn");
    const dropdown = document.querySelector(".user-dropdown");
    const submenuBtn = document.querySelector(".staff-btn");
    const submenu = document.querySelector(".submenu");

    // Toggle profile dropdown
    if (userBtn && dropdown) {
        userBtn.addEventListener("click", (e) => {
            e.stopPropagation();
            dropdown.classList.toggle("hidden");
        });
        document.addEventListener("click", () => dropdown.classList.add("hidden"));
    }

    // Toggle CBT submenu
    if (submenuBtn && submenu) {
        submenuBtn.addEventListener("click", () => {
            submenu.classList.toggle("open");
        });
    }
});
</script>
