<?php
include '../config/conn.php';


// ✅ Ensure student login
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'student') {
    header("Location: ../login.php");
    exit();
}

$student_id = $_SESSION['user_id'];

// ✅ Initialize unread_count to 0
$unread_count = 0;

// ✅ Fetch unread notifications count
$sql = "SELECT COUNT(*) as cnt FROM notifications 
        WHERE user_id = ? AND user_type = 'student' AND is_read = 0";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $student_id);
$stmt->execute();
$result = $stmt->get_result();
if ($row = $result->fetch_assoc()) {
    $unread_count = $row['cnt'];
}
$stmt->close();
?>

<!-- Header -->
<header class="bg-white shadow-sm z-10">
    <div class="flex items-center justify-between px-6 py-4 header-content">
        <div class="flex items-center">
            <button class="text-gray-500 focus:outline-none lg:hidden menu-btn">
                <i class="fas fa-bars text-xl"></i>
            </button>
            <h2 class="heading text-xl font-semibold text-gray-800 ml-4">Dashboard</h2>
        </div>
        
        <div class="flex items-center">
           
            
            <div class="relative ml-4 flex items-center">
                <!-- Notifications -->
                <a href="student_notifications.php" class="text-gray-500 focus:outline-none mx-4 relative">
                    <i class="far fa-bell text-xl"></i>
                    <?php if ($unread_count > 0): ?>
                        <span class="absolute -top-1 -right-1 bg-red-500 text-white text-xs font-bold px-1.5 py-0.5 rounded-full">
                            <?php echo $unread_count; ?>
                        </span>
                    <?php endif; ?>
                </a>

               
            </div>
        </div>
    </div>
</header>

<!-- Mobile search container -->
<div class="mobile-search-overlay"></div>
<div class="mobile-search-container">
   
</div>
