<?php
session_start();
include '../config/conn.php';

// ✅ Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// ✅ Validate invoice ID
$invoice_id = isset($_GET['invoice_id']) ? intval($_GET['invoice_id']) : 0;
if ($invoice_id <= 0) {
    die("Invalid invoice ID");
}

// ✅ Get invoice details
$invoice_query = "SELECT i.*, s.full_name, s.student_id, s.roll_number, 
                 c.class_name, sec.section_name, 
                 (SELECT COALESCE(SUM(amount), 0) 
                  FROM payments p 
                  WHERE p.invoice_id = i.id) as paid_amount
                 FROM invoices i 
                 JOIN students s ON i.student_id = s.id 
                 JOIN classes c ON s.class = c.id 
                 JOIN sections sec ON s.section = sec.id 
                 WHERE i.id = $invoice_id";

$invoice_result = mysqli_query($conn, $invoice_query);

if (!$invoice_result || mysqli_num_rows($invoice_result) == 0) {
    die("Invoice not found for ID: $invoice_id");
}

$invoice = mysqli_fetch_assoc($invoice_result);

require_once(__DIR__ . '/../tcpdf/TCPDF-main/tcpdf.php');

// Create new PDF document
$pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);

// Set document info
$pdf->SetCreator('AdinoHeight College');
$pdf->SetAuthor('AdinoHeight College');
$pdf->SetTitle('Payment Receipt - ' . $invoice['student_id']);
$pdf->SetSubject('Payment Receipt');

// Add a page
$pdf->AddPage();

//  Build HTML content
$html = '
<h1 style="text-align:center;color:#2c3e50;">ADINOHEIGHT COLLEGE</h1>
<h2 style="text-align:center;color:#3498db;">PAYMENT RECEIPT</h2>

<table border="0" cellpadding="5">
    <tr>
        <td width="30%"><strong>Receipt No:</strong></td>
        <td width="70%">REC' . str_pad($invoice_id, 6, '0', STR_PAD_LEFT) . '</td>
    </tr>
    <tr>
        <td><strong>Date:</strong></td>
        <td>' . date('F j, Y') . '</td>
    </tr>
    <tr>
        <td><strong>Student Name:</strong></td>
        <td>' . $invoice['full_name'] . '</td>
    </tr>
    <tr>
        <td><strong>Student ID:</strong></td>
        <td>' . $invoice['student_id'] . '</td>
    </tr>
    <tr>
        <td><strong>Class:</strong></td>
        <td>' . $invoice['class_name'] . ' - ' . $invoice['section_name'] . '</td>
    </tr>
    <tr>
        <td><strong>Roll No:</strong></td>
        <td>' . $invoice['roll_number'] . '</td>
    </tr>
</table>

<br>

<table border="1" cellpadding="5">
    <tr style="background-color:#f2f2f2;">
        <th width="70%">Description</th>
        <th width="30%">Amount (₦)</th>
    </tr>
    <tr>
        <td>' . $invoice['description'] . '</td>
        <td>' . number_format($invoice['amount'], 2) . '</td>
    </tr>
    <tr>
        <td style="text-align:right;"><strong>Total Paid:</strong></td>
        <td><strong>' . number_format($invoice['paid_amount'], 2) . '</strong></td>
    </tr>
</table>

<br><br>

<p style="text-align:center;">Thank you for your payment!</p>
<p style="text-align:center;">AdinoHeight College<br>www.adinoheightcollege.edu.ng</p>
';

// ✅ Output HTML content
$pdf->writeHTML($html, true, false, true, false, '');

// ✅ Download as PDF
$pdf->Output('receipt_' . $invoice['student_id'] . '.pdf', 'D');
?>
