<?php
// Start output buffering at the very beginning
ob_start();

// Include connection first (no output)
include '../config/conn.php';

// Check session without including header.php yet
session_name('ADINOHEIGHT_SESSION');
ini_set('session.cookie_lifetime', 0);
ini_set('session.cookie_secure', isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on');
ini_set('session.cookie_httponly', true);
ini_set('session.cookie_samesite', 'Lax');

session_start();

// Check if user is logged in as a student
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true || $_SESSION['user_type'] !== 'student') {
    // Clear buffer before redirect
    ob_end_clean();
    header('Location: portal_login.php');
    exit();
}

// Validate payment ID
$payment_id = isset($_GET['payment_id']) ? intval($_GET['payment_id']) : 0;
if ($payment_id <= 0) {
    ob_end_clean();
    die("Invalid payment ID");
}

// Get payment details
$payment_query = "SELECT p.*, i.description, i.amount as invoice_amount, 
                 s.full_name, s.student_id, s.roll_number, 
                 c.class_name, sec.section_name
                 FROM payments p
                 JOIN invoices i ON p.invoice_id = i.id
                 JOIN students s ON i.student_id = s.id
                 LEFT JOIN classes c ON s.class = c.id
                 LEFT JOIN sections sec ON s.section = sec.id
                 WHERE p.id = $payment_id";

$payment_result = mysqli_query($conn, $payment_query);

if (!$payment_result) {
    ob_end_clean();
    die("Database error: " . mysqli_error($conn));
}

if (mysqli_num_rows($payment_result) == 0) {
    ob_end_clean();
    die("Payment not found for ID: $payment_id");
}

$payment = mysqli_fetch_assoc($payment_result);

// Check if TCPDF exists
$use_tcpdf = file_exists(__DIR__ . '/../tcpdf/TCPDF-main/tcpdf.php');

if ($use_tcpdf) {
    // Use TCPDF for PDF generation
    require_once(__DIR__ . '/../tcpdf/TCPDF-main/tcpdf.php');
    
    // Create new PDF document
    $pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);
    
    // Set document info
    $pdf->SetCreator('AdinoHeight College');
    $pdf->SetAuthor('AdinoHeight College');
    $pdf->SetTitle('Payment Receipt - ' . $payment['student_id']);
    $pdf->SetSubject('Payment Receipt');
    
    // Add a page
    $pdf->AddPage();
    
    // Build HTML content
    $html = buildReceiptHTML($payment, $payment_id);
    
    // Output HTML content
    $pdf->writeHTML($html, true, false, true, false, '');
    
    // Clear any previous output and download as PDF
    ob_end_clean();
    $pdf->Output('receipt_' . $payment['student_id'] . '_' . date('Ymd_His') . '.pdf', 'D');
    exit();
} else {
    // Fallback to basic HTML output if TCPDF not available
    // Clear buffer first
    ob_end_clean();
    
    // Set HTML content type
    header('Content-Type: text/html; charset=utf-8');
    echo buildReceiptHTML($payment, $payment_id);
    exit();
}

function buildReceiptHTML($payment, $payment_id) {
    return '
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Payment Receipt - ' . $payment['student_id'] . '</title>
        <style>
            body { 
                font-family: Arial, sans-serif; 
                margin: 0;
                padding: 20px;
                color: #333;
            }
            .container {
                max-width: 800px;
                margin: 0 auto;
                border: 1px solid #ddd;
                padding: 30px;
                box-shadow: 0 0 10px rgba(0,0,0,0.1);
            }
            .header { 
                text-align: center; 
                margin-bottom: 30px;
                border-bottom: 2px solid #3498db;
                padding-bottom: 20px;
            }
            .school-name { 
                font-size: 24px; 
                font-weight: bold; 
                color: #2c3e50; 
                margin-bottom: 5px;
            }
            .receipt-title { 
                font-size: 20px; 
                color: #3498db; 
                margin-top: 5px;
            }
            .details { 
                margin: 20px 0; 
            }
            .detail-row { 
                margin: 8px 0; 
                display: flex;
            }
            .label { 
                font-weight: bold; 
                width: 150px; 
            }
            .value {
                flex: 1;
            }
            .footer { 
                margin-top: 40px; 
                text-align: center; 
                font-size: 14px; 
                color: #7f8c8d;
                border-top: 1px solid #ddd;
                padding-top: 20px;
            }
            table { 
                width: 100%; 
                border-collapse: collapse; 
                margin: 20px 0; 
                border: 1px solid #ddd;
            }
            th { 
                background-color: #f2f2f2; 
                text-align: left; 
                padding: 12px; 
                border: 1px solid #ddd; 
                font-weight: bold;
            }
            td { 
                padding: 12px; 
                border: 1px solid #ddd; 
            }
            .total-row { 
                font-weight: bold; 
                background-color: #f9f9f9;
            }
            .print-button {
                text-align: center;
                margin: 20px 0;
            }
            .print-button button {
                background-color: #3498db;
                color: white;
                border: none;
                padding: 10px 20px;
                border-radius: 5px;
                cursor: pointer;
                font-size: 16px;
            }
            .print-button button:hover {
                background-color: #2980b9;
            }
            @media print {
                .print-button {
                    display: none;
                }
                body {
                    padding: 0;
                }
                .container {
                    border: none;
                    box-shadow: none;
                    padding: 0;
                }
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <div class="school-name">ADINOHEIGHT COLLEGE</div>
                <div class="receipt-title">PAYMENT RECEIPT</div>
            </div>

            <div class="details">
                <div class="detail-row">
                    <span class="label">Receipt No:</span>
                    <span class="value">REC' . str_pad($payment_id, 6, '0', STR_PAD_LEFT) . '</span>
                </div>
                <div class="detail-row">
                    <span class="label">Date:</span>
                    <span class="value">' . date('F j, Y', strtotime($payment['payment_date'])) . '</span>
                </div>
                <div class="detail-row">
                    <span class="label">Student Name:</span>
                    <span class="value">' . htmlspecialchars($payment['full_name']) . '</span>
                </div>
                <div class="detail-row">
                    <span class="label">Student ID:</span>
                    <span class="value">' . htmlspecialchars($payment['student_id']) . '</span>
                </div>
                <div class="detail-row">
                    <span class="label">Class:</span>
                    <span class="value">' . htmlspecialchars($payment['class_name']) . ' - ' . htmlspecialchars($payment['section_name']) . '</span>
                </div>
                <div class="detail-row">
                    <span class="label">Roll No:</span>
                    <span class="value">' . htmlspecialchars($payment['roll_number']) . '</span>
                </div>
            </div>

            <table>
                <tr>
                    <th width="70%">Description</th>
                    <th width="30%">Amount (₦)</th>
                </tr>
                <tr>
                    <td>' . htmlspecialchars($payment['description']) . '</td>
                    <td>₦ ' . number_format($payment['invoice_amount'], 2) . '</td>
                </tr>
                <tr class="total-row">
                    <td style="text-align:right;">Amount Paid:</td>
                    <td>₦ ' . number_format($payment['amount'], 2) . '</td>
                </tr>
                <tr>
                    <td style="text-align:right;">Payment Method:</td>
                    <td>' . ucfirst($payment['payment_method']) . '</td>
                </tr>
                <tr>
                    <td style="text-align:right;">Transaction ID:</td>
                    <td>' . (!empty($payment['transaction_id']) ? htmlspecialchars($payment['transaction_id']) : 'N/A') . '</td>
                </tr>
                <tr>
                    <td style="text-align:right;">Payment Date:</td>
                    <td>' . date('M j, Y g:i A', strtotime($payment['payment_date'])) . '</td>
                </tr>
            </table>

            <div class="print-button">
                <button onclick="window.print()">Print Receipt</button>
            </div>

            <div class="footer">
                <div>Thank you for your payment!</div>
                <div>AdinoHeight College<br>www.adinoheightschool.com/</div>
                <div style="margin-top: 40px; border-top: 1px solid #000; width: 200px; margin-left: auto; margin-right: auto;">
                    Authorized Signature
                </div>
            </div>
        </div>
    </body>
    </html>';
}
?>