
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Dashboard - School Management System</title>
    
    <!-- Chart.js for charts -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <style>
        .dashboard-card {
            transition: all 0.3s ease;
           
            overflow: hidden;
            background: white;
        }
      
        
        .stat-card {
            background: white;
            padding: 1.5rem;
            position: relative;
        }
        
        .stat-card.attendance { border-left: 4px solid #3b82f6; }
        .stat-card.grades { border-left: 4px solid #10b981; }
        .stat-card.schedule { border-left: 4px solid #8b5cf6; }
        .stat-card.events { border-left: 4px solid #f59e0b; }
        
        .stat-icon {
            width: 48px;
            height: 48px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }
        
        .stat-icon.attendance { background: #dbeafe; color: #3b82f6; }
        .stat-icon.grades { background: #dcfce7; color: #10b981; }
        .stat-icon.schedule { background: #f3e8ff; color: #8b5cf6; }
        .stat-icon.events { background: #fef3c7; color: #f59e0b; }
        
        .gradient-text {
            background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .attendance-badge {
            padding: 0.25rem 0.5rem;
            border-radius: 0.375rem;
            font-size: 0.75rem;
            font-weight: 500;
        }
        
        .badge-present { background: #dcfce7; color: #166534; }
        .badge-absent { background: #fee2e2; color: #991b1b; }
        .badge-late { background: #fef3c7; color: #92400e; }
        .badge-half-day { background: #dbeafe; color: #1e40af; }
        .badge-not-recorded { background: #e5e7eb; color: #374151; }
        
        .quick-action-card {
            transition: all 0.2s ease;
            border: 1px solid #e5e7eb;
            border-radius: 0.5rem;
            padding: 1rem;
            text-align: center;
        }
        
     
        
        .chart-container {
            position: relative;
            height: 300px;
            width: 100%;
        }
        
        .progress-bar {
            height: 8px;
            border-radius: 4px;
            background: #e5e7eb;
            overflow: hidden;
        }
        
        .progress-fill {
            height: 100%;
            border-radius: 4px;
            transition: width 0.3s ease;
        }
        
        .grade-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 0.75rem;
            padding: 1rem;
        }
        
        .schedule-item {
            border-left: 3px solid #3b82f6;
            padding-left: 1rem;
        }
    </style>
</head>
<body class="bg-gray-50">
    <div class="container mx-auto px-0 py-0">
        <!-- Header Section -->
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-8">
            <div>
                <h1 class="text-2xl md:text-3xl font-bold text-gray-800">Student Dashboard</h1>
                <p class="text-gray-600 mt-1">Welcome back, <?php echo $student['full_name']; ?>!</p>
            </div>
            <div class="flex items-center space-x-4 mt-4 md:mt-0">
                <div class="text-right">
                    <p class="text-sm text-gray-600">Student ID: <?php echo $student['student_id']; ?></p>
                    <p class="text-sm text-gray-600"><?php echo date('l, F j, Y'); ?></p>
                </div>
                <?php if (!empty($student['photo'])): ?>
                    <img src="../uploads/<?php echo $student['photo']; ?>" 
                         alt="Profile" class="w-10 h-10  border-2 border-white rouned-full">
                <?php else: ?>
                    <div class="w-10 h-10 bg-blue-600  flex items-center justify-center text-white font-bold ">
                        <?php echo substr($student['full_name'], 0, 1); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Stats Overview -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-8">
            <div class="stat-card attendance">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="text-2xl font-bold text-gray-800"><?php echo $attendance_percentage; ?>%</h3>
                        <p class="text-gray-600 text-sm">Attendance</p>
                    </div>
                    <div class="stat-icon attendance">
                        <i class="fas fa-calendar-check"></i>
                    </div>
                </div>
                <div class="mt-2">
                    <span class="attendance-badge badge-<?php echo str_replace('_', '-', $today_status); ?>">
                        Today: <?php echo ucfirst(str_replace('_', ' ', $today_status)); ?>
                    </span>
                </div>
            </div>
            
            <div class="stat-card grades">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="text-2xl font-bold text-gray-800">
                            <?php 
                            if (!empty($recent_grades)) {
    $avg_grade = array_sum(array_column($recent_grades, 'percentage')) / count($recent_grades);
    echo round($avg_grade, 1) . '%';
} else {
    echo 'N/A';
}

                            ?>
                        </h3>
                        <p class="text-gray-600 text-sm">Average Grade</p>
                    </div>
                    <div class="stat-icon grades">
                        <i class="fas fa-chart-line"></i>
                    </div>
                </div>
                <div class="mt-2 text-sm text-gray-500">
                    <?php echo count($recent_grades); ?> recent assessments
                </div>
            </div>
            
            <div class="stat-card schedule">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="text-2xl font-bold text-gray-800"><?php echo count($todays_schedule); ?></h3>
                        <p class="text-gray-600 text-sm">Today's Classes</p>
                    </div>
                    <div class="stat-icon schedule">
                        <i class="fas fa-clock"></i>
                    </div>
                </div>
                <div class="mt-2 text-sm text-gray-500">
                    <?php echo $student['class_name'] . ' - ' . $student['section_name']; ?>
                </div>
            </div>
            
            <div class="stat-card events">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="text-2xl font-bold text-gray-800"><?php echo count($upcoming_events); ?></h3>
                        <p class="text-gray-600 text-sm">Upcoming Events</p>
                    </div>
                    <div class="stat-icon events">
                        <i class="fas fa-calendar-day"></i>
                    </div>
                </div>
                <div class="mt-2 text-sm text-gray-500">
                    Next: <?php echo !empty($upcoming_events) ? date('M j', strtotime($upcoming_events[0]['event_date'])) : 'None'; ?>
                </div>
            </div>
        </div>

        <!-- Main Content Grid -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Left Column -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Performance Charts -->
                <div class="dashboard-card p-6">
                    <h2 class="text-xl font-bold text-gray-800 mb-6 gradient-text">My Performance</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Attendance Trend Chart -->
                        <div>
                            <h3 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
                                <i class="fas fa-calendar-alt mr-2 text-blue-600"></i>
                                Attendance Trend
                            </h3>
                            <div class="chart-container">
                                <canvas id="attendanceTrendChart"></canvas>
                            </div>
                        </div>
                        
                        <!-- Grade Distribution -->
                        <div>
                            <h3 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
                                <i class="fas fa-chart-pie mr-2 text-green-600"></i>
                                Grade Distribution
                            </h3>
                            <div class="chart-container">
                                <canvas id="gradeDistributionChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Today's Schedule -->
                <div class="dashboard-card p-6">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-semibold text-gray-800">Today's Schedule</h3>
                        <span class="text-sm text-blue-600 font-medium"><?php echo date('l, F j'); ?></span>
                    </div>
                    
                    <?php if (!empty($todays_schedule)): ?>
                        <div class="space-y-4">
                            <?php foreach ($todays_schedule as $period): 
                                $start_time = date('g:i A', strtotime($period['start_time']));
                                $end_time = date('g:i A', strtotime($period['end_time']));
                            ?>
                                <div class="schedule-item">
                                    <div class="flex justify-between items-start">
                                        <div>
                                            <h4 class="font-medium text-gray-800"><?php echo $period['subject_name']; ?></h4>
                                            <p class="text-sm text-gray-600"><?php echo $period['teacher_name']; ?></p>
                                        </div>
                                        <div class="text-right">
                                            <span class="text-sm font-medium text-gray-700"><?php echo $start_time; ?> - <?php echo $end_time; ?></span>
                                            <p class="text-xs text-gray-500">Room: <?php echo $period['room'] ?? 'N/A'; ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-4 text-gray-500">
                            <i class="fas fa-calendar-times text-3xl mb-2"></i>
                            <p>No classes scheduled for today</p>
                        </div>
                    <?php endif; ?>
                    
                    <div class="mt-4 text-center">
                        <a href="timetable.php" class="text-blue-600 hover:text-blue-800 text-sm inline-flex items-center">
                            View Full Timetable <i class="fas fa-arrow-right ml-1 text-xs"></i>
                        </a>
                    </div>
                </div>

                <!-- Recent Announcements -->
                <div class="dashboard-card p-6">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-semibold text-gray-800">Recent Announcements</h3>
                        <a href="announcements.php" class="text-blue-600 hover:text-blue-800 text-sm flex items-center">
                            View All <i class="fas fa-arrow-right ml-1 text-xs"></i>
                        </a>
                    </div>
                    
                    <?php if (!empty($announcements)): ?>
                        <div class="space-y-4">
                            <?php foreach ($announcements as $announcement): ?>
                                <div class="p-3 border border-gray-200  hover:bg-gray-50 transition-colors">
                                    <h4 class="font-medium text-gray-800"><?php echo htmlspecialchars($announcement['title']); ?></h4>
                                    <p class="text-sm text-gray-600 mt-1"><?php echo nl2br(htmlspecialchars(substr($announcement['content'], 0, 100) . '...')); ?></p>
                                    <div class="flex justify-between items-center mt-2">
                                        <span class="text-xs text-gray-500">
                                            <?php echo date('M j, Y', strtotime($announcement['created_at'])); ?>
                                        </span>
                                        <span class="text-xs px-2 py-1 bg-blue-100 text-blue-800 ">
                                            <?php echo ucfirst($announcement['target_audience']); ?>
                                        </span>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php else: ?>
                        <p class="text-gray-500 text-center py-4">No announcements</p>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Right Column -->
            <div class="space-y-6">
                <!-- Quick Actions -->
                <div class="dashboard-card p-6">
                    <h3 class="text-lg font-semibold text-gray-800 mb-4">Quick Access</h3>
                    <div class="grid grid-cols-2 gap-3">
                        <a href="attendance.php" class="quick-action-card bg-blue-50 hover:bg-blue-100 border-blue-200">
                            <div class="text-blue-600 text-2xl mb-2">
                                <i class="fas fa-calendar-check"></i>
                            </div>
                            <p class="text-sm font-medium text-blue-800">My Attendance</p>
                        </a>
                        <a href="grades.php" class="quick-action-card bg-green-50 hover:bg-green-100 border-green-200">
                            <div class="text-green-600 text-2xl mb-2">
                                <i class="fas fa-book"></i>
                            </div>
                            <p class="text-sm font-medium text-green-800">My Grades</p>
                        </a>
                        <a href="timetable.php" class="quick-action-card bg-purple-50 hover:bg-purple-100 border-purple-200">
                            <div class="text-purple-600 text-2xl mb-2">
                                <i class="fas fa-clock"></i>
                            </div>
                            <p class="text-sm font-medium text-purple-800">Timetable</p>
                        </a>
                        <a href="assignments.php" class="quick-action-card bg-orange-50 hover:bg-orange-100 border-orange-200">
                            <div class="text-orange-600 text-2xl mb-2">
                                <i class="fas fa-tasks"></i>
                            </div>
                            <p class="text-sm font-medium text-orange-800">Assignments</p>
                        </a>
                    </div>
                </div>

<!-- Recent Grades -->
<div class="dashboard-card p-6">
    <div class="flex justify-between items-center mb-4">
        <h3 class="text-lg font-semibold text-gray-800">Recent Grades</h3>
        <a href="grades.php" class="text-blue-600 hover:text-blue-800 text-sm flex items-center">
            View All <i class="fas fa-arrow-right ml-1 text-xs"></i>
        </a>
    </div>
    
    <?php if (!empty($recent_grades)): ?>
        <div class="space-y-3">
            <?php foreach ($recent_grades as $grade): 
                $percentage = $grade['percentage'];
                if ($percentage >= 80) {
                    $color_class = 'text-green-600';
                } elseif ($percentage >= 60) {
                    $color_class = 'text-yellow-600';
                } else {
                    $color_class = 'text-red-600';
                }
            ?>
                <div class="flex justify-between items-center p-2 border border-gray-200 ">
                    <div>
                        <h4 class="text-sm font-medium text-gray-800">
                            <?php echo htmlspecialchars($grade['quiz_title']); ?>
                        </h4>
                        <p class="text-xs text-gray-500">
                            <?php echo date('M j', strtotime($grade['submitted_at'])); ?>
                        </p>
                    </div>
                    <div class="text-right">
                        <span class="font-bold <?php echo $color_class; ?>">
                            <?php echo $percentage; ?>%
                        </span>
                        <p class="text-xs text-gray-500">
                            <?php echo $grade['score']; ?>/<?php echo $grade['total_marks']; ?>
                        </p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <p class="text-gray-500 text-center py-4">No grades recorded yet</p>
    <?php endif; ?>
</div>


                <!-- Upcoming Events -->
             <div class="dashboard-card p-6">
    <div class="flex justify-between items-center mb-4">
        <h3 class="text-lg font-semibold text-gray-800">Upcoming Events</h3>
        <a href="events.php" class="text-blue-600 hover:text-blue-800 text-sm flex items-center">
            View All <i class="fas fa-arrow-right ml-1 text-xs"></i>
        </a>
    </div>
    
    <?php if (!empty($upcoming_events)): ?>
        <div class="space-y-3">
            <?php foreach ($upcoming_events as $event): ?>
                <div class="p-3 border border-gray-200 hover:bg-gray-50 transition-colors">
                    <div class="flex items-start space-x-3">
                        <div class="flex-shrink-0 w-10 h-10 bg-blue-100 flex items-center justify-center">
                            <span class="text-blue-600 font-bold text-sm">
                                <?php echo date('d', strtotime($event['event_date'])); ?>
                            </span>
                        </div>
                        <div class="flex-1 min-w-0">
                            <h4 class="text-sm font-medium text-gray-800 truncate">
                                <?php echo htmlspecialchars($event['title']); ?>
                            </h4>
                            <p class="text-xs text-gray-500 mt-1">
                                <?php echo date('g:i A', strtotime($event['start_time'])); ?> 
                                - <?php echo date('g:i A', strtotime($event['end_time'])); ?>
                            </p>
                            <p class="text-xs text-gray-500">
                                <?php echo htmlspecialchars($event['location']); ?>
                            </p>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <p class="text-gray-500 text-center py-4">No upcoming events</p>
    <?php endif; ?>
</div>


                <!-- Attendance Summary -->
                <div class="dashboard-card p-6">
                    <h3 class="text-lg font-semibold text-gray-800 mb-4">Monthly Attendance</h3>
                    <div class="grid grid-cols-2 gap-4 mb-4">
                        <div class="text-center p-3 bg-green-50 ">
                            <div class="text-2xl font-bold text-green-600"><?php echo $attendance_stats['present_days']; ?></div>
                            <div class="text-sm text-green-800">Present</div>
                        </div>
                        <div class="text-center p-3 bg-red-50 ">
                            <div class="text-2xl font-bold text-red-600"><?php echo $attendance_stats['absent_days']; ?></div>
                            <div class="text-sm text-red-800">Absent</div>
                        </div>
                        <div class="text-center p-3 bg-yellow-50 ">
                            <div class="text-2xl font-bold text-yellow-600"><?php echo $attendance_stats['late_days']; ?></div>
                            <div class="text-sm text-yellow-800">Late</div>
                        </div>
                        <div class="text-center p-3 bg-blue-50 ">
                            <div class="text-2xl font-bold text-blue-600"><?php echo $attendance_stats['half_days']; ?></div>
                            <div class="text-sm text-blue-800">Half Day</div>
                        </div>
                    </div>
                    <div class="text-center">
                        <a href="attendance.php" class="text-blue-600 hover:text-blue-800 text-sm inline-flex items-center">
                            View Detailed Report <i class="fas fa-arrow-right ml-1 text-xs"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript for Charts -->
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize Chart.js charts
        initCharts();
    });

    function initCharts() {
        // Attendance Trend Chart
        const attendanceCtx = document.getElementById('attendanceTrendChart').getContext('2d');
        new Chart(attendanceCtx, {
            type: 'line',
            data: {
                labels: <?php echo json_encode($attendance_chart_data['dates']); ?>,
                datasets: [{
                    label: 'Attendance Status',
                    data: <?php echo json_encode($attendance_chart_data['status']); ?>,
                    fill: true,
                    backgroundColor: 'rgba(59, 130, 246, 0.1)',
                    borderColor: 'rgb(59, 130, 246)',
                    tension: 0.4,
                    pointBackgroundColor: 'rgb(59, 130, 246)',
                    pointBorderColor: '#fff',
                    pointHoverBackgroundColor: '#fff',
                    pointHoverBorderColor: 'rgb(59, 130, 246)',
                    pointRadius: 4,
                    pointHoverRadius: 6
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        min: 0,
                        max: 100,
                        ticks: {
                            callback: function(value) {
                                if (value === 100) return 'Present';
                                if (value === 75) return 'Late';
                                if (value === 50) return 'Half Day';
                                if (value === 25) return 'Absent';
                                if (value === 0) return 'No Record';
                                return '';
                            }
                        },
                        grid: {
                            drawBorder: false
                        }
                    },
                    x: {
                        grid: {
                            display: false
                        }
                    }
                },
                plugins: {
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                const value = context.raw;
                                if (value === 100) return 'Status: Present';
                                if (value === 75) return 'Status: Late';
                                if (value === 50) return 'Status: Half Day';
                                if (value === 25) return 'Status: Absent';
                                if (value === 0) return 'Status: No Record';
                                return '';
                            }
                        }
                    },
                    legend: {
                        display: false
                    }
                }
            }
        });

        // Grade Distribution Chart (dummy data for now)
        const gradeCtx = document.getElementById('gradeDistributionChart').getContext('2d');
        new Chart(gradeCtx, {
            type: 'doughnut',
            data: {
                labels: ['A (90-100%)', 'B (80-89%)', 'C (70-79%)', 'D (60-69%)', 'F (<60%)'],
                datasets: [{
                    data: [25, 35, 20, 15, 5], // Example data
                    backgroundColor: [
                        'rgba(16, 185, 129, 0.8)',
                        'rgba(101, 163, 13, 0.8)',
                        'rgba(245, 158, 11, 0.8)',
                        'rgba(249, 115, 22, 0.8)',
                        'rgba(239, 68, 68, 0.8)'
                    ],
                    borderColor: [
                        'rgb(16, 185, 129)',
                        'rgb(101, 163, 13)',
                        'rgb(245, 158, 11)',
                        'rgb(249, 115, 22)',
                        'rgb(239, 68, 68)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom'
                    }
                }
            }
        });
    }
    </script>
</body>
</html>

<?php
include 'include/footer.php';

// Close database connection
mysqli_close($conn);
?>