<?php
ob_start();
include "include/header.php";
include '../config/conn.php';

// Check if user is logged in and is a student
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'student') {
    header('Location: login.php');
    exit();
}

$student_id = $_SESSION['user_id'];
$success = '';
$error = '';

// Get student's class and section
$student_query = "SELECT s.class, s.section, c.class_name, sec.section_name 
                  FROM students s 
                  JOIN classes c ON s.class = c.id 
                  JOIN sections sec ON s.section = sec.id 
                  WHERE s.id = $student_id";
$student_result = mysqli_query($conn, $student_query);

if (!$student_result || mysqli_num_rows($student_result) === 0) {
    $error = "Student record not found. Please contact administration.";
} else {
    $student_data = mysqli_fetch_assoc($student_result);
    $class_id = $student_data['class'];
    $section_id = $student_data['section'];
    $class_name = $student_data['class_name'];
    $section_name = $student_data['section_name'];

    // Pagination setup
    $limit = 5;
    $page = isset($_GET['page']) ? intval($_GET['page']) : 1;
    if ($page < 1) $page = 1;
    $offset = ($page - 1) * $limit;

    // Get total number of assignments for pagination
    $count_query = "SELECT COUNT(*) as total FROM assignments 
                    WHERE class_id = $class_id AND section_id = $section_id";
    $count_result = mysqli_query($conn, $count_query);
    $total_assignments = mysqli_fetch_assoc($count_result)['total'];
    $total_pages = ceil($total_assignments / $limit);

    // Fetch assignments for this student's class and section with pagination
    $assignments_query = "SELECT a.*, c.class_name, s.section_name, sub.subject_name, u.full_name as teacher_name
                         FROM assignments a
                         JOIN classes c ON a.class_id = c.id
                         JOIN sections s ON a.section_id = s.id
                         JOIN subjects sub ON a.subject_id = sub.id
                         JOIN users u ON a.teacher_id = u.id
                         WHERE a.class_id = $class_id AND a.section_id = $section_id
                         ORDER BY a.due_date DESC
                         LIMIT $limit OFFSET $offset";
    $assignments_result = mysqli_query($conn, $assignments_query);

    // Get submission status for each assignment
    $submission_status = [];
    if ($assignments_result && mysqli_num_rows($assignments_result) > 0) {
        mysqli_data_seek($assignments_result, 0);
        while ($assignment = mysqli_fetch_assoc($assignments_result)) {
            $assignment_id = $assignment['id'];
            $submission_query = "SELECT * FROM assignment_submissions 
                                 WHERE assignment_id = $assignment_id AND student_id = $student_id";
            $submission_result = mysqli_query($conn, $submission_query);
            
            if ($submission_result && mysqli_num_rows($submission_result) > 0) {
                $submission_status[$assignment_id] = mysqli_fetch_assoc($submission_result);
            }
        }
    }
    
    // Get latest assignments (for the "Latest Assignments" section)
    $latest_limit = 3;
    $latest_query = "SELECT a.*, c.class_name, s.section_name, sub.subject_name, u.full_name as teacher_name
                    FROM assignments a
                    JOIN classes c ON a.class_id = c.id
                    JOIN sections s ON a.section_id = s.id
                    JOIN subjects sub ON a.subject_id = sub.id
                    JOIN users u ON a.teacher_id = u.id
                    WHERE a.class_id = $class_id AND a.section_id = $section_id
                    ORDER BY a.created_at DESC
                    LIMIT $latest_limit";
    $latest_result = mysqli_query($conn, $latest_query);
    $latest_assignments = [];
    if ($latest_result && mysqli_num_rows($latest_result) > 0) {
        while ($assignment = mysqli_fetch_assoc($latest_result)) {
            $latest_assignments[] = $assignment;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<body class="bg-gray-50">
<div class="container">
    <div class="bg-white p-2 ">
        <div class="flex justify-between items-center mb-6">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">My Assignments</h1>
                <p class="text-gray-600"><?php echo $class_name . ' - ' . $section_name; ?></p>
            </div>
            <div class="text-sm text-gray-600">
                <i class="fas fa-user-graduate mr-1"></i> 
                <?php echo $_SESSION['full_name']; ?>
            </div>
        </div>

        <?php if (!empty($error)): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <i class="fas fa-exclamation-circle mr-2"></i> <?php echo $error; ?>
            </div>
        <?php endif; ?>

        <!-- Status Messages -->
        <div id="status-message"></div>

        <!-- Latest Assignments Section -->
        <?php if (!empty($latest_assignments)): ?>
        <div class="mb-8">
            <h2 class="text-xl font-semibold text-gray-800 mb-4">Latest Assignments</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <?php foreach ($latest_assignments as $assignment): 
                    $is_overdue = strtotime($assignment['due_date']) < time();
                    $has_submission = isset($submission_status[$assignment['id']]);
                ?>
                    <div class="border border-gray-200 rounded-lg p-4 hover:shadow-md transition-shadow">
                        <div class="flex justify-between items-start mb-2">
                            <h3 class="text-lg font-semibold text-gray-800 truncate"><?php echo $assignment['title']; ?></h3>
                            <span class="text-xs font-medium px-2 py-1 rounded 
                                <?php echo $has_submission ? 'bg-green-100 text-green-800' : 
                                       ($is_overdue ? 'bg-red-100 text-red-800' : 'bg-blue-100 text-blue-800'); ?>">
                                <?php echo $has_submission ? 'Submitted' : 
                                       ($is_overdue ? 'Overdue' : 'Pending'); ?>
                            </span>
                        </div>
                        
                        <p class="text-sm text-gray-600 mb-2">Subject: <?php echo $assignment['subject_name']; ?></p>
                        <p class="text-sm text-gray-600 mb-2">Teacher: <?php echo $assignment['teacher_name']; ?></p>
                        
                        <div class="mb-3">
                            <p class="text-sm text-gray-600">Due Date</p>
                            <p class="text-sm font-medium <?php echo $is_overdue ? 'text-red-600' : 'text-gray-800'; ?>">
                                <?php echo date('M j, Y g:i A', strtotime($assignment['due_date'])); ?>
                            </p>
                        </div>
                        
                        <a href="#assignment-<?php echo $assignment['id']; ?>" class="text-blue-600 hover:text-blue-800 text-sm inline-flex items-center">
                            View Details <i class="fas fa-arrow-right ml-1 text-xs"></i>
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- All Assignments Section -->
        <div class="mb-8">
            <div class="flex justify-between items-center mb-4">
                <h2 class="text-xl font-semibold text-gray-800">All Assignments</h2>
                <span class="text-sm text-gray-600">
                    <?php echo $total_assignments; ?> assignment(s) total
                </span>
            </div>
            
            <?php if (isset($assignments_result) && $assignments_result && mysqli_num_rows($assignments_result) > 0): ?>
                <div class="grid grid-cols-1 gap-4">
                    <?php 
                    mysqli_data_seek($assignments_result, 0);
                    while ($assignment = mysqli_fetch_assoc($assignments_result)): 
                        $is_overdue = strtotime($assignment['due_date']) < time();
                        $has_submission = isset($submission_status[$assignment['id']]);
                        $submission = $has_submission ? $submission_status[$assignment['id']] : null;
                    ?>
                        <div id="assignment-<?php echo $assignment['id']; ?>" class=" p-0 border border-gray-200  assignment-item" data-id="<?php echo $assignment['id']; ?>">
                            <div class="flex justify-between items-start mb-2">
                                <h3 class="text-lg font-sem极ibold text-gray-800"><?php echo $assignment['title']; ?></h3>
                                <span class="text-sm font-medium px-2 py-1 rounded 
                                    <?php echo $has_submission ? 'bg-green-100 text-green-800' : 
                                           ($is_overdue ? 'bg-red-100 text-red-800' : 'bg-blue-100 text-blue-800'); ?>">
                                    <?php echo $has_submission ? 'Submitted' : 
                                           ($is_overdue ? 'Overdue' : 'Pending'); ?>
                                </span>
                            </div>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-3">
                                <div>
                                    <p class="text-sm text-gray-600">Subject</p>
                                    <p class="font-medium"><?php echo $assignment['subject_name']; ?></p>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-600">Teacher</p>
                                    <p class="font-medium"><?极 echo $assignment['teacher_name']; ?></p>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-600">Due Date</p>
                                    <p class="font-medium <?php echo $is_overdue ? 'text-red-600' : 'text-gray-800'; ?>">
                                        <?php echo date('M j, Y g:i A', strtotime($assignment['due_date'])); ?>
                                        <?php if ($is_overdue): ?>
                                            <span class="text-red-500 text-sm">(Overdue)</span>
                                        <?php endif; ?>
                                    </p>
                                </div>
                                <div>
                                    <p class极="text-sm text-gray-600">Max Marks</p>
                                    <p class="font-medium"><?php echo $assignment['max_marks'] > 0 ? $assignment['max_marks'] : 'Not specified'; ?></p>
                                </div>
                            </div>
                            
                            <?php if (!empty($assignment['description'])): ?>
                                <div class="mb-3">
                                    <p class="text-sm text-gray-600">Description</p>
                                    <p class="text-gray-800"><?php echo nl2br($assignment['description']); ?></p>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (!empty($assignment['file_path'])): ?>
                                <div class="mb-3">
                                    <p class="text-sm text-gray-600">Assignment File</p>
                                    <a href="../uploads/assignments/<?php echo $assignment['file_path']; ?>" 
                                       class="text-blue-600 hover:text-blue-800 inline-flex items-center" download>
                                        <i class="fas fa-download mr-1"></i> Download Assignment File
                                    </a>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($has_submission): ?>
                                <div class="bg-blue-50 p-0 mb-3 rounded border border-blue-100">
                                    <p class="text-blue-800 font-medium">
                                        <i class="fas fa-check-circle mr-1"></i> 
                                        You submitted this assignment on <?php echo date('M j, Y g:i A', strtotime($submission['submitted_at'])); ?>
                                    </p>
                                    <?php if (!empty($submission['submission_text'])): ?>
                                        <div class="mt-2">
                                            <p class="text-sm text-gray-600">Your Answer:</p>
                                            <p class="text-gray-800"><?php echo nl2br($submission['submission_text']); ?></p>
                                        </div>
                                    <?php endif; ?>
                                    <?php if (!empty($submission['submission_file'])): ?>
                                        <div class="mt-2">
                                            <p class="text-sm text-gray-600">Your File:</p>
                                            <a href="../uploads/assignment_answers/<?php echo $submission['submission_file']; ?>" 
                                               class="text-blue-600 hover:text-blue-800 inline-flex items-center" download>
                                                <i class="fas极 fa-download mr-1"></i> Download your submission
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                            
                            <!-- Submission Form -->
                            <?php if (!$is_overdue || ($is_overdue && !$has_submission)): ?>
                                <button type="button" onclick="toggleSubmissionForm(<?php echo $assignment['id']; ?>)" 
                                        class="bg-blue-600 hover:极bg-blue-700 text-white px-4 py-2 rounded inline-flex items-center">
                                    <i class="fas fa-paper-plane mr-2"></i> 
                                    <?php echo $has_submission ? 'Update Submission' : 'Submit Assignment'; ?>
                                </button>
                                
                                <div id="submission-form-<?php echo $assignment['id']; ?>" class="mt-4 hidden">
                                    <form method="POST" enctype="multipart/form-data" class="bg-gray-50 p-4 border border-gray-200 submission-form">
                                        <input type="hidden" name="assignment_id" value="<?php echo $assignment['id']; ?>">
                                        
                                        <div class="mb-4">
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Your Answer</label>
                                            <textarea name="submission_text" rows="4" class="w-full px-4 py-2 border rounded focus:outline-none focus:ring-2 focus:ring-blue-500"><?php echo $submission['submission_text'] ?? ''; ?></textarea>
                                        </div>
                                        
                                        <div class="mb-4">
                                            <label class="block text-sm font-medium text-gray-700 mb极-1">Upload File (optional)</label>
                                            <input type="file" name="submission_file" class="w-full px-4 py-2 border rounded focus:outline-none focus:ring-2 focus:ring-blue-500">
                                            <p class="text-xs text-gray-500 mt-1">Allowed formats: PDF, DOC, DOCX, TXT, JPG, PNG, ZIP, RAR (Max 10MB)</p>
                                            
                                            <?php if (!empty($submission['submission_file'])): ?>
                                                <div class="mt-2">
                                                    <p class="text-sm text-gray-600">Current file:</p>
                                                    <a href="../uploads/assignment_answers/<?php echo $submission['submission_file']; ?>" 
                                                       class="text-blue-600 hover:text-blue-800 inline-flex items-center" download>
                                                        <i class="fas fa-download mr-1"></i> Download current file
                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <div class="flex justify-end space-x-2">
                                            <button type="button" onclick="toggleSubmissionForm(<?php echo $assignment['id']; ?>)" 
                                                    class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded">
                                                Cancel
                                            </button>
                                            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded submit-btn">
                                                <i class="fas fa-paper-plane mr-2"></i> 
                                                <?php echo $has_submission ? 'Update Submission' : 'Submit Assignment'; ?>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            <?php elseif ($is_overdue && $has_submission): ?>
                                <p class="text-red-500 text-sm mt-2">
                                    <i class="fas fa-exclamation-triangle mr-1"></i>
                                    The due date has passed. You can no longer update your submission.
                                </p>
                            <?php else: ?>
                                <p class="text-red-500 text-sm mt-2">
                                    <i class="fas fa-exclamation-triangle mr-1"></i>
                                    The due date has passed. You can no longer submit this assignment.
                                </p>
                            <?php endif; ?>
                        </div>
                    <?php endwhile; ?>
                </div>

                <!-- Pagination -->
                <?php if ($total_pages > 1): ?>
                <div class="mt-6 flex justify-center">
                    <nav class="inline-flex rounded-md ">
                        <?php if ($page > 1): ?>
                            <a href="?page=<?php echo $page - 1; ?>" class="px-3 py-2  border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50 inline-flex items-center">
                                <i class="fas fa-chevron-left mr-1"></i> Previous
                            </a>
                        <?php endif; ?>
                        
                        <?php 
                        // Show page numbers
                        $start_page = max(1, $page - 2);
                        $end_page = min($total_pages, $start_page + 4);
                        
                        if ($end_page - $start_page < 4) {
                            $start_page = max(1, $end_page - 4);
                        }
                        
                        for ($i = $start_page; $i <= $end_page; $i++): 
                        ?>
                            <a href="?page=<?php echo $i; ?>" class="<?php echo $i == $page ? 'bg-blue-50 border-blue-500 text-blue-600' : 'bg-white border-gray-300 text-gray-500 hover:bg-gray-50'; ?> px-3 py-2 border-t border-b text-sm font-medium">
                                <?php echo $i; ?>
                            </a>
                        <?php endfor; ?>
                        
                        <?php if ($page < $total_pages): ?>
                            <a href="?page=<?php echo $page + 1; ?>" class="px-3 py-2 rounded-r-md border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50 inline-flex items-center">
                                Next <i class="fas fa-chevron-right ml-1"></i>
                            </a>
                        <?php endif; ?>
                    </nav>
                </div>
                <?php endif; ?>
                
            <?php else: ?>
                <div class="bg-gray-100 p-6 text-center rounded">
                    <i class="fas fa-tasks text-4xl text-gray-300 mb-3"></i>
                    <p class="text-gray-600">No assignments have been given to your class yet.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
function toggleSubmissionForm(assignmentId) {
    const form = document.getElementById('submission-form-' + assignmentId);
    form.classList.toggle('hidden');
}

// AJAX form submission
$(document).ready(function() {
    $('.submission-form').on('submit', function(e) {
        e.preventDefault();
        
        const form = $(this);
        const formData = new FormData(this);
        const submitBtn = form.find('.submit-btn');
        const assignmentId = form.find('input[name="assignment_id"]').val();
        const assignmentItem = $('.assignment-item[data-id="' + assignmentId + '"]');
        
        // Show loading state
        submitBtn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin mr-2"></i> Processing...');
        
        $.ajax({
            url: 'submit_assignment.php',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                try {
                    // Try to parse as JSON
                    const result = typeof response === 'string' ? JSON.parse(response) : response;
                    
                    if (result.success) {
                        // Show success message
                        showStatusMessage(result.message, 'success');
                        
                        // Hide the form
                        $('#submission-form-' + assignmentId).addClass('hidden');
                        
                        // Update the assignment item with new status
                        updateAssignmentStatus(assignmentItem, result);
                    } else {
                        showStatusMessage(result.message, 'error');
                    }
                } catch (e) {
                    console.error('Error parsing response:', e, response);
                    showStatusMessage('Error processing response. Please try again.', 'error');
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX error:', status, error);
                showStatusMessage('Network error. Please check your connection and try again.', 'error');
            },
            complete: function() {
                // Reset button state
                const hasSubmission = assignmentItem.find('.bg-blue-50').length > 0;
                submitBtn.prop('disabled', false).html(
                    '<i class="fas fa-paper-plane mr-2"></i> ' + 
                    (hasSubmission ? 'Update Submission' : 'Submit Assignment')
                );
                
                // Scroll to top to show message
                window.scrollTo(0, 0);
            }
        });
    });
});

function showStatusMessage(message, type) {
    const bgClass = type === 'success极' ? 'bg-green-100 border-green-400 text-green-700' : 'bg-red-100 border-red-400 text-red-700';
    const icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';
    
    $('#status-message').html(
        '<div class="' + bgClass + ' border px-4 py-3 rounded mb-4">' +
        '<i class="fas ' + icon + ' mr-2"></i>' + message + '</div>'
    );
    
    // Auto-hide messages after 5 seconds
    setTimeout(function() {
        $('#status-message').fadeOut();
    }, 5000);
}

function updateAssignmentStatus(assignmentItem, result) {
    const statusSpan = assignmentItem.find('span:first');
    statusSpan.removeClass('bg-red-100 text-red-800 bg-blue-100 text-blue-800')
              .addClass('bg-green-100 text-green-800')
              .text('Submitted');
    
    // Update submission details if they exist
    if (result.submission) {
        let submissionHtml = 
            '<div class="bg-blue-50 p-3 mb-3 rounded border border-blue-100">' +
            '<p class="text-blue-800 font-medium">' +
            '<i class="fas fa-check-circle mr-1"></i> ' +
            'You submitted this assignment on ' + result.submission.submitted_at +
            '</p>';
        
        if (result.submission.submission_text) {
            submissionHtml += 
                '<div class="mt-2">' +
                '<p class="text-sm text-gray-600">Your Answer:</p>' +
                '<p class="text-gray-800">' + result.submission.submission_text + '</p>' +
                '</div>';
        }
        
        if (result.submission.submission_file) {
            submissionHtml += 
                '<div class="mt-2">' +
                '<p class="text-sm text-gray-600">Your File:</p>' +
                '<a href="../uploads/assignment_answers/' + result.submission.submission_file + '" ' +
                'class="text-blue-600 hover:text-blue-800 inline-flex items-center" download>' +
                '<i class="fas fa-download mr-1"></i> Download your submission' +
                '</a>' +
                '</div>';
        }
        
        submissionHtml += '</div>';
        
        // Remove existing submission info if any and add new one
        assignmentItem.find('.bg-blue-50').remove();
        assignmentItem.find('button').first().before(submissionHtml);
    }
}
</script>

</body>
</html>

<?php
include "include/footer.php";
ob_end_flush();
?>