<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// ✅ Ensure parent login
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'parent') {
    header('Location: login.php');
    exit();
}

// Check if notice ID is provided
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header('Location: notices.php');
    exit();
}

$notice_id = intval($_GET['id']);
$parent_id = $_SESSION['user_id'];

// ✅ Verify the parent has access to this notice (through their children)
$access_query = "
    SELECT DISTINCT n.*, u.full_name as created_by_name
    FROM notices n
    LEFT JOIN users u ON n.created_by = u.id
    WHERE n.id = $notice_id
    AND (
        n.audience_type = 'all'
        OR (n.audience_type = 'class' AND n.target_id IN (SELECT class FROM students WHERE parent_id = $parent_id))
        OR (n.audience_type = 'section' AND n.target_id IN (SELECT section FROM students WHERE parent_id = $parent_id))
        OR (n.audience_type = 'student' AND n.target_id IN (SELECT id FROM students WHERE parent_id = $parent_id))
    )
    AND (n.expiry_date IS NULL OR n.expiry_date >= CURDATE())
";

$access_result = mysqli_query($conn, $access_query);
$notice = mysqli_fetch_assoc($access_result);

if (!$notice) {
    echo "<div class='bg-white p-6 rounded-lg shadow'>
            <div class='text-center py-8'>
                <i class='fas fa-exclamation-circle text-4xl text-red-500 mb-4'></i>
                <h2 class='text-xl font-bold text-gray-800 mb-2'>Access Denied</h2>
                <p class='text-gray-600'>You don't have permission to view this notice or it may have expired.</p>
                <a href='notices.php' class='inline-block mt-4 bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700'>
                    <i class='fas fa-arrow-left mr-2'></i> Back to Notices
                </a>
            </div>
          </div>";
    include 'include/footer.php';
    exit();
}

// Get audience details for display
$audience_info = "";
if ($notice['audience_type'] === 'all') {
    $audience_info = "All Students and Parents";
} else {
    // Get the specific target name based on audience type
    $target_name = "";
    $target_table = "";
    $target_column = "";
    
    switch ($notice['audience_type']) {
        case 'class':
            $target_table = "classes";
            $target_column = "class_name"; // Correct column name for class
            break;
        case 'section':
            $target_table = "sections";
            $target_column = "section_name"; // Correct column name for section
            break;
        case 'student':
            $target_table = "students";
            $target_column = "full_name"; // Correct column name for student
            break;
    }
    
    if (!empty($target_table) && !empty($target_column)) {
        $target_query = "SELECT $target_column FROM $target_table WHERE id = " . $notice['target_id'];
        $target_result = mysqli_query($conn, $target_query);
        if ($target_result && mysqli_num_rows($target_result) > 0) {
            $target_data = mysqli_fetch_assoc($target_result);
            $target_name = $target_data[$target_column];
        }
    }
    
    $audience_info = ucfirst($notice['audience_type']) . ": " . ($target_name ? $target_name : "ID " . $notice['target_id']);
}

// Priority badge styling
$priority_class = 'bg-blue-100 text-blue-800';
if ($notice['priority'] === 'high') $priority_class = 'bg-yellow-100 text-yellow-800';
if ($notice['priority'] === 'urgent') $priority_class = 'bg-red-100 text-red-800';

// Format dates
$created_date = date('F j, Y \a\t g:i A', strtotime($notice['created_at']));
$expiry_info = $notice['expiry_date'] 
    ? date('F j, Y', strtotime($notice['expiry_date'])) 
    : "No expiry";
?>

<div class="bg-white p-6 rounded-lg shadow max-w-4xl mx-auto">
    <!-- Header with back button -->
    <div class="flex justify-between items-center mb-6">
        <a href="notices.php" class="text-blue-600 hover:text-blue-800 font-medium flex items-center">
            <i class="fas fa-arrow-left mr-2"></i> Back to Notices
        </a>
        <span class="text-xs font-medium px-2.5 py-0.5 rounded-full <?php echo $priority_class; ?>">
            <?php echo ucfirst($notice['priority']); ?> Priority
        </span>
    </div>

    <!-- Notice Title -->
    <h1 class="text-3xl font-bold text-gray-800 mb-4"><?php echo htmlspecialchars($notice['title']); ?></h1>
    
    <!-- Notice Metadata -->
    <div class="bg-gray-50 p-4 rounded-lg mb-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm text-gray-600">
            <div>
                <p><strong class="text-gray-700">Audience:</strong> <?php echo $audience_info; ?></p>
                <p><strong class="text-gray-700">Posted by:</strong> <?php echo htmlspecialchars($notice['created_by_name']); ?></p>
            </div>
            <div>
                <p><strong class="text-gray-700">Posted on:</strong> <?php echo $created_date; ?></p>
                <p><strong class="text-gray-700">Expires:</strong> <?php echo $expiry_info; ?></p>
            </div>
        </div>
    </div>

    <!-- Notice Content -->
    <div class="prose max-w-none mb-8">
        <?php echo nl2br(htmlspecialchars($notice['content'])); ?>
    </div>

    <!-- Attachments (if any) -->
    <?php if (!empty($notice['attachments'])): 
        // Check if attachments is a JSON string or already an array
        if (is_string($notice['attachments'])) {
            $attachments = json_decode($notice['attachments'], true);
        } else {
            $attachments = $notice['attachments'];
        }
        
        if (is_array($attachments) && count($attachments) > 0): ?>
            <div class="border-t pt-6 mt-6">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Attachments</h3>
                <div class="space-y-2">
                    <?php foreach ($attachments as $attachment): 
                        // Handle both string and array attachment formats
                        $filename = is_array($attachment) ? $attachment['name'] : $attachment;
                        $file_path = '../admin/uploads/notices/' . $filename;
                        $file_ext = pathinfo($filename, PATHINFO_EXTENSION);
                        $icon_class = 'fa-file';
                        
                        // Set appropriate icon based on file type
                        if (in_array($file_ext, ['pdf'])) $icon_class = 'fa-file-pdf';
                        if (in_array($file_ext, ['doc', 'docx'])) $icon_class = 'fa-file-word';
                        if (in_array($file_ext, ['xls', 'xlsx'])) $icon_class = 'fa-file-excel';
                        if (in_array($file_ext, ['jpg', 'jpeg', 'png', 'gif'])) $icon_class = 'fa-file-image';
                    ?>
                        <div class="flex items-center p-3 bg-gray-50 rounded-lg hover:bg-gray-100">
                            <i class="fas <?php echo $icon_class; ?> text-gray-500 mr-3 text-lg"></i>
                            <span class="flex-grow text-gray-700"><?php echo htmlspecialchars($filename); ?></span>
                            <?php if (file_exists($file_path)): ?>
                                <a href="<?php echo $file_path; ?>" 
                                   target="_blank" 
                                   class="bg-blue-600 hover:bg-blue-700 text-white px-3 py-1 rounded text-sm flex items-center">
                                    <i class="fas fa-download mr-1"></i> Download
                                </a>
                            <?php else: ?>
                                <span class="text-gray-400 text-sm">File not available</span>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
    <?php endif; ?>

    <!-- Action Buttons -->
    <div class="border-t pt-6 mt-6 flex justify-between">
        <a href="notices.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded flex items-center">
            <i class="fas fa-arrow-left mr-2"></i> Back to All Notices
        </a>
        
        <!-- Print button -->
        <button onclick="window.print()" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded flex items-center">
            <i class="fas fa-print mr-2"></i> Print Notice
        </button>
    </div>
</div>

<!-- Print Styles -->
<style>
@media print {
    .bg-white {
        box-shadow: none !important;
    }
    .bg-gray-50 {
        background-color: #f9fafb !important;
        -webkit-print-color-adjust: exact;
    }
    a, button {
        display: none !important;
    }
    .rounded-lg {
        border-radius: 0 !important;
    }
    body {
        padding: 0;
        margin: 0;
    }
}
</style>

<?php
include 'include/footer.php';
ob_end_flush();
?>