<?php
session_start();
include '../config/conn.php';

// Check if user is logged in as parent


if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'parent') {
    header('Location: portal_login.php');
    exit();
}


// Test query
$query = "SELECT id, title, message, type, created_at, is_read 
          FROM parent_notifications 
          WHERE parent_id = $parent_id AND is_read = 0
          ORDER BY created_at DESC
          LIMIT 10";

$result = mysqli_query($conn, $query);

echo "Query executed. Rows found: " . mysqli_num_rows($result) . "<br>";

if (mysqli_num_rows($result) > 0) {
    echo "<h3>Found Notifications:</h3>";
    while ($row = mysqli_fetch_assoc($result)) {
        echo "ID: " . $row['id'] . " - " . $row['title'] . " - " . $row['message'] . "<br>";
    }
} else {
    echo "No notifications found. Let's create a test notification...<br>";
    
    // Create a test notification
    $test_query = "INSERT INTO parent_notifications (parent_id, title, message, type) 
                   VALUES ($parent_id, 'Test Notification', 'This is a test notification from the system', 'notice')";
    
    if (mysqli_query($conn, $test_query)) {
        echo "Test notification created!<br>";
        
        // Now check again
        $result2 = mysqli_query($conn, $query);
        echo "Now found: " . mysqli_num_rows($result2) . " notifications<br>";
    } else {
        echo "Error creating test notification: " . mysqli_error($conn) . "<br>";
    }
}

// Check if table exists
$table_check = mysqli_query($conn, "SHOW TABLES LIKE 'parent_notifications'");
if (mysqli_num_rows($table_check) == 0) {
    echo "<h3 style='color: red;'>ERROR: parent_notifications table does not exist!</h3>";
} else {
    echo "<h3 style='color: green;'>parent_notifications table exists</h3>";
}
?>