<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// Check login
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'parent') {
    header('Location: login.php');
    exit();
}

$parent_id = $_SESSION['user_id'];
$success = '';
$error = '';

// Get children for this parent
$children_query = "SELECT s.id, s.full_name, s.student_id, s.roll_number, 
                          c.class_name, sec.section_name, s.class, s.section
                   FROM students s
                   LEFT JOIN classes c ON s.class = c.id
                   LEFT JOIN sections sec ON s.section = sec.id
                   WHERE s.parent_id = $parent_id AND s.status = 'active'";
$children_result = mysqli_query($conn, $children_query);

// Check if query was successful
if (!$children_result) {
    $error = "Database error: " . mysqli_error($conn);
}

// Which child is selected?
$student_id = isset($_GET['student_id']) ? intval($_GET['student_id']) : 0;

// If no child selected, show list
if ($student_id === 0) {
    ?>
    <div class="bg-white p-6  ">
        <h2 class="text-2xl font-bold mb-4">Select a Child to View Teachers</h2>
        
        <?php if (!empty($error)): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <?php echo $error; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($children_result && mysqli_num_rows($children_result) > 0): ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <?php while ($child = mysqli_fetch_assoc($children_result)): ?>
                    <div class="border border-gray-200  p-4  transition-shadow duration-300">
                        <div class="text-center">
                            <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i class="fas fa-user-graduate text-blue-600 text-2xl"></i>
                            </div>
                            <h3 class="font-semibold text-lg"><?php echo htmlspecialchars($child['full_name']); ?></h3>
                            <p class="text-gray-600 text-sm"><?php echo htmlspecialchars($child['class_name'].' - '.$child['section_name']); ?></p>
                            <p class="text-gray-500 text-xs mt-1">ID: <?php echo htmlspecialchars($child['student_id']); ?></p>
                        </div>
                        <div class="mt-4 text-center">
                            <a href="teacher.php?student_id=<?php echo $child['id']; ?>"
                               class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2  inline-flex items-center">
                                <i class="fas fa-chalkboard-teacher mr-2"></i> View Teachers
                            </a>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        <?php else: ?>
            <div class="text-center py-8">
                <i class="fas fa-users text-gray-400 text-5xl mb-4"></i>
                <p class="text-gray-700 text-lg">No children linked to this parent account.</p>
            </div>
        <?php endif; ?>
    </div>
    <?php
    include 'include/footer.php';
    ob_end_flush();
    exit();
}

// Verify the selected student belongs to the parent
$valid_student = false;
$selected_student = null;
if ($children_result) {
    mysqli_data_seek($children_result, 0);
    while ($child = mysqli_fetch_assoc($children_result)) {
        if ($child['id'] == $student_id) {
            $valid_student = true;
            $selected_student = $child;
            break;
        }
    }
}

if (!$valid_student) {
    header('Location: teacher.php');
    exit();
}

// Fetch student details with class/section info
$student_query = "SELECT s.*, c.class_name, sec.section_name 
                  FROM students s 
                  LEFT JOIN classes c ON s.class = c.id 
                  LEFT JOIN sections sec ON s.section = sec.id 
                  WHERE s.id = $student_id";
$student_result = mysqli_query($conn, $student_query);
$student = mysqli_fetch_assoc($student_result);

if (!$student) {
    $error = "Invalid student selected.";
}

// Get class teacher for the student's class
$class_teacher_query = "SELECT u.id, u.full_name, u.email, u.phone, u.photo, u.teacher_id,
                               c.class_name
                        FROM classes c
                        LEFT JOIN users u ON c.class_teacher_id = u.id
                        WHERE c.id = {$student['class']} AND u.role = 'teacher' AND u.status = 'active'";
$class_teacher_result = mysqli_query($conn, $class_teacher_query);
$class_teacher = $class_teacher_result ? mysqli_fetch_assoc($class_teacher_result) : null;

// Get section teacher for the student's section
$section_teacher_query = "SELECT u.id, u.full_name, u.email, u.phone, u.photo, u.teacher_id,
                                 sec.section_name
                          FROM sections sec
                          LEFT JOIN users u ON sec.section_teacher_id = u.id
                          WHERE sec.id = {$student['section']} AND u.role = 'teacher' AND u.status = 'active'";
$section_teacher_result = mysqli_query($conn, $section_teacher_query);
$section_teacher = $section_teacher_result ? mysqli_fetch_assoc($section_teacher_result) : null;

// Get subject teachers from class_schedules for the student's specific class and section
$subject_teachers_query = "SELECT DISTINCT cs.teacher_id, u.full_name, u.email, u.phone, u.photo, u.teacher_id,
                                  s.subject_name, s.subject_code, 
                                  ts.start_time, ts.end_time, cs.day_of_week
                           FROM class_schedules cs
                           JOIN users u ON cs.teacher_id = u.id
                           JOIN subjects s ON cs.subject_id = s.id
                           LEFT JOIN time_slots ts ON cs.time_slot_id = ts.id
                           WHERE cs.class_id = {$student['class']} 
                           AND cs.section_id = {$student['section']}
                           AND u.role = 'teacher' 
                           AND u.status = 'active'
                           AND cs.status = 'active'
                           ORDER BY s.subject_name";
$subject_teachers_result = mysqli_query($conn, $subject_teachers_query);
$subject_teachers = [];
if ($subject_teachers_result) {
    while ($teacher = mysqli_fetch_assoc($subject_teachers_result)) {
        $subject_teachers[] = $teacher;
    }
}

// Get all teachers who teach this student (including class, section, and subject teachers)
$all_teachers = [];

// Add class teacher if exists
if ($class_teacher) {
    $class_teacher['role'] = 'Class Teacher';
    $class_teacher['subjects'] = ['All Subjects'];
    $class_teacher['schedule_info'] = 'Overall Class Management';
    $all_teachers[$class_teacher['id']] = $class_teacher;
}

// Add section teacher if exists and different from class teacher
if ($section_teacher && $section_teacher['id'] != ($class_teacher ? $class_teacher['id'] : null)) {
    $section_teacher['role'] = 'Section Teacher';
    $section_teacher['subjects'] = ['All Subjects'];
    $section_teacher['schedule_info'] = 'Section Coordination';
    $all_teachers[$section_teacher['id']] = $section_teacher;
}

// Add subject teachers from class schedule
foreach ($subject_teachers as $teacher) {
    $teacher_id = $teacher['teacher_id'];
    
    if (!isset($all_teachers[$teacher_id])) {
        $teacher['role'] = 'Subject Teacher';
        $teacher['subjects'] = [$teacher['subject_name']];
        
        // Add schedule information
        $schedule_info = '';
        if (!empty($teacher['day_of_week'])) {
            $schedule_info = ucfirst($teacher['day_of_week']);
            if (!empty($teacher['start_time']) && !empty($teacher['end_time'])) {
                $schedule_info .= ' ' . date('g:i A', strtotime($teacher['start_time'])) . ' - ' . date('g:i A', strtotime($teacher['end_time']));
            }
        }
        $teacher['schedule_info'] = $schedule_info;
        
        $all_teachers[$teacher_id] = $teacher;
    } else {
        // Add subject to existing teacher
        if (!in_array($teacher['subject_name'], $all_teachers[$teacher_id]['subjects'])) {
            $all_teachers[$teacher_id]['subjects'][] = $teacher['subject_name'];
        }
        
        // Update schedule information
        if (!empty($teacher['day_of_week'])) {
            $schedule_info = ucfirst($teacher['day_of_week']);
            if (!empty($teacher['start_time']) && !empty($teacher['end_time'])) {
                $schedule_info .= ' ' . date('g:i A', strtotime($teacher['start_time'])) . ' - ' . date('g:i A', strtotime($teacher['end_time']));
            }
            
            if (empty($all_teachers[$teacher_id]['schedule_info']) || $all_teachers[$teacher_id]['schedule_info'] == 'Overall Class Management') {
                $all_teachers[$teacher_id]['schedule_info'] = $schedule_info;
            } else {
                $all_teachers[$teacher_id]['schedule_info'] .= '; ' . $schedule_info;
            }
        }
    }
}
?>

<div class="bg-white p-6  ">
    <!-- Header with Back Button -->
    <div class="flex justify-between items-center mb-6">
        <div>
            <h2 class="text-2xl font-bold text-gray-800">Teachers for <?php echo htmlspecialchars($student['full_name']); ?></h2>
            <p class="text-gray-600"><?php echo htmlspecialchars($student['class_name'] . ' - ' . $student['section_name']); ?></p>
        </div>
        <a href="teacher.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2  flex items-center">
            <i class="fas fa-arrow-left mr-2"></i> Back to Children
        </a>
    </div>

    <?php if (!empty($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <?php echo $error; ?>
        </div>
    <?php endif; ?>

    <!-- Student Information -->
    <div class="mb-6 bg-blue-50 p-4 ">
        <h3 class="text-lg font-semibold text-blue-800 mb-2">Student Information</h3>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div>
                <p><strong>Name:</strong> <?php echo htmlspecialchars($student['full_name']); ?></p>
                <p><strong>Student ID:</strong> <?php echo htmlspecialchars($student['student_id']); ?></p>
            </div>
            <div>
                <p><strong>Class:</strong> <?php echo htmlspecialchars($student['class_name']); ?></p>
                <p><strong>Section:</strong> <?php echo htmlspecialchars($student['section_name']); ?></p>
            </div>
            <div>
                <p><strong>Roll Number:</strong> <?php echo htmlspecialchars($student['roll_number']); ?></p>
                <p><strong>Academic Year:</strong> <?php echo date('Y'); ?>/<?php echo date('Y') + 1; ?></p>
            </div>
        </div>
    </div>

    <!-- Teachers Section -->
    <div class="mb-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4">Assigned Teachers</h3>
        
        <?php if (!empty($all_teachers)): ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php foreach ($all_teachers as $teacher): ?>
                    <div class="border border-gray-200  p-4  transition-shadow duration-300">
                        <!-- Teacher Photo and Basic Info -->
                        <div class="flex items-center mb-4">
                            <div class="mr-4">
                                <?php if (!empty($teacher['photo'])): ?>
                                    <img src="../uploads/<?php echo htmlspecialchars($teacher['photo']); ?>" 
                                         alt="<?php echo htmlspecialchars($teacher['full_name']); ?>" 
                                         class="w-16 h-16 rounded-full object-cover border-2 border-blue-200">
                                <?php else: ?>
                                    <div class="w-16 h-16 rounded-full bg-blue-100 flex items-center justify-center border-2 border-blue-200">
                                        <i class="fas fa-user-tie text-blue-400 text-2xl"></i>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div>
                                <h4 class="font-semibold text-lg"><?php echo htmlspecialchars($teacher['full_name']); ?></h4>
                                <p class="text-blue-600 text-sm"><?php echo htmlspecialchars($teacher['role']); ?></p>
                                <p class="text-gray-500 text-xs">ID: <?php echo htmlspecialchars($teacher['teacher_id']); ?></p>
                            </div>
                        </div>

                        <!-- Subjects Taught -->
                        <div class="mb-3">
                            <p class="text-sm font-medium text-gray-700 mb-1">Subjects:</p>
                            <div class="flex flex-wrap gap-1">
                                <?php foreach ($teacher['subjects'] as $subject): ?>
                                    <span class="bg-green-100 text-green-800 text-xs px-2 py-1 rounded">
                                        <?php echo htmlspecialchars($subject); ?>
                                    </span>
                                <?php endforeach; ?>
                            </div>
                        </div>

                        <!-- Schedule Information -->
                        <?php if (!empty($teacher['schedule_info']) && $teacher['role'] == 'Subject Teacher'): ?>
                        <div class="mb-3">
                            <p class="text-sm font-medium text-gray-700 mb-1">Schedule:</p>
                            <span class="bg-purple-100 text-purple-800 text-xs px-2 py-1 rounded">
                                <i class="fas fa-clock mr-1"></i><?php echo htmlspecialchars($teacher['schedule_info']); ?>
                            </span>
                        </div>
                        <?php endif; ?>

                        <!-- Contact Information -->
                        <div class="space-y-1 text-sm">
                            <?php if (!empty($teacher['email'])): ?>
                                <p class="flex items-center text-gray-600">
                                    <i class="fas fa-envelope mr-2 text-blue-500"></i>
                                    <?php echo htmlspecialchars($teacher['email']); ?>
                                </p>
                            <?php endif; ?>
                            
                            <?php if (!empty($teacher['phone'])): ?>
                                <p class="flex items-center text-gray-600">
                                    <i class="fas fa-phone mr-2 text-green-500"></i>
                                    <?php echo htmlspecialchars($teacher['phone']); ?>
                                </p>
                            <?php endif; ?>
                        </div>

                        <!-- Role Badge -->
                        <div class="mt-3 pt-3 border-t border-gray-100">
                            <?php if ($teacher['role'] == 'Class Teacher'): ?>
                                <span class="bg-purple-100 text-purple-800 text-xs px-2 py-1 rounded-full">
                                    <i class="fas fa-crown mr-1"></i> Class Teacher
                                </span>
                            <?php elseif ($teacher['role'] == 'Section Teacher'): ?>
                                <span class="bg-orange-100 text-orange-800 text-xs px-2 py-1 rounded-full">
                                    <i class="fas fa-users mr-1"></i> Section Teacher
                                </span>
                            <?php else: ?>
                                <span class="bg-blue-100 text-blue-800 text-xs px-2 py-1 rounded-full">
                                    <i class="fas fa-book mr-1"></i> Subject Teacher
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="bg-yellow-50 border border-yellow-200  p-6 text-center">
                <i class="fas fa-exclamation-circle text-yellow-500 text-4xl mb-3"></i>
                <h4 class="text-yellow-700 font-semibold mb-2">No Teachers Assigned</h4>
                <p class="text-yellow-600">No teachers have been assigned to this class/section in the schedule yet.</p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Class Schedule Summary -->
    <?php if (!empty($subject_teachers)): ?>
    <div class="bg-gray-50 p-4  mb-6">
        <h3 class="text-lg font-semibold text-gray-800 mb-3">Class Schedule Summary</h3>
        <div class="overflow-x-auto">
            <table class="min-w-full bg-white text-sm">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="py-2 px-3 text-left">Subject</th>
                        <th class="py-2 px-3 text-left">Teacher</th>
                        <th class="py-2 px-3 text-left">Day</th>
                        <th class="py-2 px-3 text-left">Time</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($subject_teachers as $schedule): ?>
                    <tr class="border-b border-gray-200">
                        <td class="py-2 px-3"><?php echo htmlspecialchars($schedule['subject_name']); ?></td>
                        <td class="py-2 px-3"><?php echo htmlspecialchars($schedule['full_name']); ?></td>
                        <td class="py-2 px-3"><?php echo !empty($schedule['day_of_week']) ? ucfirst($schedule['day_of_week']) : 'Not scheduled'; ?></td>
                        <td class="py-2 px-3">
                            <?php if (!empty($schedule['start_time']) && !empty($schedule['end_time'])): ?>
                                <?php echo date('g:i A', strtotime($schedule['start_time'])) . ' - ' . date('g:i A', strtotime($schedule['end_time'])); ?>
                            <?php else: ?>
                                Not specified
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>

    <!-- Teacher Responsibilities -->
    <div class="bg-gray-50 p-4 ">
        <h3 class="text-lg font-semibold text-gray-800 mb-3">Teacher Responsibilities</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
            <div>
                <h4 class="font-medium text-blue-600 mb-2"><i class="fas fa-crown mr-2"></i>Class Teacher</h4>
                <ul class="list-disc list-inside text-gray-600 space-y-1">
                    <li>Overall class management</li>
                    <li>Parent-teacher communication</li>
                    <li>Student progress monitoring</li>
                    <li>Disciplinary matters</li>
                </ul>
            </div>
            <div>
                <h4 class="font-medium text-green-600 mb-2"><i class="fas fa-book mr-2"></i>Subject Teachers</h4>
                <ul class="list-disc list-inside text-gray-600 space-y-1">
                    <li>Subject-specific instruction</li>
                    <li>Assignment and exam preparation</li>
                    <li>Subject progress evaluation</li>
                    <li>Academic guidance</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<?php
include 'include/footer.php';
ob_end_flush();
?>