<?php
header('Content-Type: text/event-stream');
header('Cache-Control: no-cache');
header('Connection: keep-alive');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Credentials: true');

include '../config/conn.php';

// Get parent ID from query string
$parent_id = isset($_GET['parent_id']) ? intval($_GET['parent_id']) : 0;
$last_event_id = isset($_GET['last_event']) ? intval($_GET['last_event']) : 0;

if ($parent_id === 0) {
    die("data: {\"error\": \"Invalid parent ID\"}\n\n");
}

// Set script execution time
set_time_limit(0);
ob_implicit_flush(true);
ob_end_flush();

// Function to send SSE
function sendSSE($id, $data) {
    echo "id: " . $id . "\n";
    echo "data: " . json_encode($data) . "\n\n";
    flush();
}

// Send initial connection event
sendSSE(time(), [
    'type' => 'connection',
    'message' => 'Connected to real-time server',
    'timestamp' => date('Y-m-d H:i:s')
]);

// Check for new events every 2 seconds
$last_check = time();
while (true) {
    // Check if client is still connected
    if (connection_aborted()) {
        break;
    }

    // Query for new events
    $query = "SELECT id, event_type, event_data, created_at 
              FROM realtime_events 
              WHERE parent_id = $parent_id 
              AND id > $last_event_id 
              ORDER BY id ASC 
              LIMIT 10";
    
    $result = mysqli_query($conn, $query);
    
    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $event_data = json_decode($row['event_data'], true);
            $event_data['id'] = $row['id'];
            $event_data['timestamp'] = $row['created_at'];
            
            sendSSE($row['id'], $event_data);
            
            $last_event_id = $row['id'];
        }
    }
    
    // Send heartbeat every 30 seconds
    if ((time() - $last_check) >= 30) {
        sendSSE(time(), [
            'type' => 'heartbeat',
            'message' => 'Still connected',
            'timestamp' => date('Y-m-d H:i:s')
        ]);
        $last_check = time();
    }
    
    // Sleep for 2 seconds before next check
    sleep(2);
}

mysqli_close($conn);
?>