<?php
include '../config/conn.php';
session_start();

header('Content-Type: application/json');

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'parent') {
    echo json_encode(['success' => false, 'message' => 'Not authorized']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $parent_id = $_SESSION['user_id'];
    
    if (isset($input['subscription'])) {
        $subscription_json = json_encode($input['subscription']);
        
        // Save to database
        $subscription_escaped = mysqli_real_escape_string($conn, $subscription_json);
        $query = "UPDATE parents SET push_subscription = '$subscription_escaped' WHERE id = $parent_id";
        
        if (mysqli_query($conn, $query)) {
            echo json_encode(['success' => true, 'message' => 'Push notifications enabled']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to save subscription']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'No subscription data']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>