<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in as parent
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'parent') {
    header('Location: login.php');
    exit();
}

$parent_id = $_SESSION['user_id'];
$success_message = '';
$error_message = '';

// Handle mark all as read
if (isset($_POST['mark_all_read'])) {
    $query = "UPDATE parent_notifications SET is_read = 1 WHERE parent_id = $parent_id AND is_read = 0";
    if (mysqli_query($conn, $query)) {
        $success_message = "All notifications marked as read!";
    } else {
        $error_message = "Error updating notifications: " . mysqli_error($conn);
    }
}

// Handle mark single as read
if (isset($_GET['mark_read'])) {
    $notification_id = intval($_GET['mark_read']);
    $query = "UPDATE parent_notifications SET is_read = 1 WHERE id = $notification_id AND parent_id = $parent_id";
    mysqli_query($conn, $query);
    header('Location: notifications.php');
    exit();
}

// Handle clear all notifications
if (isset($_POST['clear_all'])) {
    $query = "DELETE FROM parent_notifications WHERE parent_id = $parent_id";
    if (mysqli_query($conn, $query)) {
        $success_message = "All notifications cleared!";
    } else {
        $error_message = "Error clearing notifications: " . mysqli_error($conn);
    }
}

// Get all notifications
$query = "SELECT id, title, message, type, created_at, is_read 
          FROM parent_notifications 
          WHERE parent_id = $parent_id 
          ORDER BY created_at DESC";

$result = mysqli_query($conn, $query);
$notifications = [];
$unread_count = 0;

if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $notifications[] = $row;
        if (!$row['is_read']) {
            $unread_count++;
        }
    }
}

ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notifications - Adinoheightschool</title>
    <style>
        .notification-item {
            border-left: 4px solid;
            transition: all 0.3s ease;
            margin-bottom: 1rem;
        }
        .notification-item.unread {
            background-color: #f0f9ff;
            border-left-color: #3b82f6;
        }
        .notification-item.read {
            border-left-color: #d1d5db;
            background-color: #f9fafb;
        }
        .notification-type {
            display: inline-flex;
            align-items: center;
            padding: 0.25rem 0.75rem;
            border-radius: 9999px;
            font-size: 0.75rem;
            font-weight: 500;
        }
        .new-badge {
            background-color: #ef4444;
            color: white;
            padding: 0.25rem 0.5rem;
            border-radius: 9999px;
            font-size: 0.75rem;
            font-weight: 500;
        }
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
</head>
<body class="bg-gray-100">
<div class="container mx-auto px-4 py-6">
    <div class="max-w-4xl mx-auto">
        <!-- Header -->
        <div class="bg-white p-6 rounded-lg shadow-sm mb-6">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">Notifications</h1>
                    <p class="text-gray-600">Stay updated with school announcements and activities</p>
                </div>
                <div class="text-right">
                    <span class="bg-blue-100 text-blue-800 px-3 py-1 rounded-full text-sm font-medium">
                        <?php echo count($notifications); ?> total
                    </span>
                    <?php if ($unread_count > 0): ?>
                        <span class="bg-red-100 text-red-800 px-3 py-1 rounded-full text-sm font-medium ml-2">
                            <?php echo $unread_count; ?> unread
                        </span>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <?php if (!empty($notifications)): ?>
        <div class="bg-white p-4 rounded-lg shadow-sm mb-6">
            <div class="flex space-x-4">
                <form method="POST" class="inline">
                    <button type="submit" name="mark_all_read" 
                            class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg flex items-center">
                        <i class="fas fa-check-double mr-2"></i> Mark All as Read
                    </button>
                </form>
                <form method="POST" class="inline" onsubmit="return confirm('Are you sure you want to clear all notifications?');">
                    <button type="submit" name="clear_all" 
                            class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-lg flex items-center">
                        <i class="fas fa-trash mr-2"></i> Clear All
                    </button>
                </form>
            </div>
        </div>
        <?php endif; ?>

        <!-- Messages -->
        <?php if (!empty($success_message)): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6 fade-in">
                <i class="fas fa-check-circle mr-2"></i><?php echo $success_message; ?>
            </div>
        <?php endif; ?>

        <?php if (!empty($error_message)): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6 fade-in">
                <i class="fas fa-exclamation-circle mr-2"></i><?php echo $error_message; ?>
            </div>
        <?php endif; ?>

        <!-- Notifications List -->
        <div class="bg-white rounded-lg shadow-sm">
            <?php if (!empty($notifications)): ?>
                <div class="divide-y">
                    <?php foreach ($notifications as $notification): ?>
                        <div class="notification-item <?php echo $notification['is_read'] ? 'read' : 'unread'; ?> p-6 fade-in">
                            <div class="flex justify-between items-start mb-2">
                                <h3 class="font-semibold text-gray-800 text-lg">
                                    <?php echo htmlspecialchars($notification['title']); ?>
                                </h3>
                                <span class="text-sm text-gray-500">
                                    <?php echo date('M j, Y g:i A', strtotime($notification['created_at'])); ?>
                                </span>
                            </div>
                            
                            <p class="text-gray-600 mb-4 leading-relaxed">
                                <?php echo htmlspecialchars($notification['message']); ?>
                            </p>
                            
                            <div class="flex justify-between items-center">
                                <span class="notification-type 
                                    <?php echo $notification['type'] === 'attendance' ? 'bg-green-100 text-green-800' : 
                                           ($notification['type'] === 'exam' ? 'bg-blue-100 text-blue-800' : 
                                           ($notification['type'] === 'fee' ? 'bg-yellow-100 text-yellow-800' : 
                                           ($notification['type'] === 'event' ? 'bg-purple-100 text-purple-800' : 
                                           'bg-gray-100 text-gray-800'))); ?>">
                                    <i class="fas 
                                        <?php echo $notification['type'] === 'attendance' ? 'fa-calendar-check' : 
                                               ($notification['type'] === 'exam' ? 'fa-chart-line' : 
                                               ($notification['type'] === 'fee' ? 'fa-file-invoice-dollar' : 
                                               ($notification['type'] === 'event' ? 'fa-calendar-alt' : 
                                               'fa-bell'))); ?> mr-1"></i>
                                    <?php echo ucfirst($notification['type']); ?>
                                </span>
                                
                                <div class="flex space-x-2">
                                    <?php if (!$notification['is_read']): ?>
                                        <span class="new-badge">
                                            <i class="fas fa-circle mr-1"></i>New
                                        </span>
                                    <?php endif; ?>
                                    
                                    <?php if (!$notification['is_read']): ?>
                                        <a href="?mark_read=<?php echo $notification['id']; ?>" 
                                           class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-3 py-1 rounded text-sm flex items-center">
                                            <i class="fas fa-check mr-1"></i> Mark Read
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div class="text-center py-16">
                    <i class="fas fa-bell-slash text-5xl text-gray-300 mb-4"></i>
                    <h3 class="text-xl font-medium text-gray-600 mb-2">No notifications yet</h3>
                    <p class="text-gray-500 max-w-md mx-auto">
                        You're all caught up! When you have new notifications from the school, 
                        they will appear here.
                    </p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
// Auto-hide success messages after 5 seconds
document.addEventListener('DOMContentLoaded', function() {
    const successMessage = document.querySelector('.bg-green-100');
    if (successMessage) {
        setTimeout(() => {
            successMessage.style.display = 'none';
        }, 5000);
    }
});

// Add smooth animations
document.addEventListener('DOMContentLoaded', function() {
    const notifications = document.querySelectorAll('.notification-item');
    notifications.forEach((notification, index) => {
        notification.style.animationDelay = `${index * 0.1}s`;
    });
});
</script>

<?php include 'include/footer.php'; ?>
</body>
</html>