<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// ✅ Ensure parent login
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'parent') {
    header('Location: login.php');
    exit();
}

$parent_id = $_SESSION['user_id'];
$error = '';

// ✅ Get children linked to this parent - FIXED QUERY
// Assuming the parent ID is stored in the students table as parent_id
$children_query = "
    SELECT s.id, s.full_name, s.class, s.section, c.class_name, sec.section_name
    FROM students s
    LEFT JOIN classes c ON s.class = c.id
    LEFT JOIN sections sec ON s.section = sec.id
    WHERE s.parent_id = $parent_id
";
$children_result = mysqli_query($conn, $children_query);

// Check if query was successful
if (!$children_result) {
    $error = "Database error: " . mysqli_error($conn);
}

$child_ids = [];
$child_names = [];
if ($children_result && mysqli_num_rows($children_result) > 0) {
    while ($row = mysqli_fetch_assoc($children_result)) {
        $child_ids[] = $row['id'];
        $child_names[$row['id']] = $row;
    }
}

if (empty($child_ids)) {
    echo "<div class='bg-white p-6 rounded-lg shadow'>
            <h2 class='text-xl font-bold mb-2'>No Children Linked</h2>
            <p class='text-gray-600'>This parent account has no linked children. Please contact the school admin.</p>
          </div>";
    include 'include/footer.php';
    ob_end_flush();
    exit();
}

$child_ids_str = implode(',', $child_ids);
$current_date = date('Y-m-d');

// ✅ Fetch notices relevant to any of the parent's children
$notices_query = "
    SELECT DISTINCT n.*, u.full_name as created_by_name
    FROM notices n
    LEFT JOIN users u ON n.created_by = u.id
    WHERE (
        n.audience_type = 'all'
        OR (n.audience_type = 'class' AND n.target_id IN (SELECT class FROM students WHERE id IN ($child_ids_str)))
        OR (n.audience_type = 'section' AND n.target_id IN (SELECT section FROM students WHERE id IN ($child_ids_str)))
        OR (n.audience_type = 'student' AND n.target_id IN ($child_ids_str))
    )
    AND (n.expiry_date IS NULL OR n.expiry_date >= '$current_date')
    ORDER BY 
        CASE n.priority 
            WHEN 'urgent' THEN 1
            WHEN 'high' THEN 2
            ELSE 3
        END,
        n.created_at DESC
";
$notices_result = mysqli_query($conn, $notices_query);

// Check if query was successful
if (!$notices_result) {
    $error = "Database error: " . mysqli_error($conn);
}
?>

<div class="bg-white p-6 rounded-lg">
    <h2 class="text-2xl font-bold text-gray-800 mb-4">Notice Board</h2>
    
    <?php if (!empty($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <?php echo $error; ?>
        </div>
    <?php endif; ?>
    
    <p class="text-gray-600 mb-6">Showing notices for your children.</p>

    <?php if ($notices_result && mysqli_num_rows($notices_result) > 0): ?>
        <div class="space-y-4">
            <?php while ($notice = mysqli_fetch_assoc($notices_result)): ?>
                <?php
                // Priority badge color
                $priority_class = 'bg-blue-100 text-blue-800';
                if ($notice['priority'] === 'high') $priority_class = 'bg-yellow-100 text-yellow-800';
                if ($notice['priority'] === 'urgent') $priority_class = 'bg-red-100 text-red-800';
                ?>
                <div class="border border-gray-200 rounded-lg p-4 hover:shadow-md transition-shadow">
                    <div class="flex justify-between items-start mb-2">
                        <div>
                            <h4 class="font-semibold text-gray-800 text-lg"><?php echo htmlspecialchars($notice['title']); ?></h4>
                            <p class="text-sm text-gray-600">
                                Audience: <?php echo ucfirst($notice['audience_type']); ?>
                                <?php if ($notice['audience_type'] !== 'all'): ?>
                                    (<?php echo htmlspecialchars($notice['target_name'] ?? 'Specific'); ?>)
                                <?php endif; ?>
                            </p>
                        </div>
                        <span class="text-xs font-medium px-2.5 py-0.5 rounded-full <?php echo $priority_class; ?>">
                            <?php echo ucfirst($notice['priority']); ?>
                        </span>
                    </div>

                    <div class="text-gray-700 mb-3">
                        <?php 
                        $content_preview = strlen($notice['content']) > 150 
                            ? substr($notice['content'], 0, 150) . '...' 
                            : $notice['content'];
                        echo nl2br(htmlspecialchars($content_preview));
                        ?>
                    </div>

                    <div class="flex justify-between items-center text-sm text-gray-500">
                        <div>
                            <span>Posted by: <?php echo htmlspecialchars($notice['created_by_name']); ?></span>
                            <span class="mx-2">•</span>
                            <span><?php echo date('M j, Y', strtotime($notice['created_at'])); ?></span>
                            <?php if ($notice['expiry_date']): ?>
                                <span class="mx-2">•</span>
                                <span>Expires: <?php echo date('M j, Y', strtotime($notice['expiry_date'])); ?></span>
                            <?php endif; ?>
                        </div>
                        <a href="view_notice_detail.php?id=<?php echo $notice['id']; ?>" class="text-blue-600 hover:text-blue-800 font-medium flex items-center">
                            <i class="fas fa-eye mr-1"></i> Read More
                        </a>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>
    <?php else: ?>
        <div class="text-center py-8">
            <i class="fas fa-bell-slash text-4xl text-gray-300 mb-4"></i>
            <p class="text-gray-500 text-lg">No notices available at the moment.</p>
            <p class="text-gray-400">Check back later for updates.</p>
        </div>
    <?php endif; ?>
</div>

<?php
include 'include/footer.php';
ob_end_flush();
?>