<?php
session_start();
include '../config/conn.php';

// Check if user is logged in as parent
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'parent') {
    header('HTTP/1.1 403 Forbidden');
    echo json_encode(['success' => false, 'error' => 'Access denied']);
    exit();
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);
$notification_id = isset($input['notification_id']) ? intval($input['notification_id']) : 0;

if ($notification_id > 0) {
    $parent_id = $_SESSION['user_id'];
    
    // Update only notifications belonging to this parent
    $query = "UPDATE parent_notifications SET is_read = 1 
              WHERE id = $notification_id AND parent_id = $parent_id";
    
    if (mysqli_query($conn, $query)) {
        $response = ['success' => true];
    } else {
        error_log("Update error: " . mysqli_error($conn));
        $response = ['success' => false, 'error' => 'Database error'];
    }
} else {
    $response = ['success' => false, 'error' => 'Invalid notification ID'];
}

header('Content-Type: application/json');
echo json_encode($response);

mysqli_close($conn);
?>