<?php
// DB connection
include '../config/conn.php';

// Get parent info from session
$parent_id = $_SESSION['user_id'];
$query = "SELECT * FROM parents WHERE id = ?";
$stmt  = $conn->prepare($query);
$stmt->bind_param("i", $parent_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    session_destroy();
    header('Location: ../portal_login.php');
    exit();
}

$parent = $result->fetch_assoc();
$stmt->close();

// Profile picture
$user_image = !empty($parent['picture']) ? $parent['picture'] : 'default.png';
?>

<!-- Sidebar -->
<div class="sidebar bg-white w-64 md:w-72 py-6 px-4 flex flex-col justify-between shadow-sm overflow-y-auto">

    <!-- Logo -->
    <div class="mb-10 px-4">
              <h1 class="heading text-xl font-semibold text-primary flex items-center">
            <img src="../img/logotwo.png" alt="Adinoheight Logo" 
                 class="h-20 w-20 object-contain"> 
            Adinoheight
        </h1>
        <p class="text-xs text-gray-500 mt-1">Parent Portal</p>
    </div>

    <!-- Navigation -->
<!-- Navigation -->
<nav class="flex-1">
    <ul class="space-y-1">
        <li>
            <a href="index.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item hover:bg-gray-100">
                <i class="fas fa-tachometer-alt mr-3 w-5 text-center"></i>
                <span>Dashboard</span>
            </a>
        </li>

        <li>
            <a href="view_attendance.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                <i class="fas fa-user-check mr-3 w-5 text-center"></i>
                <span>Child Attendance</span>
            </a>
        </li>
        
        <li>
            <a href="teacher.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                <i class="fas fa-chalkboard-teacher mr-3 w-5 text-center"></i>
                <span>Teacher</span>
            </a>
        </li>

        <li>
            <a href="result.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                <i class="fas fa-graduation-cap mr-3 w-5 text-center"></i>
                <span>Report Card</span>
            </a>
        </li>

        <li>
            <a href="view_fees.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                <i class="fas fa-wallet mr-3 w-5 text-center"></i>
                <span>Fee Payment</span>
            </a>
        </li>

        <li>
            <a href="notices.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                <i class="fas fa-bullhorn mr-3 w-5 text-center"></i>
                <span>School Notices</span>
            </a>
        </li>
    </ul>
</nav>


    <!-- User section -->
    <div class="pt-6 mt-6 border-t border-gray-100">
        <div class="relative">
            <button class="flex items-center w-full px-4 py-2 hover:bg-gray-100 rounded-lg focus:outline-none user-dropdown-btn">
                <div class="flex-shrink-0">
                    <img src="../uploads/<?php echo htmlspecialchars($user_image); ?>" 
                        alt="Profile" 
                        class="profile-img"
                        style="width:60px; height:60px; object-fit:cover; border-radius:50%; border:3px solid #4CAF50; box-shadow:0px 4px 10px rgba(0,0,0,0.2);">
                </div>
                <div class="ml-3 text-left">
                    <p class="text-sm font-medium text-gray-700"><?= htmlspecialchars($parent['fullname']) ?></p>
                    <p class="text-xs text-gray-500">Parent</p>
                </div>
                <i class="fas fa-chevron-down ml-auto text-xs text-gray-500"></i>
            </button>

            <!-- Dropdown -->
            <div class="hidden absolute bottom-12 left-4 w-48 bg-white border rounded-lg shadow-md user-dropdown">
                <a href="profile.php" class="block px-4 py-2 text-sm text-gray-600 hover:bg-gray-100">My Profile</a>
                <a href="edit_profile.php" class="block px-4 py-2 text-sm text-gray-600 hover:bg-gray-100">Settings</a>
                <a href="logout.php" class="block px-4 py-2 text-sm text-red-600 hover:bg-red-50">Logout</a>
            </div>
        </div>
    </div>
</div>

<!-- Overlay for mobile -->
<div class="overlay"></div>

<!-- JS for dropdown -->
<script>
document.addEventListener("DOMContentLoaded", function () {
    const userBtn = document.querySelector(".user-dropdown-btn");
    const dropdown = document.querySelector(".user-dropdown");

    if (userBtn && dropdown) {
        userBtn.addEventListener("click", (e) => {
            e.stopPropagation();
            dropdown.classList.toggle("hidden");
        });
        document.addEventListener("click", () => dropdown.classList.add("hidden"));
    }
});
</script>
