<?php
session_start();
include '../config/conn.php';

// Ensure parent login
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'parent') {
    header('Content-Type: application/json');
    echo json_encode([]);
    exit();
}

$parent_id = $_SESSION['user_id'];

// Get the last check time from session or set to current time minus 5 minutes
$last_check = isset($_SESSION['last_attendance_check']) ? 
    $_SESSION['last_attendance_check'] : 
    date('Y-m-d H:i:s', strtotime('-5 minutes'));

// Get attendance updates for this parent's children since last check
$query = "
    SELECT a.*, s.full_name as student_name, c.class_name, sec.section_name
    FROM attendance a
    INNER JOIN students s ON a.student_id = s.id
    INNER JOIN classes c ON a.class_id = c.id
    INNER JOIN sections sec ON a.section_id = sec.id
    WHERE s.parent_id = $parent_id
    AND a.recorded_at > '$last_check'
    ORDER BY a.recorded_at DESC
";

$result = mysqli_query($conn, $query);
$updates = [];

if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $updates[] = [
            'student_name' => $row['student_name'],
            'class_name' => $row['class_name'],
            'section_name' => $row['section_name'],
            'status' => $row['status'],
            'date' => $row['attendance_date'],
            'time' => date('H:i', strtotime($row['recorded_at']))
        ];
    }
}

// Update last check time
$_SESSION['last_attendance_check'] = date('Y-m-d H:i:s');

header('Content-Type: application/json');
echo json_encode($updates);
?>