<?php
date_default_timezone_set('Africa/Lagos');
session_start();
include 'config/conn.php';
// Include PHPMailer
require 'vendor/autoload.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Check if token is provided
if (!isset($_GET['token'])) {
    die("Invalid access. No token provided.");
}

$token = mysqli_real_escape_string($conn, $_GET['token']);
$success = '';
$error = '';

// Verify token is valid and not expired
$token_query = "SELECT * FROM qr_attendance_tokens 
                WHERE token = '$token' AND expiry_time > NOW()";
$token_result = mysqli_query($conn, $token_query);

if (mysqli_num_rows($token_result) === 0) {
    $error = "Invalid or expired QR code";
} else {
    $token_data = mysqli_fetch_assoc($token_result);
    $class_id = $token_data['class_id'];
    $section_id = $token_data['section_id'];
    $is_yearly = $token_data['is_yearly'];
    
    // Get class and section names for display
    $class_name = mysqli_fetch_assoc(mysqli_query($conn, "SELECT class_name FROM classes WHERE id = $class_id"))['class_name'];
    $section_name = mysqli_fetch_assoc(mysqli_query($conn, "SELECT section_name FROM sections WHERE id = $section_id"))['section_name'];
}

// Function to get parent email and info
function getParentInfo($student_id) {
    global $conn;
    
    $query = "SELECT p.id as parent_id, p.email, p.fullname as parent_name, p.contact as parent_phone
              FROM parents p
              INNER JOIN students s ON p.id = s.parent_id
              WHERE s.student_id = '$student_id' AND s.status = 'active'";
    
    $result = mysqli_query($conn, $query);
    
    if (mysqli_num_rows($result) > 0) {
        return mysqli_fetch_assoc($result);
    }
    
    return null;
}

// Function to send push notification to parent
function sendParentPushNotification($parent_id, $student_name, $status, $class_name, $section_name, $attendance_date) {
    global $conn;
    
    $title = "Attendance Update - $student_name";
    $message = "Your child $student_name was marked as " . ucfirst($status) . " in $class_name - $section_name on $attendance_date";
    
    // Store notification for parent
    $query = "INSERT INTO parent_notifications 
              (parent_id, title, message, type, is_read, created_at) 
              VALUES ($parent_id, '$title', '$message', 'attendance', 0, NOW())";
    
    return mysqli_query($conn, $query);
}

// Function to send browser push notification
function sendBrowserPushNotification($parent_id, $student_name, $status, $class_name, $section_name, $attendance_date) {
    global $conn;
    
    $title = "Attendance Update - $student_name";
    $message = "Your child $student_name was marked as " . ucfirst($status) . " in $class_name - $section_name on $attendance_date";
    
    // Store notification in database (this will be picked up by the service worker)
    $query = "INSERT INTO parent_notifications 
              (parent_id, title, message, type, is_read, created_at) 
              VALUES ($parent_id, '$title', '$message', 'attendance', 0, NOW())";
    
    return mysqli_query($conn, $query);
}

// Function to send email notification with enhanced details
function sendEmailNotification($student_name, $student_email, $attendance_date, $status, $time, $class_name, $section_name, $parent_email = null, $parent_name = null) {
    // Get admin email from database
    global $conn;
    $admin_query = "SELECT email FROM users WHERE role = 'admin' LIMIT 1";
    $admin_result = mysqli_query($conn, $admin_query);
    
    if (mysqli_num_rows($admin_result) === 0) {
        error_log("No admin found in database");
        return false;
    }
    
    $admin = mysqli_fetch_assoc($admin_result);
    $admin_email = $admin['email'];
    
    $mail = new PHPMailer(true);
    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host       = 'smtp.gmail.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'holuwaseunisrael@gmail.com';
        $mail->Password   = 'ceae tepn tfyx oxjn';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port       = 465;

        // Recipients - Updated to use Adinoheightschool branding
        $mail->setFrom('attendance@adinoheightschool.com', 'Adinoheightschool Attendance System');
        $mail->addAddress($admin_email);
        
        // Add student email if available
        if (!empty($student_email)) {
            $mail->addAddress($student_email);
        }
        
        // Add parent email if available
        if (!empty($parent_email)) {
            $mail->addAddress($parent_email);
        }
        
        $mail->addReplyTo('noreply@adinoheightschool.com', 'Adinoheightschool No Reply');

        // Content - Updated with school branding and enhanced details
        $mail->isHTML(true);
        $mail->Subject = "Adinoheightschool Attendance - $student_name - $attendance_date";
        
        $parent_greeting = $parent_name ? "<p><strong>Parent:</strong> $parent_name</p>" : "";
        
        $mail->Body = "
        <html>
        <head>
            <title>Adinoheightschool Attendance Notification</title>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                .header { background-color: #3b82f6; color: white; padding: 20px; text-align: center; }
                .content { padding: 20px; }
                .footer { background-color: #f3f4f6; padding: 15px; text-align: center; font-size: 12px; }
                .school-name { font-weight: bold; color: #1e40af; }
                .status-badge { padding: 4px 8px; border-radius: 4px; display: inline-block; }
            </style>
        </head>
        <body>
            <div class='header'>
                <h2>Adinoheightschool Attendance System</h2>
            </div>
            <div class='content'>
                <h3>Attendance Recorded Successfully</h3>
                <p><strong>Student:</strong> $student_name</p>
                $parent_greeting
                <p><strong>Class:</strong> $class_name</p>
                <p><strong>Section:</strong> $section_name</p>
                <p><strong>Date:</strong> $attendance_date</p>
                <p><strong>Time:</strong> $time</p>
                <p><strong>Status:</strong> <span class='status-badge' style='background-color: " . 
                    ($status == 'present' ? '#d1fae5' : ($status == 'late' ? '#fef3c7' : '#fee2e2')) . 
                    "; color: " . ($status == 'present' ? '#065f46' : ($status == 'late' ? '#92400e' : '#b91c1c')) . 
                    ";'>" . ucfirst($status) . "</span></p>
            </div>
            <div class='footer'>
                <p>This is an automated notification from <span class='school-name'>Adinoheightschool</span></p>
                <p>Please do not reply to this email</p>
            </div>
        </body>
        </html>";
        
        return $mail->send();
    } catch (Exception $e) {
        error_log("Mailer Error: {$mail->ErrorInfo}");
        return false;
    }
}

// Handle AJAX request
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['student_id']) && isset($_POST['attendance_date'])) {
    header('Content-Type: application/json');
    
    $student_id = mysqli_real_escape_string($conn, $_POST['student_id']);
    $attendance_date = mysqli_real_escape_string($conn, $_POST['attendance_date']);
    $response = ['success' => false, 'message' => ''];
    
    // Validate date (cannot be in the future)
    if (strtotime($attendance_date) > strtotime(date('Y-m-d'))) {
        $response['message'] = "Cannot record attendance for future dates";
        echo json_encode($response);
        exit;
    }
    
    // Check if student exists and is active
    $student_query = "SELECT id, student_id, full_name, email, class, section, parent_id 
                      FROM students 
                      WHERE student_id = '$student_id' AND status='active' 
                      LIMIT 1";
    $student_result = mysqli_query($conn, $student_query);
    
    if (mysqli_num_rows($student_result) === 0) {
        $response['message'] = "No active student found with this ID";
        echo json_encode($response);
        exit;
    }
    
    $student = mysqli_fetch_assoc($student_result);
    $student_db_id = $student['id'];
    $student_class_id = $student['class'];
    $student_section_id = $student['section'];
    $parent_id = $student['parent_id'];
    
    // Check if student belongs to the correct class/section
    if ($student_class_id != $class_id || $student_section_id != $section_id) {
        $response['message'] = "This QR code is for a different class/section";
        echo json_encode($response);
        exit;
    }
    
    // Get class and section names for email
    $class_name = mysqli_fetch_assoc(mysqli_query($conn, "SELECT class_name FROM classes WHERE id = $student_class_id"))['class_name'];
    $section_name = mysqli_fetch_assoc(mysqli_query($conn, "SELECT section_name FROM sections WHERE id = $student_section_id"))['section_name'];
    
    // Check if attendance already recorded for this date
    $check_query = "SELECT id FROM attendance 
                    WHERE student_id = $student_db_id 
                    AND attendance_date = '$attendance_date'";
    $check_result = mysqli_query($conn, $check_query);
    
    if (mysqli_num_rows($check_result) > 0) {
        $response['message'] = "Attendance already recorded for this date";
        echo json_encode($response);
        exit;
    }
    
    // Determine status based on time (late after 8:30 AM)
    $current_time = date('H:i:s');
    $status = 'present';
    if (strtotime($current_time) > strtotime('08:30:00')) {
        $status = 'late';
    }
    
    // Record attendance
    $insert_query = "INSERT INTO attendance 
        (student_id, class_id, section_id, attendance_date, status, recorded_by, recorded_at)
        VALUES ($student_db_id, '$student_class_id', '$student_section_id', '$attendance_date', '$status', 99, NOW())";
    
    if (mysqli_query($conn, $insert_query)) {
        // Get parent information
        $parent_info = getParentInfo($student_id);
        $parent_email = $parent_info ? $parent_info['email'] : null;
        $parent_name = $parent_info ? $parent_info['parent_name'] : null;
        $parent_id = $parent_info ? $parent_info['parent_id'] : null;
        
        // Send email notification with enhanced details (to admin, student, and parent)
        $email_sent = sendEmailNotification(
            $student['full_name'], 
            $student['email'], 
            $attendance_date, 
            $status, 
            $current_time,
            $class_name,
            $section_name,
            $parent_email,
            $parent_name
        );
        
        // Send push notification to parent if parent exists
        $push_sent = false;
        $browser_push_sent = false;
        
        if ($parent_id) {
            $push_sent = sendParentPushNotification(
                $parent_id,
                $student['full_name'],
                $status,
                $class_name,
                $section_name,
                $attendance_date
            );
            
            $browser_push_sent = sendBrowserPushNotification(
                $parent_id,
                $student['full_name'],
                $status,
                $class_name,
                $section_name,
                $attendance_date
            );
        }
        
        $response['success'] = true;
        $response['message'] = "Thank you! Attendance recorded successfully for " . $student['full_name'];
        
        $notifications = [];
        if ($email_sent) {
            $notifications[] = "Email notification sent";
        }
        if ($push_sent) {
            $notifications[] = "Parent notification sent";
        }
        if ($browser_push_sent) {
            $notifications[] = "Browser notification queued";
        }
        
        if (!empty($notifications)) {
            $response['message'] .= ". " . implode(", ", $notifications) . ".";
        }
    } else {
        $response['message'] = "Error saving attendance: " . mysqli_error($conn);
    }
    
    echo json_encode($response);
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Adinoheightschool - Student Attendance</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
            background-color: #f3f4f6;
        }
        .container {
            max-width: 100%;
            padding: 1rem;
        }
        .card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            padding: 1.5rem;
            margin-bottom: 1rem;
        }
        .btn {
            display: block;
            width: 100%;
            padding: 0.75rem;
            border-radius: 8px;
            font-weight: 600;
            text-align: center;
            border: none;
            cursor: pointer;
            transition: background-color 0.2s;
        }
        .btn-primary {
            background-color: #3b82f6;
            color: white;
        }
        .btn-primary:hover {
            background-color: #2563eb;
        }
        .btn-primary:disabled {
            background-color: #93c5fd;
            cursor: not-allowed;
        }
        .input-field {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #d1d5db;
            border-radius: 8px;
            font-size: 16px;
        }
        .input-field:focus {
            outline: none;
            border-color: #3b82f6;
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.2);
        }
        .alert {
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
            display: none;
        }
        .alert-success {
            background-color: #d1fae5;
            color: #065f46;
            border: 1px solid #a7f3d0;
        }
        .alert-error {
            background-color: #fee2e2;
            color: #b91c1c;
            border: 1px solid #fca5a5;
        }
        .spinner {
            display: inline-block;
            width: 1rem;
            height: 1rem;
            border: 2px solid #ffffff;
            border-radius: 50%;
            border-top-color: transparent;
            animation: spin 1s linear infinite;
        }
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        .school-header {
            background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%);
            color: white;
            padding: 1.5rem;
            border-radius: 12px;
            margin-bottom: 1.5rem;
            text-align: center;
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto py-8">
        <div class="max-w-md mx-auto">
            <!-- School Branding Header -->
            <div class="school-header">
                <h1 class="text-2xl font-bold">Adinoheightschool</h1>
                <p class="text-sm opacity-90">Student Attendance System</p>
            </div>

            <div id="alertBox" class="alert" style="display: none;">
                <i class="fas mr-2" id="alertIcon"></i> <span id="alertMessage"></span>
            </div>

            <?php if (isset($token_data) && mysqli_num_rows($token_result) > 0): ?>
                <div class="text-center mb-6">
                    <p class="text-gray-600">Enter your Student ID and select date to record attendance</p>
                    <p class="text-sm text-gray-500 mt-1">Class: <?php echo $class_name . ' - ' . $section_name; ?></p>
                    <?php if ($is_yearly == 1): ?>
                        <p class="text-sm text-green-600 font-semibold">Yearly QR Code - Valid until <?php echo date('M j, Y', strtotime($token_data['expiry_time'])); ?></p>
                    <?php else: ?>
                        <p class="text-sm text-gray-500">Date: <?php echo date('M j, Y', strtotime($token_data['attendance_date'])); ?></p>
                    <?php endif; ?>
                </div>

                <div class="card">
                    <form id="attendanceForm">
                        <div class="mb-4">
                            <label for="student_id" class="block text-sm font-medium text-gray-700 mb-1">Student ID</label>
                            <input type="text" id="student_id" name="student_id" 
                                class="input-field" placeholder="Enter your student ID" 
                                required autocomplete="off" autofocus>
                        </div>
                        
                        <div class="mb-4">
                            <label for="attendance_date" class="block text-sm font-medium text-gray-700 mb-1">Select Date</label>
                            <input type="date" id="attendance_date" name="attendance_date" 
                                class="input-field" 
                                value="<?php echo date('Y-m-d'); ?>"
                                max="<?php echo date('Y-m-d'); ?>"
                                required>
                        </div>
                        
                        <button type="submit" id="submitBtn" class="btn btn-primary">
                            <i class="fas fa-check-circle mr-2"></i> Submit Attendance
                        </button>
                    </form>
                </div>
                
                <div class="text-center text-sm text-gray-500 mt-4">
                    <p>QR code valid until <?php echo date('M j, Y', strtotime($token_data['expiry_time'])); ?></p>
                </div>
            <?php else: ?>
                <div class="card text-center">
                    <i class="fas fa-exclamation-triangle text-yellow-500 text-4xl mb-3"></i>
                    <h2 class="text-xl font-semibold text-gray-800">Invalid QR Code</h2>
                    <p class="text-gray-600 mt-2">This QR code is invalid or has expired.</p>
                    <p class="text-sm text-gray-500 mt-4">Please contact Adinoheightschool administration for assistance.</p>
                </div>
            <?php endif; ?>
            
            <div class="text-center mt-8">
                <p class="text-sm text-gray-500">Adinoheightschool © <?php echo date('Y'); ?></p>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('attendanceForm');
            const alertBox = document.getElementById('alertBox');
            const alertIcon = document.getElementById('alertIcon');
            const alertMessage = document.getElementById('alertMessage');
            const submitBtn = document.getElementById('submitBtn');
            const studentIdInput = document.getElementById('student_id');
            
            if (form) {
                form.addEventListener('submit', function(e) {
                    e.preventDefault();
                    
                    // Show loading state
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<span class="spinner mr-2"></span> Processing...';
                    
                    // Get form data
                    const formData = new FormData();
                    formData.append('student_id', studentIdInput.value);
                    formData.append('attendance_date', document.getElementById('attendance_date').value);
                    
                    // Send AJAX request
                    fetch('', {
                        method: 'POST',
                        body: formData
                    })
                    .then(response => response.json())
                    .then(data => {
                        // Show alert
                        if (data.success) {
                            alertBox.className = 'alert alert-success';
                            alertIcon.className = 'fas fa-check-circle';
                        } else {
                            alertBox.className = 'alert alert-error';
                            alertIcon.className = 'fas fa-exclamation-circle';
                        }
                        
                        alertMessage.textContent = data.message;
                        alertBox.style.display = 'block';
                        
                        // Clear form if successful
                        if (data.success) {
                            form.reset();
                            document.getElementById('attendance_date').value = '<?php echo date('Y-m-d'); ?>';
                        }
                    })
                    .catch(error => {
                        alertBox.className = 'alert alert-error';
                        alertIcon.className = 'fas fa-exclamation-circle';
                        alertMessage.textContent = 'An error occurred. Please try again.';
                        alertBox.style.display = 'block';
                    })
                    .finally(() => {
                        // Reset button state
                        submitBtn.disabled = false;
                        submitBtn.innerHTML = '<i class="fas fa-check-circle mr-2"></i> Submit Attendance';
                        
                        // Hide alert after 5 seconds
                        setTimeout(() => {
                            alertBox.style.display = 'none';
                        }, 5000);
                    });
                });
            }
            
            // Focus on input field when page loads
            if (studentIdInput) {
                studentIdInput.focus();
            }
        });
    </script>
</body>
</html>
<?php
mysqli_close($conn);
?>