<?php
date_default_timezone_set('Africa/Lagos');
session_start();
include 'config/conn.php';
// Include PHPMailer
require 'vendor/autoload.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Check if token is provided
if (!isset($_GET['token'])) {
    die("Invalid access. No token provided.");
}

$token = mysqli_real_escape_string($conn, $_GET['token']);
$success = '';
$error = '';

// Verify token is valid and not expired
$token_query = "SELECT * FROM qr_attendance_tokens 
                WHERE token = '$token' AND expiry_time > NOW() AND is_teacher = 1";
$token_result = mysqli_query($conn, $token_query);

if (mysqli_num_rows($token_result) === 0) {
    $error = "Invalid or expired QR code";
} else {
    $token_data = mysqli_fetch_assoc($token_result);
    $attendance_year = $token_data['attendance_year'];
}

// Function to send email notification with enhanced details
function sendEmailNotification($teacher_name, $teacher_email, $attendance_date, $status, $time) {
    // Get admin email from database
    global $conn;
    $admin_query = "SELECT email FROM users WHERE role = 'admin' LIMIT 1";
    $admin_result = mysqli_query($conn, $admin_query);
    
    if (mysqli_num_rows($admin_result) === 0) {
        error_log("No admin found in database");
        return false;
    }
    
    $admin = mysqli_fetch_assoc($admin_result);
    $admin_email = $admin['email'];
    
    $mail = new PHPMailer(true);
    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host       = 'smtp.gmail.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'holuwaseunisrael@gmail.com';
        $mail->Password   = 'ceae tepn tfyx oxjn';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port       = 465;

        // Recipients - Updated to use Adinoheightschool branding
        $mail->setFrom('attendance@adinoheightschool.com', 'Adinoheightschool Attendance System');
        $mail->addAddress($admin_email);
        if (!empty($teacher_email)) {
            $mail->addAddress($teacher_email);
        }
        $mail->addReplyTo('noreply@adinoheightschool.com', 'Adinoheightschool No Reply');

        // Content - Updated with school branding and enhanced details
        $mail->isHTML(true);
        $mail->Subject = "Adinoheightschool Teacher Attendance - $teacher_name - $attendance_date";
        $mail->Body = "
        <html>
        <head>
            <title>Adinoheightschool Teacher Attendance Notification</title>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                .header { background-color: #3b82f6; color: white; padding: 20px; text-align: center; }
                .content { padding: 20px; }
                .footer { background-color: #f3f4f6; padding: 15px; text-align: center; font-size: 12px; }
                .school-name { font-weight: bold; color: #1e40af; }
                .status-badge { padding: 4px 8px; border-radius: 4px; display: inline-block; }
            </style>
        </head>
        <body>
            <div class='header'>
                <h2>Adinoheightschool Teacher Attendance System</h2>
            </div>
            <div class='content'>
                <h3>Teacher Attendance Recorded Successfully</h3>
                <p><strong>Teacher:</strong> $teacher_name</p>
                <p><strong>Date:</strong> $attendance_date</p>
                <p><strong>Time:</strong> $time</p>
                <p><strong>Status:</strong> <span class='status-badge' style='background-color: " . 
                    ($status == 'present' ? '#d1fae5' : ($status == 'late' ? '#fef3c7' : '#fee2e2')) . 
                    "; color: " . ($status == 'present' ? '#065f46' : ($status == 'late' ? '#92400e' : '#b91c1c')) . 
                    ";'>" . ucfirst($status) . "</span></p>
            </div>
            <div class='footer'>
                <p>This is an automated notification from <span class='school-name'>Adinoheightschool</span></p>
                <p>Please do not reply to this email</p>
            </div>
        </body>
        </html>";
        
        return $mail->send();
    } catch (Exception $e) {
        error_log("Mailer Error: {$mail->ErrorInfo}");
        return false;
    }
}

// Handle AJAX request
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['teacher_id']) && isset($_POST['attendance_date'])) {
    header('Content-Type: application/json');
    
    $teacher_id = mysqli_real_escape_string($conn, $_POST['teacher_id']);
    $attendance_date = mysqli_real_escape_string($conn, $_POST['attendance_date']);
    $response = ['success' => false, 'message' => ''];
    
    // Validate date (cannot be in the future)
    if (strtotime($attendance_date) > strtotime(date('Y-m-d'))) {
        $response['message'] = "Cannot record attendance for future dates";
        echo json_encode($response);
        exit;
    }
    
    // Check if teacher exists and is active
    $teacher_query = "SELECT id, teacher_id, full_name, email 
                      FROM users 
                      WHERE teacher_id = '$teacher_id' AND role='teacher' AND status='active' 
                      LIMIT 1";
    $teacher_result = mysqli_query($conn, $teacher_query);
    
    if (mysqli_num_rows($teacher_result) === 0) {
        $response['message'] = "No active teacher found with this ID";
        echo json_encode($response);
        exit;
    }
    
    $teacher = mysqli_fetch_assoc($teacher_result);
    $teacher_db_id = $teacher['id'];
    
    // Check if attendance already recorded for this date
    $check_query = "SELECT id FROM teacher_attendance 
                    WHERE teacher_id = $teacher_db_id 
                    AND attendance_date = '$attendance_date'";
    $check_result = mysqli_query($conn, $check_query);
    
    if (mysqli_num_rows($check_result) > 0) {
        $response['message'] = "Attendance already recorded for this date";
        echo json_encode($response);
        exit;
    }
    
    // Determine status based on time (late after 8:30 AM)
    $current_time = date('H:i:s');
    $status = 'present';
    if (strtotime($current_time) > strtotime('08:30:00')) {
        $status = 'late';
    }
    
    // Record attendance
    $insert_query = "INSERT INTO teacher_attendance 
        (teacher_id, attendance_date, status, recorded_by, recorded_at)
        VALUES ($teacher_db_id, '$attendance_date', '$status', 99, NOW())";
    
    if (mysqli_query($conn, $insert_query)) {
        // Send email notification with enhanced details
        $email_sent = sendEmailNotification(
            $teacher['full_name'], 
            $teacher['email'], 
            $attendance_date, 
            $status, 
            $current_time
        );
        
        $response['success'] = true;
        $response['message'] = "Thank you! Attendance recorded successfully for " . $teacher['full_name'];
        if ($email_sent) {
            $response['message'] .= ". Email notification sent.";
        }
    } else {
        $response['message'] = "Error saving attendance: " . mysqli_error($conn);
    }
    
    echo json_encode($response);
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Adinoheightschool - Teacher Attendance</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
            background-color: #f3f4f6;
        }
        .container {
            max-width: 100%;
            padding: 1rem;
        }
        .card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            padding: 1.5rem;
            margin-bottom: 1rem;
        }
        .btn {
            display: block;
            width: 100%;
            padding: 0.75rem;
            border-radius: 8px;
            font-weight: 600;
            text-align: center;
            border: none;
            cursor: pointer;
            transition: background-color 0.2s;
        }
        .btn-primary {
            background-color: #3b82f6;
            color: white;
        }
        .btn-primary:hover {
            background-color: #2563eb;
        }
        .btn-primary:disabled {
            background-color: #93c5fd;
            cursor: not-allowed;
        }
        .input-field {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #d1d5db;
            border-radius: 8px;
            font-size: 16px;
        }
        .input-field:focus {
            outline: none;
            border-color: #3b82f6;
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.2);
        }
        .alert {
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
            display: none;
        }
        .alert-success {
            background-color: #d1fae5;
            color: #065f46;
            border: 1px solid #a7f3d0;
        }
        .alert-error {
            background-color: #fee2e2;
            color: #b91c1c;
            border: 1px solid #fca5a5;
        }
        .spinner {
            display: inline-block;
            width: 1rem;
            height: 1rem;
            border: 2px solid #ffffff;
            border-radius: 50%;
            border-top-color: transparent;
            animation: spin 1s linear infinite;
        }
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        .school-header {
            background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%);
            color: white;
            padding: 1.5rem;
            border-radius: 12px;
            margin-bottom: 1.5rem;
            text-align: center;
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto py-8">
        <div class="max-w-md mx-auto">
            <!-- School Branding Header -->
            <div class="school-header">
                <h1 class="text-2xl font-bold">Adinoheightschool</h1>
                <p class="text-sm opacity-90">Teacher Attendance System</p>
            </div>

            <div id="alertBox" class="alert" style="display: none;">
                <i class="fas mr-2" id="alertIcon"></i> <span id="alertMessage"></span>
            </div>

            <?php if (isset($token_data) && mysqli_num_rows($token_result) > 0): ?>
                <div class="text-center mb-6">
                    <p class="text-gray-600">Enter your Teacher ID and select date to record attendance</p>
                    <p class="text-sm text-gray-500 mt-1">Academic Year: <?php echo $attendance_year . '-' . ($attendance_year + 1); ?></p>
                    <p class="text-sm text-green-600 font-semibold">QR Code valid until <?php echo date('M j, Y', strtotime($token_data['expiry_time'])); ?></p>
                </div>

                <div class="card">
                    <form id="attendanceForm">
                        <div class="mb-4">
                            <label for="teacher_id" class="block text-sm font-medium text-gray-700 mb-1">Teacher ID</label>
                            <input type="text" id="teacher_id" name="teacher_id" 
                                class="input-field" placeholder="Enter your teacher ID" 
                                required autocomplete="off" autofocus>
                        </div>
                        
                        <div class="mb-4">
                            <label for="attendance_date" class="block text-sm font-medium text-gray-700 mb-1">Select Date</label>
                            <input type="date" id="attendance_date" name="attendance_date" 
                                class="input-field" 
                                value="<?php echo date('Y-m-d'); ?>"
                                max="<?php echo date('Y-m-d'); ?>"
                                required>
                        </div>
                        
                        <button type="submit" id="submitBtn" class="btn btn-primary">
                            <i class="fas fa-check-circle mr-2"></i> Submit Attendance
                        </button>
                    </form>
                </div>
                
                <div class="text-center text-sm text-gray-500 mt-4">
                    <p>QR code valid until <?php echo date('M j, Y', strtotime($token_data['expiry_time'])); ?></p>
                </div>
            <?php else: ?>
                <div class="card text-center">
                    <i class="fas fa-exclamation-triangle text-yellow-500 text-4xl mb-3"></i>
                    <h2 class="text-xl font-semibold text-gray-800">Invalid QR Code</h2>
                    <p class="text-gray-600 mt-2">This QR code is invalid or has expired.</p>
                    <p class="text-sm text-gray-500 mt-4">Please contact Adinoheightschool administration for assistance.</p>
                </div>
            <?php endif; ?>
            
            <div class="text-center mt-8">
                <p class="text-sm text-gray-500">Adinoheightschool © <?php echo date('Y'); ?></p>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('attendanceForm');
            const alertBox = document.getElementById('alertBox');
            const alertIcon = document.getElementById('alertIcon');
            const alertMessage = document.getElementById('alertMessage');
            const submitBtn = document.getElementById('submitBtn');
            const teacherIdInput = document.getElementById('teacher_id');
            
            if (form) {
                form.addEventListener('submit', function(e) {
                    e.preventDefault();
                    
                    // Show loading state
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<span class="spinner mr-2"></span> Processing...';
                    
                    // Get form data
                    const formData = new FormData();
                    formData.append('teacher_id', teacherIdInput.value);
                    formData.append('attendance_date', document.getElementById('attendance_date').value);
                    
                    // Send AJAX request
                    fetch('', {
                        method: 'POST',
                        body: formData
                    })
                    .then(response => response.json())
                    .then(data => {
                        // Show alert
                        if (data.success) {
                            alertBox.className = 'alert alert-success';
                            alertIcon.className = 'fas fa-check-circle';
                        } else {
                            alertBox.className = 'alert alert-error';
                            alertIcon.className = 'fas fa-exclamation-circle';
                        }
                        
                        alertMessage.textContent = data.message;
                        alertBox.style.display = 'block';
                        
                        // Clear form if successful
                        if (data.success) {
                            form.reset();
                            document.getElementById('attendance_date').value = '<?php echo date('Y-m-d'); ?>';
                        }
                    })
                    .catch(error => {
                        alertBox.className = 'alert alert-error';
                        alertIcon.className = 'fas fa-exclamation-circle';
                        alertMessage.textContent = 'An error occurred. Please try again.';
                        alertBox.style.display = 'block';
                    })
                    .finally(() => {
                        // Reset button state
                        submitBtn.disabled = false;
                        submitBtn.innerHTML = '<i class="fas fa-check-circle mr-2"></i> Submit Attendance';
                        
                        // Hide alert after 5 seconds
                        setTimeout(() => {
                            alertBox.style.display = 'none';
                        }, 5000);
                    });
                });
            }
            
            // Focus on input field when page loads
            if (teacherIdInput) {
                teacherIdInput.focus();
            }
        });
    </script>
</body>
</html>
<?php
mysqli_close($conn);
?>