// =============================
// Mobile menu functionality
// =============================
const mobileMenuButton = document.querySelector('.mobile-menu-button');
const mobileMenu = document.querySelector('.mobile-menu');

// Toggle main mobile menu
mobileMenuButton.addEventListener('click', () => {
    mobileMenu.classList.toggle('open');
});

// Handle all dropdown buttons inside mobile menu
document.querySelectorAll('.frequents-mobile-button').forEach((button) => {
    button.addEventListener('click', () => {
        const dropdown = button.nextElementSibling; // The <div> right after the button
        dropdown.classList.toggle('open');

        // Rotate the arrow icon
        const icon = button.querySelector('svg');
        icon.classList.toggle('rotate-180');
    });
});

// Sticky header effect on scroll
const stickyHeader = document.querySelector('.sticky-header');
window.addEventListener('scroll', () => {
    if (window.scrollY > 50) {
        stickyHeader.classList.add('scrolled');
    } else {
        stickyHeader.classList.remove('scrolled');
    }
});

// Close mobile menu when clicking outside
document.addEventListener('click', (e) => {
    if (!e.target.closest('.mobile-menu') && 
        !e.target.closest('.mobile-menu-button') && 
        mobileMenu.classList.contains('open')) {
        mobileMenu.classList.remove('open');

        // Close all dropdowns when menu closes
        document.querySelectorAll('.mobile-dropdown-menu').forEach(menu => {
            menu.classList.remove('open');
        });
        document.querySelectorAll('.frequents-mobile-button svg').forEach(icon => {
            icon.classList.remove('rotate-180');
        });
    }
});

// =============================
// Carousel functionality
// =============================
document.addEventListener('DOMContentLoaded', function() {
    const carouselItems = document.querySelectorAll('.carousel-item');
    const indicators = document.querySelectorAll('.carousel-indicator');
    const prevButton = document.querySelector('.carousel-control.prev');
    const nextButton = document.querySelector('.carousel-control.next');
    const progressBar = document.querySelector('.carousel-progress-bar');
    let currentIndex = 0;
    let interval;
    let progressInterval;
    let progressWidth = 0;

    // Function to show a specific slide
    function showSlide(index) {
        carouselItems.forEach(item => item.classList.remove('active'));
        indicators.forEach(indicator => indicator.classList.remove('active'));

        carouselItems[index].classList.add('active');
        indicators[index].classList.add('active');
        currentIndex = index;
        resetProgress();
    }

    // Next & Previous slides
    function nextSlide() {
        let nextIndex = (currentIndex + 1) % carouselItems.length;
        showSlide(nextIndex);
    }
    function prevSlide() {
        let prevIndex = (currentIndex - 1 + carouselItems.length) % carouselItems.length;
        showSlide(prevIndex);
    }

    // Progress bar handling
    function resetProgress() {
        progressWidth = 0;
        progressBar.style.width = '0%';
        clearInterval(progressInterval);
        startProgress();
    }
    function startProgress() {
        progressInterval = setInterval(() => {
            progressWidth += 0.5;
            progressBar.style.width = progressWidth + '%';

            if (progressWidth >= 100) {
                clearInterval(progressInterval);
                nextSlide();
            }
        }, 50);
    }

    // Auto sliding
    function startCarousel() {
        interval = setInterval(nextSlide, 5000);
        startProgress();
    }
    function stopCarousel() {
        clearInterval(interval);
        clearInterval(progressInterval);
    }

    // Event listeners
    nextButton.addEventListener('click', () => {
        stopCarousel();
        nextSlide();
        startCarousel();
    });
    prevButton.addEventListener('click', () => {
        stopCarousel();
        prevSlide();
        startCarousel();
    });
    indicators.forEach((indicator, index) => {
        indicator.addEventListener('click', () => {
            stopCarousel();
            showSlide(index);
            startCarousel();
        });
    });

    const carousel = document.querySelector('.carousel');
    carousel.addEventListener('mouseenter', stopCarousel);
    carousel.addEventListener('mouseleave', startCarousel);

    // Start carousel on page load
    startCarousel();
});
