<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Adinoheight College - Raising Godly Leaders Through Quality Education</title>
    <meta name="description" content="Adinoheight College offers exceptional education from Early Years to College. We nurture godly leaders through our play-based, rigorous curriculum and character development programs.">
    <meta name="keywords" content="Adinoheight College, Christian school, quality education, Early Years, Primary school, Secondary school, College preparation, godly leaders, Nigeria school">
    <meta name="author" content="Adinoheight College">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="https://www.adinoheightcollege.com">
    
    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="Adinoheight College - Raising Godly Leaders">
    <meta property="og:description" content="Quality education from Early Years to College with a focus on character development and academic excellence.">
    <meta property="og:url" content="https://www.adinoheightcollege.com">
    <meta property="og:type" content="website">
    <meta property="og:image" content="https://www.adinoheightcollege.com/img/og-image.jpg">
    <!-- Font Awesome CDN -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Adinoheight College - Raising Role Model">
    <meta name="twitter:description" content="Quality education from Early Years to College with a focus on character development and academic excellence.">
    <meta name="twitter:image" content="https://www.adinoheightcollege.com/img/twitter-image.jpg">
    <link rel="manifest" href="/manifest.json">
<meta name="theme-color" content="#1d4ed8">

<!-- iOS Support -->
<link rel="apple-touch-icon" href="img/logotwo.png">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
<meta name="apple-mobile-web-app-title" content="Adinoheight College">
    
    <!-- Structured Data -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "EducationalOrganization",
      "name": "Adinoheight College",
      "description": "Adinoheight College offers exceptional education from Early Years to College, focusing on raising godly leaders.",
      "url": "https://www.adinoheightcollege.com",
      "logo": "https://www.adinoheightcollege.com/img/logotwo.png",
      "telephone": "+234-805-625-5718",
      "address": {
        "@type": "PostalAddress",
        "streetAddress": "",
        "addressLocality": "",
        "addressCountry": "Nigeria"
      },
      "sameAs": [
        "https://www.facebook.com/adinoheightcollege",
        "https://www.instagram.com/adinoheightcollege",
        "https://twitter.com/adinoheightcollege",
        "https://www.youtube.com/channel/adinoheightcollege"
      ]
    }
    </script>
    <style> 
   .carousel {
    position: relative;
    width: 100%;
    height: 500px!important;
    overflow: hidden;
}

          .mission-vision-section {
            padding: 20px 6%;
           
        }
        
     .section-title {
            font-size: 2rem;
            color: #555;
            margin-bottom: 15px;
            font-weight: 500;
        }
        
        .section-subtitle {
            font-size: 1.2rem;
            color: #1d4ed8;
            font-weight: 500;
        }
        
        .mission-vision-content {
            display: flex;
            flex-direction: column;
            gap: 60px;
        }
        
        .mission-card, .vision-card {
            display: flex;
            flex-wrap: wrap;
         
        }
        
        .mission-image, .vision-image {
            flex: 1;
            min-width: 300px;
            height: 400px;
            overflow: hidden;
        }
        
        .mission-image img, .vision-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.5s ease;
        }
        
        .mission-image:hover img, .vision-image:hover img {
            transform: scale(1.03);
        }
        
        .mission-content, .vision-content {
            flex: 1;
            min-width: 300px;
            padding: 40px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }
        
        .mission-content h3, .vision-content h3 {
            font-size: 1.2em!important;
            color: #555;
            margin-bottom: 15px;
            font-weight: 600;
        }
        
        .mission-content h4, .vision-content h4 {
            font-size: 1rem!important;
            color: #555;
            margin-bottom: 20px;
            font-weight: 500;
        }
        
        .mission-content p, .vision-content p {
            color: #4b5563;
            line-height: 1.8;
            margin-bottom: 25px;
        }
        
        .read-more-btn {
            display: inline-flex;
            align-items: center;
            color: #1d4ed8;
            font-weight: 500;
            text-decoration: none;
            transition: all 0.3s ease;
        }
        
        .read-more-btn:hover {
            color: #1e3a8a;
            transform: translateX(5px);
        }
        
        @media (max-width: 768px) {
            .section-title {
            font-size: 1.5rem!important;
            color: #555;
            margin-bottom: 15px;
            font-weight: 500;
        }
           .carousel {
    position: relative;
    width: 100%;
    height: 300px!important;
    overflow: hidden;
}

         .section-subtitle {
            font-size: 1.1rem!important;
            color: #1d4ed8;
            font-weight: 500;
        }
            .mission-card, .vision-card {
                flex-direction: column;
            }
            
            .mission-image, .vision-image {
                height: 300px;
            }
            
            .mission-content, .vision-content {
                padding: 30px 20px;
            }
        }</style>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Merriweather:wght@300;400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="css/styles.css">
    <!-- Favicon -->
<link rel="icon" type="image/png" href="img/logotwo.png">

</head>
<body>
        <!-- Announcement bar -->
    <div class="announcement-bar">
        <div class="container mx-auto px-4 py-2 header-top flex justify-between items-center">
            <div class="news-ticker">
                <div class="news-text">
                    <span class="bg-primary-600 px-3 py-1  mr-4 font-bold text-xs"  style="color:white; cursor: pointer;">LATEST NEWS:</span>
                    <span  style="color:white; cursor: pointer;">Adinoheight College – Admissions Still Open! Limited spaces available for the 2024/2025 academic session.</span>
                </div>
            </div>
            <a href="#" class="portal-link text-white hover:text-primary-200 font-medium flex items-center text-sm transition-colors duration-200">
                <span><a href="portal_login" style="color:white; cursor: pointer;">Portal Login</a></span>
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round"  style="color:white; cursor: pointer;"stroke-width="2" d="M9 5l7 7-7 7" />
                </svg>
            </a>
        </div>
    </div>
 
    <header class="sticky-header">
        <!-- Main navigation -->
        <div class=s>
            <div class="container mx-auto px-4 py-3">
                <!-- Logo and contact info -->
                <div class="flex flex-col md:flex-row justify-between items-center mb-4">
                    <div class="logo-container mb-4 md:mb-0">
                        <div class="logo mr-3">
                            <img src="img/logotwo.png" alt="Adinoheight College Logo">
                        </div>
                        <div class="school-name">
                            <h1 class="text-2xl md:text-3xl">Adinoheight College</h1>
                            <p class="school-tagline">Raising Role Model</p>
                        </div>
                    </div>
                    
                    <div class="flex items-center">
                        <div class="contact-info mr-4">
                            <div class="contact-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                </svg>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500">Call Us:</p>
                                <p class="text-primary-700 font-bold">08056255718</p>
                            </div>
                        </div>
                        
                        <!-- Mobile menu button -->
                        <button class="mobile-menu-button md:hidden">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16m-7 6h7" />
                            </svg>
                        </button>
                    </div>
                </div>
                
                <!-- Navigation menu -->
                <nav class="nav-menu hidden md:flex justify-between items-center">
                    <div class="flex space-x-1">
                        <a href="index" class="nav-link">Home</a>
                        <a href="about" class="nav-link">About</a>
                        
                        <!-- Frequents dropdown -->
                        <div class="dropdown-group">
                            <button class="nav-link flex items-center">
                                <span>Frequents</span>
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1 transition-transform duration-200" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                                </svg>
                            </button>
                            <div class="dropdown-menu">
                                <a href="gallery" class="dropdown-item">Gallery</a>
                                <a href="event" class="dropdown-item">Events</a>
                                <a href="director" class="dropdown-item">Director speech</a>
                            
                            </div>
                        </div>
                        <div class="dropdown-group">
                            <button class="nav-link flex items-center">
                                <span>Academic</span>
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1 transition-transform duration-200" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                                </svg>
                            </button>
                            <div class="dropdown-menu">
                               
                             <a href="admission" class="dropdown-item">Admission Process</a>
        <a href="creche" class="dropdown-item">Creche</a>
        <a href="primary" class="dropdown-item">Primary</a>
                <a href="secondary" class="dropdown-item">Secondary</a>
        <a href="college" class="dropdown-item">College</a>

                            </div>
                        </div>
                        
                        <a href="contact" class="nav-link">Contact</a>
                        <a href="portal_login" class="nav-link">Portal</a>
                    </div>
                    
                    <!-- Social icons -->
                    <div class="social-icons space-x-2">
                        <a href="#" class="social-icon">
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a href="#" class="social-icon">
                            <i class="fab fa-twitter"></i>
                        </a>
                        <a href="#" class="social-icon">
                            <i class="fab fa-instagram"></i>
                        </a>
                        <a href="#" class="social-icon">
                            <i class="fab fa-linkedin-in"></i>
                        </a>
                        <a href="#" class="social-icon">
                            <i class="fab fa-youtube"></i>
                        </a>
                    </div>
                </nav>
                
                <!-- Mobile menu (hidden by default) -->
                <div class="mobile-menu md:hidden">
                    <div class="py-3">
                        <a href="index" class="mobile-nav-link">Home</a>
                        <a href="about" class="mobile-nav-link">About</a>
                        
                        <!-- Frequents dropdown for mobile -->
                      <!-- Frequents dropdown for mobile -->
<div class="border-b border-gray-100">
    <button class="mobile-nav-link w-full text-left flex justify-between items-center frequents-mobile-button">
        <span>Frequents</span>
        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 transition-transform duration-300" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
        </svg>
    </button>
    <div class="mobile-dropdown-menu">
        <a href="gallery" class="dropdown-item">Gallery</a>
        <a href="event" class="dropdown-item">Events</a>
        <a href="director" class="dropdown-item">Director speech</a>
       
    </div>
</div>

<!-- Academic dropdown for mobile -->
<div class="border-b border-gray-100">
    <button class="mobile-nav-link w-full text-left flex justify-between items-center frequents-mobile-button">
        <span>Academic</span>
        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 transition-transform duration-300" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
        </svg>
    </button>
    <div class="mobile-dropdown-menu">
        <a href="admission" class="dropdown-item">Admission Process</a>
        <a href="creche" class="dropdown-item">Creche</a>
        <a href="primary" class="dropdown-item">Primary</a>
                <a href="secondary" class="dropdown-item">Secondary</a>
        <a href="college" class="dropdown-item">College</a>
    </div>
</div>

                        
                        <a href="contact" class="mobile-nav-link">Contact</a>
                        <a href="portal_login" class="mobile-nav-link">Portal</a>
                        <!-- Social icons for mobile -->
                        <div class="flex space-x-3 py-6 justify-center">
                            <a href="#" class="social-icon">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                            <a href="#" class="social-icon">
                                <i class="fab fa-twitter"></i>
                            </a>
                            <a href="#" class="social-icon">
                                <i class="fab fa-instagram"></i>
                            </a>
                            <a href="#" class="social-icon">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                            <a href="#" class="social-icon">
                                <i class="fab fa-youtube"></i>
                            </a>
                        </div>
                        
                        <!-- Contact info for mobile -->
                        <div class="text-center py-4 border-t border-gray-100">
                            <p class="text-xs text-gray-500">Call Us:</p>
                            <p class="text-primary-700 font-bold">08056255718</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <button id="installBtn" style="
    display:none;
    background:#1d4ed8;
    color:white;
    padding:10px 18px;
    border:none;
    border-radius:8px;
    cursor:pointer;
    font-weight:600;
">
    📲 Install Adinoheight App
</button>

<script>
let deferredPrompt;
const installBtn = document.getElementById("installBtn");

window.addEventListener("beforeinstallprompt", (e) => {
  e.preventDefault();
  deferredPrompt = e;
  installBtn.style.display = "inline-block"; // Show button
});

installBtn.addEventListener("click", () => {
  installBtn.style.display = "none"; // Hide button after click
  deferredPrompt.prompt();
  deferredPrompt.userChoice.then((choice) => {
    if (choice.outcome === "accepted") {
      console.log("✅ User installed the app");
    } else {
      console.log("❌ User dismissed the install prompt");
    }
    deferredPrompt = null;
  });
});
</script>

