<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

if (!isset($user_id)) {
    require_once 'auth_check.php';
}
// Initialize variables
$class_id = isset($_GET['class_id']) ? intval($_GET['class_id']) : 0;
$section_id = isset($_GET['section_id']) ? intval($_GET['section_id']) : 0;
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : '';
$end_date = isset($_GET['end_date']) ? $_GET['end_date'] : '';
$success = '';
$error = '';

// Fetch all classes
$classes_query = "SELECT id, class_name FROM classes WHERE status = 'active' ORDER BY class_name";
$classes_result = mysqli_query($conn, $classes_query);

// Fetch sections based on selected class
$sections = [];
if ($class_id > 0) {
    $sections_query = "SELECT id, section_name FROM sections WHERE class_id = $class_id AND status = 'active' ORDER BY section_name";
    $sections_result = mysqli_query($conn, $sections_query);
    while ($section = mysqli_fetch_assoc($sections_result)) {
        $sections[] = $section;
    }
}

// Fetch invoices based on selected class, section, and date range
$invoices = [];
if ($class_id > 0 && $section_id > 0) {
    // Build the base query
    $invoices_query = "SELECT i.*, s.full_name, s.student_id, s.roll_number, 
                      (SELECT COALESCE(SUM(amount), 0) FROM payments p WHERE p.invoice_id = i.id) as paid_amount
                      FROM invoices i
                      JOIN students s ON i.student_id = s.id
                      WHERE s.class = $class_id AND s.section = $section_id";
    
    // Add date filter if provided
    if (!empty($start_date) && !empty($end_date)) {
        $start_date_formatted = date('Y-m-d', strtotime($start_date));
        $end_date_formatted = date('Y-m-d', strtotime($end_date));
        $invoices_query .= " AND DATE(i.created_at) BETWEEN '$start_date_formatted' AND '$end_date_formatted'";
    }
    
    $invoices_query .= " ORDER BY i.created_at DESC";
    
    $invoices_result = mysqli_query($conn, $invoices_query);
    while ($invoice = mysqli_fetch_assoc($invoices_result)) {
        $invoices[] = $invoice;
    }
}

// Handle payment recording
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['record_payment'])) {
    $invoice_id = intval($_POST['invoice_id']);
    $amount = floatval($_POST['amount']);
    $payment_method = mysqli_real_escape_string($conn, $_POST['payment_method']);
    $transaction_id = mysqli_real_escape_string($conn, $_POST['transaction_id']);
    
    // Validate inputs
    if ($amount <= 0 || empty($payment_method)) {
        $error = "Please fill all required fields with valid values.";
    } else {
        // First, get the student_id from the invoice
        $student_query = "SELECT student_id FROM invoices WHERE id = $invoice_id";
        $student_result = mysqli_query($conn, $student_query);
        
        if ($student_result && mysqli_num_rows($student_result) > 0) {
            $student_data = mysqli_fetch_assoc($student_result);
            $student_id = $student_data['student_id'];
            $recorded_by = $_SESSION['user_id']; // Assuming you have user_id in session
            
            // Debug: Check if we have the student_id
            if (empty($student_id)) {
                $error = "Error: Student ID is missing from the invoice.";
            } else {
                // Now insert with student_id included
                $insert_query = "INSERT INTO payments (invoice_id, student_id, amount, payment_method, transaction_id, recorded_by, payment_date) 
                               VALUES ($invoice_id, $student_id, $amount, '$payment_method', '$transaction_id', $recorded_by, NOW())";
                
                if (mysqli_query($conn, $insert_query)) {
                    // Update invoice status if fully paid
                    $check_paid_query = "SELECT amount, 
                                        (SELECT COALESCE(SUM(amount), 0) FROM payments WHERE invoice_id = $invoice_id) as total_paid
                                        FROM invoices WHERE id = $invoice_id";
                    $paid_result = mysqli_query($conn, $check_paid_query);
                    
                    if ($paid_result && mysqli_num_rows($paid_result) > 0) {
                        $paid_data = mysqli_fetch_assoc($paid_result);
                        
                        if ($paid_data['total_paid'] >= $paid_data['amount']) {
                            $update_query = "UPDATE invoices SET status = 'paid' WHERE id = $invoice_id";
                            mysqli_query($conn, $update_query);
                        }
                        
                        $success = "Payment recorded successfully!";
                    } else {
                        $error = "Error checking payment status: " . mysqli_error($conn);
                    }
                } else {
                    $error = "Error recording payment: " . mysqli_error($conn);
                }
            }
        } else {
            $error = "Error: Could not find invoice or student information.";
        }
    }
}

// Get class and section names for display
$class_name = '';
$section_name = '';
if ($class_id > 0) {
    $class_name_query = "SELECT class_name FROM classes WHERE id = $class_id";
    $class_name_result = mysqli_query($conn, $class_name_query);
    if ($class_name_result && mysqli_num_rows($class_name_result) > 0) {
        $class_name = mysqli_fetch_assoc($class_name_result)['class_name'];
    }
}

if ($section_id > 0) {
    $section_name_query = "SELECT section_name FROM sections WHERE id = $section_id";
    $section_name_result = mysqli_query($conn, $section_name_query);
    if ($section_name_result && mysqli_num_rows($section_name_result) > 0) {
        $section_name = mysqli_fetch_assoc($section_name_result)['section_name'];
    }
}

ob_end_flush();
?>

<div class="bg-white p-6 rounded-lg ">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">View Invoices</h2>
        <a href="payment.php" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg flex items-center">
            <i class="fas fa-plus mr-2"></i> Create New Invoices
        </a>
    </div>

    <?php if (!empty($success)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo $success; ?>
        </div>
    <?php endif; ?>
    
    <?php if (!empty($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <?php echo $error; ?>
        </div>
    <?php endif; ?>

    <!-- Filter Section -->
    <div class="mb-6 bg-gray-50 p-4 rounded-lg">
        <form method="GET" action="" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <!-- Class Filter -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Select Class</label>
                <select name="class_id" id="class_filter" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    <option value="">Select Class</option>
                    <?php 
                    mysqli_data_seek($classes_result, 0);
                    while ($class = mysqli_fetch_assoc($classes_result)): 
                    ?>
                        <option value="<?php echo $class['id']; ?>" <?php echo ($class_id == $class['id']) ? 'selected' : ''; ?>>
                            <?php echo $class['class_name']; ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            
            <!-- Section Filter -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Select Section</label>
                <select name="section_id" id="section_filter" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" <?php echo ($class_id == 0) ? 'disabled' : ''; ?> required>
                    <option value="">Select Section</option>
                    <?php foreach ($sections as $section): ?>
                        <option value="<?php echo $section['id']; ?>" <?php echo ($section_id == $section['id']) ? 'selected' : ''; ?>>
                            <?php echo $section['section_name']; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <!-- Start Date Filter -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Start Date</label>
                <input type="date" name="start_date" value="<?php echo $start_date; ?>" 
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <!-- End Date Filter -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">End Date</label>
                <input type="date" name="end_date" value="<?php echo $end_date; ?>" 
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <!-- Buttons -->
            <div class="flex items-end space-x-2 col-span-4">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg flex items-center h-10">
                    <i class="fas fa-filter mr-2"></i> Load Invoices
                </button>
                <a href="view_invoices.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg flex items-center h-10">
                    <i class="fas fa-times mr-2"></i> Clear
                </a>
            </div>
        </form>
    </div>

    <?php if ($class_id > 0 && $section_id > 0): ?>
        <?php if (!empty($invoices)): ?>
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white">
                    <thead class="bg-gray-200 text-gray-700">
                        <tr>
                            <th class="py-3 px-4 text-left">Student ID</th>
                            <th class="py-3 px-4 text-left">Student Name</th>
                            <th class="py-3 px-4 text-left">Description</th>
                            <th class="py-3 px-4 text-left">Amount</th>
                            <th class="py-3 px-4 text-left">Paid</th>
                            <th class="py-3 px-4 text-left">Balance</th>
                            <th class="py-3 px-4 text-left">Due Date</th>
                            <th class="py-3 px-4 text-left">Created Date</th>
                            <th class="py-3 px-4 text-left">Status</th>
                            <th class="py-3 px-4 text-left">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="text-gray-600">
                        <?php foreach ($invoices as $invoice): 
                            $balance = $invoice['amount'] - $invoice['paid_amount'];
                            $status = $balance <= 0 ? 'Paid' : ($invoice['paid_amount'] > 0 ? 'Partial' : 'Unpaid');
                            $status_class = $status == 'Paid' ? 'bg-green-100 text-green-800' : 
                                          ($status == 'Partial' ? 'bg-yellow-100 text-yellow-800' : 'bg-red-100 text-red-800');
                        ?>
                            <tr class="border-b border-gray-200 hover:bg-gray-50">
                                <td class="py-3 px-4"><?php echo $invoice['student_id']; ?></td>
                                <td class="py-3 px-4"><?php echo $invoice['full_name']; ?></td>
                                <td class="py-3 px-4"><?php echo $invoice['description']; ?></td>
                                <td class="py-3 px-4">₦<?php echo number_format($invoice['amount'], 2); ?></td>
                                <td class="py-3 px-4">₦<?php echo number_format($invoice['paid_amount'], 2); ?></td>
                                <td class="py-3 px-4">₦<?php echo number_format($balance, 2); ?></td>
                                <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($invoice['due_date'])); ?></td>
                                <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($invoice['created_at'])); ?></td>
                                <td class="py-3 px-4">
                                    <span class="px-2 py-1 rounded-full text-xs <?php echo $status_class; ?>">
                                        <?php echo $status; ?>
                                    </span>
                                </td>
                                <td class="py-3 px-4">
                                    <?php if ($balance > 0): ?>
                                        <button onclick="openPaymentModal(<?php echo $invoice['id']; ?>, <?php echo $balance; ?>)" 
                                                class="bg-green-600 hover:bg-green-700 text-white px-3 py-1 rounded text-sm flex items-center mr-2">
                                            <i class="fas fa-money-bill-wave mr-1"></i> Record Payment
                                        </button>
                                        <button onclick="initiatePaystackPayment(<?php echo $invoice['id']; ?>, <?php echo $balance; ?>, '<?php echo $invoice['email'] ?? 'admin@school.com'; ?>')" 
                                                class="bg-blue-600 hover:bg-blue-700 text-white px-3 py-1 rounded text-sm flex items-center">
                                            <i class="fas fa-credit-card mr-1"></i> Pay with Paystack
                                        </button>
                                    <?php else: ?>
                                        <span class="text-green-600">Paid in Full</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p class="text-center py-4 text-gray-500">
                No invoices found for <?php echo $class_name . " - " . $section_name; ?> 
                <?php if (!empty($start_date) && !empty($end_date)): ?>
                    between <?php echo date('M j, Y', strtotime($start_date)); ?> and <?php echo date('M j, Y', strtotime($end_date)); ?>
                <?php endif; ?>.
            </p>
        <?php endif; ?>
    <?php else: ?>
        <div class="bg-white p-8 rounded-lg  text-center">
            <i class="fas fa-file-invoice-dollar text-4xl text-gray-300 mb-4"></i>
            <h3 class="text-lg font-medium text-gray-600">Please select a class and section to view invoices</h3>
        </div>
    <?php endif; ?>
</div>

<!-- Payment Modal -->
<div id="paymentModal" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white p-6 rounded-lg -lg w-full max-w-md">
        <h3 class="text-xl font-semibold text-gray-800 mb-4">Record Payment</h3>
        <form method="POST" action="">
            <input type="hidden" id="invoice_id" name="invoice_id" value="">
            
            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 mb-1">Amount to Pay (₦)</label>
                <input type="number" step="0.01" min="0" id="payment_amount" name="amount" 
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 mb-1">Payment Method</label>
                <select name="payment_method" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    <option value="">Select Method</option>
                    <option value="cash">Cash</option>
                    <option value="bank_transfer">Bank Transfer</option>
                    <option value="card">Card</option>
                    <option value="mobile_money">Mobile Money</option>
                </select>
            </div>
            
            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 mb-1">Transaction ID (Optional)</label>
                <input type="text" name="transaction_id" 
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <div class="flex justify-end space-x-3">
                <button type="button" onclick="closePaymentModal()" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
                    Cancel
                </button>
                <button type="submit" name="record_payment" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg">
                    Record Payment
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// JavaScript to handle dynamic section loading based on class selection
document.getElementById('class_filter').addEventListener('change', function() {
    const classId = this.value;
    const sectionSelect = document.getElementById('section_filter');
    
    if (classId) {
        // Enable section dropdown
        sectionSelect.disabled = false;
        
        // Fetch sections for the selected class via AJAX
        fetch('get_sectionss.php?class_id=' + classId)
            .then(response => response.json())
            .then(sections => {
                // Clear existing options except the first one
                while (sectionSelect.options.length > 1) {
                    sectionSelect.remove(1);
                }
                
                // Add new options
                sections.forEach(section => {
                    const option = document.createElement('option');
                    option.value = section.id;
                    option.textContent = section.section_name;
                    sectionSelect.appendChild(option);
                });
            })
            .catch(error => console.error('Error fetching sections:', error));
    } else {
        // Disable and clear section dropdown if no class is selected
        sectionSelect.disabled = true;
        while (sectionSelect.options.length > 1) {
            sectionSelect.remove(1);
        }
    }
});

// Payment modal functions
function openPaymentModal(invoiceId, maxAmount) {
    document.getElementById('invoice_id').value = invoiceId;
    document.getElementById('payment_amount').value = maxAmount;
    document.getElementById('payment_amount').max = maxAmount;
    document.getElementById('paymentModal').classList.remove('hidden');
}

function closePaymentModal() {
    document.getElementById('paymentModal').classList.add('hidden');
}

function initiatePaystackPayment(invoiceId, amount, email) {
    // Convert amount to kobo (Paystack requires amount in kobo)
    const amountInKobo = amount * 100;
    
    // Create a form to submit to paystack_redirect.php
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = 'paystack_redirect.php';
    
    const invoiceInput = document.createElement('input');
    invoiceInput.type = 'hidden';
    invoiceInput.name = 'invoice_id';
    invoiceInput.value = invoiceId;
    
    const amountInput = document.createElement('input');
    amountInput.type = 'hidden';
    amountInput.name = 'amount';
    amountInput.value = amountInKobo;
    
    const emailInput = document.createElement('input');
    emailInput.type = 'hidden';
    emailInput.name = 'email';
    emailInput.value = email || 'admin@school.com'; // Default email if not available
    
    form.appendChild(invoiceInput);
    form.appendChild(amountInput);
    form.appendChild(emailInput);
    
    document.body.appendChild(form);
    form.submit();
}
</script>

<?php
include 'include/footer.php';
?>