<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Fetch all classes for the filter dropdown
$classes_query = "SELECT id, class_name FROM classes WHERE status = 'active' ORDER BY class_name";
$classes_result = mysqli_query($conn, $classes_query);

// Fetch sections based on selected class
$sections = [];
if (isset($_GET['class_filter']) && !empty($_GET['class_filter'])) {
    $class_id = mysqli_real_escape_string($conn, $_GET['class_filter']);
    $sections_query = "SELECT id, section_name FROM sections WHERE class_id = $class_id AND status = 'active' ORDER BY section_name";
    $sections_result = mysqli_query($conn, $sections_query);
    while ($section = mysqli_fetch_assoc($sections_result)) {
        $sections[] = $section;
    }
}

// Handle delete operation
if (isset($_GET['delete_id'])) {
    $delete_id = mysqli_real_escape_string($conn, $_GET['delete_id']);
    
    // Get student data to delete the photo file
    $query = "SELECT photo FROM students WHERE id = $delete_id";
    $result = mysqli_query($conn, $query);
    $student = mysqli_fetch_assoc($result);
    
    if ($student['photo'] && file_exists($student['photo'])) {
        unlink($student['photo']);
    }
    
    // Delete student record
    $query = "DELETE FROM students WHERE id = $delete_id";
    if (mysqli_query($conn, $query)) {
        $_SESSION['message'] = "Student deleted successfully";
        $_SESSION['message_type'] = "success";
    } else {
        $_SESSION['message'] = "Error deleting student: " . mysqli_error($conn);
        $_SESSION['message_type'] = "error";
    }
    
    // Preserve filter parameters in redirect
    $filter_params = '';
    if (isset($_GET['class_filter']) && !empty($_GET['class_filter'])) {
        $filter_params .= '&class_filter=' . $_GET['class_filter'];
    }
    if (isset($_GET['section_filter']) && !empty($_GET['section_filter'])) {
        $filter_params .= '&section_filter=' . $_GET['section_filter'];
    }
    
    header('Location: student_table.php?' . ltrim($filter_params, '&'));
    exit();
}

// Handle Excel export
if (isset($_GET['export_excel'])) {
    // Build query with filters if applied
    $export_query = "SELECT s.*, c.class_name, sec.section_name 
              FROM students s 
              LEFT JOIN classes c ON s.class = c.id 
              LEFT JOIN sections sec ON s.section = sec.id 
              WHERE 1=1";
    
    if (isset($_GET['class_filter']) && !empty($_GET['class_filter'])) {
        $class_filter = mysqli_real_escape_string($conn, $_GET['class_filter']);
        $export_query .= " AND s.class = '$class_filter'";
    }
    
    if (isset($_GET['section_filter']) && !empty($_GET['section_filter'])) {
        $section_filter = mysqli_real_escape_string($conn, $_GET['section_filter']);
        $export_query .= " AND s.section = '$section_filter'";
    }
    
    if (!empty($search)) {
        $export_query .= " AND (s.full_name LIKE '%$search%' OR s.student_id LIKE '%$search%' OR s.email LIKE '%$search%' OR s.phone LIKE '%$search%' OR c.class_name LIKE '%$search%' OR sec.section_name LIKE '%$search%')";
    }
    
    $export_query .= " ORDER BY s.created_at DESC";
    $result = mysqli_query($conn, $export_query);
    
    // Set headers for Excel file download
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="students_export_' . date('Y-m-d') . '.xls"');
    
    // Start Excel content
    echo "ID\tStudent ID\tFull Name\tClass\tSection\tRoll Number\tEmail\tPhone\tStatus\tCreated At\n";
    
    if (mysqli_num_rows($result) > 0) {
        while ($student = mysqli_fetch_assoc($result)) {
            echo $student['id'] . "\t";
            echo $student['student_id'] . "\t";
            echo $student['full_name'] . "\t";
            echo $student['class_name'] . "\t";
            echo $student['section_name'] . "\t";
            echo $student['roll_number'] . "\t";
            echo $student['email'] . "\t";
            echo $student['phone'] . "\t";
            echo $student['status'] . "\t";
            echo $student['created_at'] . "\n";
        }
    }
    exit();
}

// Initialize search and filter variables
$search = isset($_GET['search']) ? mysqli_real_escape_string($conn, $_GET['search']) : '';
$class_filter = isset($_GET['class_filter']) ? mysqli_real_escape_string($conn, $_GET['class_filter']) : '';
$section_filter = isset($_GET['section_filter']) ? mysqli_real_escape_string($conn, $_GET['section_filter']) : '';
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$per_page = 10; // Number of records per page

// Ensure page is within valid range
if ($page < 1) $page = 1;

// Build the base query with joins to get class and section names
$base_query = "FROM students s 
               LEFT JOIN classes c ON s.class = c.id 
               LEFT JOIN sections sec ON s.section = sec.id 
               WHERE 1=1";
               
if (!empty($search)) {
    $base_query .= " AND (s.full_name LIKE '%$search%' OR s.student_id LIKE '%$search%' OR s.email LIKE '%$search%' OR s.phone LIKE '%$search%' OR c.class_name LIKE '%$search%' OR sec.section_name LIKE '%$search%')";
}

// Add class filter if selected
if (!empty($class_filter)) {
    $base_query .= " AND s.class = '$class_filter'";
}

// Add section filter if selected
if (!empty($section_filter)) {
    $base_query .= " AND s.section = '$section_filter'";
}

// Get total number of records for pagination
$count_query = "SELECT COUNT(*) as total $base_query";
$count_result = mysqli_query($conn, $count_query);
$total_records = mysqli_fetch_assoc($count_result)['total'];
$total_pages = ceil($total_records / $per_page);

// Ensure page is within valid range
if ($page > $total_pages && $total_pages > 0) $page = $total_pages;

// Calculate offset - FIXED: Ensure offset is never negative
$offset = max(0, ($page - 1) * $per_page);

// Build the main query with pagination - selecting class and section names
$query = "SELECT s.*, c.class_name, sec.section_name $base_query ORDER BY s.created_at DESC LIMIT $offset, $per_page";
$result = mysqli_query($conn, $query);
ob_end_flush();
?>

<div class="bg-white p-6  ">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Students List</h2>
        <a href="add_student.php" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2  flex items-center">
            <i class="fas fa-plus mr-2"></i> Add New Student
        </a>
    </div>

    <?php if (isset($_SESSION['message'])): ?>
        <div class="<?php echo $_SESSION['message_type'] == 'success' ? 'bg-green-100 border-green-400 text-green-700' : 'bg-red-100 border-red-400 text-red-700'; ?> border px-4 py-3  mb-4">
            <?php 
            echo $_SESSION['message']; 
            unset($_SESSION['message']);
            unset($_SESSION['message_type']);
            ?>
        </div>
    <?php endif; ?>

    <!-- Filter and Search Section -->
    <div class="mb-6 bg-gray-50 p-4 ">
        <form method="GET" action="" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <!-- Class Filter -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Filter by Class</label>
                <select name="class_filter" id="class_filter" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">All Classes</option>
                    <?php while ($class = mysqli_fetch_assoc($classes_result)): ?>
                        <option value="<?php echo $class['id']; ?>" <?php echo ($class_filter == $class['id']) ? 'selected' : ''; ?>>
                            <?php echo $class['class_name']; ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            
            <!-- Section Filter -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Filter by Section</label>
                <select name="section_filter" id="section_filter" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" <?php echo empty($class_filter) ? 'disabled' : ''; ?>>
                    <option value="">All Sections</option>
                    <?php foreach ($sections as $section): ?>
                        <option value="<?php echo $section['id']; ?>" <?php echo ($section_filter == $section['id']) ? 'selected' : ''; ?>>
                            <?php echo $section['section_name']; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <!-- Search Input -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                <input type="text" name="search" value="<?php echo htmlspecialchars($search); ?>" 
                    placeholder="Search students..." 
                    class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <!-- Buttons -->
            <div class="flex items-end space-x-2">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2  flex items-center h-10">
                    <i class="fas fa-filter mr-2"></i> Apply Filters
                </button>
                <a href="students.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2  flex items-center h-10">
                    <i class="fas fa-times mr-2"></i> Clear
                </a>
            </div>
        </form>
    </div>

    <!-- Search and Export Section -->
    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
        <!-- Results Count -->
        <div class="text-sm text-gray-600">
            <?php if (!empty($search) || !empty($class_filter) || !empty($section_filter)): ?>
                Found <?php echo $total_records; ?> student(s)
                <?php if (!empty($search)): ?> matching "<?php echo htmlspecialchars($search); ?>"<?php endif; ?>
                <?php if (!empty($class_filter)): ?> in selected class<?php endif; ?>
                <?php if (!empty($section_filter)): ?> and section<?php endif; ?>
            <?php else: ?>
                Total <?php echo $total_records; ?> student(s)
            <?php endif; ?>
        </div>
        
  <a href="export_students.php?<?php 
    echo !empty($search) ? 'search=' . urlencode($search) . '&' : ''; 
    echo !empty($class_filter) ? 'class_filter=' . urlencode($class_filter) . '&' : ''; 
    echo !empty($section_filter) ? 'section_filter=' . urlencode($section_filter) : ''; 
?>" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2  flex items-center">
    <i class="fas fa-file-excel mr-2"></i> Export to Excel
</a>

    </div>

    <div class="overflow-x-auto">
        <table class="min-w-full bg-white">
            <thead class="bg-gray-200 text-gray-700">
                <tr>
                    <th class="py-3 px-4 text-left">Student ID</th>
                    <th class="py-3 px-4 text-left">Full Name</th>
                    <th class="py-3 px-4 text-left">Class</th>
                    <th class="py-3 px-4 text-left">Section</th>
                    <th class="py-3 px-4 text-left">Roll No</th>
                    <th class="py-3 px-4 text-left">Email</th>
                    <th class="py-3 px-4 text-left">Phone</th>
                    <th class="py-3 px-4 text-left">Status</th>
                    <th class="py-3 px-4 text-left">Actions</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <?php if (mysqli_num_rows($result) > 0): ?>
                    <?php while ($student = mysqli_fetch_assoc($result)): ?>
                        <tr class="border-b border-gray-200 hover:bg-gray-50">
                            <td class="py-3 px-4"><?php echo $student['student_id']; ?></td>
                            <td class="py-3 px-4"><?php echo $student['full_name']; ?></td>
                            <td class="py-3 px-4"><?php echo $student['class_name']; ?></td>
                            <td class="py-3 px-4"><?php echo $student['section_name']; ?></td>
                            <td class="py-3 px-4"><?php echo $student['roll_number']; ?></td>
                            <td class="py-3 px-4"><?php echo $student['email']; ?></td>
                            <td class="py-3 px-4"><?php echo $student['phone']; ?></td>
                            <td class="py-3 px-4">
                                <?php if ($student['status'] == 'active'): ?>
                                    <span class="bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 ">Active</span>
                                <?php elseif ($student['status'] == 'inactive'): ?>
                                    <span class="bg-red-100 text-red-800 text-xs font-medium px-2.5 py-0.5 ">Inactive</span>
                                <?php elseif ($student['status'] == 'graduated'): ?>
                                    <span class="bg-yellow-100 text-yellow-800 text-xs font-medium px-2.5 py-0.5">Graduated</span>
                                <?php elseif ($student['status'] == 'transferred'): ?>
                                    <span class="bg-indigo-100 text-indigo-800 text-xs font-medium px-2.5 py-0.5 ">Transferred</span>
                                <?php endif; ?>
                            </td>
                            <td class="py-3 px-4">
                                <div class="flex space-x-2">
                                    <a href="view_student.php?id=<?php echo $student['id']; ?>" class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-1 " title="View">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="edit_student.php?id=<?php echo $student['id']; ?>" class="bg-yellow-500 hover:bg-yellow-600 text-white px-3 py-1 " title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="student_table.php?delete_id=<?php echo $student['id']; 
                                        if (!empty($class_filter)) echo '&class_filter=' . $class_filter;
                                        if (!empty($section_filter)) echo '&section_filter=' . $section_filter;
                                        if (!empty($search)) echo '&search=' . urlencode($search);
                                        ?>" class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 " title="Delete" onclick="return confirm('Are you sure you want to delete this student?');">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="9" class="py-4 px-4 text-center">
                            <?php if (!empty($search) || !empty($class_filter) || !empty($section_filter)): ?>
                                No students found with the current filters.
                                <a href="student_table.php" class="text-blue-600 hover:underline">View all students</a>
                            <?php else: ?>
                                No students found. <a href="add_student.php" class="text-blue-600 hover:underline">Add a new student</a>.
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <?php if ($total_pages > 1): ?>
    <div class="flex justify-center mt-6">
        <nav class="inline-flex  ">
            <!-- Previous Page Link -->
            <?php if ($page > 1): ?>
                <a href="?page=<?php echo $page - 1; 
                    echo !empty($search) ? '&search=' . urlencode($search) : ''; 
                    echo !empty($class_filter) ? '&class_filter=' . $class_filter : ''; 
                    echo !empty($section_filter) ? '&section_filter=' . $section_filter : ''; 
                ?>" class="py-2 px-4 border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50 ">
                    <i class="fas fa-chevron-left"></i>
                </a>
            <?php else: ?>
                <span class="py-2 px-4 border border-gray-300 bg-gray-100 text-sm font-medium text-gray-400 ">
                    <i class="fas fa-chevron-left"></i>
                </span>
            <?php endif; ?>

            <!-- Page Numbers -->
            <?php 
            // Calculate start and end of pagination links
            $start = max(1, $page - 2);
            $end = min($total_pages, $start + 4);
            $start = max(1, $end - 4);
            
            for ($i = $start; $i <= $end; $i++): 
            ?>
                <?php if ($i == $page): ?>
                    <span class="py-2 px-4 border border-gray-300 bg-blue-600 text-white text-sm font-medium">
                        <?php echo $i; ?>
                    </span>
                <?php else: ?>
                    <a href="?page=<?php echo $i; 
                        echo !empty($search) ? '&search=' . urlencode($search) : ''; 
                        echo !empty($class_filter) ? '&class_filter=' . $class_filter : ''; 
                        echo !empty($section_filter) ? '&section_filter=' . $section_filter : ''; 
                    ?>" class="py-2 px-4 border border-gray-300 bg-white text-sm font-medium text-gray-700 hover:bg-gray-50">
                        <?php echo $i; ?>
                    </a>
                <?php endif; ?>
            <?php endfor; ?>

            <!-- Next Page Link -->
            <?php if ($page < $total_pages): ?>
                <a href="?page=<?php echo $page + 1; 
                    echo !empty($search) ? '&search=' . urlencode($search) : ''; 
                    echo !empty($class_filter) ? '&class_filter=' . $class_filter : ''; 
                    echo !empty($section_filter) ? '&section_filter=' . $section_filter : ''; 
                ?>" class="py-2 px-4 border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50 ">
                    <i class="fas fa-chevron-right"></i>
                </a>
            <?php else: ?>
                <span class="py-2 px-4 border border-gray-300 bg-gray-100 text-sm font-medium text-gray-400 ">
                    <i class="fas fa-chevron-right"></i>
                </span>
            <?php endif; ?>
        </nav>
    </div>
    <?php endif; ?>
</div>

<script>
// JavaScript to handle dynamic section loading based on class selection
document.getElementById('class_filter').addEventListener('change', function() {
    const classId = this.value;
    const sectionSelect = document.getElementById('section_filter');
    
    if (classId) {
        // Enable section dropdown
        sectionSelect.disabled = false;
        
        // Fetch sections for the selected class via AJAX
        fetch('get_section.php?class_id=' + classId)
            .then(response => response.json())
            .then(sections => {
                // Clear existing options except the first one
                while (sectionSelect.options.length > 1) {
                    sectionSelect.remove(1);
                }
                
                // Add new options
                sections.forEach(section => {
                    const option = document.createElement('option');
                    option.value = section.id;
                    option.textContent = section.section_name;
                    sectionSelect.appendChild(option);
                });
            })
            .catch(error => console.error('Error fetching sections:', error));
    } else {
        // Disable and clear section dropdown if no class is selected
        sectionSelect.disabled = true;
        while (sectionSelect.options.length > 1) {
            sectionSelect.remove(1);
        }
    }
});
</script>

<?php
include 'include/footer.php';
mysqli_close($conn);
?>