<?php
include '../config/conn.php';

// Get public cameras
$public_cameras = mysqli_query($conn, "SELECT * FROM cctv_cameras WHERE is_public = 1 AND status = 'active'");

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <title>Public CCTV Monitoring - AdinoHeight College</title>
    <style>
        body { margin: 0; padding: 20px; background: #1a202c; color: white; font-family: Arial; }
        .camera-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)); gap: 20px; }
        .camera { background: #2d3748; border-radius: 10px; overflow: hidden; }
        .camera-info { padding: 15px; background: #4a5568; }
        video { width: 100%; height: 300px; background: #000; }
    </style>
</head>
<body>
    <h1>Public CCTV Monitoring - AdinoHeight College</h1>
    <div class="camera-grid">
        <?php while($camera = mysqli_fetch_assoc($public_cameras)): ?>
        <div class="camera">
            <video controls muted playsinline>
                <source src="<?php echo $camera['stream_url']; ?>" type="application/x-mpegURL">
            </video>
            <div class="camera-info">
                <h3><?php echo $camera['name']; ?> - <?php echo $camera['location']; ?></h3>
            </div>
        </div>
        <?php endwhile; ?>
    </div>
</body>
</html>