<?php

include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$invoice_id = isset($_GET['invoice_id']) ? intval($_GET['invoice_id']) : 0;

if ($invoice_id <= 0) {
    die("Invalid invoice ID");
}

// Get invoice details
$invoice_query = "SELECT i.*, s.full_name, s.student_id, s.roll_number, 
                 c.class_name, sec.section_name 
                 FROM invoices i 
                 JOIN students s ON i.student_id = s.id 
                 JOIN classes c ON s.class = c.id 
                 JOIN sections sec ON s.section = sec.id 
                 WHERE i.id = $invoice_id";
$invoice_result = mysqli_query($conn, $invoice_query);
$invoice = mysqli_fetch_assoc($invoice_result);
?>

<div class="bg-white p-6 rounded-lg shadow">
    <div class="text-center mb-6">
        <i class="fas fa-check-circle text-6xl text-green-500 mb-4"></i>
        <h2 class="text-2xl font-bold text-gray-800">Payment Successful!</h2>
        <p class="text-gray-600">Thank you for your payment.</p>
    </div>

    <div class="bg-gray-50 p-6 rounded-lg mb-6">
        <h3 class="text-lg font-semibold mb-4">Payment Details</h3>
        <div class="grid grid-cols-2 gap-4">
            <div>
                <p class="text-gray-600">Student Name:</p>
                <p class="font-semibold"><?php echo $invoice['full_name']; ?></p>
            </div>
            <div>
                <p class="text-gray-600">Student ID:</p>
                <p class="font-semibold"><?php echo $invoice['student_id']; ?></p>
            </div>
            <div>
                <p class="text-gray-600">Class:</p>
                <p class="font-semibold"><?php echo $invoice['class_name'] . ' ' . $invoice['section_name']; ?></p>
            </div>
            <div>
                <p class="text-gray-600">Amount Paid:</p>
                <p class="font-semibold">₦<?php echo number_format($invoice['amount'], 2); ?></p>
            </div>
            <div>
                <p class="text-gray-600">Payment Date:</p>
                <p class="font-semibold"><?php echo date('F j, Y, g:i a'); ?></p>
            </div>
            <div>
                <p class="text-gray-600">Payment Method:</p>
                <p class="font-semibold">Paystack</p>
            </div>
        </div>
    </div>

    <div class="flex justify-center space-x-4">
        <a href="view_invoices.php" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg">
            Back to Invoices
        </a>
        <a href="generate_receipt.php?invoice_id=<?php echo $invoice_id; ?>" class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded-lg">
            <i class="fas fa-download mr-2"></i> Download Receipt
        </a>
    </div>
</div>

<?php include 'include/footer.php'; ?>