<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';


// Initialize variables
$class_id = isset($_GET['class_id']) ? intval($_GET['class_id']) : 0;
$section_id = isset($_GET['section_id']) ? intval($_GET['section_id']) : 0;
$search_date = isset($_GET['search_date']) ? $_GET['search_date'] : '';
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$records_per_page = 10;
$offset = ($page - 1) * $records_per_page;
$success = '';
$error = '';
$selected_students = isset($_POST['students']) ? $_POST['students'] : [];
$selected_payments = isset($_POST['payments']) ? $_POST['payments'] : [];

// Handle delete actions
if (isset($_POST['delete_selected'])) {
    if (!empty($selected_payments)) {
        $payment_ids = implode(',', array_map('intval', $selected_payments));
        $delete_query = "DELETE FROM payments WHERE id IN ($payment_ids)";
        if (mysqli_query($conn, $delete_query)) {
            $success = "Selected payments deleted successfully!";
        } else {
            $error = "Error deleting payments: " . mysqli_error($conn);
        }
    } else {
        $error = "Please select at least one payment to delete.";
    }
} elseif (isset($_GET['delete_id'])) {
    $delete_id = intval($_GET['delete_id']);
    $delete_query = "DELETE FROM payments WHERE id = $delete_id";
    if (mysqli_query($conn, $delete_query)) {
        $success = "Payment deleted successfully!";
    } else {
        $error = "Error deleting payment: " . mysqli_error($conn);
    }
}

// Fetch all classes
$classes_query = "SELECT id, class_name FROM classes WHERE status = 'active' ORDER BY class_name";
$classes_result = mysqli_query($conn, $classes_query);

// Fetch sections based on selected class
$sections = [];
if ($class_id > 0) {
    $sections_query = "SELECT id, section_name FROM sections WHERE class_id = $class_id AND status = 'active' ORDER BY section_name";
    $sections_result = mysqli_query($conn, $sections_query);
    while ($section = mysqli_fetch_assoc($sections_result)) {
        $sections[] = $section;
    }
}

// Fetch students based on selected class and section
$students = [];
if ($class_id > 0 && $section_id > 0) {
    $students_query = "SELECT id, student_id, full_name, roll_number 
                       FROM students 
                       WHERE class = $class_id AND section = $section_id AND status = 'active' 
                       ORDER BY roll_number";
    $students_result = mysqli_query($conn, $students_query);
    while ($student = mysqli_fetch_assoc($students_result)) {
        $students[] = $student;
    }
}

// Handle invoice creation
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_invoices'])) {
    $class_id = intval($_POST['class_id']);
    $section_id = intval($_POST['section_id']);
    $description = mysqli_real_escape_string($conn, $_POST['description']);
    $amount = floatval($_POST['amount']);
    $due_date = mysqli_real_escape_string($conn, $_POST['due_date']);
    
    // Validate inputs
    if (empty($class_id) || empty($section_id) || empty($description) || $amount <= 0 || empty($due_date)) {
        $error = "Please fill all required fields with valid values.";
    } elseif (empty($selected_students)) {
        $error = "Please select at least one student.";
    } else {
        // Begin transaction
        mysqli_begin_transaction($conn);
        
        try {
            foreach ($selected_students as $student_id) {
                $student_id = intval($student_id);
                
                // Check if invoice already exists for this student and description
                $check_query = "SELECT id FROM invoices WHERE student_id = $student_id AND description = '$description' AND status = 'unpaid'";
                $check_result = mysqli_query($conn, $check_query);
                
                if (mysqli_num_rows($check_result) == 0) {
                    $insert_query = "INSERT INTO invoices (student_id, description, amount, due_date, created_by, created_at) 
                                     VALUES ($student_id, '$description', $amount, '$due_date', {$_SESSION['user_id']}, NOW())";
                    mysqli_query($conn, $insert_query);
                }
            }
            
            // Commit transaction
            mysqli_commit($conn);
            $success = "Invoices created successfully for selected students!";
            $selected_students = []; // Reset selected students
            
        } catch (Exception $e) {
            // Rollback transaction on error
            mysqli_rollback($conn);
            $error = "Error creating invoices: " . $e->getMessage();
        }
    }
}

// Handle receipt download
// Handle receipt download - FIXED VERSION
if (isset($_GET['download_receipt'])) {
    $payment_id = intval($_GET['download_receipt']);
    
    // Fixed query - join with invoices table to get description
    $receipt_query = "SELECT p.*, i.description as invoice_description, s.full_name, s.student_id, 
                             c.class_name, sec.section_name
                      FROM payments p
                      JOIN invoices i ON p.invoice_id = i.id
                      JOIN students s ON p.student_id = s.id
                      LEFT JOIN classes c ON s.class = c.id
                      LEFT JOIN sections sec ON s.section = sec.id
                      WHERE p.id = $payment_id";
    
    $receipt_result = mysqli_query($conn, $receipt_query);
    
    if ($receipt_result && mysqli_num_rows($receipt_result) > 0) {
        $payment_data = mysqli_fetch_assoc($receipt_result);
        
        // Clear any previous output
        ob_clean();
        
        // HTML receipt for download
        $receipt_html = '
        <!DOCTYPE html>
        <html>
        <head>
            <title>Payment Receipt</title>
            <style>
                body { font-family: Arial, sans-serif; margin: 40px; }
                .header { text-align: center; margin-bottom: 30px; border-bottom: 2px solid #333; padding-bottom: 20px; }
                .school-name { font-size: 24px; font-weight: bold; color: #2c3e50; }
                .receipt-title { font-size: 20px; color: #3498db; margin-top: 10px; }
                .details { margin: 20px 0; }
                .detail-row { margin: 10px 0; padding: 5px 0; }
                .label { font-weight: bold; display: inline-block; width: 150px; }
                .footer { margin-top: 40px; text-align: center; color: #7f8c8d; }
                .signature { margin-top: 60px; border-top: 1px solid #000; width: 200px; margin: 0 auto; }
                @media print {
                    body { margin: 20px; }
                    .no-print { display: none; }
                }
            </style>
        </head>
        <body>
            <div class="header">
                <div class="school-name">ADINOHEIGHT COLLEGE</div>
                <div class="receipt-title">OFFICIAL PAYMENT RECEIPT</div>
            </div>
            
            <div class="details">
                <div class="detail-row"><span class="label">Receipt Number:</span> REC-'.str_pad($payment_id, 6, '0', STR_PAD_LEFT).'</div>
                <div class="detail-row"><span class="label">Date Issued:</span> '.date('F j, Y', strtotime($payment_data['payment_date'])).'</div>
                <div class="detail-row"><span class="label">Student ID:</span> '.$payment_data['student_id'].'</div>
                <div class="detail-row"><span class="label">Student Name:</span> '.$payment_data['full_name'].'</div>';
        
        if (!empty($payment_data['class_name'])) {
            $receipt_html .= '<div class="detail-row"><span class="label">Class:</span> '.$payment_data['class_name'].'</div>';
        }
        
        if (!empty($payment_data['section_name'])) {
            $receipt_html .= '<div class="detail-row"><span class="label">Section:</span> '.$payment_data['section_name'].'</div>';
        }
        
        $receipt_html .= '
                <div class="detail-row"><span class="label">Description:</span> '.$payment_data['invoice_description'].'</div>
                <div class="detail-row"><span class="label">Amount Paid:</span> ₦ '.number_format($payment_data['amount'], 2).'</div>
                <div class="detail-row"><span class="label">Payment Method:</span> '.ucfirst($payment_data['payment_method']).'</div>
                <div class="detail-row"><span class="label">Transaction ID:</span> '.$payment_data['transaction_id'].'</div>
            </div>
            
            <div class="footer">
                <div>Thank you for your payment!</div>
                <div>AdinoHeight College</div>
                <div class="signature">Authorized Signature</div>
            </div>
            
            <div class="no-print" style="margin-top: 30px; text-align: center;">
                <button onclick="window.print()">Print Receipt</button>
            </div>
        </body>
        </html>';
        
        echo $receipt_html;
        exit();
    } else {
        $error = "Receipt not found for payment ID: $payment_id";
    }
}

// Build query for payments with optional date filter
$payments_query = "SELECT p.*, s.full_name, s.student_id, c.class_name, sec.section_name
                   FROM payments p
                   JOIN students s ON p.student_id = s.id
                   LEFT JOIN classes c ON s.class = c.id
                   LEFT JOIN sections sec ON s.section = sec.id";
                   
// Add date filter if provided
if (!empty($search_date)) {
    $payments_query .= " WHERE DATE(p.payment_date) = '" . mysqli_real_escape_string($conn, $search_date) . "'";
}

// Get total count for pagination
$count_query = $payments_query;
$count_result = mysqli_query($conn, $count_query);
$total_records = mysqli_num_rows($count_result);
$total_pages = ceil($total_records / $records_per_page);

// Add pagination and ordering to the main query
$payments_query .= " ORDER BY p.payment_date DESC LIMIT $offset, $records_per_page";

$payments_result = mysqli_query($conn, $payments_query);
$recent_payments = [];
while ($row = mysqli_fetch_assoc($payments_result)) {
    $recent_payments[] = $row;
}

// Get class and section names for display
$class_name = '';
$section_name = '';
if ($class_id > 0) {
    $class_name_query = "SELECT class_name FROM classes WHERE id = $class_id";
    $class_name_result = mysqli_query($conn, $class_name_query);
    if ($class_name_result && mysqli_num_rows($class_name_result) > 0) {
        $class_name = mysqli_fetch_assoc($class_name_result)['class_name'];
    }
}

if ($section_id > 0) {
    $section_name_query = "SELECT section_name FROM sections WHERE id = $section_id";
    $section_name_result = mysqli_query($conn, $section_name_query);
    if ($section_name_result && mysqli_num_rows($section_name_result) > 0) {
        $section_name = mysqli_fetch_assoc($section_name_result)['section_name'];
    }
}

ob_end_flush();
?>

<div class="bg-white p-6  ">
   

    <?php if (!empty($success)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3  mb-4">
            <?php echo $success; ?>
        </div>
    <?php endif; ?>
    
    <?php if (!empty($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3  mb-4">
            <?php echo $error; ?>
        </div>
    <?php endif; ?>

    <!-- Filter Section -->
    <div class="mb-6 bg-gray-50 p-4 ">
        <form method="GET" action="" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <!-- Class Filter -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Select Class</label>
                <select name="class_id" id="class_filter" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    <option value="">Select Class</option>
                    <?php 
                    // Reset pointer and loop through classes again
                    mysqli_data_seek($classes_result, 0);
                    while ($class = mysqli_fetch_assoc($classes_result)): 
                    ?>
                        <option value="<?php echo $class['id']; ?>" <?php echo ($class_id == $class['id']) ? 'selected' : ''; ?>>
                            <?php echo $class['class_name']; ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            
            <!-- Section Filter -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Select Section</label>
                <select name="section_id" id="section_filter" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" <?php echo ($class_id == 0) ? 'disabled' : ''; ?> required>
                    <option value="">Select Section</option>
                    <?php foreach ($sections as $section): ?>
                        <option value="<?php echo $section['id']; ?>" <?php echo ($section_id == $section['id']) ? 'selected' : ''; ?>>
                            <?php echo $section['section_name']; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <!-- Date Search Filter -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Search by Date</label>
                <input type="date" name="search_date" value="<?php echo $search_date; ?>" 
                    class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <!-- Buttons -->
            <div class="flex items-end space-x-2">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2  flex items-center h-10">
                    <i class="fas fa-filter mr-2"></i> Apply Filters
                </button>
                <a href="payment.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2  flex items-center h-10">
                    <i class="fas fa-times mr-2"></i> Clear
                </a>
            </div>
        </form>
    </div>

    <?php if ($class_id > 0 && $section_id > 0): ?>
        <!-- Invoice Creation Section -->
        <div class="mb-6 bg-white p-4  ">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-semibold text-gray-800">
                    Create Invoices for <?php echo $class_name . " - " . $section_name; ?>
                </h3>
            </div>
            
            <?php if (!empty($students)): ?>
                <form method="POST" action="">
                    <input type="hidden" name="class_id" value="<?php echo $class_id; ?>">
                    <input type="hidden" name="section_id" value="<?php echo $section_id; ?>">
                    
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                        <input type="text" name="description" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" 
                            placeholder="Tuition Fee for <?php echo date('F Y'); ?>" required>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Amount (₦)</label>
                            <input type="number" step="0.01" min="0" name="amount" 
                                class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Due Date</label>
                            <input type="date" name="due_date" 
                                class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required
                                value="<?php echo date('Y-m-d', strtotime('+30 days')); ?>">
                        </div>
                    </div>
                    
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Select Students</label>
                        <div class="flex items-center mb-2">
                            <input type="checkbox" id="select-all" class="mr-2">
                            <label for="select-all" class="text-sm text-gray-600">Select All Students</label>
                        </div>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3 max-h-60 overflow-y-auto p-2 border ">
                            <?php foreach ($students as $student): ?>
                            <div class="flex items-center">
                                <input type="checkbox" name="students[]" value="<?php echo $student['id']; ?>" 
                                    class="student-checkbox mr-2" 
                                    <?php echo in_array($student['id'], $selected_students) ? 'checked' : ''; ?>>
                                <label class="text-sm"><?php echo $student['roll_number'] . ' - ' . $student['full_name']; ?></label>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    
                    <div class="flex justify-end">
                        <button type="submit" name="create_invoices" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2  flex items-center">
                            <i class="fas fa-file-invoice-dollar mr-2"></i> Create Invoices
                        </button>
                    </div>
                </form>
            <?php else: ?>
                <p class="text-center py-4 text-gray-500">
                    No students found in this class and section.
                </p>
            <?php endif; ?>
        </div>
    <?php else: ?>
        <div class="bg-white p-8   text-center">
            <i class="fas fa-money-bill-wave text-4xl text-gray-300 mb-4"></i>
            <h3 class="text-lg font-medium text-gray-600">Please select a class and section to create invoices</h3>
        </div>
    <?php endif; ?>
    
    <!-- Recent Payments Section -->
    <div class="bg-white p-4   mt-6">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-lg font-semibold text-gray-800">Recent Payments</h3>
            <?php if (!empty($search_date)): ?>
                <span class="text-sm text-gray-600">Filtered by: <?php echo date('F j, Y', strtotime($search_date)); ?></span>
            <?php endif; ?>
        </div>
        
        <?php if (count($recent_payments) > 0): ?>
            <form method="POST" action="" id="payments-form">
                <div class="flex justify-between items-center mb-3">
                    <div class="flex items-center">
                        <input type="checkbox" id="select-all-payments" class="mr-2">
                        <label for="select-all-payments" class="text-sm text-gray-600">Select All</label>
                    </div>
                    <button type="submit" name="delete_selected" class="bg-red-600 hover:bg-red-700 text-white px-3 py-1  text-sm flex items-center" onclick="return confirm('Are you sure you want to delete the selected payments?')">
                        <i class="fas fa-trash mr-1"></i> Delete Selected
                    </button>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white">
                        <thead class="bg-gray-200 text-gray-700">
                            <tr>
                                <th class="py-3 px-4 text-left w-8"></th>
                                <th class="py-3 px-4 text-left">Date</th>
                                <th class="py-3 px-4 text-left">Student ID</th>
                                <th class="py-3 px-4 text-left">Student Name</th>
                                <th class="py-3 px-4 text-left">Class</th>
                                <th class="py-3 px-4 text-left">Description</th>
                                <th class="py-3 px-4 text-left">Amount</th>
                                <th class="py-3 px-4 text-left">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-600">
                            <?php foreach ($recent_payments as $payment): ?>
                                <tr class="border-b border-gray-200 hover:bg-gray-50">
                                    <td class="py-3 px-4">
                                        <input type="checkbox" name="payments[]" value="<?php echo $payment['id']; ?>" class="payment-checkbox">
                                    </td>
                                    <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($payment['payment_date'])); ?></td>
                                    <td class="py-3 px-4"><?php echo $payment['student_id']; ?></td>
                                    <td class="py-3 px-4"><?php echo $payment['full_name']; ?></td>
                                    <td class="py-3 px-4">
                                        <?php 
                                        $class_info = $payment['class_name'];
                                        if (!empty($payment['section_name'])) {
                                            $class_info .= ' - ' . $payment['section_name'];
                                        }
                                        echo $class_info;
                                        ?>
                                    </td>
                                    <td class="py-3 px-4"><?php echo isset($payment['description']) ? $payment['description'] : 'Payment'; ?></td>
                                    <td class="py-3 px-4">₦<?php echo number_format($payment['amount'], 2); ?></td>
                                    <td class="py-3 px-4">
                                        <div class="flex space-x-2">
                                           
                                            <a href="?download_receipt=<?php echo $payment['id']; ?>" target="_blank"
                                               class="bg-green-600 hover:bg-green-700 text-white px-3 py-1  text-sm flex items-center">
                                                <i class="fas fa-download mr-1"></i> Download
                                            </a>
                                            <a href="?delete_id=<?php echo $payment['id']; ?>" 
                                               class="bg-red-600 hover:bg-red-700 text-white px-3 py-1  text-sm flex items-center"
                                               onclick="return confirm('Are you sure you want to delete this payment?')">
                                                <i class="fas fa-trash mr-1"></i> Delete
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </form>
            
            <!-- Pagination -->
            <?php if ($total_pages > 1): ?>
                <div class="flex justify-center items-center mt-4">
                    <nav class="inline-flex -md ">
                        <?php if ($page > 1): ?>
                            <a href="?page=<?php echo $page - 1; ?><?php echo !empty($search_date) ? '&search_date='.$search_date : ''; ?><?php echo $class_id > 0 ? '&class_id='.$class_id : ''; ?><?php echo $section_id > 0 ? '&section_id='.$section_id : ''; ?>"
                               class="px-3 py-2 -l-md border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                                <i class="fas fa-chevron-left mr-1"></i> Previous
                            </a>
                        <?php else: ?>
                            <span class="px-3 py-2 -l-md border border-gray-300 bg-gray-100 text-sm font-medium text-gray-400">
                                <i class="fas fa-chevron-left mr-1"></i> Previous
                            </span>
                        <?php endif; ?>
                        
                        <!-- Page numbers -->
                        <?php 
                        $start_page = max(1, $page - 2);
                        $end_page = min($total_pages, $start_page + 4);
                        if ($end_page - $start_page < 4) {
                            $start_page = max(1, $end_page - 4);
                        }
                        
                        for ($i = $start_page; $i <= $end_page; $i++): 
                        ?>
                            <a href="?page=<?php echo $i; ?><?php echo !empty($search_date) ? '&search_date='.$search_date : ''; ?><?php echo $class_id > 0 ? '&class_id='.$class_id : ''; ?><?php echo $section_id > 0 ? '&section_id='.$section_id : ''; ?>"
                               class="px-3 py-2 border-t border-b border-gray-300 bg-white text-sm font-medium <?php echo $i == $page ? 'text-blue-600 bg-blue-50' : 'text-gray-500 hover:bg-gray-50'; ?>">
                                <?php echo $i; ?>
                            </a>
                        <?php endfor; ?>
                        
                        <?php if ($page < $total_pages): ?>
                            <a href="?page=<?php echo $page + 1; ?><?php echo !empty($search_date) ? '&search_date='.$search_date : ''; ?><?php echo $class_id > 0 ? '&class_id='.$class_id : ''; ?><?php echo $section_id > 0 ? '&section_id='.$section_id : ''; ?>"
                               class="px-3 py-2  border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50">
                                Next <i class="fas fa-chevron-right ml-1"></i>
                            </a>
                        <?php else: ?>
                            <span class="px-3 py-2  border border-gray-300 bg-gray-100 text-sm font-medium text-gray-400">
                                Next <i class="fas fa-chevron-right ml-1"></i>
                            </span>
                        <?php endif; ?>
                    </nav>
                </div>
            <?php endif; ?>
            
        <?php else: ?>
            <p class="text-center py-4 text-gray-500">
                <?php echo !empty($search_date) ? "No payments found for the selected date." : "No recent payments found."; ?>
            </p>
        <?php endif; ?>
    </div>
</div>

<!-- Receipt View Modal -->
<div id="receiptModal" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center z-50 hidden">
    <div class="bg-white   w-11/12 md:w-3/4 lg:w-2/3 max-h-screen overflow-auto">
        <div class="p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-xl font-semibold text-gray-800">Payment Receipt</h3>
                <button onclick="closeModal()" class="text-gray-500 hover:text-gray-700">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <div id="receiptContent" class="p-4 border ">
                <!-- Receipt content will be loaded here -->
            </div>
            <div class="mt-4 flex justify-end space-x-3">
                <button onclick="printReceipt()" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2  flex items-center">
                    <i class="fas fa-print mr-2"></i> Print
                </button>
                <button onclick="closeModal()" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 ">
                    Close
                </button>
            </div>
        </div>
    </div>
</div>

<script>
// JavaScript to handle dynamic section loading based on class selection
document.getElementById('class_filter').addEventListener('change', function() {
    const classId = this.value;
    const sectionSelect = document.getElementById('section_filter');
    
    if (classId) {
        // Enable section dropdown
        sectionSelect.disabled = false;
        
        // Fetch sections for the selected class via AJAX
        fetch('get_sectionss.php?class_id=' + classId)
            .then(response => response.json())
            .then(sections => {
                // Clear existing options except the first one
                while (sectionSelect.options.length > 1) {
                    sectionSelect.remove(1);
                }
                
                // Add new options
                sections.forEach(section => {
                    const option = document.createElement('option');
                    option.value = section.id;
                    option.textContent = section.section_name;
                    sectionSelect.appendChild(option);
                });
            })
            .catch(error => console.error('Error fetching sections:', error));
    } else {
        // Disable and clear section dropdown if no class is selected
        sectionSelect.disabled = true;
        while (sectionSelect.options.length > 1) {
            sectionSelect.remove(1);
        }
    }
});

// Select all students functionality
document.getElementById('select-all').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.student-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
    });
});

// Select all payments functionality
document.getElementById('select-all-payments').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.payment-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
    });
});

// View receipt functionality
function viewReceipt(paymentId) {
    fetch('get_receipt.php?payment_id=' + paymentId)
        .then(response => response.text())
        .then(data => {
            document.getElementById('receiptContent').innerHTML = data;
            document.getElementById('receiptModal').classList.remove('hidden');
        })
        .catch(error => {
            console.error('Error loading receipt:', error);
            alert('Error loading receipt. Please try again.');
        });
}

function closeModal() {
    document.getElementById('receiptModal').classList.add('hidden');
}

function printReceipt() {
    const receiptContent = document.getElementById('receiptContent').innerHTML;
    const printWindow = window.open('', '_blank');
    printWindow.document.write(`
        <!DOCTYPE html>
        <html>
        <head>
            <title>Print Receipt</title>
            <style>
                body { font-family: Arial, sans-serif; margin: 40px; }
                .header { text-align: center; margin-bottom: 30px; }
                .school-name { font-size: 24px; font-weight: bold; }
                .receipt-title { font-size: 20px; margin-top: 10px; }
                .details { margin: 20px 0; }
                .detail-row { margin: 8px 0; }
                .label { font-weight: bold; display: inline-block; width: 150px; }
                .footer { margin-top: 40px; text-align: center; }
                .signature { margin-top: 60px; border-top: 1px solid #000; width: 200px; }
                @media print {
                    body { margin: 20px; }
                    .no-print { display: none; }
                }
            </style>
        </head>
        <body>
            ${receiptContent}
            <div class="no-print" style="margin-top: 30px; text-align: center;">
                <button onclick="window.print()">Print Receipt</button>
                <button onclick="window.close()">Close</button>
            </div>
        </body>
        </html>
    `);
    printWindow.document.close();
}

// Close modal when clicking outside
window.onclick = function(event) {
    const modal = document.getElementById('receiptModal');
    if (event.target === modal) {
        closeModal();
    }
}
</script>

<?php
include 'include/footer.php';
// Don't close the connection here as it's needed until the end of the script
?>