<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// ✅ Ensure only admin can access
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit();
}

// Initialize variables
$success = '';
$error = '';
$notice_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$action = isset($_GET['action']) ? $_GET['action'] : '';

// Handle Add / Edit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_notice'])) {
        $title = mysqli_real_escape_string($conn, $_POST['title']);
        $content = mysqli_real_escape_string($conn, $_POST['content']);
        $audience_type = mysqli_real_escape_string($conn, $_POST['audience_type']);
        $target_id = ($audience_type !== 'all') ? intval($_POST['target_id']) : 0;
        $priority = mysqli_real_escape_string($conn, $_POST['priority']);
        $expiry_date = !empty($_POST['expiry_date']) ? $_POST['expiry_date'] : null;

        $query = "INSERT INTO notices (title, content, audience_type, target_id, priority, expiry_date, created_by) 
                  VALUES ('$title', '$content', '$audience_type', $target_id, '$priority', " . 
                  ($expiry_date ? "'$expiry_date'" : "NULL") . ", {$_SESSION['user_id']})";

        if (mysqli_query($conn, $query)) {
            $notice_id = mysqli_insert_id($conn);

            // ✅ Insert Notifications
            if ($audience_type === 'all') {
                // Students
                $res = mysqli_query($conn, "SELECT id FROM students");
                while ($row = mysqli_fetch_assoc($res)) {
                    mysqli_query($conn, "INSERT INTO notifications 
                        (user_id, user_type, title, message, related_id, type, is_read, created_at) 
                        VALUES ({$row['id']}, 'student', '$title', '$content', $notice_id, 'notice', 0, NOW())");
                }
                // Teachers
                $res = mysqli_query($conn, "SELECT id FROM teachers");
                while ($row = mysqli_fetch_assoc($res)) {
                    mysqli_query($conn, "INSERT INTO notifications 
                        (user_id, user_type, title, message, related_id, type, is_read, created_at) 
                        VALUES ({$row['id']}, 'teacher', '$title', '$content', $notice_id, 'notice', 0, NOW())");
                }
                // Parents
                $res = mysqli_query($conn, "SELECT id FROM parents");
                while ($row = mysqli_fetch_assoc($res)) {
                    mysqli_query($conn, "INSERT INTO notifications 
                        (user_id, user_type, title, message, related_id, type, is_read, created_at) 
                        VALUES ({$row['id']}, 'parent', '$title', '$content', $notice_id, 'notice', 0, NOW())");
                }

            } elseif ($audience_type === 'class') {
                $res = mysqli_query($conn, "SELECT id FROM students WHERE class_id = $target_id");
                while ($row = mysqli_fetch_assoc($res)) {
                    mysqli_query($conn, "INSERT INTO notifications 
                        (user_id, user_type, title, message, related_id, type, is_read, created_at) 
                        VALUES ({$row['id']}, 'student', '$title', '$content', $notice_id, 'notice', 0, NOW())");
                }

            } elseif ($audience_type === 'section') {
                $res = mysqli_query($conn, "SELECT id FROM students WHERE section_id = $target_id");
                while ($row = mysqli_fetch_assoc($res)) {
                    mysqli_query($conn, "INSERT INTO notifications 
                        (user_id, user_type, title, message, related_id, type, is_read, created_at) 
                        VALUES ({$row['id']}, 'student', '$title', '$content', $notice_id, 'notice', 0, NOW())");
                }

            } elseif ($audience_type === 'student') {
                mysqli_query($conn, "INSERT INTO notifications 
                    (user_id, user_type, title, message, related_id, type, is_read, created_at) 
                    VALUES ($target_id, 'student', '$title', '$content', $notice_id, 'notice', 0, NOW())");

            } elseif ($audience_type === 'teacher') {
                mysqli_query($conn, "INSERT INTO notifications 
                    (user_id, user_type, title, message, related_id, type, is_read, created_at) 
                    VALUES ($target_id, 'teacher', '$title', '$content', $notice_id, 'notice', 0, NOW())");

            } elseif ($audience_type === 'parent') {
                mysqli_query($conn, "INSERT INTO notifications 
                    (user_id, user_type, title, message, related_id, type, is_read, created_at) 
                    VALUES ($target_id, 'parent', '$title', '$content', $notice_id, 'notice', 0, NOW())");
            }

            $success = "✅ Notice added and notifications sent!";
        } else {
            $error = "❌ Error adding notice: " . mysqli_error($conn);
        }
    }

    elseif (isset($_POST['edit_notice'])) {
        $title = mysqli_real_escape_string($conn, $_POST['title']);
        $content = mysqli_real_escape_string($conn, $_POST['content']);
        $audience_type = mysqli_real_escape_string($conn, $_POST['audience_type']);
        $target_id = ($audience_type !== 'all') ? intval($_POST['target_id']) : 0;
        $priority = mysqli_real_escape_string($conn, $_POST['priority']);
        $expiry_date = !empty($_POST['expiry_date']) ? $_POST['expiry_date'] : null;
        $notice_id = intval($_POST['notice_id']);

        $query = "UPDATE notices SET 
                  title = '$title', 
                  content = '$content', 
                  audience_type = '$audience_type', 
                  target_id = $target_id, 
                  priority = '$priority', 
                  expiry_date = " . ($expiry_date ? "'$expiry_date'" : "NULL") . "
                  WHERE id = $notice_id";

        if (mysqli_query($conn, $query)) {
            $success = "✅ Notice updated successfully!";
        } else {
            $error = "❌ Error updating notice: " . mysqli_error($conn);
        }
    }
}

// Handle Delete
if ($action === 'delete' && $notice_id > 0) {
    $query = "DELETE FROM notices WHERE id = $notice_id";
    if (mysqli_query($conn, $query)) {
        $success = "✅ Notice deleted successfully!";
    } else {
        $error = "❌ Error deleting notice: " . mysqli_error($conn);
    }
}

// Dropdown data
$classes_result = mysqli_query($conn, "SELECT id, class_name FROM classes ORDER BY class_name");
$students_result = mysqli_query($conn, "SELECT id, student_id, full_name FROM students ORDER BY full_name");
$sections_result = mysqli_query($conn, "SELECT s.id, s.section_name, c.class_name 
                                        FROM sections s 
                                        LEFT JOIN classes c ON s.class_id = c.id 
                                        ORDER BY c.class_name, s.section_name");

// Fetch notices
$notices_result = mysqli_query($conn, "SELECT n.*, u.full_name as created_by_name 
                                       FROM notices n 
                                       LEFT JOIN users u ON n.created_by = u.id 
                                       ORDER BY n.created_at DESC");

$edit_notice = null;
if ($action === 'edit' && $notice_id > 0) {
    $edit_query = "SELECT * FROM notices WHERE id = $notice_id";
    $edit_result = mysqli_query($conn, $edit_query);
    if (mysqli_num_rows($edit_result) > 0) {
        $edit_notice = mysqli_fetch_assoc($edit_result);
    }
}
?>

<div class="bg-white p-6 rounded-lg">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Notice Board Management</h2>
        <button onclick="toggleNoticeForm()" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg flex items-center">
            <i class="fas fa-plus mr-2"></i> Add New Notice
        </button>
    </div>

    <?php if (!empty($success)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo $success; ?>
        </div>
    <?php endif; ?>
    
    <?php if (!empty($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <?php echo $error; ?>
        </div>
    <?php endif; ?>

    <!-- Notice Form (Initially hidden if not editing) -->
    <div id="noticeForm" class="mb-6 bg-gray-50 p-4 rounded-lg <?php echo !$edit_notice ? 'hidden' : ''; ?>">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">
            <?php echo $edit_notice ? 'Edit Notice' : 'Add New Notice'; ?>
        </h3>
        
        <form method="POST" action="">
            <?php if ($edit_notice): ?>
                <input type="hidden" name="notice_id" value="<?php echo $edit_notice['id']; ?>">
            <?php endif; ?>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Title *</label>
                    <input type="text" name="title" value="<?php echo $edit_notice ? $edit_notice['title'] : ''; ?>" 
                        class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Priority</label>
                    <select name="priority" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="normal" <?php echo ($edit_notice && $edit_notice['priority'] == 'normal') ? 'selected' : ''; ?>>Normal</option>
                        <option value="high" <?php echo ($edit_notice && $edit_notice['priority'] == 'high') ? 'selected' : ''; ?>>High</option>
                        <option value="urgent" <?php echo ($edit_notice && $edit_notice['priority'] == 'urgent') ? 'selected' : ''; ?>>Urgent</option>
                    </select>
                </div>
            </div>
            
            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 mb-1">Content *</label>
                <textarea name="content" rows="4" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required><?php echo $edit_notice ? $edit_notice['content'] : ''; ?></textarea>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Audience Type *</label>
                    <select name="audience_type" id="audienceType" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                        <option value="all" <?php echo ($edit_notice && $edit_notice['audience_type'] == 'all') ? 'selected' : ''; ?>>All Students</option>
                        <option value="class" <?php echo ($edit_notice && $edit_notice['audience_type'] == 'class') ? 'selected' : ''; ?>>Specific Class</option>
                        <option value="section" <?php echo ($edit_notice && $edit_notice['audience_type'] == 'section') ? 'selected' : ''; ?>>Specific Section</option>
                        <option value="student" <?php echo ($edit_notice && $edit_notice['audience_type'] == 'student') ? 'selected' : ''; ?>>Specific Student</option>
                    </select>
                </div>
                
                <div id="targetContainer">
                    <?php if ($edit_notice && $edit_notice['audience_type'] == 'class'): ?>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Select Class *</label>
                        <select name="target_id" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <?php 
                            mysqli_data_seek($classes_result, 0);
                            while ($class = mysqli_fetch_assoc($classes_result)): 
                            ?>
                                <option value="<?php echo $class['id']; ?>" <?php echo ($edit_notice['target_id'] == $class['id']) ? 'selected' : ''; ?>>
                                    <?php echo $class['class_name']; ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    <?php elseif ($edit_notice && $edit_notice['audience_type'] == 'section'): ?>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Select Section *</label>
                        <select name="target_id" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <?php 
                            mysqli_data_seek($sections_result, 0);
                            while ($section = mysqli_fetch_assoc($sections_result)): 
                            ?>
                                <option value="<?php echo $section['id']; ?>" <?php echo ($edit_notice['target_id'] == $section['id']) ? 'selected' : ''; ?>>
                                    <?php echo $section['class_name'] . ' - ' . $section['section_name']; ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    <?php elseif ($edit_notice && $edit_notice['audience_type'] == 'student'): ?>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Select Student *</label>
                        <select name="target_id" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <?php 
                            mysqli_data_seek($students_result, 0);
                            while ($student = mysqli_fetch_assoc($students_result)): 
                            ?>
                                <option value="<?php echo $student['id']; ?>" <?php echo ($edit_notice['target_id'] == $student['id']) ? 'selected' : ''; ?>>
                                    <?php echo $student['full_name'] . ' (' . $student['student_id'] . ')'; ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 mb-1">Expiry Date (Optional)</label>
                <input type="date" name="expiry_date" value="<?php echo $edit_notice ? $edit_notice['expiry_date'] : ''; ?>" 
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <div class="flex justify-end space-x-2">
                <button type="button" onclick="cancelEdit()" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
                    Cancel
                </button>
                <button type="submit" name="<?php echo $edit_notice ? 'edit_notice' : 'add_notice'; ?>" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">
                    <?php echo $edit_notice ? 'Update Notice' : 'Add Notice'; ?>
                </button>
            </div>
        </form>
    </div>

    <!-- Notices List -->
    <div class="bg-white p-4 rounded-lg shadow">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">All Notices</h3>
        
        <?php if (mysqli_num_rows($notices_result) > 0): ?>
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white">
                    <thead class="bg-gray-200 text-gray-700">
                        <tr>
                            <th class="py-3 px-4 text-left">Title</th>
                            <th class="py-3 px-4 text-left">Audience</th>
                            <th class="py-3 px-4 text-left">Priority</th>
                            <th class="py-3 px-4 text-left">Created</th>
                            <th class="py-3 px-4 text-left">Expires</th>
                            <th class="py-3 px-4 text-left">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="text-gray-600">
                        <?php while ($notice = mysqli_fetch_assoc($notices_result)): 
                            // Determine audience display text
                            $audience_text = '';
                            if ($notice['audience_type'] === 'all') {
                                $audience_text = 'All Students';
                            } elseif ($notice['audience_type'] === 'class') {
                                $class_query = "SELECT class_name FROM classes WHERE id = " . $notice['target_id'];
                                $class_result = mysqli_query($conn, $class_query);
                                if ($class_result && mysqli_num_rows($class_result) > 0) {
                                    $class_name = mysqli_fetch_assoc($class_result)['class_name'];
                                    $audience_text = 'Class: ' . $class_name;
                                } else {
                                    $audience_text = 'Class: Not found';
                                }
                            } elseif ($notice['audience_type'] === 'section') {
                                $section_query = "SELECT s.section_name, c.class_name 
                                                  FROM sections s 
                                                  LEFT JOIN classes c ON s.class_id = c.id 
                                                  WHERE s.id = " . $notice['target_id'];
                                $section_result = mysqli_query($conn, $section_query);
                                if ($section_result && mysqli_num_rows($section_result) > 0) {
                                    $section = mysqli_fetch_assoc($section_result);
                                    $audience_text = 'Section: ' . $section['class_name'] . ' - ' . $section['section_name'];
                                } else {
                                    $audience_text = 'Section: Not found';
                                }
                            } elseif ($notice['audience_type'] === 'student') {
                                $student_query = "SELECT full_name, student_id FROM students WHERE id = " . $notice['target_id'];
                                $student_result = mysqli_query($conn, $student_query);
                                if ($student_result && mysqli_num_rows($student_result) > 0) {
                                    $student = mysqli_fetch_assoc($student_result);
                                    $audience_text = 'Student: ' . $student['full_name'] . ' (' . $student['student_id'] . ')';
                                } else {
                                    $audience_text = 'Student: Not found';
                                }
                            }
                            
                            // Priority badge color
                            $priority_class = '';
                            switch ($notice['priority']) {
                                case 'high':
                                    $priority_class = 'bg-yellow-100 text-yellow-800';
                                    break;
                                case 'urgent':
                                    $priority_class = 'bg-red-100 text-red-800';
                                    break;
                                default:
                                    $priority_class = 'bg-blue-100 text-blue-800';
                            }
                        ?>
                            <tr class="border-b border-gray-200 hover:bg-gray-50">
                                <td class="py-3 px-4 font-medium"><?php echo $notice['title']; ?></td>
                                <td class="py-3 px-4"><?php echo $audience_text; ?></td>
                                <td class="py-3 px-4">
                                    <span class="text-xs font-medium px-2.5 py-0.5 rounded-full <?php echo $priority_class; ?>">
                                        <?php echo ucfirst($notice['priority']); ?>
                                    </span>
                                </td>
                                <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($notice['created_at'])); ?></td>
                                <td class="py-3 px-4">
                                    <?php echo $notice['expiry_date'] ? date('M j, Y', strtotime($notice['expiry_date'])) : 'Never'; ?>
                                </td>
                                <td class="py-3 px-4">
                                    <div class="flex space-x-2">
                                        <a href="?action=edit&id=<?php echo $notice['id']; ?>" class="text-blue-600 hover:text-blue-800">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="?action=delete&id=<?php echo $notice['id']; ?>" class="text-red-600 hover:text-red-800" onclick="return confirm('Are you sure you want to delete this notice?');">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                        <button onclick="viewNotice(<?php echo $notice['id']; ?>)" class="text-green-600 hover:text-green-800">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p class="text-center py-4 text-gray-500">No notices found.</p>
        <?php endif; ?>
    </div>
</div>

<!-- Notice View Modal -->
<div id="noticeModal" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white rounded-lg shadow-xl w-11/12 md:w-2/3 lg:w-1/2 max-h-screen overflow-y-auto">
        <div class="p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 id="modalTitle" class="text-xl font-bold text-gray-800"></h3>
                <button onclick="closeModal()" class="text-gray-500 hover:text-gray-700">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="mb-4">
                <span id="modalAudience" class="text-sm text-gray-600"></span>
                <span id="modalPriority" class="text-xs font-medium px-2.5 py-0.5 rounded-full ml-2"></span>
            </div>
            <div id="modalContent" class="prose max-w-none mb-4"></div>
            <div class="text-sm text-gray-500">
                <p>Posted by: <span id="modalAuthor"></span> on <span id="modalDate"></span></p>
                <p>Expires: <span id="modalExpiry"></span></p>
            </div>
        </div>
    </div>
</div>

<script>
// Toggle notice form visibility
function toggleNoticeForm() {
    const form = document.getElementById('noticeForm');
    form.classList.toggle('hidden');
    
    // If we're showing the form, scroll to it
    if (!form.classList.contains('hidden')) {
        form.scrollIntoView({ behavior: 'smooth' });
    }
}

// Cancel edit and hide form
function cancelEdit() {
    window.location.href = 'noticeboard.php';
}

// Dynamic audience target selection
document.getElementById('audienceType').addEventListener('change', function() {
    const audienceType = this.value;
    const targetContainer = document.getElementById('targetContainer');
    
    if (audienceType === 'all') {
        targetContainer.innerHTML = '';
    } else if (audienceType === 'class') {
        targetContainer.innerHTML = `
            <label class="block text-sm font-medium text-gray-700 mb-1">Select Class *</label>
            <select name="target_id" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                <?php 
                mysqli_data_seek($classes_result, 0);
                while ($class = mysqli_fetch_assoc($classes_result)): 
                ?>
                    <option value="<?php echo $class['id']; ?>"><?php echo $class['class_name']; ?></option>
                <?php endwhile; ?>
            </select>
        `;
    } else if (audienceType === 'section') {
        targetContainer.innerHTML = `
            <label class="block text-sm font-medium text-gray-700 mb-1">Select Section *</label>
            <select name="target_id" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                <?php 
                mysqli_data_seek($sections_result, 0);
                while ($section = mysqli_fetch_assoc($sections_result)): 
                ?>
                    <option value="<?php echo $section['id']; ?>"><?php echo $section['class_name'] . ' - ' . $section['section_name']; ?></option>
                <?php endwhile; ?>
            </select>
        `;
    } else if (audienceType === 'student') {
        targetContainer.innerHTML = `
            <label class="block text-sm font-medium text-gray-700 mb-1">Select Student *</label>
            <select name="target_id" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                <?php 
                mysqli_data_seek($students_result, 0);
                while ($student = mysqli_fetch_assoc($students_result)): 
                ?>
                    <option value="<?php echo $student['id']; ?>"><?php echo $student['full_name'] . ' (' . $student['student_id'] . ')'; ?></option>
                <?php endwhile; ?>
            </select>
        `;
    }
});

// View notice in modal
// View notice in modal
function viewNotice(noticeId) {
    fetch('get_notice.php?id=' + noticeId)
        .then(response => {
            if (!response.ok) {
                return response.json().then(errorData => {
                    throw new Error(errorData.error || 'Failed to fetch notice');
                });
            }
            return response.json();
        })
        .then(notice => {
            if (notice.error) {
                throw new Error(notice.error);
            }
            
            document.getElementById('modalTitle').textContent = notice.title;
            document.getElementById('modalAudience').textContent = notice.audience;
            
            // Set priority badge
            const prioritySpan = document.getElementById('modalPriority');
            prioritySpan.textContent = notice.priority;
            switch(notice.priority) {
                case 'high':
                    prioritySpan.className = 'text-xs font-medium px-2.5 py-0.5 rounded-full ml-2 bg-yellow-100 text-yellow-800';
                    break;
                case 'urgent':
                    prioritySpan.className = 'text-xs font-medium px-2.5 py-0.5 rounded-full ml-2 bg-red-100 text-red-800';
                    break;
                default:
                    prioritySpan.className = 'text-xs font-medium px-2.5 py-0.5 rounded-full ml-2 bg-blue-100 text-blue-800';
            }
            
            document.getElementById('modalContent').innerHTML = notice.content.replace(/\n/g, '<br>');
            document.getElementById('modalAuthor').textContent = notice.author;
            document.getElementById('modalDate').textContent = notice.created_at;
            document.getElementById('modalExpiry').textContent = notice.expiry_date || 'Never';
            
            // Show modal
            document.getElementById('noticeModal').classList.remove('hidden');
        })
        .catch(error => {
            console.error('Error fetching notice:', error);
            alert('Error loading notice details: ' + error.message);
        });
}
// Close modal
function closeModal() {
    document.getElementById('noticeModal').classList.add('hidden');
}

// Initialize audience type on page load if editing
<?php if ($edit_notice): ?>
document.addEventListener('DOMContentLoaded', function() {
    const audienceType = document.getElementById('audienceType');
    if (audienceType) {
        audienceType.dispatchEvent(new Event('change'));
    }
});
<?php endif; ?>
</script>

<?php
include 'include/footer.php';
?>