<?php
include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}
$teacher_id = $_SESSION['user_id'];

// Handle leave approval/disapproval
if (isset($_POST['action']) && isset($_POST['leave_id'])) {
    $leave_id = mysqli_real_escape_string($conn, $_POST['leave_id']);
    $action = mysqli_real_escape_string($conn, $_POST['action']);
    $remarks = isset($_POST['remarks']) ? mysqli_real_escape_string($conn, $_POST['remarks']) : '';
    
    if ($action == 'approve') {
        $status = 'approved';
        $message = "Leave request approved successfully";
    } else {
        $status = 'rejected';
        $message = "Leave request rejected successfully";
    }
    
    $query = "UPDATE teacher_leaves SET status = '$status', approved_by = $teacher_id, approval_date = NOW(), remarks = '$remarks' WHERE id = $leave_id";
    
    if (mysqli_query($conn, $query)) {
        $_SESSION['message'] = $message;
        $_SESSION['message_type'] = "success";
    } else {
        $_SESSION['message'] = "Error updating leave request: " . mysqli_error($conn);
        $_SESSION['message_type'] = "error";
    }
    
    header('Location: leave_management.php');
    exit();
}

// Initialize filter variables
$status_filter = isset($_GET['status_filter']) ? mysqli_real_escape_string($conn, $_GET['status_filter']) : '';
$date_filter = isset($_GET['date_filter']) ? mysqli_real_escape_string($conn, $_GET['date_filter']) : '';
$search = isset($_GET['search']) ? mysqli_real_escape_string($conn, $_GET['search']) : '';

// Build the base query
$base_query = "SELECT tl.*, t.full_name, t.teacher_id 
               FROM teacher_leaves tl 
               JOIN teachers t ON tl.teacher_id = t.id 
               WHERE 1=1";

// Add filters if applied
if (!empty($status_filter)) {
    $base_query .= " AND tl.status = '$status_filter'";
} else {
    // By default, show pending requests
    $base_query .= " AND tl.status = 'pending'";
}

if (!empty($date_filter)) {
    $base_query .= " AND ('$date_filter' BETWEEN tl.start_date AND tl.end_date)";
}

if (!empty($search)) {
    $base_query .= " AND (t.full_name LIKE '%$search%' OR t.teacher_id LIKE '%$search%')";
}

$base_query .= " ORDER BY tl.apply_date DESC";

$result = mysqli_query($conn, $base_query);

// Get leave requests count by status for tabs
$status_counts_query = "SELECT status, COUNT(*) as count FROM teacher_leaves GROUP BY status";
$status_counts_result = mysqli_query($conn, $status_counts_query);
$status_counts = [];
$total_pending = 0;

while ($row = mysqli_fetch_assoc($status_counts_result)) {
    $status_counts[$row['status']] = $row['count'];
    if ($row['status'] == 'pending') {
        $total_pending = $row['count'];
    }
}

ob_end_flush();
?>

<div class="bg-white p-6 rounded-lg shadow-md">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Leave Management</h2>
        <?php if ($total_pending > 0): ?>
            <span class="bg-red-500 text-white px-3 py-1 rounded-full text-sm">
                <?php echo $total_pending; ?> Pending Request(s)
            </span>
        <?php endif; ?>
    </div>

    <?php if (isset($_SESSION['message'])): ?>
        <div class="<?php echo $_SESSION['message_type'] == 'success' ? 'bg-green-100 border-green-400 text-green-700' : 'bg-red-100 border-red-400 text-red-700'; ?> border px-4 py-3 rounded mb-4">
            <?php 
            echo $_SESSION['message']; 
            unset($_SESSION['message']);
            unset($_SESSION['message_type']);
            ?>
        </div>
    <?php endif; ?>

    <!-- Status Tabs -->
    <div class="mb-6 border-b border-gray-200">
        <ul class="flex flex-wrap -mb-px">
            <li class="mr-2">
                <a href="?status_filter=pending" class="<?php echo ($status_filter == '' || $status_filter == 'pending') ? 'border-blue-600 text-blue-600 border-b-2' : 'border-transparent text-gray-500 hover:text-gray-600 hover:border-gray-300'; ?> inline-block py-4 px-4 text-sm font-medium text-center border-b-2">
                    Pending
                    <?php if (isset($status_counts['pending'])): ?>
                        <span class="bg-gray-100 text-gray-800 text-xs font-medium ml-2 px-2.5 py-0.5 rounded-full"><?php echo $status_counts['pending']; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="mr-2">
                <a href="?status_filter=approved" class="<?php echo ($status_filter == 'approved') ? 'border-blue-600 text-blue-600 border-b-2' : 'border-transparent text-gray-500 hover:text-gray-600 hover:border-gray-300'; ?> inline-block py-4 px-4 text-sm font-medium text-center border-b-2">
                    Approved
                    <?php if (isset($status_counts['approved'])): ?>
                        <span class="bg-gray-100 text-gray-800 text-xs font-medium ml-2 px-2.5 py-0.5 rounded-full"><?php echo $status_counts['approved']; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="mr-2">
                <a href="?status_filter=rejected" class="<?php echo ($status_filter == 'rejected') ? 'border-blue-600 text-blue-600 border-b-2' : 'border-transparent text-gray-500 hover:text-gray-600 hover:border-gray-300'; ?> inline-block py-4 px-4 text-sm font-medium text-center border-b-2">
                    Rejected
                    <?php if (isset($status_counts['rejected'])): ?>
                        <span class="bg-gray-100 text-gray-800 text-xs font-medium ml-2 px-2.5 py-0.5 rounded-full"><?php echo $status_counts['rejected']; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="mr-2">
                <a href="?status_filter=" class="<?php echo ($status_filter == 'all') ? 'border-blue-600 text-blue-600 border-b-2' : 'border-transparent text-gray-500 hover:text-gray-600 hover:border-gray-300'; ?> inline-block py-4 px-4 text-sm font-medium text-center border-b-2">
                    All Requests
                </a>
            </li>
        </ul>
    </div>

    <!-- Filter and Search Section -->
    <div class="mb-6 bg-gray-50 p-4 rounded-lg">
        <form method="GET" action="" class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <!-- Status Filter (hidden as we have tabs) -->
            <input type="hidden" name="status_filter" value="<?php echo $status_filter; ?>">
            
            <!-- Date Filter -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Filter by Date</label>
                <input type="date" name="date_filter" value="<?php echo $date_filter; ?>" 
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <!-- Search Input -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Search Teacher</label>
                <input type="text" name="search" value="<?php echo htmlspecialchars($search); ?>" 
                    placeholder="Search by name or ID..." 
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <!-- Buttons -->
            <div class="flex items-end space-x-2">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg flex items-center h-10">
                    <i class="fas fa-filter mr-2"></i> Apply Filters
                </button>
                <a href="leave_management.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg flex items-center h-10">
                    <i class="fas fa-times mr-2"></i> Clear
                </a>
            </div>
        </form>
    </div>

    <!-- Leave Requests Table -->
    <div class="overflow-x-auto">
        <table class="min-w-full bg-white">
            <thead class="bg-gray-200 text-gray-700">
                <tr>
                    <th class="py-3 px-4 text-left">Teacher</th>
                    <th class="py-3 px-4 text-left">Leave Type</th>
                    <th class="py-3 px-4 text-left">Start Date</th>
                    <th class="py-3 px-4 text-left">End Date</th>
                    <th class="py-3 px-4 text-left">Duration</th>
                    <th class="py-3 px-4 text-left">Reason</th>
                    <th class="py-3 px-4 text-left">Status</th>
                    <th class="py-3 px-4 text-left">Apply Date</th>
                    <th class="py-3 px-4 text-left">Actions</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <?php if (mysqli_num_rows($result) > 0): ?>
                    <?php while ($leave = mysqli_fetch_assoc($result)): 
                        $start_date = new DateTime($leave['start_date']);
                        $end_date = new DateTime($leave['end_date']);
                        $duration = $start_date->diff($end_date)->days + 1;
                    ?>
                        <tr class="border-b border-gray-200 hover:bg-gray-50">
                            <td class="py-3 px-4">
                                <div class="font-medium"><?php echo $leave['full_name']; ?></div>
                                <div class="text-sm text-gray-500">ID: <?php echo $leave['teacher_id']; ?></div>
                            </td>
                            <td class="py-3 px-4"><?php echo ucfirst($leave['leave_type']); ?></td>
                            <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($leave['start_date'])); ?></td>
                            <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($leave['end_date'])); ?></td>
                            <td class="py-3 px-4"><?php echo $duration; ?> day(s)</td>
                            <td class="py-3 px-4"><?php echo $leave['reason']; ?></td>
                            <td class="py-3 px-4">
                                <?php if ($leave['status'] == 'pending'): ?>
                                    <span class="bg-yellow-100 text-yellow-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Pending</span>
                                <?php elseif ($leave['status'] == 'approved'): ?>
                                    <span class="bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Approved</span>
                                <?php else: ?>
                                    <span class="bg-red-100 text-red-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Rejected</span>
                                <?php endif; ?>
                            </td>
                            <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($leave['apply_date'])); ?></td>
                            <td class="py-3 px-4">
                                <?php if ($leave['status'] == 'pending'): ?>
                                    <div class="flex space-x-2">
                                        <form method="POST" action="" class="inline">
                                            <input type="hidden" name="leave_id" value="<?php echo $leave['id']; ?>">
                                            <input type="hidden" name="action" value="approve">
                                            <button type="submit" class="bg-green-500 hover:bg-green-600 text-white px-3 py-1 rounded" title="Approve" onclick="return confirm('Approve this leave request?')">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                        <button type="button" onclick="openRejectModal(<?php echo $leave['id']; ?>)" class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded" title="Reject">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                <?php else: ?>
                                    <span class="text-gray-400">Processed</span>
                                    <?php if (!empty($leave['remarks'])): ?>
                                        <br><small class="text-gray-500" title="Remarks: <?php echo $leave['remarks']; ?>">With remarks</small>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="9" class="py-8 px-4 text-center text-gray-500">
                            <?php if (!empty($status_filter) || !empty($date_filter) || !empty($search)): ?>
                                No leave requests found with the current filters.
                            <?php else: ?>
                                No pending leave requests at the moment.
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Reject Modal -->
<div id="rejectModal" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white rounded-lg shadow-xl w-full max-w-md">
        <div class="p-6">
            <h3 class="text-xl font-bold text-gray-800 mb-4">Reject Leave Request</h3>
            <form method="POST" action="">
                <input type="hidden" name="leave_id" id="reject_leave_id">
                <input type="hidden" name="action" value="reject">
                
                <div class="mb-4">
                    <label for="remarks" class="block text-sm font-medium text-gray-700 mb-1">Remarks (Optional)</label>
                    <textarea name="remarks" id="remarks" rows="3" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Add remarks for rejection..."></textarea>
                </div>
                
                <div class="flex justify-end space-x-3">
                    <button type="button" onclick="closeRejectModal()" class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 rounded-lg">
                        Cancel
                    </button>
                    <button type="submit" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-lg">
                        Confirm Reject
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function openRejectModal(leaveId) {
    document.getElementById('reject_leave_id').value = leaveId;
    document.getElementById('rejectModal').classList.remove('hidden');
}

function closeRejectModal() {
    document.getElementById('rejectModal').classList.add('hidden');
    document.getElementById('remarks').value = '';
}

// Close modal when clicking outside
document.getElementById('rejectModal').addEventListener('click', function(e) {
    if (e.target.id === 'rejectModal') {
        closeRejectModal();
    }
});
</script>

<?php
include 'include/footer.php';
mysqli_close($conn);
?>