<?php
// group.php
include 'include/header.php';
include '../config/conn.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$student_id = $_SESSION['user_id'];
$success = '';
$error = '';

// Handle joining/leaving groups
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['join_group'])) {
        $group_id = mysqli_real_escape_string($conn, $_POST['group_id']);
        
        // Check if student is already in the group
        $check_sql = "SELECT * FROM student_groups WHERE student_id = '$student_id' AND group_id = '$group_id'";
        $check_result = mysqli_query($conn, $check_sql);
        
        if (mysqli_num_rows($check_result) > 0) {
            $error = "You are already a member of this group!";
        } else {
            // Join the group
            $join_sql = "INSERT INTO student_groups (student_id, group_id, joined_date) 
                         VALUES ('$student_id', '$group_id', NOW())";
            
            if (mysqli_query($conn, $join_sql)) {
                $success = "Successfully joined the group!";
            } else {
                $error = "Error joining group: " . mysqli_error($conn);
            }
        }
    }
    
    if (isset($_POST['leave_group'])) {
        $group_id = mysqli_real_escape_string($conn, $_POST['group_id']);
        
        // Leave the group
        $leave_sql = "DELETE FROM student_groups WHERE student_id = '$student_id' AND group_id = '$group_id'";
        
        if (mysqli_query($conn, $leave_sql)) {
            $success = "Successfully left the group!";
        } else {
            $error = "Error leaving group: " . mysqli_error($conn);
        }
    }
}

// Fetch all available groups
$groups_sql = "SELECT * FROM groups ORDER BY name";
$groups_result = mysqli_query($conn, $groups_sql);

// Fetch groups the student is currently in
$my_groups_sql = "SELECT g.* FROM groups g 
                  INNER JOIN student_groups sg ON g.id = sg.group_id 
                  WHERE sg.student_id = '$student_id' 
                  ORDER BY g.name";
$my_groups_result = mysqli_query($conn, $my_groups_sql);
$my_groups = array();
while ($row = mysqli_fetch_assoc($my_groups_result)) {
    $my_groups[] = $row['id'];
}
?>

<style>
    .groups-container {
        padding: 20px;
        max-width: 1200px;
        margin: 0 auto;
    }
    
    .page-title {
        color: #2c3e50;
        text-align: center;
        margin-bottom: 30px;
        font-size: 2.5rem;
    }
    
    .section-title {
        color: #3498db;
        border-bottom: 2px solid #3498db;
        padding-bottom: 10px;
        margin-top: 30px;
        margin-bottom: 20px;
        font-size: 1.8rem;
    }
    
    .groups-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
        gap: 20px;
        margin-bottom: 40px;
    }
    
    .group-card {
        background: white;
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        overflow: hidden;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    
    .group-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 16px rgba(0,0,0,0.2);
    }
    
    .group-header {
        padding: 20px;
        text-align: center;
        background: linear-gradient(135deg, #3498db, #2c3e50);
        color: white;
    }
    
    .group-icon {
        font-size: 3rem;
        margin-bottom: 15px;
    }
    
    .group-name {
        font-size: 1.5rem;
        margin: 0;
    }
    
    .group-body {
        padding: 20px;
    }
    
    .group-description {
        color: #7f8c8d;
        margin-bottom: 20px;
        line-height: 1.5;
    }
    
    .group-members {
        display: flex;
        align-items: center;
        color: #7f8c8d;
        margin-bottom: 20px;
    }
    
    .group-members i {
        margin-right: 10px;
    }
    
    .group-actions {
        display: flex;
        justify-content: center;
    }
    
    .btn-join, .btn-leave {
        padding: 10px 20px;
        border: none;
        border-radius: 5px;
        cursor: pointer;
        font-weight: bold;
        transition: background 0.3s ease;
    }
    
    .btn-join {
        background: #2ecc71;
        color: white;
    }
    
    .btn-join:hover {
        background: #27ae60;
    }
    
    .btn-leave {
        background: #e74c3c;
        color: white;
    }
    
    .btn-leave:hover {
        background: #c0392b;
    }
    
    .no-groups {
        text-align: center;
        color: #7f8c8d;
        font-style: italic;
        padding: 30px;
        background: #f9f9f9;
        border-radius: 10px;
    }
    
    .alert {
        padding: 15px;
        margin-bottom: 20px;
        border-radius: 5px;
        text-align: center;
    }
    
    .alert-success {
        background-color: #d4edda;
        color: #155724;
        border: 1px solid #c3e6cb;
    }
    
    .alert-error {
        background-color: #f8d7da;
        color: #721c24;
        border: 1px solid #f5c6cb;
    }
    
    @media (max-width: 768px) {
        .groups-grid {
            grid-template-columns: 1fr;
        }
        
        .page-title {
            font-size: 2rem;
        }
    }
</style>

<div class="groups-container">
    <h1 class="page-title">Student Groups</h1>
    
    <?php if (!empty($success)): ?>
        <div class="alert alert-success"><?php echo $success; ?></div>
    <?php endif; ?>
    
    <?php if (!empty($error)): ?>
        <div class="alert alert-error"><?php echo $error; ?></div>
    <?php endif; ?>
    
    <h2 class="section-title">My Groups</h2>
    <?php if (mysqli_num_rows($my_groups_result) > 0): ?>
        <div class="groups-grid">
            <?php 
            // Reset pointer for my_groups_result
            mysqli_data_seek($my_groups_result, 0);
            while ($group = mysqli_fetch_assoc($my_groups_result)): 
            ?>
                <div class="group-card">
                    <div class="group-header">
                        <div class="group-icon">
                            <i class="<?php echo htmlspecialchars($group['icon']); ?>"></i>
                        </div>
                        <h3 class="group-name"><?php echo htmlspecialchars($group['name']); ?></h3>
                    </div>
                    <div class="group-body">
                        <p class="group-description"><?php echo htmlspecialchars($group['description']); ?></p>
                        <div class="group-members">
                            <i class="fas fa-users"></i>
                            <span><?php echo $group['member_count']; ?> Members</span>
                        </div>
                        <div class="group-actions">
                            <form method="POST">
                                <input type="hidden" name="group_id" value="<?php echo $group['id']; ?>">
                                <button type="submit" name="leave_group" class="btn-leave">Leave Group</button>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>
    <?php else: ?>
        <div class="no-groups">
            <i class="fas fa-users fa-3x" style="margin-bottom: 20px;"></i>
            <p>You haven't joined any groups yet. Explore the available groups below and join ones that interest you!</p>
        </div>
    <?php endif; ?>
    
    <h2 class="section-title">Available Groups</h2>
    <?php if (mysqli_num_rows($groups_result) > 0): ?>
        <div class="groups-grid">
            <?php while ($group = mysqli_fetch_assoc($groups_result)): 
                // Skip groups the student is already in
                if (in_array($group['id'], $my_groups)) continue;
            ?>
                <div class="group-card">
                    <div class="group-header">
                        <div class="group-icon">
                            <i class="<?php echo htmlspecialchars($group['icon']); ?>"></i>
                        </div>
                        <h3 class="group-name"><?php echo htmlspecialchars($group['name']); ?></h3>
                    </div>
                    <div class="group-body">
                        <p class="group-description"><?php echo htmlspecialchars($group['description']); ?></p>
                        <div class="group-members">
                            <i class="fas fa-users"></i>
                            <span><?php echo $group['member_count']; ?> Members</span>
                        </div>
                        <div class="group-actions">
                            <form method="POST">
                                <input type="hidden" name="group_id" value="<?php echo $group['id']; ?>">
                                <button type="submit" name="join_group" class="btn-join">Join Group</button>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>
    <?php else: ?>
        <div class="no-groups">
            <i class="fas fa-exclamation-circle fa-3x" style="margin-bottom: 20px;"></i>
            <p>No groups available at the moment. Please check back later!</p>
        </div>
    <?php endif; ?>
</div>

<?php include 'include/footer.php'; ?>