<?php
session_start();
require_once(__DIR__ . '/../tcpdf/TCPDF-main/tcpdf.php');

// Check if ID card data exists in session
if (!isset($_SESSION['id_card_data']) || empty($_SESSION['id_card_data']['students'])) {
    die("No student data found for ID card generation.");
}

$data = $_SESSION['id_card_data'];
unset($_SESSION['id_card_data']); // Clear the session data

// Create new PDF document
$pdf = new TCPDF('L', 'mm', 'A4', true, 'UTF-8', false);

// Set document information
$pdf->SetCreator('School Management System');
$pdf->SetAuthor('School Admin');
$pdf->SetTitle('Student ID Cards');
$pdf->SetSubject('Student Identification');

// Remove default header/footer
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// Set margins
$pdf->SetMargins(10, 10, 10);

// Set auto page breaks
$pdf->SetAutoPageBreak(true, 10);

// Add a page
$pdf->AddPage();

// Set font
$pdf->SetFont('helvetica', '', 10);

// Define card dimensions
$card_width = 85;
$card_height = 54;
$margin = 5;

// School information
$school_address = "6, Ademuyiwas Lane, Off Ayepe Road, Sagamu, Ogun State";
$school_phone = "+234 08093597160";
$school_email = "info@adinoheightschool.com";
$school_website = "https://www.adinoheightschool.com/";

// Loop through students and generate ID cards
$students = $data['students'];
$count = 0;

foreach ($students as $student) {
    // Add new page if needed (3 rows x 2 columns = 6 cards per page)
    if ($count % 6 == 0 && $count > 0) {
        $pdf->AddPage();
    }
    
    // Calculate position
    $row = floor(($count % 6) / 2);
    $col = $count % 2;
    
    $x = 10 + ($col * ($card_width + $margin));
    $y = 10 + ($row * ($card_height + $margin));
    
    // Draw card border
    $pdf->SetLineStyle(array('width' => 0.2, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(200, 200, 200)));
    $pdf->Rect($x, $y, $card_width, $card_height);
    
    // Add content to the ID card
    // Front of the card
    if ($data['card_type'] == 'front' || $data['card_type'] == 'both') {
        // School logo
        if (!empty($data['school_logo']) && file_exists('../' . $data['school_logo'])) {
            $pdf->Image('../' . $data['school_logo'], $x + 5, $y + 5, 15, 15, '', '', '', false, 300, '', false, false, 0);
        }
        
        // School name
        $pdf->SetFont('helvetica', 'B', 12);
        $pdf->SetXY($x + 25, $y + 5);
        $pdf->Cell(55, 6, 'ADINO HEIGHT SCHOOL', 0, 1, 'C');
        
        $pdf->SetFont('helvetica', 'I', 8);
        $pdf->SetX($x + 25);
        $pdf->Cell(55, 4, 'Excellence in Education', 0, 1, 'C');
        
        // Student photo
        $photo_path = !empty($student['picture']) ? '../' . $student['picture'] : '';
        if (!empty($photo_path) && file_exists($photo_path)) {
            $pdf->Image($photo_path, $x + $card_width - 20, $y + 5, 15, 18, '', '', '', false, 300, '', false, false, 0);
        } else {
            $pdf->SetFillColor(240, 240, 240);
            $pdf->Rect($x + $card_width - 20, $y + 5, 15, 18, 'F');
            $pdf->SetFont('helvetica', '', 6);
            $pdf->SetXY($x + $card_width - 20, $y + 10);
            $pdf->Cell(15, 4, 'NO PHOTO', 0, 0, 'C');
        }
        
        // Student information
        $pdf->SetFont('helvetica', '', 8);
        $pdf->SetXY($x + 5, $y + 25);
        $pdf->Cell(20, 4, 'Name:', 0, 0);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(55, 4, substr($student['full_name'], 0, 30), 0, 1);
        
        $pdf->SetFont('helvetica', '', 8);
        $pdf->SetXY($x + 5, $y + 30);
        $pdf->Cell(20, 4, 'Class:', 0, 0);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(55, 4, $student['class_name'] . ' - ' . $student['section_name'], 0, 1);
        
        $pdf->SetFont('helvetica', '', 8);
        $pdf->SetXY($x + 5, $y + 35);
        $pdf->Cell(20, 4, 'ID:', 0, 0);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(55, 4, $student['student_id'], 0, 1);
        
        $pdf->SetFont('helvetica', '', 8);
        $pdf->SetXY($x + 5, $y + 40);
        $pdf->Cell(25, 4, 'Valid Until:', 0, 0);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(50, 4, date('M Y', strtotime('+1 year')), 0, 1);
        
        // Add a barcode
        $pdf->write1DBarcode($student['student_id'], 'C39', $x + 5, $y + 45, 75, 6, 0.3, array('position' => 'C'));
    }
    
    // If generating both sides, add back of the card on next position
    if ($data['card_type'] == 'both') {
        $count++;
        $row = floor(($count % 6) / 2);
        $col = $count % 2;
        
        $x = 10 + ($col * ($card_width + $margin));
        $y = 10 + ($row * ($card_height + $margin));
        
        // Draw card border
        $pdf->Rect($x, $y, $card_width, $card_height);
        
        // Back of the card content
        $pdf->SetFont('helvetica', 'B', 10);
        $pdf->SetXY($x, $y + 5);
        $pdf->Cell($card_width, 6, 'SCHOOL INFORMATION', 0, 1, 'C');
        
        $pdf->SetFont('helvetica', '', 7);
        $pdf->SetXY($x + 5, $y + 12);
        $pdf->Cell(30, 4, 'Address:', 0, 0);
        $pdf->Cell(45, 4, substr($school_address, 0, 25), 0, 1);
        
        $pdf->SetXY($x + 5, $y + 16);
        $pdf->Cell(30, 4, 'Phone:', 0, 0);
        $pdf->Cell(45, 4, $school_phone, 0, 1);
        
        $pdf->SetXY($x + 5, $y + 20);
        $pdf->Cell(30, 4, 'Email:', 0, 0);
        $pdf->Cell(45, 4, substr($school_email, 0, 25), 0, 1);
        
        $pdf->SetXY($x + 5, $y + 24);
        $pdf->Cell(30, 4, 'Website:', 0, 0);
        $pdf->Cell(45, 4, substr($school_website, 0, 25), 0, 1);
        
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->SetXY($x + 5, $y + 30);
        $pdf->Cell(35, 4, 'Emergency Contact:', 0, 0);
        $pdf->SetFont('helvetica', '', 8);
        $pdf->Cell(40, 4, $school_phone, 0, 1);
        
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->SetXY($x + 5, $y + 34);
        $pdf->Cell(35, 4, 'Blood Group:', 0, 0);
        $pdf->SetFont('helvetica', '', 8);
        $blood_group = !empty($student['blood_group']) ? $student['blood_group'] : 'O+';
        $pdf->Cell(40, 4, $blood_group, 0, 1);
        
        // Signature
        if (!empty($data['authorized_signature']) && file_exists('../' . $data['authorized_signature'])) {
            $pdf->Image('../' . $data['authorized_signature'], $x + 5, $y + 40, 20, 10, '', '', '', false, 300, '', false, false, 0);
        }
        
        $pdf->SetFont('helvetica', '', 6);
        $pdf->SetXY($x + 5, $y + 50);
        $pdf->Cell(20, 3, 'Authorized Signature', 0, 0);
        
        // Barcode on back
        $pdf->write1DBarcode($student['student_id'], 'C39', $x + 50, $y + 40, 30, 10, 0.3, array('position' => 'C'));
    }
    
    $count++;
}

// Output PDF
$pdf->Output('student_id_cards.pdf', 'I');