<?php
include '../config/conn.php';
require '../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

if (!isset($_GET['attendance_date'])) {
    die("No date selected for export.");
}

$attendance_date = $_GET['attendance_date'];

// Fetch teacher attendance
$query = "
    SELECT u.teacher_id, u.full_name, u.email, u.phone, ta.status, ta.recorded_at
    FROM teacher_attendance ta
    JOIN users u ON ta.teacher_id = u.id
    WHERE ta.attendance_date = '$attendance_date'
    ORDER BY u.full_name
";
$result = mysqli_query($conn, $query);

// Create spreadsheet
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Headers
$sheet->setCellValue('A1', 'Teacher ID');
$sheet->setCellValue('B1', 'Full Name');
$sheet->setCellValue('C1', 'Email');
$sheet->setCellValue('D1', 'Phone');
$sheet->setCellValue('E1', 'Status');
$sheet->setCellValue('F1', 'Recorded At');

// Fill data
$row = 2;
while ($teacher = mysqli_fetch_assoc($result)) {
    $sheet->setCellValue('A'.$row, $teacher['teacher_id']);
    $sheet->setCellValue('B'.$row, $teacher['full_name']);
    $sheet->setCellValue('C'.$row, $teacher['email']);
    $sheet->setCellValue('D'.$row, $teacher['phone']);
    $sheet->setCellValue('E'.$row, ucfirst($teacher['status']));
    $sheet->setCellValue('F'.$row, $teacher['recorded_at']);
    $row++;
}

// Export file
$writer = new Xlsx($spreadsheet);
$filename = "Teacher_Attendance_$attendance_date.xlsx";

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("Content-Disposition: attachment; filename=\"$filename\"");
$writer->save("php://output");
exit;
