<?php
include '../config/conn.php';

$export_query = "SELECT s.*, c.class_name, sec.section_name 
                 FROM students s 
                 LEFT JOIN classes c ON s.class = c.id 
                 LEFT JOIN sections sec ON s.section = sec.id 
                 ORDER BY s.created_at DESC";
$result = mysqli_query($conn, $export_query);

header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment; filename="students_export_' . date('Y-m-d') . '.xls"');
header('Pragma: no-cache');
header('Expires: 0');

echo "ID\tStudent ID\tFull Name\tClass\tSection\tRoll Number\tEmail\tPhone\tStatus\tCreated At\n";

while ($student = mysqli_fetch_assoc($result)) {
    echo $student['id'] . "\t";
    echo $student['student_id'] . "\t";
    echo $student['full_name'] . "\t";
    echo $student['class_name'] . "\t";
    echo $student['section_name'] . "\t";
    echo $student['roll_number'] . "\t";
    echo $student['email'] . "\t";
    echo $student['phone'] . "\t";
    echo $student['status'] . "\t";
    echo $student['created_at'] . "\n";
}

mysqli_close($conn);
exit();
?>
