<?php
ob_start();
session_start();
include '../config/conn.php';

// Load PhpSpreadsheet (make sure you ran `composer require phpoffice/phpspreadsheet`)
require __DIR__ . '/../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Check login
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$class_id   = isset($_GET['class_id']) ? intval($_GET['class_id']) : 0;
$section_id = isset($_GET['section_id']) ? intval($_GET['section_id']) : 0;
$month      = isset($_GET['month']) ? $_GET['month'] : date('Y-m'); // format YYYY-MM

if ($class_id <= 0 || $section_id <= 0) {
    die("Class and section required");
}

// Fetch class and section name
$class_name   = '';
$section_name = '';

$res = mysqli_query($conn, "SELECT class_name FROM classes WHERE id=$class_id");
if ($res && mysqli_num_rows($res) > 0) {
    $class_name = mysqli_fetch_assoc($res)['class_name'];
}

$res = mysqli_query($conn, "SELECT section_name FROM sections WHERE id=$section_id");
if ($res && mysqli_num_rows($res) > 0) {
    $section_name = mysqli_fetch_assoc($res)['section_name'];
}

// Fetch attendance for the month
$query = "
    SELECT s.roll_number, s.student_id, s.full_name, a.attendance_date, a.status, a.recorded_at
    FROM students s
    LEFT JOIN attendance a 
        ON s.id = a.student_id 
        AND DATE_FORMAT(a.attendance_date, '%Y-%m') = '$month'
        AND a.class_id = $class_id 
        AND a.section_id = $section_id
    WHERE s.class = $class_id 
      AND s.section = $section_id 
      AND s.status = 'active'
    ORDER BY s.roll_number, a.attendance_date
";

$result = mysqli_query($conn, $query);

// Prepare spreadsheet
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$sheet->setTitle("Attendance $month");

// Headers
$sheet->setCellValue("A1", "Roll No");
$sheet->setCellValue("B1", "Student ID");
$sheet->setCellValue("C1", "Full Name");
$sheet->setCellValue("D1", "Date");
$sheet->setCellValue("E1", "Status");
$sheet->setCellValue("F1", "Time Recorded");

// Fill data
$row = 2;
if ($result && mysqli_num_rows($result) > 0) {
    while ($data = mysqli_fetch_assoc($result)) {
        $sheet->setCellValue("A{$row}", $data['roll_number']);
        $sheet->setCellValue("B{$row}", $data['student_id']);
        $sheet->setCellValue("C{$row}", $data['full_name']);
        $sheet->setCellValue("D{$row}", $data['attendance_date']);
        $sheet->setCellValue("E{$row}", ucfirst($data['status']));
        $sheet->setCellValue("F{$row}", $data['recorded_at']);
        $row++;
    }
} else {
    $sheet->setCellValue("A2", "No records found for $month");
}

// Download as Excel
$filename = "Attendance_{$class_name}_{$section_name}_{$month}.xlsx";
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("Content-Disposition: attachment; filename=\"$filename\"");
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;
?>
