<?php
include 'include/header.php';
include '../config/conn.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$admin_id = $_SESSION['user_id'];
$admin_name = $_SESSION['user_name'];

$success = '';
$error = '';

// Fetch classes from database
$classes = [];
$class_query = "SELECT `id`, `class_name` FROM `classes` WHERE `status` = 'active'";
$class_result = mysqli_query($conn, $class_query);
if ($class_result && mysqli_num_rows($class_result) > 0) {
    while ($row = mysqli_fetch_assoc($class_result)) {
        $classes[$row['id']] = $row['class_name'];
    }
}

// Fetch sections from database
$sections = [];
$section_query = "SELECT `id`, `section_name`, `class_id` FROM `sections` WHERE `status` = 'active'";
$section_result = mysqli_query($conn, $section_query);
if ($section_result && mysqli_num_rows($section_result) > 0) {
    while ($row = mysqli_fetch_assoc($section_result)) {
        if (!isset($sections[$row['class_id']])) {
            $sections[$row['class_id']] = [];
        }
        $sections[$row['class_id']][$row['id']] = $row['section_name'];
    }
}

// Fetch parents from database
$parents = [];
$parent_query = "SELECT `id`, `fullname`, `username`, `email` FROM `parents` ORDER BY `fullname`";
$parent_result = mysqli_query($conn, $parent_query);
if ($parent_result && mysqli_num_rows($parent_result) > 0) {
    while ($row = mysqli_fetch_assoc($parent_result)) {
        $parents[$row['id']] = $row['fullname'] . ' (' . $row['email'] . ')';
    }
}

// Get student ID from URL
$student_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Fetch student data if we have a valid ID
$student = null;
if ($student_id > 0) {
    $sql = "SELECT * FROM students WHERE id = '$student_id'";
    $result = mysqli_query($conn, $sql);
    
    if (mysqli_num_rows($result) > 0) {
        $student = mysqli_fetch_assoc($result);
    } else {
        $error = "Student not found with ID: $student_id";
        $student_id = 0; // Reset to indicate invalid student
    }
} else {
    $error = "Invalid student ID";
}

// Function to safely get POST values
function getPostValue($key, $default = '') {
    return isset($_POST[$key]) ? mysqli_real_escape_string($GLOBALS['conn'], $_POST[$key]) : $default;
}

// Function to check if email already exists (excluding current student)
function emailExists($email, $conn, $exclude_id) {
    $email = mysqli_real_escape_string($conn, $email);
    $exclude_id = mysqli_real_escape_string($conn, $exclude_id);
    $sql = "SELECT id FROM students WHERE email = '$email' AND id != '$exclude_id'";
    $result = mysqli_query($conn, $sql);
    return mysqli_num_rows($result) > 0;
}

// Function to check if username already exists (excluding current student)
function usernameExists($username, $conn, $exclude_id) {
    $username = mysqli_real_escape_string($conn, $username);
    $exclude_id = mysqli_real_escape_string($conn, $exclude_id);
    $sql = "SELECT id FROM students WHERE username = '$username' AND id != '$exclude_id'";
    $result = mysqli_query($conn, $sql);
    return mysqli_num_rows($result) > 0;
}

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST' && $student_id > 0) {
    // Handle form submission using the safe function
    $fullName = getPostValue('fullName', $student['full_name']);
    $username = getPostValue('username', $student['username']);
    $dob = getPostValue('dob', $student['dob']);
    $gender = getPostValue('gender', $student['gender']);
    $nationality = getPostValue('nationality', $student['nationality']);
    $idNumber = getPostValue('idNumber', $student['id_number']);
    $address = getPostValue('address', $student['address']);
    $phone = getPostValue('phone', $student['phone']);
    $email = getPostValue('email', $student['email']);
    $emergencyContact = getPostValue('emergencyContact', $student['emergency_contact']);
    $emergencyPhone = getPostValue('emergencyPhone', $student['emergency_phone']);
    $admissionDate = getPostValue('admissionDate', $student['admission_date']);
    $class = getPostValue('class', $student['class']);
    $section = getPostValue('section', $student['section']);
    $rollNumber = getPostValue('rollNumber', $student['roll_number']);
    $previousSchool = getPostValue('previousSchool', $student['previous_school']);
    $previousGrades = getPostValue('previousGrades', $student['previous_grades']);
    $medicalConditions = getPostValue('medicalConditions', $student['medical_conditions']);
    $allergies = getPostValue('allergies', $student['allergies']);
    $bloodGroup = getPostValue('bloodGroup', $student['blood_group']);
    $parent_id = getPostValue('parent_id', $student['parent_id']);
    
    // Handle password change (optional)
    $password = getPostValue('password');
    $confirm_password = getPostValue('confirm_password');
    
    // Validate required fields
    if (empty($fullName) || empty($username) || empty($dob) || empty($gender) || 
        empty($address) || empty($phone) || empty($email) || empty($admissionDate) || 
        empty($class) || empty($section) || empty($rollNumber) || empty($parent_id)) {
        $error = "Please fill in all required fields.";
    } 
    // Check if passwords match (if provided)
    else if (!empty($password) && $password !== $confirm_password) {
        $error = "Passwords do not match.";
    }
    // Check if email already exists (excluding current student)
    else if (emailExists($email, $conn, $student_id)) {
        $error = "Another student with this email address already exists. Please use a different email.";
    }
    // Check if username already exists (excluding current student)
    else if (usernameExists($username, $conn, $student_id)) {
        $error = "Username already exists. Please choose a different username.";
    }
    else {
        // Handle file upload
        $photoPath = $student['photo']; // Keep existing photo by default
        
        if (isset($_FILES['photo']) && $_FILES['photo']['error'] == 0) {
            $targetDir = "../uploads/";
            if (!is_dir($targetDir)) {
                mkdir($targetDir, 0777, true);
            }
            
            $fileName = time() . '_' . basename($_FILES['photo']['name']);
            $targetFilePath = $targetDir . $fileName;
            $fileType = pathinfo($targetFilePath, PATHINFO_EXTENSION);
            
            // Allow certain file formats
            $allowTypes = array('jpg', 'png', 'jpeg', 'gif');
            if (in_array($fileType, $allowTypes)) {
                if (move_uploaded_file($_FILES['photo']['tmp_name'], $targetFilePath)) {
                    // Delete old photo if it exists
                    if (!empty($student['photo']) && file_exists($student['photo'])) {
                        unlink($student['photo']);
                    }
                    $photoPath = $targetFilePath;
                }
            }
        }
        
        // Prepare SQL query
        $sql = "UPDATE students SET
            username = '$username', 
            full_name = '$fullName', 
            dob = '$dob', 
            gender = '$gender', 
            nationality = '$nationality', 
            id_number = '$idNumber', 
            photo = '$photoPath', 
            address = '$address', 
            phone = '$phone', 
            email = '$email', 
            emergency_contact = '$emergencyContact', 
            emergency_phone = '$emergencyPhone', 
            admission_date = '$admissionDate', 
            class = '$class', 
            section = '$section', 
            roll_number = '$rollNumber', 
            previous_school = '$previousSchool', 
            previous_grades = '$previousGrades', 
            medical_conditions = '$medicalConditions', 
            allergies = '$allergies', 
            blood_group = '$bloodGroup', 
            parent_id = '$parent_id', 
            updated_at = NOW()";
        
        // Add password update if provided
        if (!empty($password)) {
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $sql .= ", password = '$hashed_password'";
        }
        
        $sql .= " WHERE id = '$student_id'";
        
        if (mysqli_query($conn, $sql)) {
            $success = "Student information updated successfully! (Updated by " . $admin_name . " at " . date('Y-m-d H:i:s') . ")";
            
            // Refresh student data
            $result = mysqli_query($conn, "SELECT * FROM students WHERE id = '$student_id'");
            if (mysqli_num_rows($result) > 0) {
                $student = mysqli_fetch_assoc($result);
            }
        } else {
            $error = "Error updating student: " . mysqli_error($conn);
        }
    }
}
?>

<style>
    .bg-white {
        background-color: white;
    }
    .p-6 {
        padding: 1.5rem;
    }
  
   
    .text-2xl {
        font-size: 1.5rem;
    }
    .font-bold {
        font-weight: 700;
    }
    .text-gray-800 {
        color: #2d3748;
    }
    .mb-6 {
        margin-bottom: 1.5rem;
    }
    .grid {
        display: grid;
    }
    .grid-cols-1 {
        grid-template-columns: repeat(1, minmax(0, 1fr));
    }
    .md\:grid-cols-2 {
        grid-template-columns: repeat(2, minmax(0, 1fr));
    }
    .gap-6 {
        gap: 1.5rem;
    }
    .block {
        display: block;
    }
    .text-gray-700 {
        color: #4a5568;
    }
    .mb-2 {
        margin-bottom: 0.5rem;
    }
    .w-full {
        width: 100%;
    }
    .px-4 {
        padding-left: 1rem;
        padding-right: 1rem;
    }
    .py-2 {
        padding-top: 0.5rem;
        padding-bottom: 0.5rem;
    }
   
    .focus\:outline-none:focus {
        outline: none;
    }
    .focus\:ring-2:focus {
        box-shadow: 0 0 0 2px rgba(66, 153, 225, 0.5);
    }
    .focus\:ring-blue-500:focus {
        --tw-ring-color: #4299e1;
    }
    .md\:col-span-2 {
        grid-column: span 2 / span 2;
    }
    .flex {
        display: flex;
    }
    .justify-end {
        justify-content: flex-end;
    }
    .space-x-4 > * + * {
        margin-left: 1rem;
    }
    .mt-4 {
        margin-top: 1rem;
    }
    .bg-gray-500 {
        background-color: #6b7280;
    }
    .hover\:bg-gray-600:hover {
        background-color: #4b5563;
    }
    .text-white {
        color: white;
    }
    .px-6 {
        padding-left: 1.5rem;
        padding-right: 1.5rem;
    }
    .py-2 {
        padding-top: 0.5rem;
        padding-bottom: 0.5rem;
    }
    . {
        border-radius: 0.5rem;
    }
    .bg-blue-600 {
        background-color: #2563eb;
    }
    .hover\:bg-blue-700:hover {
        background-color: #1d4ed8;
    }
    .relative {
        position: relative;
    }
    .w-32 {
        width: 8rem;
    }
    .h-32 {
        height: 8rem;
    }
   
    .overflow-hidden {
        overflow: hidden;
    }
    .border-4 {
        border-width: 4px;
    }
    .border-gray-300 {
        border-color: #d1d5db;
    }
  
    .bg-gray-200 {
        background-color: #e5e7eb;
    }
    .hover\:bg-gray-300:hover {
        background-color: #d1d5db;
    }
    .text-gray-800 {
        color: #2d3748;
    }
    .mr-2 {
        margin-right: 0.5rem;
    }
    .bg-red-100 {
        background-color: #fed7d7;
    }
    .border-red-400 {
        border-color: #f56565;
    }
    .text-red-700 {
        color: #c53030;
    }
    .px-4 {
        padding-left: 1rem;
        padding-right: 1rem;
    }
    .py-3 {
        padding-top: 0.75rem;
        padding-bottom: 0.75rem;
    }
   
    .mb-4 {
        margin-bottom: 1rem;
    }
    .bg-yellow-100 {
        background-color: #feebc8;
    }
    .border-yellow-400 {
        border-color: #f6ad55;
    }
    .text-yellow-700 {
        color: #b7791f;
    }
    .flex-col {
        flex-direction: column;
    }
    .items-center {
        align-items: center;
    }
    .object-cover {
        object-fit: cover;
    }
    .text-4xl {
        font-size: 2.25rem;
    }
    .text-gray-400 {
        color: #9ca3af;
    }
    
    /* Additional styles for form layout */
    .form-section {
        margin-bottom: 25px;
        padding-bottom: 20px;
        border-bottom: 1px solid #eaeaea;
    }
    
  
    .section-title i {
        margin-right: 10px;
    }
    
    .form-row {
        display: flex;
        flex-wrap: wrap;
        margin: 0 -10px 15px;
    }
    
    .form-group {
        flex: 1 0 300px;
        padding: 0 10px;
        margin-bottom: 15px;
    }
    
    .required::after {
        content: " *";
        color: #e22;
    }
    
    .photo-upload {
        display: flex;
        flex-direction: column;
        align-items: center;
        margin-top: 10px;
    }
    
    .photo-preview {
        width: 120px;
        height: 120px;
        border: 2px dashed #d1d5db;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 15px;
        overflow: hidden;
    }
    
    .photo-preview img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        display: none;
    }
    
    .upload-btn {
        background: #eff6ff;
        color: #2563eb;
        border: 1px solid #2563eb;
        padding: 8px 20px;
        border-radius: 5px;
        cursor: pointer;
        transition: all 0.3s;
    }
    
    .upload-btn:hover {
        background: #2563eb;
        color: white;
    }
    
    .alert {
        padding: 15px;
        margin: 20px 0;
        border-radius: 5px;
        text-align: center;
    }
    
    .alert-success {
        background-color: #d1fae5;
        color: #065f46;
        border: 1px solid #a7f3d0;
    }
    
    .alert-error {
        background-color: #fee2e2;
        color: #991b1b;
        border: 1px solid #fecaca;
    }
    
    
    
    @media (max-width: 768px) {
        .form-group {
            flex: 1 0 100%;
        }
    }
</style>

<div class="bg-white p-6  ">
    <h2 class="text-2xl font-bold text-gray-800 mb-6">
        Edit Student 
        <?php if ($student_id > 0): ?>
            <span class="student-id-badge">ID: <?php echo $student_id; ?></span>
        <?php endif; ?>
    </h2>
    
    <?php if (!empty($success)): ?>
        <div class="alert alert-success"><?php echo $success; ?></div>
    <?php endif; ?>
    
    <?php if (!empty($error)): ?>
        <div class="alert alert-error"><?php echo $error; ?></div>
    <?php endif; ?>
    
    <?php if ($student_id === 0): ?>
        <div class="alert alert-error">Cannot edit student. Invalid student ID provided.</div>
    <?php else: ?>
        <form id="studentForm" method="POST" enctype="multipart/form-data" class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Photo Upload Section -->
            <div class="md:col-span-2 flex flex-col items-center mb-4">
                <div class="relative w-32 h-32 rounded-full overflow-hidden border-4 border-gray-300 mb-4">
                    <?php if (!empty($student['photo'])): ?>
                        <img id="previewImg" src="<?php echo htmlspecialchars($student['photo']); ?>" alt="Student Photo" class="w-full h-full object-cover">
                    <?php else: ?>
                        <img id="previewImg" src="" alt="Student Photo" class="w-full h-full object-cover hidden">
                        <div id="placeholder" class="w-full h-full bg-gray-200 flex items-center justify-center">
                            <i class="fas fa-user text-gray-400 text-4xl"></i>
                        </div>
                    <?php endif; ?>
                </div>
                <input type="file" id="photo" name="photo" accept="image/*" class="hidden" onchange="previewImage()">
                <button type="button" onclick="document.getElementById('photo').click()" class="bg-gray-200 hover:bg-gray-300 text-gray-800 px-4 py-2 rounded">
                    <i class="fas fa-upload mr-2"></i> Change Photo
                </button>
            </div>
            
            <!-- Account Information Section -->
            <div class="md:col-span-2">
                <div class="section-title">
                    <i class="fas fa-user-circle"></i> Account Information
                </div>
            </div>
            
            <div class="form-group">
                <label for="username" class="block text-gray-700 mb-2 required">Username</label>
                <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($student['username']); ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="password" class="block text-gray-700 mb-2">New Password (leave blank to keep current)</label>
                <input type="password" id="password" name="password" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" onkeyup="validatePassword()">
            </div>
            
            <div class="form-group">
                <label for="confirm_password" class="block text-gray-700 mb-2">Confirm New Password</label>
                <input type="password" id="confirm_password" name="confirm_password" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" onkeyup="validatePassword()">
                <p id="passwordMessage" class="text-red-500 text-sm mt-1 hidden">Passwords do not match</p>
            </div>
            
            <div class="form-group">
                <label for="parent_id" class="block text-gray-700 mb-2 required">Select Parent</label>
                <select id="parent_id" name="parent_id" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    <option value="">Select Parent</option>
                    <?php foreach ($parents as $id => $name): ?>
                        <option value="<?php echo $id; ?>" <?php echo ($student['parent_id'] == $id) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($name); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <!-- Personal Information Section -->
            <div class="md:col-span-2">
                <div class="section-title">
                    <i class="fas fa-user"></i> Personal Information
                </div>
            </div>
            
            <div class="form-group">
                <label for="fullName" class="block text-gray-700 mb-2 required">Full Name</label>
                <input type="text" id="fullName" name="fullName" value="<?php echo htmlspecialchars($student['full_name']); ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="dob" class="block text-gray-700 mb-2 required">Date of Birth</label>
                <input type="date" id="dob" name="dob" value="<?php echo htmlspecialchars($student['dob']); ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="gender" class="block text-gray-700 mb-2 required">Gender</label>
                <select id="gender" name="gender" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    <option value="">Select Gender</option>
                    <option value="male" <?php echo ($student['gender'] == 'male') ? 'selected' : ''; ?>>Male</option>
                    <option value="female" <?php echo ($student['gender'] == 'female') ? 'selected' : ''; ?>>Female</option>
                    <option value="other" <?php echo ($student['gender'] == 'other') ? 'selected' : ''; ?>>Other</option>
                </select>
            </div>
            
            <div class="form-group">
                <label for="nationality" class="block text-gray-700 mb-2">Nationality</label>
                <input type="text" id="nationality" name="nationality" value="<?php echo htmlspecialchars($student['nationality']); ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <div class="form-group">
                <label for="idNumber" class="block text-gray-700 mb-2">Government ID Number</label>
                <input type="text" id="idNumber" name="idNumber" value="<?php echo htmlspecialchars($student['id_number']); ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <!-- Contact Information Section -->
            <div class="md:col-span-2">
                <div class="section-title">
                    <i class="fas fa-address-book"></i> Contact Information
                </div>
            </div>
            
            <div class="md:col-span-2 form-group">
                <label for="address" class="block text-gray-700 mb-2 required">Residential Address</label>
                <textarea id="address" name="address" rows="3" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required><?php echo htmlspecialchars($student['address']); ?></textarea>
            </div>
            
            <div class="form-group">
                <label for="phone" class="block text-gray-700 mb-2 required">Phone Number</label>
                <input type="tel" id="phone" name="phone" value="<?php echo htmlspecialchars($student['phone']); ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="email" class="block text-gray-700 mb-2 required">Email Address</label>
                <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($student['email']); ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="emergencyContact" class="block text-gray-700 mb-2">Emergency Contact Person</label>
                <input type="text" id="emergencyContact" name="emergencyContact" value="<?php echo htmlspecialchars($student['emergency_contact']); ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <div class="form-group">
                <label for="emergencyPhone" class="block text-gray-700 mb-2">Emergency Contact Phone</label>
                <input type="tel" id="emergencyPhone" name="emergencyPhone" value="<?php echo htmlspecialchars($student['emergency_phone']); ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <!-- Academic Information Section -->
            <div class="md:col-span-2">
                <div class="section-title">
                    <i class="fas fa-graduation-cap"></i> Academic Information
                </div>
            </div>
            
            <div class="form-group">
                <label for="admissionDate" class="block text-gray-700 mb-2 required">Admission Date</label>
                <input type="date" id="admissionDate" name="admissionDate" value="<?php echo htmlspecialchars($student['admission_date']); ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="class" class="block text-gray-700 mb-2 required">Class</label>
                <select id="class" name="class" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    <option value="">Select Class</option>
                    <?php foreach ($classes as $id => $name): ?>
                        <option value="<?php echo $id; ?>" <?php echo ($student['class'] == $id) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($name); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="form-group">
                <label for="section" class="block text-gray-700 mb-2 required">Section</label>
                <select id="section" name="section" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    <option value="">Select Section</option>
                    <?php 
                    // Show sections based on student's class
                    if (isset($student['class']) && isset($sections[$student['class']])) {
                        foreach ($sections[$student['class']] as $id => $name) {
                            $selected = ($student['section'] == $id) ? 'selected' : '';
                            echo "<option value='$id' $selected>" . htmlspecialchars($name) . "</option>";
                        }
                    }
                    ?>
                </select>
            </div>
            
            <div class="form-group">
                <label for="rollNumber" class="block text-gray-700 mb-2 required">Roll Number</label>
                <input type="text" id="rollNumber" name="rollNumber" value="<?php echo htmlspecialchars($student['roll_number']); ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="previousSchool" class="block text-gray-700 mb-2">Previous School (if any)</label>
                <input type="text" id="previousSchool" name="previousSchool" value="<?php echo htmlspecialchars($student['previous_school']); ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <div class="form-group">
                <label for="previousGrades" class="block text-gray-700 mb-2">Previous Grades/Percentage</label>
                <input type="text" id="previousGrades" name="previousGrades" value="<?php echo htmlspecialchars($student['previous_grades']); ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <!-- Medical Information Section -->
            <div class="md:col-span-2">
                <div class="section-title">
                    <i class="fas fa-heartbeat"></i> Medical Information
                </div>
            </div>
            
            <div class="md:col-span-2 form-group">
                <label for="medicalConditions" class="block text-gray-700 mb-2">Medical Conditions</label>
                <textarea id="medicalConditions" name="medicalConditions" rows="2" placeholder="e.g., Asthma, Diabetes" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500"><?php echo htmlspecialchars($student['medical_conditions']); ?></textarea>
            </div>
            
            <div class="form-group">
                <label for="allergies" class="block text-gray-700 mb-2">Allergies</label>
                <input type="text" id="allergies" name="allergies" placeholder="e.g., Peanuts, Dust" value="<?php echo htmlspecialchars($student['allergies']); ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <div class="form-group">
                <label for="bloodGroup" class="block text-gray-700 mb-2">Blood Group</label>
                <select id="bloodGroup" name="bloodGroup" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Select Blood Group</option>
                    <option value="A+" <?php echo ($student['blood_group'] == 'A+') ? 'selected' : ''; ?>>A+</option>
                    <option value="A-" <?php echo ($student['blood_group'] == 'A-') ? 'selected' : ''; ?>>A-</option>
                    <option value="B+" <?php echo ($student['blood_group'] == 'B+') ? 'selected' : ''; ?>>B+</option>
                    <option value="B-" <?php echo ($student['blood_group'] == 'B-') ? 'selected' : ''; ?>>B-</option>
                    <option value="AB+" <?php echo ($student['blood_group'] == 'AB+') ? 'selected' : ''; ?>>AB+</option>
                    <option value="AB-" <?php echo ($student['blood_group'] == 'AB-') ? 'selected' : ''; ?>>AB-</option>
                    <option value="O+" <?php echo ($student['blood_group'] == 'O+') ? 'selected' : ''; ?>>O+</option>
                    <option value="O-" <?php echo ($student['blood_group'] == 'O-') ? 'selected' : ''; ?>>O-</option>
                </select>
            </div>
            
            <div class="md:col-span-2 flex justify-end space-x-4 mt-4">
                <a href="view_student.php" class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-2 ">Cancel</a>
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 ">
                    Update Student
                </button>
            </div>
        </form>
    <?php endif; ?>
</div>

<script>
    // Photo preview functionality
    function previewImage() {
        const file = document.getElementById('photo').files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                const previewImg = document.getElementById('previewImg');
                previewImg.src = e.target.result;
                previewImg.classList.remove('hidden');
                const placeholder = document.getElementById('placeholder');
                if (placeholder) placeholder.classList.add('hidden');
            }
            reader.readAsDataURL(file);
        }
    }
    
    // Dynamic section loading based on class selection
    document.getElementById('class').addEventListener('change', function() {
        const classId = this.value;
        const sectionSelect = document.getElementById('section');
        
        // Clear existing options
        sectionSelect.innerHTML = '<option value="">Select Section</option>';
        
        if (classId) {
            // AJAX request to fetch sections for the selected class
            const xhr = new XMLHttpRequest();
            xhr.open('POST', 'get_sections.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onreadystatechange = function() {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    try {
                        const sections = JSON.parse(xhr.responseText);
                        if (sections.length > 0) {
                            sections.forEach(function(section) {
                                const option = document.createElement('option');
                                option.value = section.id;
                                option.textContent = section.name;
                                sectionSelect.appendChild(option);
                            });
                            
                            // Try to select the student's current section
                            <?php if (isset($student['section'])): ?>
                                setTimeout(function() {
                                    sectionSelect.value = '<?php echo $student["section"]; ?>';
                                }, 100);
                            <?php endif; ?>
                        } else {
                            const option = document.createElement('option');
                            option.value = '';
                            option.textContent = 'No sections available';
                            sectionSelect.appendChild(option);
                        }
                    } catch (e) {
                        console.error('Error parsing sections:', e);
                    }
                }
            };
            xhr.send('class_id=' + classId);
        }
    });

    // Password validation
    function validatePassword() {
        const password = document.getElementById('password').value;
        const confirmPassword = document.getElementById('confirm_password').value;
        const message = document.getElementById('passwordMessage');
        
        if (password !== confirmPassword && confirmPassword !== '') {
            message.classList.remove('hidden');
        } else {
            message.classList.add('hidden');
        }
    }
    
    // Add event listeners for password validation
    document.getElementById('password').addEventListener('keyup', validatePassword);
    document.getElementById('confirm_password').addEventListener('keyup', validatePassword);
    
    // Form validation before submission
    document.getElementById('studentForm').addEventListener('submit', function(e) {
        const password = document.getElementById('password').value;
        const confirmPassword = document.getElementById('confirm_password').value;
        
        if (password !== confirmPassword) {
            e.preventDefault();
            alert('Passwords do not match. Please correct and try again.');
            return false;
        }
    });
</script>

<?php include 'include/footer.php'; ?>