<?php
include 'include/header.php';
include '../config/conn.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$admin_id = $_SESSION['user_id'];
$admin_name = $_SESSION['user_name'];

$success = '';
$error = '';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Add Class
    if (isset($_POST['add_class'])) {
        $class_name = mysqli_real_escape_string($conn, $_POST['class_name']);
        
        if (empty($class_name)) {
            $error = "Class name is required";
        } else {
            $check_query = "SELECT * FROM classes WHERE class_name='$class_name'";
            $check_result = mysqli_query($conn, $check_query);
            
            if (mysqli_num_rows($check_result) > 0) {
                $error = "This class already exists";
            } else {
                $insert_query = "INSERT INTO classes (class_name, created_by) 
                                VALUES ('$class_name', '$admin_id')";
                
                if (mysqli_query($conn, $insert_query)) {
                    $success = "Class added successfully!";
                } else {
                    $error = "Error: " . mysqli_error($conn);
                }
            }
        }
    }
    
    // Add Section
    if (isset($_POST['add_section'])) {
        $section_name = mysqli_real_escape_string($conn, $_POST['section_name']);
        $class_id = mysqli_real_escape_string($conn, $_POST['class_id']);
        $capacity = mysqli_real_escape_string($conn, $_POST['capacity']);
        $room_number = mysqli_real_escape_string($conn, $_POST['room_number']);
        $section_teacher_id = mysqli_real_escape_string($conn, $_POST['section_teacher_id']);
        
        if (empty($section_name) || empty($class_id) || empty($capacity)) {
            $error = "Please fill in all required fields";
        } else {
            $check_query = "SELECT * FROM sections WHERE section_name='$section_name' AND class_id='$class_id'";
            $check_result = mysqli_query($conn, $check_query);
            
            if (mysqli_num_rows($check_result) > 0) {
                $error = "This section already exists for the selected class";
            } else {
                $insert_query = "INSERT INTO sections (section_name, class_id, capacity, room_number, section_teacher_id, created_by) 
                                VALUES ('$section_name', '$class_id', '$capacity', '$room_number', '$section_teacher_id', '$admin_id')";
                
                if (mysqli_query($conn, $insert_query)) {
                    $success = "Section added successfully!";
                } else {
                    $error = "Error: " . mysqli_error($conn);
                }
            }
        }
    }
    
    // Assign Class Teacher
    if (isset($_POST['assign_class_teacher'])) {
        $class_id = mysqli_real_escape_string($conn, $_POST['class_id']);
        $teacher_id = mysqli_real_escape_string($conn, $_POST['teacher_id']);
        
        // ensure selected teacher is actually a teacher
        $teacher_check = mysqli_query($conn, "SELECT id FROM users WHERE id='$teacher_id' AND role='teacher'");
        if (mysqli_num_rows($teacher_check) == 0) {
            $error = "Invalid teacher selected.";
        } elseif (empty($class_id) || empty($teacher_id)) {
            $error = "Please select both class and teacher";
        } else {
            $update_query = "UPDATE classes SET class_teacher_id='$teacher_id' WHERE id='$class_id'";
            
            if (mysqli_query($conn, $update_query)) {
                $success = "Class teacher assigned successfully!";
            } else {
                $error = "Error: " . mysqli_error($conn);
            }
        }
    }
    
    // Assign Section Teacher
    if (isset($_POST['assign_section_teacher'])) {
        $section_id = mysqli_real_escape_string($conn, $_POST['section_id']);
        $teacher_id = mysqli_real_escape_string($conn, $_POST['teacher_id']);
        
        // ensure selected teacher is actually a teacher
        $teacher_check = mysqli_query($conn, "SELECT id FROM users WHERE id='$teacher_id' AND role='teacher'");
        if (mysqli_num_rows($teacher_check) == 0) {
            $error = "Invalid teacher selected.";
        } elseif (empty($section_id) || empty($teacher_id)) {
            $error = "Please select both section and teacher";
        } else {
            $update_query = "UPDATE sections SET section_teacher_id='$teacher_id' WHERE id='$section_id'";
            
            if (mysqli_query($conn, $update_query)) {
                $success = "Section teacher assigned successfully!";
            } else {
                $error = "Error: " . mysqli_error($conn);
            }
        }
    }
    
    // Edit Class
    if (isset($_POST['edit_class'])) {
        $class_id = mysqli_real_escape_string($conn, $_POST['class_id']);
        $class_name = mysqli_real_escape_string($conn, $_POST['class_name']);
        
        if (empty($class_name)) {
            $error = "Class name is required";
        } else {
            $check_query = "SELECT * FROM classes WHERE class_name='$class_name' AND id != '$class_id'";
            $check_result = mysqli_query($conn, $check_query);
            
            if (mysqli_num_rows($check_result) > 0) {
                $error = "This class name already exists";
            } else {
                $update_query = "UPDATE classes SET class_name='$class_name' WHERE id='$class_id'";
                
                if (mysqli_query($conn, $update_query)) {
                    $success = "Class updated successfully!";
                } else {
                    $error = "Error: " . mysqli_error($conn);
                }
            }
        }
    }
    
    // Edit Section
    if (isset($_POST['edit_section'])) {
        $section_id = mysqli_real_escape_string($conn, $_POST['section_id']);
        $section_name = mysqli_real_escape_string($conn, $_POST['section_name']);
        $class_id = mysqli_real_escape_string($conn, $_POST['class_id']);
        $capacity = mysqli_real_escape_string($conn, $_POST['capacity']);
        $room_number = mysqli_real_escape_string($conn, $_POST['room_number']);
        $section_teacher_id = mysqli_real_escape_string($conn, $_POST['section_teacher_id']);
        
        if (empty($section_name) || empty($class_id) || empty($capacity)) {
            $error = "Please fill in all required fields";
        } else {
            $check_query = "SELECT * FROM sections WHERE section_name='$section_name' AND class_id='$class_id' AND id != '$section_id'";
            $check_result = mysqli_query($conn, $check_query);
            
            if (mysqli_num_rows($check_result) > 0) {
                $error = "This section already exists for the selected class";
            } else {
                $update_query = "UPDATE sections 
                                SET section_name='$section_name', class_id='$class_id', 
                                    capacity='$capacity', room_number='$room_number', 
                                    section_teacher_id='$section_teacher_id' 
                                WHERE id='$section_id'";
                
                if (mysqli_query($conn, $update_query)) {
                    $success = "Section updated successfully!";
                } else {
                    $error = "Error: " . mysqli_error($conn);
                }
            }
        }
    }
}

// Handle delete actions
if (isset($_GET['action']) && isset($_GET['type']) && isset($_GET['id'])) {
    $action = $_GET['action'];
    $type = $_GET['type'];
    $id = $_GET['id'];
    
    if ($action == 'delete') {
        if ($type == 'class') {
            // Check if class has sections before deleting
            $check_sections = "SELECT * FROM sections WHERE class_id='$id'";
            $section_result = mysqli_query($conn, $check_sections);
            
            if (mysqli_num_rows($section_result) > 0) {
                $error = "Cannot delete class. It has sections assigned to it.";
            } else {
                $delete_query = "DELETE FROM classes WHERE id='$id'";
                if (mysqli_query($conn, $delete_query)) {
                    $success = "Class deleted successfully!";
                } else {
                    $error = "Error: " . mysqli_error($conn);
                }
            }
        } elseif ($type == 'section') {
            $delete_query = "DELETE FROM sections WHERE id='$id'";
            if (mysqli_query($conn, $delete_query)) {
                $success = "Section deleted successfully!";
            } else {
                $error = "Error: " . mysqli_error($conn);
            }
        }
    }
}

// Fetch data for dropdowns and tables
$class_query = "SELECT c.*, u.full_name as teacher_name 
                FROM classes c 
                LEFT JOIN users u ON c.class_teacher_id = u.id AND u.role='teacher'
                WHERE c.status='active' 
                ORDER BY c.class_name";
$class_result = mysqli_query($conn, $class_query);

$teacher_query = "SELECT id, full_name 
                  FROM users 
                  WHERE status='active' AND role='teacher' 
                  ORDER BY full_name";
$teacher_result = mysqli_query($conn, $teacher_query);

$section_query = "SELECT s.*, c.class_name, u.full_name as teacher_name, 
                  cu.full_name as class_teacher_name
                  FROM sections s 
                  LEFT JOIN classes c ON s.class_id = c.id 
                  LEFT JOIN users u ON s.section_teacher_id = u.id AND u.role='teacher'
                  LEFT JOIN users cu ON c.class_teacher_id = cu.id AND cu.role='teacher'
                  ORDER BY c.class_name, s.section_name";
$section_result = mysqli_query($conn, $section_query);

// Get classes for dropdown (separate query to avoid data seek issues)
$class_dropdown_query = "SELECT id, class_name 
                         FROM classes 
                         WHERE status='active' 
                         ORDER BY class_name";
$class_dropdown_result = mysqli_query($conn, $class_dropdown_query);
?>

<div class="bg-white p-6  ">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Class & Section Management</h2>
    </div>

    <?php if (!empty($success)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo $success; ?>
        </div>
    <?php endif; ?>
    
    <?php if (!empty($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <?php echo $error; ?>
        </div>
    <?php endif; ?>

    <!-- Tab Navigation -->
    <div class="flex border-b border-blue-500 mb-6">
        <button class="tab-button py-2 px-4 font-medium text-blue-600 border-b-2 border-blue-500" data-tab="class-tab">
            Manage Classes
        </button>
        <button class="tab-button py-2 px-4 font-medium text-gray-500 hover:text-blue-600" data-tab="section-tab">
            Manage Sections
        </button>
       
        <button class="tab-button py-2 px-4 font-medium text-gray-500 hover:text-blue-600" data-tab="section-teacher-tab">
            Assign Section Teachers
        </button>
    </div>

    <!-- Class Management Tab -->
    <div id="class-tab" class="tab-content active">
        <div class=" text-white px-6 py-4 ">
            <h3 class="text-xl font-semibold">Add New Class</h3>
        </div>
        
        <div class="bg-white p-6   mb-6">
            <form method="POST">
                <div class="mb-6 pb-4 border-b border-gray-200">
                    <h4 class="text-lg font-medium text-blue-600 mb-4 flex items-center">
                        <i class="fas fa-info-circle mr-2"></i> Class Details
                    </h4>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="class_name" class="block text-sm font-medium text-gray-700 mb-1">Class Name <span class="text-red-500">*</span></label>
                            <input type="text" id="class_name" name="class_name" required 
                                   placeholder="e.g., Grade 1, Grade 2, etc."
                                   class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                    </div>
                </div>
                
                <div class="flex justify-center">
                    <button type="submit" name="add_class" 
                            class="bg-blue-500 hover:bg-blue-700 text-white px-6 py-2  font-medium flex items-center transition duration-200">
                        <i class="fas fa-plus-circle mr-2"></i> Add Class
                    </button>
                </div>
            </form>
        </div>
        
        <div class=" text-white px-6 py-4 ">
            <h3 class="text-xl font-semibold">Existing Classes</h3>
        </div>
        
        <div class="bg-white p-6  ">
            <?php if (mysqli_num_rows($class_result) > 0): ?>
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white">
                        <thead class="bg-gray-200 text-gray-700">
                            <tr>
                                <th class="py-3 px-4 text-left">Class Name</th>
                               
                                <th class="py-3 px-4 text-left">Status</th>
                                <th class="py-3 px-4 text-left">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-600">
                            <?php while($class = mysqli_fetch_assoc($class_result)): ?>
                                <tr class="border-b border-gray-200 hover:bg-gray-50">
                                    <td class="py-3 px-4"><?php echo htmlspecialchars($class['class_name']); ?></td>
                                  
                                    <td class="py-3 px-4"><?php echo htmlspecialchars(ucfirst($class['status'])); ?></td>
                                    <td class="py-3 px-4">
                                        <div class="flex space-x-2">
                                            <button onclick="openEditClassModal(<?php echo $class['id']; ?>, '<?php echo htmlspecialchars($class['class_name']); ?>')" 
                                                    class="bg-blue-500 hover: text-white px-3 py-1 rounded">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button onclick="confirmDelete('class', <?php echo $class['id']; ?>, '<?php echo htmlspecialchars($class['class_name']); ?>')" 
                                                    class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p class="text-center py-4 text-gray-500">
                    No classes found. Please add classes using the form above.
                </p>
            <?php endif; ?>
        </div>
    </div>

    <!-- Section Management Tab -->
    <div id="section-tab" class="tab-content hidden">
        <div class=" text-white px-6 py-4 ">
            <h3 class="text-xl font-semibold">Add New Section</h3>
        </div>
        
        <div class="bg-white p-6   mb-6">
            <form method="POST">
                <div class="mb-6 pb-4 border-b border-gray-200">
                    <h4 class="text-lg font-medium text-blue-600 mb-4 flex items-center">
                        <i class="fas fa-info-circle mr-2"></i> Section Details
                    </h4>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                        <div>
                            <label for="section_name" class="block text-sm font-medium text-gray-700 mb-1">Section Name <span class="text-red-500">*</span></label>
                            <input type="text" id="section_name" name="section_name" required 
                                   placeholder="e.g., A, B, Morning, etc."
                                   class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        
                        <div>
                            <label for="class_id" class="block text-sm font-medium text-gray-700 mb-1">Class <span class="text-red-500">*</span></label>
                            <select id="class_id" name="class_id" required
                                    class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <option value="">Select Class</option>
                                <?php while($class = mysqli_fetch_assoc($class_dropdown_result)): ?>
                                    <option value="<?php echo $class['id']; ?>">
                                        <?php echo htmlspecialchars($class['class_name']); ?>
                                    </option>
                                <?php endwhile; ?>
                                <?php mysqli_data_seek($class_dropdown_result, 0); ?>
                            </select>
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="capacity" class="block text-sm font-medium text-gray-700 mb-1">Capacity <span class="text-red-500">*</span></label>
                            <input type="number" id="capacity" name="capacity" required 
                                   min="1" max="100" placeholder="Maximum number of students"
                                   class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        
                        <div>
                            <label for="room_number" class="block text-sm font-medium text-gray-700 mb-1">Room Number</label>
                            <input type="text" id="room_number" name="room_number" 
                                   placeholder="Optional room assignment"
                                   class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-6">
                        <div>
                            <label for="section_teacher_id" class="block text-sm font-medium text-gray-700 mb-1">Section Teacher</label>
                            <select id="section_teacher_id" name="section_teacher_id"
                                    class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <option value="">Select Section Teacher (Optional)</option>
                                <?php 
                                $teacher_section_result = mysqli_query($conn, $teacher_query);
                                while($teacher = mysqli_fetch_assoc($teacher_section_result)): ?>
                                    <option value="<?php echo $teacher['id']; ?>">
                                        <?php echo htmlspecialchars($teacher['full_name']); ?>
                                    </option>
                                <?php endwhile; ?>
                                <?php mysqli_data_seek($teacher_section_result, 0); ?>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="flex justify-center">
                    <button type="submit" name="add_section" 
                            class="bg-blue-500 hover:bg-blue-700 text-white px-6 py-2  font-medium flex items-center transition duration-200">
                        <i class="fas fa-plus-circle mr-2"></i> Add Section
                    </button>
                </div>
            </form>
        </div>
        
        <div class=" text-white px-6 py-4 ">
            <h3 class="text-xl font-semibold">Existing Sections</h3>
        </div>
        
        <div class="bg-white p-6  ">
            <?php if (mysqli_num_rows($section_result) > 0): ?>
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white">
                        <thead class="bg-gray-200 text-gray-700">
                            <tr>
                                <th class="py-3 px-4 text-left">Section Name</th>
                                <th class="py-3 px-4 text-left">Class</th>
                                <th class="py-3 px-4 text-left">Capacity</th>
                                <th class="py-3 px-4 text-left">Room Number</th>
                               
                                <th class="py-3 px-4 text-left">Class Teacher</th>
                                <th class="py-3 px-4 text-left">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-600">
                            <?php while($section = mysqli_fetch_assoc($section_result)): ?>
                                <tr class="border-b border-gray-200 hover:bg-gray-50">
                                    <td class="py-3 px-4"><?php echo htmlspecialchars($section['section_name']); ?></td>
                                    <td class="py-3 px-4"><?php echo htmlspecialchars($section['class_name']); ?></td>
                                    <td class="py-3 px-4"><?php echo htmlspecialchars($section['capacity']); ?></td>
                                    <td class="py-3 px-4"><?php echo htmlspecialchars($section['room_number'] ?? 'N/A'); ?></td>
                                   
                                    <td class="py-3 px-4"><?php echo htmlspecialchars($section['teacher_name'] ?? 'Not Assigned'); ?></td>
                                    <td class="py-3 px-4">
                                        <div class="flex space-x-2">
                                            <button onclick="openEditSectionModal(<?php echo $section['id']; ?>, '<?php echo htmlspecialchars($section['section_name']); ?>', <?php echo $section['class_id']; ?>, <?php echo $section['capacity']; ?>, '<?php echo htmlspecialchars($section['room_number'] ?? ''); ?>', <?php echo $section['section_teacher_id'] ? $section['section_teacher_id'] : 'null'; ?>)" 
                                                    class="bg-blue-500 hover: text-white px-3 py-1 rounded">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button onclick="confirmDelete('section', <?php echo $section['id']; ?>, '<?php echo htmlspecialchars($section['section_name']); ?>')" 
                                                    class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p class="text-center py-4 text-gray-500">
                    No sections found. Please add sections using the form above.
                </p>
            <?php endif; ?>
        </div>
    </div>

    <!-- Assign Class Teacher Tab -->
    <div id="class-teacher-tab" class="tab-content hidden">
        <div class=" text-white px-6 py-4 ">
            <h3 class="text-xl font-semibold">Assign Class Teacher</h3>
        </div>
        
        <div class="bg-white p-6  ">
            <form method="POST">
                <div class="mb-6 pb-4 border-b border-gray-200">
                    <h4 class="text-lg font-medium text-blue-600 mb-4 flex items-center">
                        <i class="fas fa-chalkboard-teacher mr-2"></i> Class Teacher Assignment
                    </h4>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="assign_class_id" class="block text-sm font-medium text-gray-700 mb-1">Class <span class="text-red-500">*</span></label>
                            <select id="assign_class_id" name="class_id" required
                                    class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <option value="">Select Class</option>
                                <?php 
                                $class_assign_result = mysqli_query($conn, "SELECT c.*, t.full_name as teacher_name FROM classes c LEFT JOIN teachers t ON c.class_teacher_id = t.id WHERE c.status='active' ORDER BY c.class_name");
                                while($class = mysqli_fetch_assoc($class_assign_result)): ?>
                                    <option value="<?php echo $class['id']; ?>">
                                        <?php echo htmlspecialchars($class['class_name']); ?>
                                        <?php if (!empty($class['teacher_name'])): ?>
                                            (Current: <?php echo htmlspecialchars($class['teacher_name']); ?>)
                                        <?php endif; ?>
                                    </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        
                        <div>
                            <label for="teacher_id" class="block text-sm font-medium text-gray-700 mb-1">Teacher <span class="text-red-500">*</span></label>
                            <select id="teacher_id" name="teacher_id" required
                                    class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <option value="">Select Teacher</option>
                                <?php 
                                $teacher_assign_result = mysqli_query($conn, $teacher_query);
                                while($teacher = mysqli_fetch_assoc($teacher_assign_result)): ?>
                                    <option value="<?php echo $teacher['id']; ?>">
                                        <?php echo htmlspecialchars($teacher['full_name']); ?>
                                    </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="flex justify-center">
                    <button type="submit" name="assign_class_teacher" 
                            class="bg-blue-500 hover:bg-blue-700 text-white px-6 py-2  font-medium flex items-center transition duration-200">
                        <i class="fas fa-link mr-2"></i> Assign Class Teacher
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Assign Section Teacher Tab -->
    <div id="section-teacher-tab" class="tab-content hidden">
        <div class=" text-white px-6 py-4 ">
            <h3 class="text-xl font-semibold">Assign Section Teacher</h3>
        </div>
        
        <div class="bg-white p-6  ">
            <form method="POST">
                <div class="mb-6 pb-4 border-b border-gray-200">
                    <h4 class="text-lg font-medium text-blue-600 mb-4 flex items-center">
                        <i class="fas fa-chalkboard-teacher mr-2"></i> Section Teacher Assignment
                    </h4>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="assign_section_id" class="block text-sm font-medium text-gray-700 mb-1">Section <span class="text-red-500">*</span></label>
                            <select id="assign_section_id" name="section_id" required
                                    class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <option value="">Select Section</option>
                                <?php 
                                $section_assign_result = mysqli_query($conn, "SELECT s.*, c.class_name, t.full_name as teacher_name FROM sections s LEFT JOIN classes c ON s.class_id = c.id LEFT JOIN teachers t ON s.section_teacher_id = t.id ORDER BY c.class_name, s.section_name");
                                while($section = mysqli_fetch_assoc($section_assign_result)): ?>
                                    <option value="<?php echo $section['id']; ?>">
                                        <?php echo htmlspecialchars($section['class_name']); ?> - <?php echo htmlspecialchars($section['section_name']); ?>
                                        <?php if (!empty($section['teacher_name'])): ?>
                                            (Current: <?php echo htmlspecialchars($section['teacher_name']); ?>)
                                        <?php endif; ?>
                                    </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        
                        <div>
                            <label for="section_teacher_id" class="block text-sm font-medium text-gray-700 mb-1">Teacher <span class="text-red-500">*</span></label>
                            <select id="section_teacher_id" name="teacher_id" required
                                    class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <option value="">Select Teacher</option>
                                <?php 
                                $teacher_section_assign_result = mysqli_query($conn, $teacher_query);
                                while($teacher = mysqli_fetch_assoc($teacher_section_assign_result)): ?>
                                    <option value="<?php echo $teacher['id']; ?>">
                                        <?php echo htmlspecialchars($teacher['full_name']); ?>
                                    </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="flex justify-center">
                    <button type="submit" name="assign_section_teacher" 
                            class="bg-blue-500 hover:bg-blue-700 text-white px-6 py-2  font-medium flex items-center transition duration-200">
                        <i class="fas fa-link mr-2"></i> Assign Section Teacher
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Class Modal -->
<div id="editClassModal" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white  -xl w-11/12 md:w-1/2 lg:w-1/3 max-h-screen overflow-y-auto">
        <div class="border-b px-4 py-2 flex justify-between items-center">
            <h3 class="font-semibold text-lg">Edit Class</h3>
            <button class="text-gray-600 hover:text-gray-800" onclick="closeModal('editClassModal')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <form method="POST" id="editClassForm" class="px-6 py-4">
            <input type="hidden" name="class_id" id="edit_class_id">
            
            <div class="mb-4">
                <label for="edit_class_name" class="block text-sm font-medium text-gray-700 mb-1">Class Name <span class="text-red-500">*</span></label>
                <input type="text" id="edit_class_name" name="class_name" required
                       class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <div class="flex justify-center mt-6">
                <button type="submit" name="edit_class" 
                        class="bg-blue-500 hover:bg-blue-700 text-white px-6 py-2  font-medium flex items-center transition duration-200">
                    <i class="fas fa-save mr-2"></i> Update Class
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Edit Section Modal -->
<div id="editSectionModal" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white  -xl w-11/12 md:w-1/2 lg:w-1/2 max-h-screen overflow-y-auto">
        <div class="border-b px-4 py-2 flex justify-between items-center">
            <h3 class="font-semibold text-lg">Edit Section</h3>
            <button class="text-gray-600 hover:text-gray-800" onclick="closeModal('editSectionModal')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <form method="POST" id="editSectionForm" class="px-6 py-4">
            <input type="hidden" name="section_id" id="edit_section_id">
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label for="edit_section_name" class="block text-sm font-medium text-gray-700 mb-1">Section Name <span class="text-red-500">*</span></label>
                    <input type="text" id="edit_section_name" name="section_name" required
                           class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                
                <div>
                    <label for="edit_section_class_id" class="block text-sm font-medium text-gray-700 mb-1">Class <span class="text-red-500">*</span></label>
                    <select id="edit_section_class_id" name="class_id" required
                            class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">Select Class</option>
                        <?php 
                        $class_modal_result = mysqli_query($conn, $class_dropdown_query);
                        while($class = mysqli_fetch_assoc($class_modal_result)): ?>
                            <option value="<?php echo $class['id']; ?>">
                                <?php echo htmlspecialchars($class['class_name']); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label for="edit_capacity" class="block text-sm font-medium text-gray-700 mb-1">Capacity <span class="text-red-500">*</span></label>
                    <input type="number" id="edit_capacity" name="capacity" required min="1" max="100"
                           class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                
                <div>
                    <label for="edit_room_number" class="block text-sm font-medium text-gray-700 mb-1">Room Number</label>
                    <input type="text" id="edit_room_number" name="room_number"
                           class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label for="edit_section_teacher_id" class="block text-sm font-medium text-gray-700 mb-1">Section Teacher</label>
                    <select id="edit_section_teacher_id" name="section_teacher_id"
                            class="w-full px-4 py-2 border border-gray-300  focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">Select Section Teacher (Optional)</option>
                        <?php 
                        $teacher_modal_result = mysqli_query($conn, $teacher_query);
                        while($teacher = mysqli_fetch_assoc($teacher_modal_result)): ?>
                            <option value="<?php echo $teacher['id']; ?>">
                                <?php echo htmlspecialchars($teacher['full_name']); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
            </div>
            
            <div class="flex justify-center mt-6">
                <button type="submit" name="edit_section" 
                        class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2  font-medium flex items-center transition duration-200">
                    <i class="fas fa-save mr-2"></i> Update Section
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div id="deleteModal" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white  -xl w-11/12 md:w-1/3 max-h-screen overflow-y-auto">
        <div class="border-b px-4 py-2 flex justify-between items-center">
            <h3 class="font-semibold text-lg">Confirm Delete</h3>
            <button class="text-gray-600 hover:text-gray-800" onclick="closeModal('deleteModal')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="px-6 py-4">
            <p id="deleteMessage" class="mb-6">Are you sure you want to delete this item?</p>
            <div class="flex justify-center space-x-4">
                <button onclick="proceedDelete()" 
                        class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded flex items-center">
                    <i class="fas fa-check mr-2"></i> Yes, Delete
                </button>
                <button onclick="closeModal('deleteModal')" 
                        class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded flex items-center">
                    <i class="fas fa-times mr-2"></i> Cancel
                </button>
            </div>
        </div>
    </div>
</div>

<script>
    // Tab navigation
    document.querySelectorAll('.tab-button').forEach(button => {
        button.addEventListener('click', function() {
            // Remove active class from all tabs and contents
            document.querySelectorAll('.tab-button').forEach(tab => {
                tab.classList.remove('border-blue-500', 'text-blue-600');
                tab.classList.add('text-gray-500');
            });
            
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.add('hidden');
                content.classList.remove('active');
            });
            
            // Add active class to clicked tab
            this.classList.remove('text-gray-500');
            this.classList.add('border-blue-500', 'text-blue-600');
            
            // Show corresponding content
            const tabId = this.getAttribute('data-tab');
            document.getElementById(tabId).classList.remove('hidden');
            document.getElementById(tabId).classList.add('active');
        });
    });
    
    // Form validation
    const forms = document.querySelectorAll('form');
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            const requiredFields = form.querySelectorAll('[required]');
            let valid = true;
            
            requiredFields.forEach(field => {
                if (!field.value.trim()) {
                    valid = false;
                    field.classList.add('border-red-500');
                } else {
                    field.classList.remove('border-red-500');
                }
            });
            
            if (!valid) {
                e.preventDefault();
                alert('Please fill in all required fields');
            }
        });
    });
    
    // Modal functions
    function openEditClassModal(id, name) {
        document.getElementById('edit_class_id').value = id;
        document.getElementById('edit_class_name').value = name;
        document.getElementById('editClassModal').classList.remove('hidden');
    }
    
    function openEditSectionModal(id, name, classId, capacity, roomNumber, teacherId) {
        document.getElementById('edit_section_id').value = id;
        document.getElementById('edit_section_name').value = name;
        document.getElementById('edit_section_class_id').value = classId;
        document.getElementById('edit_capacity').value = capacity;
        document.getElementById('edit_room_number').value = roomNumber || '';
        
        // Set the teacher if available
        if (teacherId) {
            document.getElementById('edit_section_teacher_id').value = teacherId;
        } else {
            document.getElementById('edit_section_teacher_id').value = '';
        }
        
        document.getElementById('editSectionModal').classList.remove('hidden');
    }
    
    function closeModal(modalId) {
        document.getElementById(modalId).classList.add('hidden');
    }
    
    // Delete confirmation
    let deleteType = '';
    let deleteId = 0;
    
    function confirmDelete(type, id, name) {
        deleteType = type;
        deleteId = id;
        
        const message = `Are you sure you want to delete ${type} "${name}"?`;
        document.getElementById('deleteMessage').textContent = message;
        document.getElementById('deleteModal').classList.remove('hidden');
    }
    
    function proceedDelete() {
        window.location.href = `?action=delete&type=${deleteType}&id=${deleteId}`;
    }
    
    // Close modals when clicking outside
    window.onclick = function(event) {
        const modals = document.querySelectorAll('[id$="Modal"]');
        modals.forEach(modal => {
            if (event.target === modal) {
                modal.classList.add('hidden');
            }
        });
    }
</script>

<?php
include 'include/footer.php';
// Close database connection
mysqli_close($conn);
?>