<?php
session_start();
include '../config/conn.php';

// Check if logged in
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

$class_id = isset($_GET['class_id']) ? intval($_GET['class_id']) : 0;
$section_id = isset($_GET['section_id']) ? intval($_GET['section_id']) : 0;
$calendar_month = isset($_GET['calendar_month']) ? $_GET['calendar_month'] : date('Y-m');

if ($class_id <= 0 || $section_id <= 0) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid class or section']);
    exit();
}

// Calendar variables
$month_name = date('F Y', strtotime($calendar_month));
$first_day = date('N', strtotime($calendar_month . '-01'));
$days_in_month = date('t', strtotime($calendar_month . '-01'));

// Get calendar attendance data
$calendar_data = [];
$calendar_query = "SELECT attendance_date, 
                   SUM(CASE WHEN status = 'present' THEN 1 ELSE 0 END) as present,
                   SUM(CASE WHEN status = 'absent' THEN 1 ELSE 0 END) as absent,
                   SUM(CASE WHEN status = 'late' THEN 1 ELSE 0 END) as late,
                   SUM(CASE WHEN status = 'half_day' THEN 1 ELSE 0 END) as half_day
                   FROM attendance 
                   WHERE class_id = $class_id 
                   AND section_id = $section_id 
                   AND DATE_FORMAT(attendance_date, '%Y-%m') = '$calendar_month'
                   GROUP BY attendance_date";
$calendar_result = mysqli_query($conn, $calendar_query);
while ($row = mysqli_fetch_assoc($calendar_result)) {
    $calendar_data[$row['attendance_date']] = $row;
}

ob_start();
?>
<div class="grid grid-cols-7 gap-2 mb-2">
    <div class="text-center font-medium text-gray-700">Mon</div>
    <div class="text-center font-medium text-gray-700">Tue</div>
    <div class="text-center font-medium text-gray-700">Wed</div>
    <div class="text-center font-medium text-gray-700">Thu</div>
    <div class="text-center font-medium text-gray-700">Fri</div>
    <div class="text-center font-medium text-gray-700">Sat</div>
    <div class="text-center font-medium text-gray-700">Sun</div>
</div>

<div class="grid grid-cols-7 gap-2">
    <?php
    // Add empty cells for days before the first day of the month
    for ($i = 1; $i < $first_day; $i++) {
        echo '<div class="calendar-day bg-gray-100"></div>';
    }
    
    // Add cells for each day of the month
    for ($day = 1; $day <= $days_in_month; $day++) {
        $current_date = date('Y-m-d', strtotime($calendar_month . '-' . sprintf('%02d', $day)));
        $is_today = ($current_date == date('Y-m-d')) ? 'today' : '';
        $has_attendance = isset($calendar_data[$current_date]);
        
        echo '<div class="calendar-day ' . $is_today . ' ' . ($has_attendance ? 'has-attendance' : '') . '">';
        echo '<div class="text-sm font-medium">' . $day . '</div>';
        
        if ($has_attendance) {
            $data = $calendar_data[$current_date];
            echo '<div class="attendance-stats">';
            echo '<div class="text-green-600">P: ' . $data['present'] . '</div>';
            echo '<div class="text-red-600">A: ' . $data['absent'] . '</div>';
            echo '<div class="text-yellow-600">L: ' . $data['late'] . '</div>';
            echo '<div class="text-purple-600">H: ' . $data['half_day'] . '</div>';
            echo '</div>';
        }
        
        echo '</div>';
        
        // Start new row after Sunday
        if (($first_day + $day - 1) % 7 == 0 && $day != $days_in_month) {
            echo '</div><div class="grid grid-cols-7 gap-2">';
        }
    }
    
    // Add empty cells for remaining days in the last week
    $last_day = date('N', strtotime($calendar_month . '-' . $days_in_month));
    if ($last_day < 7) {
        for ($i = $last_day; $i < 7; $i++) {
            echo '<div class="calendar-day bg-gray-100"></div>';
        }
    }
    ?>
</div>

<div class="mt-4 flex justify-center items-center space-x-4 text-xs">
    <div class="flex items-center">
        <div class="w-4 h-4 bg-blue-100 mr-1 border border-blue-300"></div>
        <span>Today</span>
    </div>
    <div class="flex items-center">
        <div class="w-4 h-4 bg-blue-50 mr-1"></div>
        <span>Has Attendance</span>
    </div>
</div>

<?php
$content = ob_get_clean();
echo $content;
mysqli_close($conn);
?>